/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.SqlLocator;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class AutotraceActionProvider
implements ActionProvider<Void> {
    static final String oracleDriver = "oracle.jdbc.OracleDriver";
    public static final String AUTOTRACE_CMD_ID = "Worksheet.Autotrace";
    public static final String EXPLAINPLAN_CMD_ID = "Worksheet.Explainplan";
    private WorksheetAction autotraceAction = WorksheetAction.createWorksheetAction("Worksheet.Autotrace", WorksheetAction.ActionType.BOTH, 0, -10.0);
    static final String actionPrefix = "Worksheet.VSQL_Child";
    private static final String xPlanAction = "Worksheet.DBMS_XPLAN";
    private static final String[] IDs = new String[]{"Worksheet.Explainplan", "Worksheet.VSQL_Child0", "Worksheet.VSQL_Child1", "Worksheet.VSQL_Child2", "Worksheet.DBMS_XPLAN"};
    private WorksheetAction explainAction = WorksheetAction.createWorksheetAction(IDs, "Worksheet.Explainplan", WorksheetAction.ActionType.BOTH, 0, -10.0);
    private WorksheetContext ctx;
    private boolean[] enabledChildMenus = new boolean[]{false, false, false};
    private String sqlId;
    private int cursorPosition;

    public static boolean canExplainAutotrace(String string, String string2) throws DBException, SQLException {
        if (AUTOTRACE_CMD_ID.equals(string) && !AutotraceActionProvider.isOracle(string2)) {
            return false;
        }
        return AutotraceActionProvider.isRegistered(string2);
    }

    private static boolean isRegistered(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        if (string2 != null) {
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            return worksheetFeatures.getAutotraceModelConstructor() != null;
        }
        return false;
    }

    private static boolean isOracle(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        return oracleDriver.equals(string2);
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        this.ctx = worksheetContext;
        boolean bl = false;
        try {
            bl = AutotraceActionProvider.canExplainAutotrace(string, worksheetContext.getConnectionName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        if (0 == basicDocument.getLength()) {
            return false;
        }
        if (string.startsWith(actionPrefix)) {
            int n = Integer.parseInt(string.substring(actionPrefix.length()));
            if (n == 0) {
                this.analyzeSQL();
            }
            return this.enabledChildMenus[n];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeSQL() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string = this.ctx.getConnectionName();
            if (string == null) {
                return;
            }
            if (!Connections.getInstance().isOracle(string)) return;
            String string2 = this.ctx.getParser().text;
            this.cursorPosition = this.ctx.getEditor().getCaretPosition();
            String string3 = SqlLocator.extractStmt((int)this.cursorPosition, (String)string2, null);
            if (string3 == null) {
                return;
            }
            SyntaxError syntaxError = SyntaxError.checkSQLQuerySyntax((String)string3);
            if (syntaxError != null) {
                int n = 0;
                while (n < 3) {
                    this.vSQLmenus(n, null);
                    ++n;
                }
                return;
            }
            this.enabledChildMenus = new boolean[]{false, false, false};
            Connection connection = Connections.getInstance().getConnection(string);
            if (!Connections.getInstance().tryLock(connection, 500L)) {
                return;
            }
            try {
                this.sqlId = ExplainPlanAction.stmt2sqlid(string3);
                if (this.sqlId != null) {
                    statement = connection.prepareStatement("select child_number from v$sql \n where sql_id = ?  \n order by child_number");
                    statement.setString(1, this.sqlId);
                } else {
                    statement = connection.prepareStatement("select sql_id, child_number from v$sql \n where sql_text like ?  \n order by child_number");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string3.length() && i < 5000; ++i) {
                        char c = string3.charAt(i);
                        if ('\u07d0' < c) {
                            c = '%';
                        }
                        stringBuilder.append(c);
                    }
                    statement.setString(1, stringBuilder.toString() + '%');
                }
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt("child_number");
                    if (this.sqlId == null) {
                        this.sqlId = resultSet.getString("sql_id");
                    }
                    if (2 < n) continue;
                    this.enabledChildMenus[n] = true;
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            for (int i = 0; i < 3; ++i) {
                this.vSQLmenus(i, this.sqlId);
            }
            IdeAction ideAction = IdeAction.find((String)xPlanAction);
            ideAction.putValue("Name", (Object)Messages.getString("AutotraceActionProvider.DBMS_XPLAN"));
            return;
        }
        catch (SQLRecoverableException sQLRecoverableException) {
            return;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            if (sQLSyntaxErrorException.getErrorCode() == 942) return;
            sQLSyntaxErrorException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void vSQLmenus(int n, String string) {
        IdeAction ideAction = IdeAction.find((String)(actionPrefix + n));
        ideAction.putValue("Name", (Object)this.menuLabel(n, string, this.enabledChildMenus[n]));
    }

    private String menuLabel(int n, String string, boolean bl) {
        if (string != null) {
            if (bl) {
                return "<html>V$SQL_PLAN.SQL_ID=<font color=blue>" + string + "</font>, V$SQL_PLAN.CHILD_NUMBER=<font color=blue>" + n + "</font>";
            }
            return "V$SQL_PLAN.SQL_ID=" + string + ", V$SQL_PLAN.CHILD_NUMBER=" + n;
        }
        return "V$SQL_PLAN.CHILD_NUMBER=" + n;
    }

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        boolean bl;
        if (xPlanAction.equals(string)) {
            BasicEditorPane basicEditorPane = worksheetContext.getEditor();
            String string2 = worksheetContext.getParser().text;
            long l = SqlLocator.locate((int)this.cursorPosition, (String)string2);
            int n = Service.lY((long)l);
            try {
                basicEditorPane.insertString(n, "\n\nselect * from table(dbms_xplan.display_cursor(sql_id=>'" + this.sqlId + "', format=>'ALLSTATS LAST'));\n", null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return null;
        }
        AnalyzeAction analyzeAction = null;
        boolean bl2 = bl = EXPLAINPLAN_CMD_ID.equals(string) || string.startsWith(actionPrefix);
        if (AUTOTRACE_CMD_ID.equals(string)) {
            analyzeAction = new AutotraceAction(string, worksheetContext);
        } else if (bl) {
            analyzeAction = new ExplainPlanAction(string, worksheetContext);
        } else {
            return null;
        }
        AutotracePanel autotracePanel = new AutotracePanel(string, bl, worksheetContext);
        analyzeAction.setAutoTracePanel(autotracePanel);
        ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
        arrayList.add((IRaptorTaskListener)autotracePanel.new AbstractPanel.ResultsPanelTaskListener());
        for (IRaptorTaskListener iRaptorTaskListener : arrayList) {
            analyzeAction.getDescriptor().addListener(iRaptorTaskListener);
        }
        return analyzeAction != null ? new WorksheetTaskWrapper<Void>(analyzeAction, arrayList, Collections.EMPTY_LIST, worksheetContext) : null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        if (n == 0) {
            return this.explainAction;
        }
        return this.autotraceAction;
    }

    @Override
    public int getActionsCount() {
        return 2;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }
}

