/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.app.XML2Table;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.HtmlTreeTableWidget;
import oracle.dbtools.util.Service;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeNode;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.dbtools.worksheet.commands.autotrace.Hint;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModel;

public class AutotraceTreeModel
extends AbstractTreeTableModel {
    protected String originalSQL;
    private static AutotraceTreeNode emptyRoot = new AutotraceTreeNode("");
    AutotracePanel src = null;
    AutotraceTreeModel cmp = null;
    private boolean showPartitionColumns = false;
    private Set<String> show = new TreeSet<String>();
    private static boolean showedDialog;
    Map<AutotraceTreeNode, Integer> nodeLabels = new HashMap<AutotraceTreeNode, Integer>();

    public AutotraceTreeModel(AutotracePanel autotracePanel) {
        super((Object)emptyRoot);
        this.src = autotracePanel;
    }

    public AutotraceTreeModel(AutotracePanel autotracePanel, AutotraceTreeModel autotraceTreeModel) {
        super((Object)emptyRoot);
        this.src = autotracePanel;
        this.cmp = autotraceTreeModel;
        this.cloneTreeAndMarkDiffs();
    }

    public void reset() {
        this.root = new AutotraceTreeNode("...");
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public String getSQL() {
        String string = "select user,s.last_elapsed_time \n   , s.last_output_rows \n   , s.last_cr_buffer_gets \n   , s.last_starts, s.LAST_DISK_READS, s.LAST_CU_BUFFER_GETS, s.LAST_DISK_WRITES \n   , s.ESTIMATED_ONEPASS_SIZE, s.ESTIMATED_ONEPASS_SIZE, s.LAST_DEGREE, s.LAST_EXECUTION,  \n   , s.LAST_MEMORY_USED, s.LAST_TEMPSEG_SIZE, s.MULTIPASSES_EXECUTIONS, s.ONEPASS_EXECUTIONS, s.OPTIMAL_EXECUTIONS,  \n   , p.* \nfrom v$sql_plan p, v$sql_plan_statistics s \nwhere p.hash_value = ? and p.child_number = ? \nand p.hash_value = s.hash_value(+)  \nand p.child_number = s.child_number(+)and p.id = s.operation_id(+)order by p.id";
        string = "select user,s.* \nfrom v$sql_plan_statistics_all s  \nwhere hash_value = ? and child_number = ? \norder by id";
        return string;
    }

    public void reload(String string, String string2, Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(this.getSQL());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            this.getPlanAndStats(preparedStatement, true);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("AutotraceTreeModel.14"), null);
        }
        this.reload(this.src.tbl.getTree());
    }

    void reload(final JTree jTree) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AutotraceTreeModel.this.fireTreeStructureChanged((Object)AutotraceTreeModel.this, new TreeNode[]{(TreeNode)AutotraceTreeModel.this.root}, null, null);
                for (int i = 0; i < jTree.getRowCount(); ++i) {
                    TreePath treePath = jTree.getPathForRow(i);
                    RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
                    if (SerializedData.getInstance().collapsePredNodes && (rowSrcNode.toString().endsWith("Predicates") || rowSrcNode.toString().endsWith("Projection"))) continue;
                    jTree.expandRow(i);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void explainPlan(String string, String string2, Connection connection) {
        long l = Long.parseLong(string2);
        if (3L <= l) {
            try {
                Statement statement = connection.createStatement();
                statement.setEscapeProcessing(false);
                statement.execute("explain plan SET STATEMENT_ID = '" + string2 + "' for " + string);
                statement.close();
            }
            catch (SQLException sQLException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("AutotraceTreeModel.18"), null);
            }
        }
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.originalSQL = string;
        long l = Long.parseLong(string2);
        try {
            boolean bl;
            String string3 = "select user,'N/A' last_elapsed_time \n   , 'N/A' last_output_rows \n   , 'N/A' last_cr_buffer_gets \n   , 'N/A' last_starts \n   , p.* \nfrom plan_table p \nwhere p.statement_id = ? \norder by p.id";
            boolean bl2 = bl = l < 3L;
            if (bl) {
                string2 = ExplainPlanAction.stmt2sqlid(string);
                if (string2 == null) {
                    return;
                }
                string3 = "select user,'N/A' last_elapsed_time \n   , 'N/A' last_output_rows \n   , 'N/A' last_cr_buffer_gets \n   , 'N/A' last_starts \n   , p.* \nfrom v$sql_plan p \nwhere p.sql_id = ? and p.child_number = ? \n";
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            if (bl) {
                preparedStatement.setLong(2, l);
            }
            this.getPlanAndStats(preparedStatement, bl);
            preparedStatement.close();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)Messages.getString("AutotraceTreeModel.27"), null);
        }
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public boolean isCellEditable(Object object, int n) {
        if (object instanceof RowSrcNode) {
            return ((RowSrcNode)object).isNodeColEditable(n);
        }
        return false;
    }

    public List<String> displayedColumns() {
        TreeMap treeMap;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OPERATION");
        oracle.dbtools.raptor.SerializedData serializedData = oracle.dbtools.raptor.SerializedData.getInstance();
        TreeMap treeMap2 = treeMap = this.src.isExplainPlan ? serializedData.explainOptions : serializedData.autotraceOptions;
        if (((Boolean)treeMap.get("OBJECT_NAME")).booleanValue()) {
            arrayList.add("OBJECT_NAME");
        }
        if (((Boolean)treeMap.get("OPTIONS")).booleanValue()) {
            arrayList.add("OPTIONS");
        }
        if (((Boolean)treeMap.get("Predicates Column")).equals(Boolean.TRUE)) {
            arrayList.add("ACCESS_PREDICATES");
            arrayList.add("FILTER_PREDICATES");
        }
        if (((Boolean)treeMap.get("Projection Column")).equals(Boolean.TRUE)) {
            arrayList.add("PROJECTION");
        }
        if (((Boolean)treeMap.get("Other XML Column")).equals(Boolean.TRUE)) {
            arrayList.add("OTHER_XML");
        }
        if (((Boolean)treeMap.get("Execution Order Column")).equals(Boolean.TRUE)) {
            arrayList.add("EXEC#");
        }
        if (this.showPartitionColumns) {
            arrayList.add("PARTITION_START");
            arrayList.add("PARTITION_STOP");
            arrayList.add("PARTITION_ID");
        }
        for (String string : this.show) {
            if (AutotraceTreeNode.isSpecialColumn(string) || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getColumnCount() {
        return this.displayedColumns().size();
    }

    public String getColumnName(int n) {
        return this.getColumnName(n, true);
    }

    public String getColumnName(int n, boolean bl) {
        try {
            String string = this.displayedColumns().get(n);
            if (string != null) {
                String string2 = SerializedData.getInstance().columnNames.get(string);
                if (bl && string2 != null) {
                    return string2;
                }
                return string;
            }
            return "??";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "?";
        }
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object object, int n) {
        String string = this.getColumnName(n, false);
        return ((RowSrcNode)object).getValue(string);
    }

    private void getPlanAndStats(PreparedStatement preparedStatement, boolean bl) throws SQLException {
        Object object;
        Object object2;
        Serializable serializable;
        oracle.dbtools.raptor.SerializedData serializedData = oracle.dbtools.raptor.SerializedData.getInstance();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ResultSet resultSet = preparedStatement.executeQuery();
        this.showPartitionColumns = false;
        this.show = new TreeSet<String>();
        while (resultSet.next()) {
            String string;
            Object object32;
            serializable = new AutotraceTreeNode(resultSet.getString("operation"));
            ((AutotraceTreeNode)serializable).m_id = resultSet.getString("id");
            object2 = resultSet.getString("parent_id");
            ((AutotraceTreeNode)serializable).objectName = resultSet.getString("object_name");
            object = resultSet.getString("object_owner");
            String string2 = resultSet.getString("user");
            if (object != null && !((String)object).equals(string2)) {
                ((AutotraceTreeNode)serializable).objectName = (String)object + '.' + ((AutotraceTreeNode)serializable).objectName;
            }
            ((AutotraceTreeNode)serializable).options = resultSet.getString("options");
            for (Object object32 : this.src.isExplainPlan ? serializedData.explainOptions.keySet() : serializedData.autotraceOptions.keySet()) {
                if (AutotraceTreeNode.isSpecialColumn((String)object32)) continue;
                try {
                    ((AutotraceTreeNode)serializable).extra.put((String)object32, resultSet.getString((String)object32));
                }
                catch (SQLException sQLException) {
                    this.src.logger.log(Level.SEVERE, (String)object32 + "=" + sQLException.getMessage());
                    if (!showedDialog && !bl) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("FixIt"), (String)Messages.getString("ObsoletePlanTable"), null);
                    }
                    showedDialog = true;
                }
            }
            String string3 = resultSet.getString("OTHER_TAG");
            if ("SERIAL_FROM_REMOTE".equals(string3)) {
                object32 = new AutotraceTreeNode(string3);
                ((AutotraceTreeNode)object32).color = new Color(0x777700);
                ((AutotraceTreeNode)object32).isSpanned = true;
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object32);
                string = resultSet.getString("OTHER");
                if (string != null) {
                    AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode(string);
                    autotraceTreeNode.color = new Color(0x886600);
                    autotraceTreeNode.isSpanned = true;
                    ((DefaultMutableTreeNode)object32).add(autotraceTreeNode);
                }
            }
            ((AutotraceTreeNode)serializable).partitionStart = resultSet.getString("PARTITION_START");
            ((AutotraceTreeNode)serializable).partitionStop = resultSet.getString("PARTITION_STOP");
            ((AutotraceTreeNode)serializable).partitionId = resultSet.getString("PARTITION_ID");
            if (this.showColumn("Partition Columns")) {
                if (((AutotraceTreeNode)serializable).partitionStart != null || ((AutotraceTreeNode)serializable).partitionStop != null) {
                    this.showPartitionColumns = true;
                }
                if (!oracle.dbtools.raptor.SerializedData.getInstance().skipNullCols) {
                    this.showPartitionColumns = true;
                }
            }
            object32 = ((AutotraceTreeNode)serializable).extra.keySet().iterator();
            while (object32.hasNext()) {
                string = object32.next();
                if (!this.showColumn(string)) continue;
                if (((AutotraceTreeNode)serializable).extra.get(string) != null) {
                    this.show.add(string);
                }
                if (oracle.dbtools.raptor.SerializedData.getInstance().skipNullCols) continue;
                this.show.add(string);
            }
            ((AutotraceTreeNode)serializable).otherXml = null;
            try {
                ((AutotraceTreeNode)serializable).accessPredicates = resultSet.getString("access_predicates");
                ((AutotraceTreeNode)serializable).filterPredicates = resultSet.getString("filter_predicates");
                ((AutotraceTreeNode)serializable).projection = resultSet.getString("projection");
                ((AutotraceTreeNode)serializable).qBlockName = resultSet.getString("qblock_name");
                object32 = resultSet.getClob("other_xml");
                if (object32 != null) {
                    ((AutotraceTreeNode)serializable).otherXml = object32.getSubString(1L, (int)object32.length());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            hashMap.put(((AutotraceTreeNode)serializable).m_id, serializable);
            if ("0".equals(((AutotraceTreeNode)serializable).m_id)) {
                this.root = serializable;
            } else {
                object32 = (AutotraceTreeNode)hashMap.get(object2);
                ((DefaultMutableTreeNode)object32).add((MutableTreeNode)((Object)serializable));
                ((DefaultMutableTreeNode)serializable).setParent((MutableTreeNode)object32);
            }
            if (((AutotraceTreeNode)serializable).accessPredicates != null && this.showPredicates()) {
                object32 = new AutotraceTreeNode("Access Predicates");
                ((AutotraceTreeNode)object32).color = new Color(170);
                ((AutotraceTreeNode)object32).isSpanned = true;
                ((AutotraceTreeNode)object32).predicates = ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object32);
                ((DefaultMutableTreeNode)object32).setParent((MutableTreeNode)((Object)serializable));
                AutotraceTreeModel.predicates((AutotraceTreeNode)object32, ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", ""), true);
            }
            if (((AutotraceTreeNode)serializable).filterPredicates != null && this.showPredicates()) {
                object32 = new AutotraceTreeNode("Filter Predicates");
                ((AutotraceTreeNode)object32).color = new Color(170);
                ((AutotraceTreeNode)object32).isSpanned = true;
                ((AutotraceTreeNode)object32).predicates = ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object32);
                ((DefaultMutableTreeNode)object32).setParent((MutableTreeNode)((Object)serializable));
                AutotraceTreeModel.predicates((AutotraceTreeNode)object32, ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", ""), false);
            }
            if (((AutotraceTreeNode)serializable).projection != null && this.showProjection()) {
                object32 = new AutotraceTreeNode("Projection");
                ((AutotraceTreeNode)object32).color = new Color(21777);
                ((AutotraceTreeNode)object32).isSpanned = true;
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object32);
                ((DefaultMutableTreeNode)object32).setParent((MutableTreeNode)((Object)serializable));
                AutotraceTreeModel.projection((AutotraceTreeNode)object32, ((AutotraceTreeNode)serializable).projection.replaceAll("\"", ""));
            }
            if (((AutotraceTreeNode)serializable).otherXml != null) {
                this.parseXML((RowSrcNode)this.root, ((AutotraceTreeNode)serializable).otherXml);
            }
            if (!this.isSkipped((RowSrcNode)this.root, ((AutotraceTreeNode)serializable).m_id)) continue;
            ((AutotraceTreeNode)serializable).color = Color.lightGray;
        }
        if (this.root instanceof AutotraceTreeNode) {
            this.enumerateExecOrder((AutotraceTreeNode)this.root);
        }
        resultSet.close();
        serializable = (AbstractTableModel)this.src.tbl.getModel();
        try {
            object2 = new Runnable((AbstractTableModel)serializable){
                final /* synthetic */ AbstractTableModel val$tModel;
                {
                    this.val$tModel = abstractTableModel;
                }

                @Override
                public void run() {
                    this.val$tModel.fireTableStructureChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                object2.run();
            } else {
                SwingUtilities.invokeAndWait((Runnable)object2);
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            this.src.logger.log(Level.SEVERE, exception.getMessage());
        }
        for (int i = 1; i < this.src.tbl.getColumnModel().getColumnCount(); ++i) {
            object = this.src.tbl.getColumnModel().getColumn(i);
            ((TableColumn)object).setCellRenderer(this.src.cellRenderer);
        }
    }

    private boolean isSkipped(RowSrcNode rowSrcNode, String string) {
        String string2 = "row op=\"";
        if (rowSrcNode.operation().startsWith(string2)) {
            String string3 = rowSrcNode.operation().substring(string2.length(), rowSrcNode.operation().indexOf(34, string2.length()));
            if (!string3.equals(string)) {
                return false;
            }
            String string4 = "skp=\"";
            int n = rowSrcNode.operation().indexOf(string4);
            String string5 = rowSrcNode.operation().substring(n + string4.length(), rowSrcNode.operation().indexOf(34, n + string4.length()));
            return "1".equals(string5);
        }
        for (int i = 0; i < rowSrcNode.getChildCount(); ++i) {
            RowSrcNode rowSrcNode2 = (RowSrcNode)rowSrcNode.getChildAt(i);
            boolean bl = this.isSkipped(rowSrcNode2, string);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    void cloneTreeAndMarkDiffs() {
        this.root = ((RowSrcNode)this.src.getATMdl().root).clone((RowSrcNode)this.cmp.root);
    }

    private static int minLevel(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n2;
            } else if (string.charAt(i) == ')') {
                --n2;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private static void predicates(AutotraceTreeNode autotraceTreeNode, String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = string.trim();
        if (autotraceTreeNode.toString().endsWith(" Predicates")) {
            if (bl) {
                autotraceTreeNode.accessPredicates = string2;
            } else {
                autotraceTreeNode.filterPredicates = string2;
            }
        }
        if (string2.startsWith("(") && string2.endsWith(")") && AutotraceTreeModel.minLevel((String)(object2 = string2.substring(1, string2.length() - 1))) >= 0) {
            AutotraceTreeModel.predicates(autotraceTreeNode, (String)object2, bl);
            return;
        }
        object2 = new StringTokenizer(string2, "() ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            n2 += ((String)object).length();
            if (" ".equals(object)) continue;
            if ("(".equals(object)) {
                ++n3;
                continue;
            }
            if (")".equals(object)) {
                --n3;
                continue;
            }
            if (n3 == 0 && !bl2 && "and".equalsIgnoreCase((String)object)) {
                arrayList.add(string2.substring(n, n2 - "and".length()));
                n = n2;
                continue;
            }
            if (n3 != 0 || !"or".equalsIgnoreCase((String)object)) continue;
            if (!bl2) {
                arrayList = new ArrayList();
                n = 0;
                bl2 = true;
            }
            arrayList.add(string2.substring(n, n2 - "or".length()));
            n = n2;
        }
        if (arrayList.size() > 0) {
            arrayList.add(string2.substring(n));
            object = new AutotraceTreeNode(bl2 ? "OR" : "AND");
            ((AutotraceTreeNode)object).color = new Color(204);
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
            ((DefaultMutableTreeNode)object).setParent(autotraceTreeNode);
            if (bl) {
                ((AutotraceTreeNode)object).accessPredicates = string2;
            } else {
                ((AutotraceTreeNode)object).filterPredicates = string2;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, (String)arrayList.get(i), bl);
            }
        } else {
            object = new AutotraceTreeNode(string2);
            ((AutotraceTreeNode)object).color = new Color(238);
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
            ((DefaultMutableTreeNode)object).setParent(autotraceTreeNode);
        }
    }

    private static void projection(AutotraceTreeNode autotraceTreeNode, String string) {
        int n = string.indexOf("], ");
        n = n < 0 ? string.length() : ++n;
        String string2 = string.substring(0, n);
        int n2 = string2.indexOf(91);
        if (n2 < 0) {
            return;
        }
        int n3 = string2.indexOf(44, n2);
        if (n3 < 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(string3 + "[" + string4 + "]");
            autotraceTreeNode2.color = new Color(26197);
            autotraceTreeNode2.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode2);
        } else {
            String string5 = string2.substring(0, n2);
            String string6 = string2.substring(n2 + 1, n3);
            String string7 = string2.substring(n3 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode3 = new AutotraceTreeNode(string5 + "[" + string6 + "," + string7 + "]");
            autotraceTreeNode3.color = new Color(0x556600);
            autotraceTreeNode3.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode3);
        }
        if (n < string.length()) {
            AutotraceTreeModel.projection(autotraceTreeNode, string.substring(n + 2));
        }
    }

    protected void parseXML(RowSrcNode rowSrcNode, String string) {
        try {
            Earley earley = XML2Table.xmlParser();
            List list = LexerToken.parse((String)string);
            Matrix matrix = new Matrix((Parser)earley);
            earley.parse(list, (Matriceable)matrix);
            ParseNode parseNode = earley.forest(list, matrix);
            AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode("Other XML");
            autotraceTreeNode.color = new Color(0x777700);
            autotraceTreeNode.isSpanned = true;
            if (this.showOtherXML()) {
                rowSrcNode.add(autotraceTreeNode);
            }
            this.nodes(autotraceTreeNode, parseNode, list, earley);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void enumerateExecOrder(RowSrcNode rowSrcNode) {
        AutotraceTreeNode autotraceTreeNode = ((AutotraceTreeNode)rowSrcNode).findOtherXML();
        if (autotraceTreeNode == null) {
            return;
        }
        TreeNode treeNode = autotraceTreeNode.getFirstChild();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!"{hint}".equals(treeNode2.toString())) continue;
            for (int j = 0; j < treeNode2.getChildCount(); ++j) {
                AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)treeNode2.getChildAt(j);
                Hint hint = this.orderingHint(autotraceTreeNode2);
                if (hint == null) continue;
                this.markExecNode((AutotraceTreeNode)rowSrcNode, hint);
            }
            break;
        }
    }

    private Hint orderingHint(AutotraceTreeNode autotraceTreeNode) {
        if (!autotraceTreeNode.isHint) {
            throw new AssertionError((Object)(autotraceTreeNode.toString() + " is not a hint"));
        }
        Hint hint = Hint.parse(autotraceTreeNode.operation);
        if ("LEADING".equals(hint.head)) {
            return hint;
        }
        if ("FULL".equals(hint.head)) {
            return hint;
        }
        if (hint.head.startsWith("INDEX")) {
            return hint;
        }
        return null;
    }

    private void markExecNode(AutotraceTreeNode autotraceTreeNode, Hint hint) {
        for (String string : hint.elements) {
            this.markExecNode(autotraceTreeNode, hint.queryBlock, string);
        }
    }

    private void markExecNode(AutotraceTreeNode autotraceTreeNode, String string, String string2) {
        if (autotraceTreeNode.isSpanned()) {
            return;
        }
        if (string.replace("\"", "").replace("@", "").equals(autotraceTreeNode.qBlockName) && string2.replace("\"", "").equals(autotraceTreeNode.extra.get("OBJECT_ALIAS"))) {
            if (!this.nodeLabels.containsKey(autotraceTreeNode)) {
                this.nodeLabels.put(autotraceTreeNode, -1);
                autotraceTreeNode.execOrder = this.nodeLabels.size();
            }
            return;
        }
        for (int i = 0; i < autotraceTreeNode.getChildCount(); ++i) {
            TreeNode treeNode = autotraceTreeNode.getChildAt(i);
            this.markExecNode((AutotraceTreeNode)treeNode, string, string2);
        }
    }

    private void nodes(AutotraceTreeNode autotraceTreeNode, ParseNode parseNode, List<LexerToken> list, Earley earley) {
        if (parseNode.contains(((Integer)earley.symbolIndexes.get("node")).intValue())) {
            this.node(autotraceTreeNode, parseNode, list, earley);
            return;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            this.nodes(autotraceTreeNode, parseNode2, list, earley);
        }
    }

    private void node(AutotraceTreeNode autotraceTreeNode, ParseNode parseNode, List<LexerToken> list, Earley earley) {
        AutotraceTreeNode autotraceTreeNode2 = autotraceTreeNode;
        boolean bl = parseNode.contains(((Integer)earley.symbolIndexes.get("simpletag")).intValue());
        for (ParseNode parseNode2 : parseNode.children()) {
            if (bl && parseNode2.contains(((Integer)earley.symbolIndexes.get("equalities")).intValue())) {
                autotraceTreeNode2 = new AutotraceTreeNode(list.get((int)(parseNode.from + 1)).content + " " + parseNode2.content(list));
                autotraceTreeNode2.color = new Color(0x886600);
                autotraceTreeNode2.isSpanned = true;
                autotraceTreeNode.add(autotraceTreeNode2);
                return;
            }
            if (parseNode2.contains(((Integer)earley.symbolIndexes.get("contents")).intValue())) {
                AutotraceTreeModel.contents(autotraceTreeNode2, parseNode2, list, earley);
                return;
            }
            if (parseNode2.contains(((Integer)earley.symbolIndexes.get("opentag")).intValue())) {
                for (ParseNode parseNode3 : parseNode2.children()) {
                    if (!parseNode3.contains(((Integer)earley.symbolIndexes.get("equalities")).intValue())) continue;
                    autotraceTreeNode2 = new AutotraceTreeNode(list.get((int)(parseNode2.from + 1)).content + " " + parseNode3.content(list));
                    autotraceTreeNode2.color = new Color(0x886600);
                    autotraceTreeNode2.isSpanned = true;
                    autotraceTreeNode.add(autotraceTreeNode2);
                }
                continue;
            }
            if (parseNode2.contains(((Integer)earley.symbolIndexes.get("nodes")).intValue())) {
                if (parseNode2.contains(((Integer)earley.symbolIndexes.get("node")).intValue())) {
                    this.nodes(autotraceTreeNode, parseNode2, list, earley);
                    continue;
                }
                autotraceTreeNode2 = new AutotraceTreeNode("{" + list.get((int)(parseNode2.from + 1)).content + "}");
                autotraceTreeNode2.color = new Color(0x880066);
                autotraceTreeNode2.isSpanned = true;
                autotraceTreeNode.add(autotraceTreeNode2);
                this.nodes(autotraceTreeNode2, parseNode2, list, earley);
                continue;
            }
            if (!parseNode2.contains(((Integer)earley.symbolIndexes.get("contents")).intValue())) continue;
            AutotraceTreeModel.contents(autotraceTreeNode, parseNode2, list, earley);
        }
    }

    private static void contents(AutotraceTreeNode autotraceTreeNode, ParseNode parseNode, List<LexerToken> list, Earley earley) {
        String string = parseNode.content(list);
        AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(string);
        autotraceTreeNode2.color = new Color(0x668800);
        autotraceTreeNode2.isSpanned = true;
        if ("{hint}".equals(autotraceTreeNode.operation)) {
            autotraceTreeNode2.isHint = true;
        }
        autotraceTreeNode.add(autotraceTreeNode2);
    }

    private boolean showPredicates() {
        return this.showColumn("Predicates Branch");
    }

    private boolean showProjection() {
        return this.showColumn("Projection Branch");
    }

    protected boolean showOtherXML() {
        return this.showColumn("Other XML Branch");
    }

    protected boolean showExecColumn() {
        return this.showColumn("Execution Order Column");
    }

    private boolean showColumn(String string) {
        oracle.dbtools.raptor.SerializedData serializedData = oracle.dbtools.raptor.SerializedData.getInstance();
        if (this.src.isExplainPlan) {
            return (Boolean)serializedData.explainOptions.get(string);
        }
        return (Boolean)serializedData.autotraceOptions.get(string);
    }

    public HtmlTreeTableWidget createHtmlWidget(JTree jTree) {
        Object object;
        int n;
        HtmlTreeTableWidget htmlTreeTableWidget = new HtmlTreeTableWidget();
        htmlTreeTableWidget.columnNames = new String[this.getColumnCount()];
        for (n = 0; n < htmlTreeTableWidget.columnNames.length; ++n) {
            object = this.getColumnName(n);
            object = ((String)object).replace("_CR_BUFFER_", "...");
            htmlTreeTableWidget.columnNames[n] = object = ((String)object).replace("_ELAPSED_", "...");
        }
        for (n = 0; n < jTree.getRowCount(); ++n) {
            object = jTree.getPathForRow(n);
            RowSrcNode rowSrcNode = (RowSrcNode)((TreePath)object).getLastPathComponent();
            String[] stringArray = new String[this.getColumnCount()];
            for (int i = 0; i < htmlTreeTableWidget.columnNames.length; ++i) {
                stringArray[i] = rowSrcNode.getValue(this.getColumnName(i));
            }
            if (rowSrcNode.isSpanned()) {
                String string = null;
                Color color = rowSrcNode.getColor();
                if (color != null) {
                    string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
                }
                htmlTreeTableWidget.append(rowSrcNode.toString(), stringArray, rowSrcNode.depth(), rowSrcNode.imageName(), string);
                continue;
            }
            htmlTreeTableWidget.append(null, stringArray, rowSrcNode.depth(), rowSrcNode.imageName());
        }
        return htmlTreeTableWidget;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile((String)"c:/raptor_trunk/worksheet/src/oracle/dbtools/worksheet/commands/autotrace/other_xml.txt");
        AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode("root");
        new AutotraceTreeModel(null){

            @Override
            protected boolean showOtherXML() {
                return true;
            }
        }.parseXML(autotraceTreeNode, string);
        StringBuilder stringBuilder = new StringBuilder();
        AutotraceTreeModel.tree(autotraceTreeNode, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    private static void tree(RowSrcNode rowSrcNode, StringBuilder stringBuilder) {
        int n = rowSrcNode.getChildCount();
        stringBuilder.append(Service.identln((int)rowSrcNode.depth(), (String)rowSrcNode.toString()) + "\n");
        for (int i = 0; i < n; ++i) {
            RowSrcNode rowSrcNode2 = (RowSrcNode)rowSrcNode.getChildAt(i);
            AutotraceTreeModel.tree(rowSrcNode2, stringBuilder);
        }
    }

    static {
        AutotraceTreeModel.emptyRoot.qBlockName = "Empty Explain Plan/Autotrace. Run it from the Toolbar!";
        showedDialog = false;
    }
}

