/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.editor.ListTablePanel;
import oracle.dbtools.unit_test.editor.ParamPanel;
import oracle.dbtools.unit_test.editor.ScrollableJPanel;
import oracle.dbtools.unit_test.editor.StartupListTableModel;
import oracle.dbtools.unit_test.editor.TeardownListTableModel;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.editor.UtTestEditor;
import oracle.dbtools.unit_test.editor.ValidationListTableModel;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public abstract class TestDetails
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UtTestImpl _testImpl;
    private UtTest _test;
    private boolean _unsavedChanges;
    private UtTestEditor _editor;
    private JPanel _panelCenter = new ScrollableJPanel();
    private JScrollPane _scrollPane = new JScrollPane(this._panelCenter);
    private JPanel _testImplPanel;
    private ParamPanel _paramPanel;
    private JCheckBox _coverageCheckBox;
    private ValidationListTableModel _validationListTableModel;
    private ListTablePanel<IValidation> _validationPanel;
    private StartupListTableModel _startupListTableModel;
    private ListTablePanel<IStartup> _startupPanel;
    private TeardownListTableModel _teardownListTableModel;
    private ListTablePanel<ITeardown> _teardownPanel;
    private JTextArea _testSignatureUI;
    private boolean _initialized;

    public TestDetails(UtTestEditor utTestEditor) {
        this._editor = utTestEditor;
        this.setName("TestDetailsPanel");
    }

    UtTestImpl getTestImpl() {
        return this._testImpl;
    }

    protected abstract Toolbar getToolbar();

    public void updateUI(UtTest utTest, String string) {
        this._test = utTest;
        this._testImpl = utTest.getImpl(string);
        if (null == this._testImpl && utTest.getImpls().size() > 0) {
            this._testImpl = utTest.getImpls().get(0);
        }
        this.setInitialized(false);
        this.removeAll();
        this.validate();
        this.repaint();
        this.setLayout(new BorderLayout());
        Toolbar toolbar = this.getToolbar();
        if (null != toolbar) {
            this.add((Component)toolbar, "North");
        }
        this._panelCenter.removeAll();
        this._testSignatureUI = this.getTestSignatureUI();
        this.updateTestSignatureData(this._test);
        CodeHookLookup codeHookLookup = new CodeHookLookup(){

            @Override
            public String getOwnerName() {
                return TestDetails.this._test.getTestName();
            }

            @Override
            public List<IStartup> getStartups() {
                return TestDetails.this._startupListTableModel.getRowList();
            }

            @Override
            public List<ITeardown> getTeardowns() {
                return TestDetails.this._teardownListTableModel.getRowList();
            }

            @Override
            public List<IValidation> getValidations() {
                return TestDetails.this._validationListTableModel.getRowList();
            }
        };
        this._startupListTableModel = new StartupListTableModel(codeHookLookup){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<IStartup> add() {
                String string = StartupArb.getString("NONE");
                IStartup iStartup = StartupRegistry.getInstanceFor(string);
                iStartup.loadFromXml(null);
                ArrayList<IStartup> arrayList = new ArrayList<IStartup>();
                arrayList.add(iStartup);
                return arrayList;
            }
        };
        this._startupListTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TestDetails.this.markDirty(true);
            }
        });
        this._startupListTableModel.setRowList(this._testImpl.getTest().getStartupCodeHooks());
        this._startupPanel = new ListTablePanel<IStartup>(this._startupListTableModel);
        this._startupPanel.setName("startupPanel");
        this._teardownListTableModel = new TeardownListTableModel(codeHookLookup){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ITeardown> add() {
                String string = TeardownArb.getString("NONE");
                ITeardown iTeardown = TearDownRegistry.getInstanceFor(string);
                iTeardown.loadFromXml(null);
                ArrayList<ITeardown> arrayList = new ArrayList<ITeardown>();
                arrayList.add(iTeardown);
                return arrayList;
            }
        };
        this._teardownListTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TestDetails.this.markDirty(true);
            }
        });
        this._teardownListTableModel.setRowList(this._testImpl.getTest().getTeardownCodeHooks());
        this._teardownPanel = new ListTablePanel<ITeardown>(this._teardownListTableModel);
        this._teardownPanel.setName("teardownPanel");
        this._coverageCheckBox = new JCheckBox(UiArb.getString("CODE_COVERAGE_LABEL"), this._test.getCoverage());
        this._coverageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestDetails.this.markDirty(true);
            }
        });
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        customTabbedPane.setName("testImplTabPane");
        this._testImplPanel = new JPanel();
        this._testImplPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this._testImplPanel.setName("testImplPanel");
        this.updateTestImplPanel(this._testImpl, codeHookLookup);
        customTabbedPane.addTab(null, this._testImpl.getName(), (Component)this._testImplPanel);
        GroupLayout groupLayout = new GroupLayout(this._panelCenter);
        this._panelCenter.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this._testSignatureUI).addGroup(groupLayout.createSequentialGroup().addComponent(this._startupPanel)).addGroup(groupLayout.createSequentialGroup().addComponent(this._teardownPanel)).addComponent(this._coverageCheckBox).addComponent((Component)customTabbedPane));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this._testSignatureUI).addGroup(groupLayout.createParallelGroup().addComponent(this._startupPanel)).addGroup(groupLayout.createParallelGroup().addComponent(this._teardownPanel)).addComponent(this._coverageCheckBox).addComponent((Component)customTabbedPane));
        this.add((Component)this._scrollPane, "Center");
        this.validate();
        this.repaint();
        this.setInitialized(true);
        this.toggleButtons();
    }

    private void updateTestImplPanel(UtTestImpl utTestImpl, CodeHookLookup codeHookLookup) {
        this._unsavedChanges = false;
        this._testImpl = utTestImpl;
        this._paramPanel = new ParamPanel(this._paramPanel);
        this._paramPanel.updateUI(this._testImpl);
        this._paramPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("PARAMS".equals(propertyChangeEvent.getPropertyName())) {
                    TestDetails.this.markDirty(true);
                }
            }
        });
        this._validationListTableModel = new ValidationListTableModel(codeHookLookup){

            @Override
            protected List<IValidation> add() {
                String string = ValidationArb.getString("NONE");
                IValidation iValidation = ValidationRegistry.getInstanceFor(string);
                iValidation.loadFromXml(null);
                ArrayList<IValidation> arrayList = new ArrayList<IValidation>();
                arrayList.add(iValidation);
                return arrayList;
            }
        };
        this._validationListTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TestDetails.this.markDirty(true);
            }
        });
        this._validationListTableModel.setRowList(this._testImpl.getValidationCodeHooks());
        this._validationPanel = new ListTablePanel<IValidation>(this._validationListTableModel);
        this._validationPanel.setName("validationPanel");
        GroupLayout groupLayout = new GroupLayout(this._testImplPanel);
        this._testImplPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this._paramPanel).addComponent(this._validationPanel));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this._paramPanel).addComponent(this._validationPanel));
        this._testImplPanel.validate();
    }

    private void updateTestSignatureData(UtTest utTest) {
        this._testSignatureUI.setText(utTest.getTestCall());
    }

    private JTextArea getTestSignatureUI() {
        if (null == this._testSignatureUI) {
            this._testSignatureUI = new JTextArea();
            this._testSignatureUI.setBorder(BorderFactory.createEmptyBorder());
            this._testSignatureUI.setLineWrap(true);
            this._testSignatureUI.setWrapStyleWord(true);
            this._testSignatureUI.setEditable(false);
            this._testSignatureUI.setOpaque(false);
        }
        return this._testSignatureUI;
    }

    private void toggleButtons() {
        View.updateToolbarActions((Toolbar)this.getToolbar());
        this.setEditable(this._editor.isEditable());
    }

    void setEditable(boolean bl) {
        if (null != this._paramPanel) {
            this._paramPanel.setEditable(bl);
        }
        if (null != this._startupPanel) {
            this._startupPanel.setEditable(bl);
            this._teardownPanel.setEditable(bl);
            this._coverageCheckBox.setEnabled(bl);
            this._validationPanel.setEditable(bl);
        }
    }

    void stopEditing() {
        this._paramPanel.stopEditing();
    }

    void commit() throws ObjectUpdateException {
        this.stopEditing();
        this.saveImpl();
    }

    private void saveImpl() throws ObjectUpdateException {
        if (this._unsavedChanges) {
            this._test.setStartupCodeHooks(this._startupListTableModel.getRowList());
            this._test.setTeardownCodeHooks(this._teardownListTableModel.getRowList());
            this._test.setCoverage(this._coverageCheckBox.isSelected());
            this._testImpl.setExpectedStatus(this._paramPanel.getExpectedStatus());
            this._testImpl.setExpectedErrorCode(this._paramPanel.getExpectedErrorCode());
            this._testImpl.setValidationCodeHooks(this._validationListTableModel.getRowList());
            this._test.save(true);
            this._unsavedChanges = false;
            this.toggleButtons();
        }
    }

    void rollback() {
        this.revertImpl();
    }

    private void revertImpl() {
        if (this._unsavedChanges) {
            this._unsavedChanges = false;
            String string = this._test.getId();
            this._test = new UtTest(string);
            String string2 = this._testImpl == null ? null : this._testImpl.getName();
            this.updateUI(this._test, string2);
        }
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private void markDirty(boolean bl) {
        if (this.isInitialized()) {
            this._editor.markDirty(bl);
            this._unsavedChanges = bl;
            this.toggleButtons();
        }
    }
}

