/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_objects;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.navigator.OracleNavigatorResource;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtDataTypeConnectionReference;
import oracle.dbtools.unit_test.manage_objects.ManageObjectsArb;
import oracle.dbtools.unit_test.manage_objects.PLSQLOperation;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.icons.OracleIcons;

public class PLSQLOperationSelector {
    private Component _container;
    private SelectionListener _listener;
    private DBConnectionComboBox _connectionSelector;
    private OracleDatabase _db;
    private CustomJTree _tree;
    private JScrollPane _sp;
    private TreePath _selectedPath = null;
    private boolean _inValueChangedListener = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PLSQLOperationSelector(Component component, String string, SelectionListener selectionListener) {
        this._container = component;
        this._listener = selectionListener;
        this._connectionSelector = new DBConnectionComboBox();
        this._sp = new JScrollPane();
        this._sp.setMinimumSize(new Dimension(200, 200));
        UtDataTypeConnectionReference utDataTypeConnectionReference = UtAddin.getDataTypeConnectionReference();
        String string2 = utDataTypeConnectionReference.peekConnectionQualName();
        if (string2 == null && string != null) {
            string2 = string;
            utDataTypeConnectionReference.setConnectionQualName(string);
        }
        if (string2 == null) {
            this._connectionSelector.setCurrentConnection("");
        } else {
            this._connectionSelector.setCurrentConnection(string2);
        }
        JComboBox jComboBox = this._connectionSelector.getJComboBox();
        jComboBox.addItemListener(new ConnComboListener(this._connectionSelector));
        UiUtils.nameForQA(jComboBox, "Connection", new String[0]);
        try {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            String string3 = this._connectionSelector.getCurrentConnectionName();
            this._db = this.getDatabase(string3);
            this.initTree();
        }
        catch (DBException dBException) {
            DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
            ExceptionHandler.handleException((Throwable)dBException2);
        }
        finally {
            ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        }
        this._connectionSelector.getJComboBox().addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
                        String string = PLSQLOperationSelector.this._connectionSelector.getCurrentConnectionName();
                        PLSQLOperationSelector.this._db = PLSQLOperationSelector.this.getDatabase(string);
                        PLSQLOperationSelector.this.initTree();
                        if (PLSQLOperationSelector.this._listener != null) {
                            PLSQLOperationSelector.this._listener.onSelectConnection(string);
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception.getCause() instanceof Exception ? (Exception)exception.getCause() : exception;
                        ExceptionHandler.handleException((Throwable)exception2);
                    }
                    finally {
                        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
                    }
                }
            }
        });
    }

    public Component getConnectionSelector() {
        return this._connectionSelector.getJComboBox();
    }

    public Component getOperationTree() {
        return this._sp;
    }

    public String getCurrentConnectionName() {
        return this._connectionSelector.getCurrentConnectionName();
    }

    public void setCurrentConnectionName(String string) {
        this._connectionSelector.setCurrentConnection(string);
    }

    public String[] getConnectionNames() {
        return this._connectionSelector.getConnNames();
    }

    public PLSQLOperation getSelectedOperation() {
        Object object;
        PLSQLOperation pLSQLOperation = null;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof JMutableTreeNode) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)object;
            pLSQLOperation = this.getPLSQLOperation(jMutableTreeNode);
        }
        return pLSQLOperation;
    }

    public boolean setSelectedOperation(PLSQLOperation pLSQLOperation) {
        boolean bl = false;
        try {
            TreePath treePath;
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._tree.getModel().getRoot();
            TreePath treePath2 = new TreePath(jMutableTreeNode);
            TreePath treePath3 = null;
            String string = this._db.getUserName();
            if (pLSQLOperation.getSchema().equals(string)) {
                treePath3 = treePath2;
            } else {
                treePath = this.findChildNode(treePath2, this.getRaptorLabel("SCHEMAS_LABEL"), null);
                if (treePath != null) {
                    treePath3 = this.findChildNode(treePath, pLSQLOperation.getSchema(), null);
                } else {
                    this._tree.setSelectionPath(treePath);
                    this._tree.scrollPathToVisible(treePath);
                }
            }
            if (treePath3 != null) {
                if (pLSQLOperation.getPackage() != null) {
                    treePath = this.findChildNode(treePath3, this.getRaptorLabel("PACKAGE_LABEL"), null);
                    bl = this.selectPackageOperation(treePath, pLSQLOperation);
                } else if (pLSQLOperation.isFunction()) {
                    treePath = this.findChildNode(treePath3, this.getRaptorLabel("FUNCTION_LABEL"), null);
                    bl = this.selectStandaloneOperation(treePath, pLSQLOperation);
                } else {
                    treePath = this.findChildNode(treePath3, this.getRaptorLabel("PROCEDURE_LABEL"), null);
                    bl = this.selectStandaloneOperation(treePath, pLSQLOperation);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return bl;
    }

    private boolean selectPackageOperation(TreePath treePath, PLSQLOperation pLSQLOperation) {
        boolean bl = false;
        TreePath treePath2 = this.findChildNode(treePath, pLSQLOperation.getPackage(), null);
        if (treePath2 != null) {
            TreePath treePath3 = this.findChildNode(treePath2, pLSQLOperation.getOperation(), pLSQLOperation);
            if (treePath3 != null) {
                this._tree.setSelectionPath(treePath3);
                this._tree.scrollPathToVisible(treePath3);
                bl = true;
            } else {
                this._tree.setSelectionPath(treePath2);
                this._tree.scrollPathToVisible(treePath2);
            }
        } else {
            this._tree.setSelectionPath(treePath);
            this._tree.scrollPathToVisible(treePath);
        }
        return bl;
    }

    private boolean selectStandaloneOperation(TreePath treePath, PLSQLOperation pLSQLOperation) {
        boolean bl = false;
        TreePath treePath2 = this.findChildNode(treePath, pLSQLOperation.getOperation(), null);
        if (treePath2 != null) {
            this._tree.setSelectionPath(treePath2);
            this._tree.scrollPathToVisible(treePath2);
            bl = true;
        } else {
            this._tree.setSelectionPath(treePath);
            this._tree.scrollPathToVisible(treePath);
        }
        return bl;
    }

    private TreePath findChildNode(TreePath treePath, String string, Object object) {
        this._tree.expandPath(treePath);
        TreePath treePath2 = null;
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        int n = jMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getChildAt(i);
            JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode2.getUserObject();
            if (!string.equals(jTreeCellData.getText()) || object != null && !object.equals(jTreeCellData.getUserObject())) continue;
            treePath2 = treePath.pathByAddingChild(jMutableTreeNode2);
            break;
        }
        return treePath2;
    }

    private String stripQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private OracleDatabase getDatabase(String string) throws DBException {
        return (OracleDatabase)Connections.getInstance().getDatabase(string);
    }

    private TreeNodeLoader getTreeNodeLoader(JMutableTreeNode jMutableTreeNode) {
        Object object = ((JTreeCellData)jMutableTreeNode.getUserObject()).getUserObject();
        return object instanceof TreeNodeLoader ? (TreeNodeLoader)object : null;
    }

    private PLSQLOperation getPLSQLOperation(JMutableTreeNode jMutableTreeNode) {
        Object object = ((JTreeCellData)jMutableTreeNode.getUserObject()).getUserObject();
        return object instanceof PLSQLOperation ? (PLSQLOperation)object : null;
    }

    private JMutableTreeNode createLoadableTreeNode(Icon icon, String string, String string2, TreeNodeLoader treeNodeLoader) {
        JTreeCellData jTreeCellData = new JTreeCellData(icon, string);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setToolTipText(string2);
        jTreeCellData.setUserObject((Object)treeNodeLoader);
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode(jTreeCellData);
        jMutableTreeNode.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
        return jMutableTreeNode;
    }

    private JMutableTreeNode createOperationTreeNode(Icon icon, String string, String string2, PLSQLOperation pLSQLOperation) {
        JTreeCellData jTreeCellData = new JTreeCellData(icon, string);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setToolTipText(string2);
        jTreeCellData.setUserObject((Object)pLSQLOperation);
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode(jTreeCellData);
        return jMutableTreeNode;
    }

    private JMutableTreeNode createSimpleTreeNode(Icon icon, String string, String string2) {
        JTreeCellData jTreeCellData = new JTreeCellData(icon, string);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setToolTipText(string2);
        return new JMutableTreeNode(jTreeCellData);
    }

    private Icon getRaptorIcon(String string) {
        return new ImageIcon(OracleNavigatorResource.getImage((String)string));
    }

    private String getRaptorLabel(String string) {
        return OracleNavigatorResource.getString((String)string);
    }

    private JMutableTreeNode createSchemaTreeNode(Icon icon, String string, String string2) {
        JMutableTreeNode jMutableTreeNode = this.createSimpleTreeNode(icon, string, string);
        JMutableTreeNode jMutableTreeNode2 = this.createLoadableTreeNode(this.getRaptorIcon("PACKAGE_FOLDER_ICON"), this.getRaptorLabel("PACKAGE_LABEL"), this.getRaptorLabel("PACKAGE_LABEL"), new PackagesTreeNodeLoader(string2));
        jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode2);
        JMutableTreeNode jMutableTreeNode3 = this.createLoadableTreeNode(this.getRaptorIcon("PROCEDURE_FOLDER_ICON"), this.getRaptorLabel("PROCEDURE_LABEL"), this.getRaptorLabel("PROCEDURE_LABEL"), new ProceduresTreeNodeLoader(string2));
        jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode3);
        JMutableTreeNode jMutableTreeNode4 = this.createLoadableTreeNode(this.getRaptorIcon("FUNCTION_FOLDER_ICON"), this.getRaptorLabel("FUNCTION_LABEL"), this.getRaptorLabel("FUNCTION_LABEL"), new FunctionsTreeNodeLoader(string2));
        jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode4);
        return jMutableTreeNode;
    }

    private void initTree() throws DBException {
        Object object;
        JMutableTreeNode jMutableTreeNode = null;
        if (this._db == null) {
            jMutableTreeNode = new JMutableTreeNode(ManageObjectsArb.getString("TREE_ROOT_INITIAL_VALUE"));
        } else {
            object = this._db.getUserName();
            object = this.stripQuotes((String)object);
            Icon icon = this.getRaptorIcon("ORACLE_CONNECTION_ICON");
            jMutableTreeNode = this.createSchemaTreeNode(icon, this._db.getConnectionName(), (String)object);
            JMutableTreeNode jMutableTreeNode2 = this.createLoadableTreeNode(this.getRaptorIcon("SCHEMAS_FOLDER_ICON"), this.getRaptorLabel("SCHEMAS_LABEL"), this.getRaptorLabel("SCHEMAS_LABEL"), new SchemasTreeNodeLoader((String)object));
            jMutableTreeNode.add((MutableTreeNode)jMutableTreeNode2);
        }
        object = new DefaultTreeModel((TreeNode)jMutableTreeNode);
        this._tree = new CustomJTree((TreeModel)object);
        this._tree.enableToolTips(true);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                try {
                    JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
                    TreeNodeLoader treeNodeLoader = PLSQLOperationSelector.this.getTreeNodeLoader(jMutableTreeNode);
                    if (treeNodeLoader != null) {
                        treeNodeLoader.ensureChildrenLoaded(jMutableTreeNode);
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!PLSQLOperationSelector.this._inValueChangedListener) {
                    PLSQLOperationSelector.this._inValueChangedListener = true;
                    try {
                        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                        PLSQLOperation pLSQLOperation = PLSQLOperationSelector.this.getPLSQLOperation(jMutableTreeNode);
                        if (pLSQLOperation != null) {
                            boolean bl;
                            boolean bl2 = bl = PLSQLOperationSelector.this._listener != null ? PLSQLOperationSelector.this._listener.onSelectOperation(pLSQLOperation) : true;
                            if (bl) {
                                PLSQLOperationSelector.this._selectedPath = treeSelectionEvent.getPath();
                            } else if (PLSQLOperationSelector.this._selectedPath != null) {
                                PLSQLOperationSelector.this._tree.setSelectionPath(PLSQLOperationSelector.this._selectedPath);
                            } else {
                                PLSQLOperationSelector.this._tree.clearSelection();
                            }
                        }
                    }
                    finally {
                        PLSQLOperationSelector.this._inValueChangedListener = false;
                    }
                }
            }
        });
        this._sp.setViewportView((Component)this._tree);
    }

    private class SchemasTreeNodeLoader
    extends TreeNodeLoader {
        SchemasTreeNodeLoader(String string) {
            super(string);
        }

        @Override
        void loadChildren(JMutableTreeNode jMutableTreeNode, String string) throws SQLException {
            for (String string2 : this.queryObjectNames("schemaUsers", string)) {
                JMutableTreeNode jMutableTreeNode2 = PLSQLOperationSelector.this.createSchemaTreeNode(OracleIcons.getIcon((String)"user.png"), string2, string2);
                ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    private class FunctionsTreeNodeLoader
    extends TreeNodeLoader {
        FunctionsTreeNodeLoader(String string) {
            super(string);
        }

        @Override
        void loadChildren(JMutableTreeNode jMutableTreeNode, String string) throws SQLException {
            for (String string2 : this.queryObjectNames("schemaFunctions", string)) {
                JMutableTreeNode jMutableTreeNode2 = PLSQLOperationSelector.this.createOperationTreeNode(PLSQLOperationSelector.this.getRaptorIcon("FUNCTION_ICON"), string2, string2, new PLSQLOperation(string, null, string2, true, string2, null));
                ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    private class ConnComboListener
    implements ItemListener {
        private DBConnectionComboBox _connectionSelector;

        public ConnComboListener(DBConnectionComboBox dBConnectionComboBox) {
            this._connectionSelector = dBConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    String string = (String)itemEvent.getItem();
                    UtAddin.getDataTypeConnectionReference().setConnectionQualName(string);
                    this._connectionSelector.setCurrentConnection(string);
                    break;
                }
            }
        }
    }

    private class ProceduresTreeNodeLoader
    extends TreeNodeLoader {
        ProceduresTreeNodeLoader(String string) {
            super(string);
        }

        @Override
        void loadChildren(JMutableTreeNode jMutableTreeNode, String string) throws SQLException {
            for (String string2 : this.queryObjectNames("schemaProcedures", string)) {
                JMutableTreeNode jMutableTreeNode2 = PLSQLOperationSelector.this.createOperationTreeNode(PLSQLOperationSelector.this.getRaptorIcon("PROCEDURE_ICON"), string2, string2, new PLSQLOperation(string, null, string2, false, string2, null));
                ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    private class PackageOperationTreeNodeLoader
    extends TreeNodeLoader {
        private String _package;

        PackageOperationTreeNodeLoader(String string, String string2) {
            super(string);
            this._package = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PLSQLOperation> queryPackagePLSQLOperations(String string, String string2) throws SQLException {
            ArrayList<PLSQLOperation> arrayList = null;
            Connection connection = PLSQLOperationSelector.this._db.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet;
                block10: {
                    resultSet = null;
                    try {
                        CharSequence charSequence;
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(false);
                        String string3 = UtUtils.getQuery("packageOperations");
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("SCHEMA", string);
                        hashMap.put("PACKAGE", string2);
                        resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                        if (resultSet == null) break block10;
                        ArrayList<PackageOp> arrayList2 = new ArrayList<PackageOp>();
                        PackageOp packageOp = null;
                        while (resultSet.next()) {
                            String string4 = resultSet.getString("OP_NAME");
                            String object = resultSet.getString("ARG_NAME");
                            charSequence = resultSet.getString("DATA_TYPE");
                            String string5 = resultSet.getString("OVERLOAD");
                            if (packageOp == null || !packageOp.opName.equals(string4) || packageOp.overload == null && string5 != null || packageOp.overload != null && !packageOp.overload.equals(string5)) {
                                packageOp = new PackageOp();
                                packageOp.opName = string4;
                                packageOp.overload = string5;
                                arrayList2.add(packageOp);
                            }
                            if (charSequence == null || ((String)charSequence).equals("")) continue;
                            if (object != null && !object.equals("")) {
                                packageOp.args.add(object + ' ' + (String)charSequence);
                                continue;
                            }
                            packageOp.retType = charSequence;
                        }
                        arrayList = new ArrayList<PLSQLOperation>(arrayList2.size());
                        for (PackageOp packageOp2 : arrayList2) {
                            charSequence = new StringBuffer();
                            ((StringBuffer)charSequence).append(packageOp2.opName);
                            if (packageOp2.args.size() > 0) {
                                ((StringBuffer)charSequence).append(" ( ");
                                ((StringBuffer)charSequence).append(packageOp2.args.get(0));
                                for (int i = 1; i < packageOp2.args.size(); ++i) {
                                    ((StringBuffer)charSequence).append(", ");
                                    ((StringBuffer)charSequence).append(packageOp2.args.get(i));
                                }
                                ((StringBuffer)charSequence).append(" )");
                            }
                            if (packageOp2.retType != null) {
                                ((StringBuffer)charSequence).append(" return " + packageOp2.retType);
                            }
                            arrayList.add(new PLSQLOperation(string, string2, packageOp2.opName, packageOp2.retType != null, ((StringBuffer)charSequence).toString(), packageOp2.overload));
                        }
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
            }
            return arrayList;
        }

        @Override
        void loadChildren(JMutableTreeNode jMutableTreeNode, String string) throws SQLException {
            for (PLSQLOperation pLSQLOperation : this.queryPackagePLSQLOperations(string, this._package)) {
                Icon icon = pLSQLOperation.isFunction() ? PLSQLOperationSelector.this.getRaptorIcon("FUNCTION_ICON") : PLSQLOperationSelector.this.getRaptorIcon("PROCEDURE_ICON");
                String string2 = null;
                string2 = pLSQLOperation.isFunction() ? "function " : "procedure ";
                string2 = string2 + pLSQLOperation.getSignature();
                JMutableTreeNode jMutableTreeNode2 = PLSQLOperationSelector.this.createOperationTreeNode(icon, pLSQLOperation.getOperation(), string2, pLSQLOperation);
                ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }

        class PackageOp {
            String opName;
            String overload;
            String retType;
            ArrayList<String> args = new ArrayList();

            PackageOp() {
            }
        }
    }

    private class PackagesTreeNodeLoader
    extends TreeNodeLoader {
        PackagesTreeNodeLoader(String string) {
            super(string);
        }

        @Override
        void loadChildren(JMutableTreeNode jMutableTreeNode, String string) throws SQLException {
            for (String string2 : this.queryObjectNames("schemaPackages", string)) {
                string2 = PLSQLOperationSelector.this.stripQuotes(string2);
                JMutableTreeNode jMutableTreeNode2 = PLSQLOperationSelector.this.createLoadableTreeNode(OracleIcons.getIcon((String)"plsql_package.png"), string2, string2, new PackageOperationTreeNodeLoader(string, string2));
                ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    private abstract class TreeNodeLoader {
        private boolean _childrenLoaded = false;
        private String _schema;

        TreeNodeLoader(String string) {
            this._schema = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ensureChildrenLoaded(JMutableTreeNode jMutableTreeNode) throws SQLException {
            if (!this._childrenLoaded) {
                Cursor cursor = PLSQLOperationSelector.this._container.getCursor();
                PLSQLOperationSelector.this._container.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).getChild(jMutableTreeNode, 0);
                    ((DefaultTreeModel)PLSQLOperationSelector.this._tree.getModel()).removeNodeFromParent((MutableTreeNode)jMutableTreeNode2);
                    this.loadChildren(jMutableTreeNode, this._schema);
                    this._childrenLoaded = true;
                }
                finally {
                    PLSQLOperationSelector.this._container.setCursor(cursor);
                }
            }
        }

        abstract void loadChildren(JMutableTreeNode var1, String var2) throws SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> queryObjectNames(String string, String string2) throws SQLException {
            ArrayList<String> arrayList = new ArrayList<String>();
            Connection connection = PLSQLOperationSelector.this._db.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet;
                block4: {
                    resultSet = null;
                    try {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        dBUtil.setRaiseError(false);
                        String string3 = UtUtils.getQuery(string);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("SCHEMA", string2);
                        resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                        if (resultSet == null) break block4;
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("NAME"));
                        }
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
            }
            return arrayList;
        }
    }

    public static abstract class SelectionListener {
        public abstract void onSelectConnection(String var1);

        public abstract boolean onSelectOperation(PLSQLOperation var1);
    }
}

