/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_user;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.RunPrivilegedScript;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.manage_user.UserStrings;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public abstract class UserUtils {
    private static Connection sysConn = null;

    private UserUtils() {
    }

    public static String getQuery(Connection connection, String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(UtAddin.class.getClassLoader(), "/oracle/dbtools/unit_test/manage_user/UserSql.xml"));
        Query query = queryXMLSupport.getQuery(string, connection != null ? connection : UtAddin.getRepositoryManager().getConnection());
        return query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean basicPrivsCheck(Connection connection) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UserUtils.getQuery(connection, "isDBA");
                String string2 = dBUtil.executeReturnOneCol(string, (List)null);
                bl = !string2.equals("0");
                if (!bl) {
                    string = UserUtils.getQuery(connection, "basic_privs_check");
                    string2 = dBUtil.executeReturnOneCol(string, (List)null);
                    bl = !string2.equals("0");
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean roleSelectCheck(Connection connection) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UserUtils.getQuery(connection, "role_check");
                bl = dBUtil.execute(string, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean roleCountCheck(Connection connection) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UserUtils.getQuery(connection, "role_check");
                String string2 = dBUtil.executeOracleReturnOneCol(string, (Map)null);
                bl = string2.equals("2");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canReadUserInfo(Connection connection) {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UserUtils.getQuery(connection, "priv_user");
                bl = dBUtil.execute(string, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sessionHasAdminRole(Connection connection) {
        String string = null;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string2 = UserUtils.getQuery(connection, "sessionHasAdminRole");
                string = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string != null && !string.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sessionHasUserRole(Connection connection) {
        String string = null;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string2 = UserUtils.getQuery(connection, "sessionHasUserRole");
                string = dBUtil.executeReturnOneCol(string2, hashMap);
                bl = string != null && !string.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUser(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = UserUtils.getQuery(connection, "get_user");
                string = dBUtil.executeReturnOneCol(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAdminUser(Connection connection, String string, boolean bl) {
        String string2 = null;
        boolean bl2 = false;
        if ((string == null || string.equals("")) && (string = UserUtils.getUser(connection)) == null) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string3 = bl ? UserUtils.getQuery(connection, "isAdminAdmin") : UserUtils.getQuery(connection, "isUserAdmin");
                hashMap.put("USERNAME", string);
                string2 = dBUtil.executeReturnOneCol(string3, hashMap);
                bl2 = !string2.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean grantUser(Connection connection, String string, boolean bl) {
        boolean bl2 = false;
        if ((string == null || string.equals("")) && (string = UserUtils.getUser(connection)) == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "grant UT_REPO_USER to \"" + string + "\"";
                if (bl) {
                    string2 = string2 + " with admin option";
                }
                bl2 = dBUtil.execute(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean revokeUser(Connection connection, String string) {
        boolean bl = false;
        if ((string == null || string.equals("")) && (string = UserUtils.getUser(connection)) == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "revoke UT_REPO_USER from \"" + string + "\"";
                bl = dBUtil.execute(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean grantAdmin(Connection connection, String string, boolean bl) {
        boolean bl2 = false;
        if ((string == null || string.equals("")) && (string = UserUtils.getUser(connection)) == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "grant UT_REPO_ADMINISTRATOR to \"" + string + "\"";
                if (bl) {
                    string2 = string2 + " with admin option";
                }
                bl2 = dBUtil.execute(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean revokeAdmin(Connection connection, String string) {
        boolean bl = false;
        if ((string == null || string.equals("")) && (string = UserUtils.getUser(connection)) == null) {
            return false;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string2 = "revoke UT_REPO_ADMINISTRATOR from \"" + string + "\"";
                bl = dBUtil.execute(string2, (List)null);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUsers(Connection connection) {
        ResultSet resultSet = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string = UserUtils.getQuery(connection, "repo_users");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        linkedList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAdmins(Connection connection) {
        ResultSet resultSet = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string = UserUtils.getQuery(connection, "repo_admins");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        linkedList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNonUsers(Connection connection) {
        ResultSet resultSet = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string = UserUtils.getQuery(connection, "non_user");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        linkedList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNonAdmins(Connection connection) {
        ResultSet resultSet = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string = UserUtils.getQuery(connection, "non_admin");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        linkedList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return linkedList;
    }

    public static boolean ensureRolesSetup(Connection connection, String string) {
        boolean bl = false;
        try {
            bl = UserUtils.ensureRolesSetupInt(connection, string);
            if (UtAddin.getRepositoryManager().isConnected()) {
                UtAddin.getRepositoryManager().initializeConnection();
                if (bl && UserUtils.expandRolePrivs()) {
                    UtAddin.getRepositoryManager().initializeConnection();
                }
            }
        }
        finally {
            UserUtils.closeSysConn();
        }
        return bl;
    }

    private static boolean ensureRolesSetupInt(Connection connection, String string) {
        boolean bl = false;
        if (UserUtils.basicPrivsCheck(connection)) {
            if (UserUtils.roleSelectCheck(connection)) {
                if (UserUtils.roleCountCheck(connection)) {
                    if (UserUtils.canReadUserInfo(connection)) {
                        if (UserUtils.isAdminUser(connection, UserUtils.getUser(connection), true)) {
                            bl = true;
                        } else if (UserUtils.isAdminUser(connection, UserUtils.getUser(connection), false)) {
                            bl = true;
                        } else {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("NO_ADMIN_PERM"), (String)UserStrings.getString("INFO_TITLE"), null);
                            if (UserUtils.grantAdmin(connection, string)) {
                                bl = UserUtils.ensureRolesSetupInt(connection, string);
                            }
                        }
                    } else {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("NO_ADMIN_PERM"), (String)UserStrings.getString("INFO_TITLE"), null);
                        if (UserUtils.grantAdmin(connection, string)) {
                            bl = UserUtils.ensureRolesSetupInt(connection, string);
                        }
                    }
                } else {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("NO_ROLES"), (String)UserStrings.getString("INFO_TITLE"), null);
                    if (UserUtils.createRoles(connection, string)) {
                        bl = UserUtils.ensureRolesSetupInt(connection, string);
                    }
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("NO_SELECT"), (String)UserStrings.getString("INFO_TITLE"), null);
                if (UserUtils.grantSelect(connection, string)) {
                    bl = UserUtils.ensureRolesSetupInt(connection, string);
                }
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("NO_BASIC_PRIVS"), (String)UserStrings.getString("INFO_TITLE"), null);
            if (UserUtils.grantBasicPrivs(connection, string)) {
                bl = UserUtils.ensureRolesSetupInt(connection, string);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean expandRolePrivs() {
        Object object;
        String[] stringArray;
        boolean bl = false;
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        String string = UtAddin.getRepositoryManager().getName();
        if (Connections.getInstance().lock(connection)) {
            try {
                stringArray = DBUtil.getInstance((Connection)connection);
                object = UserUtils.getQuery(connection, "expand_role_check");
                String string2 = stringArray.executeOracleReturnOneCol((String)object, (Map)null);
                bl = string2 == null || !string2.equals("2");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        if (bl) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)UserStrings.getString("INSUFFICIENT_ROLE_PRIVS"), (String)UserStrings.getString("INFO_TITLE"), null);
            bl = false;
            stringArray = new String[]{"grant select on dba_tab_privs to UT_REPO_ADMINISTRATOR", "grant select on dba_tab_privs to UT_REPO_USER", "grant execute on dbms_lock to UT_REPO_ADMINISTRATOR", "grant execute on dbms_lock to UT_REPO_USER"};
            try {
                object = UserUtils.getConnection(string);
                if (object != null) {
                    bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)object);
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UserUtils.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return bl;
    }

    private static Connection getConnection(String string) {
        if (sysConn == null) {
            String string2 = "sys as SYSDBA";
            String string3 = "";
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string);
                ConnectionIdentifier connectionIdentifier = null;
                if (connection != null) {
                    connectionIdentifier = DefaultConnectionIdentifier.createIdentifier((Connection)connection);
                }
                if (connectionIdentifier != null && DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)connectionIdentifier, (String)"autonomous")) {
                    string2 = "ADMIN";
                    string3 = "";
                }
            }
            catch (Throwable throwable) {
                Logger.getLogger(UtUtils.class.getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            }
            sysConn = RunPrivilegedScript.getConnection((String)string, (String)string2, (String)string3);
        }
        return sysConn;
    }

    private static void closeSysConn() {
        if (sysConn != null) {
            try {
                sysConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            sysConn = null;
        }
    }

    private static boolean grantBasicPrivs(Connection connection, String string) {
        String[] stringArray = new String[]{"grant connect, resource, create view, unlimited tablespace to \"" + UserUtils.getUser(connection) + "\""};
        try {
            boolean bl = false;
            Connection connection2 = UserUtils.getConnection(string);
            if (connection2 != null) {
                bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)connection2);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UserUtils.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }

    private static boolean grantAdmin(Connection connection, String string) {
        String[] stringArray = new String[]{"grant UT_REPO_ADMINISTRATOR to \"" + UserUtils.getUser(connection) + "\" with admin option"};
        try {
            boolean bl = false;
            Connection connection2 = UserUtils.getConnection(string);
            if (connection2 != null) {
                bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)connection2);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UserUtils.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }

    private static boolean grantSelect(Connection connection, String string) {
        String[] stringArray = new String[]{"grant select on dba_roles to \"" + UserUtils.getUser(connection) + "\"", "grant select on dba_role_privs to \"" + UserUtils.getUser(connection) + "\""};
        try {
            boolean bl = false;
            Connection connection2 = UserUtils.getConnection(string);
            if (connection2 != null) {
                bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)connection2);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UserUtils.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }

    private static boolean createRoles(Connection connection, String string) {
        String[] stringArray = new String[]{"create role UT_REPO_ADMINISTRATOR", "create role UT_REPO_USER", "grant create public synonym,drop public synonym to UT_REPO_ADMINISTRATOR", "grant select on dba_role_privs to UT_REPO_USER", "grant select on dba_role_privs to UT_REPO_ADMINISTRATOR", "grant select on dba_roles to UT_REPO_ADMINISTRATOR", "grant select on dba_roles to UT_REPO_USER", "grant select on dba_tab_privs to UT_REPO_ADMINISTRATOR", "grant select on dba_tab_privs to UT_REPO_USER", "grant execute on dbms_lock to UT_REPO_ADMINISTRATOR", "grant execute on dbms_lock to UT_REPO_USER", "grant UT_REPO_USER to UT_REPO_ADMINISTRATOR with admin option", "grant UT_REPO_ADMINISTRATOR to \"" + UserUtils.getUser(connection) + "\" with admin option"};
        try {
            boolean bl = false;
            Connection connection2 = UserUtils.getConnection(string);
            if (connection2 != null) {
                bl = RunPrivilegedScript.runWithPreview((String[])stringArray, (Connection)connection2);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UserUtils.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
    }
}

