/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.awt.Component;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.runner.StatusObject;
import oracle.dbtools.unit_test.runner.UtRunnerArb;
import oracle.dbtools.unit_test.runner.UtRunnerImplArgs;
import oracle.dbtools.unit_test.runner.UtRunnerImplIterator;
import oracle.dbtools.unit_test.runner.UtRunnerObject;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Ide;

public class Debugger {
    private Runner _runner;
    private String message;

    public Debugger(String string) throws ConnectionCanceledException {
        this._runner = new Runner(string);
    }

    Connection getConn() {
        return this._runner.getConn();
    }

    String getRunnerDBQual() {
        return this._runner.getRunnerDBQual();
    }

    public void debugImpl(final UtTestImpl utTestImpl) {
        RaptorTask<String> raptorTask = new RaptorTask<String>(UtRunnerArb.format("UT_TASK_NAME", utTestImpl.getName()), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected String doWork() throws TaskException {
                Debugger.this.message = Debugger.this.debugRunImpl(utTestImpl);
                return Debugger.this.message;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                String string = UtRunnerArb.format("UT_TASK_FAIL", raptorTaskEvent.getTaskDescriptor().getName(), raptorTaskEvent.getTaskDescriptor().getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                Debugger.this._runner.closeConn();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Debugger.this._runner.closeConn();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UtUtils.popupMessage((Component)Ide.getMainWindow(), utTestImpl.getName(), Debugger.this.message);
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugRunImpl(UtTestImpl utTestImpl) {
        if (utTestImpl == null) {
            return UtRunnerArb.getString("DEBUG_NO_IMPL");
        }
        if (this._runner.getConn() == null) {
            return this._runner.getConnectionStatus().getMessage();
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (UtRunnerImplIterator utRunnerImplIterator = null;){
            DBConfig dBConfig = DBConfig.getInstance();
            String string = dBConfig.getString("NULLDISPLAY");
            DataTypeConnectionProvider dataTypeConnectionProvider = UtAddin.getRunnerDataTypeFactory().getDataTypeConnectionProvider(this._runner.getConn());
            utRunnerImplIterator = utTestImpl.getRunnerIterator(dataTypeConnectionProvider);
            utRunnerImplIterator.open();
            UtRunnerObject utRunnerObject = utRunnerImplIterator.next();
            if (utRunnerObject != null) {
                stringBuilder.append(UtRunnerArb.getString("DEBUG_HEADER") + "\n\n");
                stringBuilder.append(UtRunnerArb.getString("DEBUG_CODE") + "\n");
                stringBuilder.append(utRunnerObject.getSql());
                stringBuilder.append("\n" + UtRunnerArb.getString("DEBUG_BINDS") + "\n");
                for (BindingStrategy bindingStrategy : utRunnerObject.getBinds()) {
                    UtRunnerImplArgs utRunnerImplArgs = (UtRunnerImplArgs)bindingStrategy.getParameter();
                    bindingStrategy.reportBinding(stringBuilder, string, utRunnerImplArgs.getInputDataValue());
                }
                stringBuilder.append("\n" + UtRunnerArb.getString("DEBUG_RESULTS") + "\n");
                StatusObject statusObject = this._runner.executeImpl(utTestImpl, null, true, false, true, true);
                stringBuilder.append(UtRunnerArb.getString(statusObject.getStatus()) + "\n");
                if (statusObject.getDebug() != null) {
                    stringBuilder.append(statusObject.getDebug() + "\n");
                } else if (statusObject.getMessage() != null) {
                    stringBuilder.append(statusObject.getMessage() + "\n");
                }
            } else {
                stringBuilder.append(UtRunnerArb.getString("DQV_NO_VALUES"));
            }
        }
        return stringBuilder.toString();
    }
}

