/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.runner.UtRunnerImplArgs;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtArguments;
import oracle.dbtools.unit_test.testObjects.UtLookupItem;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.sql.CLOB;
import oracle.xml.parser.v2.XMLElement;

public class UtTestImplArgs
implements Cloneable,
UtRunnerImplArgs {
    private static Logger LOGGER = Logger.getLogger(UtTestImplArgs.class.getName());
    private final DataType datatype;
    private final UtArguments arg;
    private String _utiId;
    private boolean _testOutVal;
    private boolean dirty = false;
    private String argId;
    private Map<ValueSelector, DataValue> _values = new HashMap<ValueSelector, DataValue>(ValueSelector.values().length);
    private List<DataValue> _oldValues = new ArrayList<DataValue>(4);
    public static boolean _DEBUG = false;
    protected TableCellEditor _tableCellEditor;

    public UtTestImplArgs(String string, UtArguments utArguments, boolean bl, InputStream inputStream, InputStream inputStream2, boolean bl2) {
        this.arg = utArguments;
        this._testOutVal = bl;
        DataTypeConnectionProvider dataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
        DataTypeFactory dataTypeFactory = dataTypeConnectionProvider.getDataTypeFactory();
        this.datatype = dataTypeFactory.getDataType(dataTypeConnectionProvider, utArguments.get_type_metadata(dataTypeFactory));
        this._utiId = string;
        this.loadFromXml(ValueSelector.input, inputStream);
        this.loadFromXml(ValueSelector.result, inputStream2);
        this.dirty = bl2;
    }

    private DataValue getDataValueFromStringRep(String string) {
        DataValue dataValue = null;
        if (string != null && !string.equals("")) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                StringReader stringReader = new StringReader(string);
                int n = stringReader.read();
                while (n >= 0) {
                    outputStreamWriter.write(n);
                    n = stringReader.read();
                }
                outputStreamWriter.flush();
                byteArrayOutputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                dataValue = XMLUtil.unmarshallDataValue((InputStream)byteArrayInputStream, (DataType)this.datatype);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
            }
        } else {
            dataValue = this.datatype.getDataValue(null);
        }
        return dataValue;
    }

    UtTestImplArgs(XMLElement xMLElement, Map<String, UtArguments> map, ImportContext importContext) {
        this.argId = xMLElement.getAttribute("argId");
        if (this.argId == null || this.argId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this.arg = map.get(this.argId);
        if (this.arg == null) {
            importContext.log(LoggerLevel.SEVERE, "Arg not found: " + this.argId);
        }
        DataTypeConnectionProvider dataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
        DataTypeFactory dataTypeFactory = dataTypeConnectionProvider.getDataTypeFactory();
        this.datatype = dataTypeFactory.getDataType(dataTypeConnectionProvider, this.arg.get_type_metadata(dataTypeFactory));
        this._utiId = xMLElement.getAttribute("utiId");
        if (this._utiId == null || this._utiId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        String string = xMLElement.getAttribute("input_value");
        DataValue dataValue = this.getDataValueFromStringRep(string);
        this._values.put(ValueSelector.input, dataValue);
        String string2 = xMLElement.getAttribute("output_value");
        DataValue dataValue2 = this.getDataValueFromStringRep(string2);
        this._values.put(ValueSelector.result, dataValue2);
        String string3 = xMLElement.getAttribute("test_out_val");
        if (string3 != null && !string3.equals("")) {
            this._testOutVal = Boolean.parseBoolean(string3);
        }
    }

    private String getStringRepFromDataValue(DataValue dataValue) {
        String string = null;
        if (dataValue != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                XMLUtil.marshallDataValue((OutputStream)byteArrayOutputStream, (DataValue)dataValue);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), "UTF-8");
                StringWriter stringWriter = new StringWriter();
                int n = inputStreamReader.read();
                while (n >= 0) {
                    char c = (char)n;
                    stringWriter.append(c);
                    n = inputStreamReader.read();
                }
                stringWriter.flush();
                string = stringWriter.toString();
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
            }
        }
        return string;
    }

    void exportFields(XMLElement xMLElement, ExportContext exportContext) {
        String string;
        String string2;
        XMLElement xMLElement2 = exportContext.createExportedElement(xMLElement, "parm");
        xMLElement2.setAttribute("argId", this.getArgId());
        xMLElement2.setAttribute("utiId", this._utiId);
        DataValue dataValue = this._values.get((Object)ValueSelector.input);
        if (dataValue != null && (string2 = this.getStringRepFromDataValue(dataValue)) != null) {
            xMLElement2.setAttribute("input_value", string2);
        }
        if ((string2 = this._values.get((Object)ValueSelector.result)) != null && (string = this.getStringRepFromDataValue((DataValue)string2)) != null) {
            xMLElement2.setAttribute("output_value", string);
        }
        xMLElement2.setAttribute("test_out_val", Boolean.toString(this._testOutVal));
    }

    @Override
    public String getArgId() {
        return this.arg != null ? this.arg.getArgId() : this.argId;
    }

    @Override
    public boolean getTestOutVal() {
        return this._testOutVal;
    }

    public void setTestOutVal(boolean bl) {
        this._testOutVal = bl;
    }

    public void setTestOutVal(int n) {
        this.setTestOutVal(n != 0);
    }

    public UtArguments getArguments() {
        return this.arg;
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getUtiId() {
        return this._utiId;
    }

    public BindingMode getMode() {
        if (this.arg.isReturn()) {
            return BindingMode.RETURN;
        }
        return BindingMode.getBindingMode((String)this.arg.get_in_out());
    }

    public String getName() {
        return this.arg.get_argument_name();
    }

    public Object getInput() {
        return this._getValue(ValueSelector.input);
    }

    public void setInput(Object object) {
        this._setValue(ValueSelector.input, object);
    }

    public boolean equalsInput(Object object) {
        return this.equalsSelectedValue(ValueSelector.input, object);
    }

    @Override
    public DataValue getInputDataValue() {
        return this._getValue(ValueSelector.input);
    }

    public Object getResult() {
        return this._getValue(ValueSelector.result);
    }

    public void setResult(Object object) {
        this._setValue(ValueSelector.result, object);
    }

    @Override
    public DataValue getResultDataValue() {
        return this._getValue(ValueSelector.result);
    }

    public boolean equalsReturn(Object object) {
        return this.equalsSelectedValue(ValueSelector.result, object);
    }

    public boolean equalsSelectedValue(ValueSelector valueSelector, Object object) {
        try {
            DataValue dataValue = this.datatype.getDataValue(object);
            DataValue dataValue2 = this._getValue(valueSelector);
            return dataValue.equals(dataValue2);
        }
        catch (DataTypeIllegalArgumentException dataTypeIllegalArgumentException) {
            LOGGER.log(Level.WARNING, UtUtils.logString(dataTypeIllegalArgumentException), dataTypeIllegalArgumentException);
            return false;
        }
    }

    BindingStrategy getBind(BindContext bindContext) {
        DataType dataType = this.getDataType();
        return dataType.getBind(bindContext, (DataBinding)this);
    }

    @Override
    public void bind(CallableStatement callableStatement, BindingStrategy bindingStrategy) throws SQLException {
        bindingStrategy.bind((Statement)callableStatement, this.getInputDataValue());
    }

    @Override
    public DataValue getOutput(BindingStrategy bindingStrategy) throws SQLException {
        return bindingStrategy.getOutput();
    }

    protected void _debug(String string) {
        if (_DEBUG) {
            LOGGER.log(Level.WARNING, string);
        }
    }

    private DataValue _getValue(ValueSelector valueSelector) {
        if (_DEBUG) {
            this._debug("._getValue(" + (Object)((Object)valueSelector) + ") values=" + this._values);
        }
        DataValue dataValue = this._values.get((Object)valueSelector);
        try {
            return dataValue == null ? this.datatype.getDataValue(null) : dataValue;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
            return null;
        }
    }

    private DataValue _setValue(ValueSelector valueSelector, DataValue dataValue) {
        DataValue dataValue2;
        DataValue dataValue3;
        DataValue dataValue4 = dataValue3 = dataValue != null ? NamedDataValue.getNamedDataValue((String)this.getName(), (DataValue)dataValue) : dataValue;
        if (_DEBUG) {
            this._debug("._setValue(" + (Object)((Object)valueSelector) + ", " + dataValue3 + ")");
        }
        if ((dataValue2 = this._values.put(valueSelector, dataValue3)) != null && !this._oldValues.contains(dataValue2)) {
            this._oldValues.add(dataValue2);
        }
        if (!this._oldValues.contains(dataValue3)) {
            this._oldValues.add(dataValue3);
        }
        if (_DEBUG) {
            this._debug("._setValue(" + (Object)((Object)valueSelector) + ") values=" + this._values);
        }
        return dataValue2;
    }

    private DataValue _setValue(ValueSelector valueSelector, Object object) {
        return this._setValue(valueSelector, this.datatype.getDataValue(object));
    }

    public List<DataValue> getChoices(PairElement pairElement) {
        DataValue dataValue;
        Object object;
        DataValue dataValue2;
        Object object2;
        DataType dataType = this.getDataType();
        LinkedList<DataValue> linkedList = new LinkedList<DataValue>();
        Object object3 = this._oldValues.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (object2 == null || linkedList.contains(object2)) continue;
            linkedList.add((DataValue)object2);
        }
        if (null == pairElement) {
            pairElement = UtConfig.getInstance().getPairElement("LOOKUP_CATEGORY");
        }
        if ((object2 = UtUtils.getLookupValues((String)(object3 = pairElement != null ? pairElement.getName() : "DEFAULT"), dataType.getPlainDataTypeString())) == null || ((Vector)object2).size() == 0) {
            object2 = UtUtils.getLookupValues((String)object3, dataType.getBaseDataTypeString());
        }
        if (object2 != null) {
            dataValue2 = ((Vector)object2).iterator();
            while (dataValue2.hasNext()) {
                object = (UtLookupItem)dataValue2.next();
                try {
                    dataValue = ((UtLookupItem)object).getValue();
                    if (!dataValue.getDataType().equals(dataType)) {
                        dataValue = dataType.getDataValue((Object)dataValue);
                    }
                    if (linkedList.contains(dataValue)) continue;
                    linkedList.add(NamedDataValue.getNamedDataValue((String)this.getName(), (DataValue)dataValue));
                }
                catch (DataTypeIllegalArgumentException dataTypeIllegalArgumentException) {}
            }
        }
        if ((dataValue2 = dataType.getDataValue(DataTypesUtil.EMPTY)) != null && !dataValue2.isNull() && !linkedList.contains(dataValue2)) {
            linkedList.add(NamedDataValue.getNamedDataValue((String)this.getName(), (DataValue)dataValue2));
        }
        if (dataType.isEnumeration()) {
            object = dataType.getEnumerationValues().iterator();
            while (object.hasNext()) {
                dataValue = (DataValue)object.next();
                if (linkedList.contains(dataValue)) continue;
                linkedList.add(NamedDataValue.getNamedDataValue((String)this.getName(), (DataValue)dataValue));
            }
        }
        if (!linkedList.contains(object = dataType.getDataValue(null))) {
            linkedList.add(NamedDataValue.getNamedDataValue((String)this.getName(), (DataValue)object));
        }
        return linkedList;
    }

    private Clob saveToXml(ValueSelector valueSelector, Clob clob) throws ObjectUpdateException {
        if (valueSelector == ValueSelector.input && this.getMode().getEffectiveMode() != BindingMode.OUT || valueSelector == ValueSelector.result && this.getMode().getEffectiveMode() != BindingMode.IN) {
            if (clob != null) {
                try {
                    XMLUtil.marshallDataValue((Clob)clob, (DataValue)this._getValue(valueSelector), (String)this.getName());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
                    throw new ObjectUpdateException(exception);
                }
            }
            return clob;
        }
        return null;
    }

    public void loadFromXml(ValueSelector valueSelector, InputStream inputStream) {
        if (valueSelector == ValueSelector.input && this.getMode().getEffectiveMode() != BindingMode.OUT || valueSelector == ValueSelector.result && this.getMode().getEffectiveMode() != BindingMode.IN) {
            try {
                if (inputStream != null) {
                    this._setValue(valueSelector, XMLUtil.unmarshallDataValue((InputStream)inputStream, (DataType)this.datatype, (String)this.getName()));
                } else {
                    this._setValue(valueSelector, this.datatype.getDataValue(null));
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
            }
        }
    }

    public CLOB getEmptyClob(ValueSelector valueSelector) throws SQLException {
        if (valueSelector == ValueSelector.input && this.getMode().getEffectiveMode() != BindingMode.OUT || valueSelector == ValueSelector.result && this.getMode().getEffectiveMode() != BindingMode.IN) {
            return CLOB.getEmptyCLOB();
        }
        return null;
    }

    private String getQuery(String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(UtAddin.class.getClassLoader(), "/oracle/dbtools/unit_test/testObjects/ObjectSql.xml"));
        Query query = queryXMLSupport.getQuery(string, UtAddin.getRepositoryManager().getConnection());
        return query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(boolean bl) throws ObjectUpdateException {
        if (!bl && !this.dirty) {
            return;
        }
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                CLOB cLOB = this.getEmptyClob(ValueSelector.input);
                CLOB cLOB2 = this.getEmptyClob(ValueSelector.result);
                this.writeArgs(connection, (Clob)cLOB, (Clob)cLOB2);
                if (cLOB != null || cLOB2 != null) {
                    ResultSet resultSet = null;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    try {
                        Clob clob = null;
                        Clob clob2 = null;
                        String string = UtUtils.getQuery("loadForUpdateImplArg");
                        hashMap.put("ID", this._utiId);
                        hashMap.put("ARG", this.getArgId());
                        dBUtil.setRaiseError(true);
                        resultSet = dBUtil.executeOracleQuery(string, hashMap);
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                clob = resultSet.getClob("INPUT_VALUE");
                                clob2 = resultSet.getClob("OUTPUT_VALUE");
                            }
                        }
                        clob = this.saveToXml(ValueSelector.input, clob);
                        clob2 = this.saveToXml(ValueSelector.result, clob2);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                this.dirty = false;
            }
            catch (ObjectUpdateException objectUpdateException) {
                throw objectUpdateException;
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, UtUtils.logString(exception), exception);
                throw new ObjectUpdateException(exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArgs(Connection connection, Clob clob, Clob clob2) throws ObjectUpdateException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = this.getQuery("mergeTestImplArgs");
                hashMap.put("UTI_ID", this._utiId);
                hashMap.put("ARG_ID", this.getArgId());
                hashMap.put("INPUT_VALUE", clob);
                hashMap.put("OUTPUT_VALUE", clob2);
                hashMap.put("TEST_OUTVAL", this.getTestOutVal() ? 1 : 0);
                dBUtil.setRaiseError(true);
                int n = dBUtil.executeUpdate(string, hashMap);
                if (0 == n) {
                    throw new ObjectUpdateException();
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public UtTestImplArgs clone() {
        UtTestImplArgs utTestImplArgs = null;
        try {
            utTestImplArgs = (UtTestImplArgs)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.log(Level.WARNING, UtUtils.logString(cloneNotSupportedException), cloneNotSupportedException);
        }
        return utTestImplArgs;
    }

    public static enum ValueSelector {
        input,
        result;

    }
}

