/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.PrepareResult;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.timesten.ResultSetCondition;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.dbtools.raptor.timesten.X10ResultSetTableModel;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.timesten.extendedtype.BlobType;
import oracle.dbtools.raptor.timesten.extendedtype.VarBinaryType;
import oracle.dbtools.raptor.timesten.utils.SelectSimpleParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class X10ERSTM
extends EditableResultSetTableModel {
    private static Logger theLogger = Logger.getLogger(X10ERSTM.class.getPackage().getName());
    protected Calendar _calendar = Calendar.getInstance();
    private boolean shouldCloseResultSet;
    private static final TTSQLExceptionListener SQL_EXCEPTION_LISTENER = TTSQLExceptionListener.getTheInstance();
    protected HashMap<Integer, RowInfo> _columnMap = new HashMap();
    private boolean theGridConnectionFlag = false;
    private boolean theRowKeyFoundFlag = false;
    private String pkColName;
    private int pkColLocation;
    protected boolean _resultSetInvalidFlag;
    private WeakReference<ChangeListener> theChangeListener;

    public synchronized boolean is_resultSetInvalidFlag() {
        return this._resultSetInvalidFlag;
    }

    protected synchronized void set_resultSetInvalidFlag(boolean bl) {
        this._resultSetInvalidFlag = bl;
    }

    public X10ERSTM() {
        this._addRowScnColumn = false;
        this._skipCols.add("ROWID_ALIAS");
    }

    public List<String> getEditableColNames() {
        List list = super.getEditableColNames();
        return list;
    }

    public String getModifiedSql() {
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this._expandedSql == null) {
            if (this.theGridConnectionFlag && this.theRowKeyFoundFlag) {
                stringBuilder.append("SELECT ROWID rowid_alias, ROWKEY#, *");
            } else {
                stringBuilder.append("SELECT ROWID rowid_alias, *");
            }
            stringBuilder.append(" FROM " + this._schemaName + "." + this._tablename);
            this._expandedSql = stringBuilder.toString();
        } else if (this._expandedSql != null) {
            stringBuilder.append(this._rstmsql.getModifiedSql(this._expandedSql));
        } else {
            stringBuilder.append(this._rstmsql.getModifiedSql());
        }
        theLogger.info("Expanded SQL: " + this._expandedSql);
        String string = this.getOrderBy();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(string);
        }
        String string2 = SelectSimpleParser.appendToFirst(stringBuilder.toString(), "/*+ TT_PartialResult(1) */");
        theLogger.info("Modified SQL: <" + string2 + ">");
        return RSTMSql.sanitizeSql((String)string2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        Connections connections = null;
        DBUtil dBUtil = null;
        List list = this.getBindList();
        Map map = this.getBindMap();
        boolean bl = false;
        try {
            String string = this.getModifiedSql();
            assert (ModelUtil.hasLength((String)string));
            preparedStatement = null;
            connection = this.getConnection();
            dBUtil = DBUtil.getInstance((Connection)connection);
            if (this.getBindMap() != null) {
                PrepareResult prepareResult = dBUtil.prepareNonOracleSql(string, map);
                list = prepareResult.getBinds();
            } else if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            connections = Connections.getInstance();
            bl = connections.lock(connection);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            DBUtil.bind((PreparedStatement)preparedStatement, (List)list);
            if (!bl) return preparedStatement;
        }
        catch (SQLException sQLException) {
            try {
                SQL_EXCEPTION_LISTENER.handleSQLError(connection, sQLException);
                throw sQLException;
                catch (DBException dBException) {
                    throw dBException;
                }
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                connections.unlock(connection);
                throw throwable;
            }
        }
        connections.unlock(connection);
        return preparedStatement;
    }

    protected void init(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        super.init(string, string2, list, map, dBObject);
        this.initGridAndRowKey();
        this.initHelper();
    }

    protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
        super.init(string, string2, list, map);
        this.initGridAndRowKey();
        this.initHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initGridAndRowKey() {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            theLogger.severe("Connection error :" + dBException.getMessage());
            return;
        }
        try {
            if (!TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
                theLogger.finest("Classic connection.");
                return;
            }
            this.theGridConnectionFlag = true;
            theLogger.finest("Scaleout connection.");
            String string = "select  rtrim(c.colname) \"Column Name\"from sys.tables t, sys.columns c where t.tblid = c.id and  t.tblowner = '#towner#'and t.tblname = '#tname#' and c.colname = 'ROWKEY#';";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string.replace("#towner#", this._dbObject.getSchemaName()).replace("#tname#", this._dbObject.getObjectName()));
            if (resultSet.next()) {
                this.theRowKeyFoundFlag = true;
                theLogger.warning("ROWKEY# column found in table " + this._schemaName + "." + this._tablename);
                return;
            }
            resultSet.close();
            statement.close();
            theLogger.finest("Table " + this._schemaName + "." + this._tablename + " does not have ROWKEY# column.");
            String string2 = "select   rtrim(c.colname) \"Column Name\", c.colnum \"COLUMN NUM\" from sys.tables t, sys.columns c where  t.tblid = c.id  and  t.tblowner = '#towner#' and t.tblname = '#tname#' and c.coloptions=0x01";
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2.replace("#towner#", this._dbObject.getSchemaName()).replace("#tname#", this._dbObject.getObjectName()));
            int n = 1;
            while (resultSet.next()) {
                if (n > 1) {
                    theLogger.warning("Table " + this._schemaName + "." + this._tablename + " has more than one Primary key and does not have ROWKEY# column, so using ROWID.");
                    this.theGridConnectionFlag = false;
                    this.theRowKeyFoundFlag = false;
                    return;
                }
                this.pkColName = resultSet.getString("Column Name");
                this.pkColLocation = resultSet.getInt("COLUMN NUM");
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            this.theGridConnectionFlag = false;
            this.theRowKeyFoundFlag = false;
            theLogger.severe("Not able to get ROWKEY# or Scaleout connection information :" + exception.getMessage());
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void initHelper() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ROWID");
        arrayList.add("ROWID_ALIAS");
        if (this.theGridConnectionFlag && this.theRowKeyFoundFlag) {
            arrayList.add("ROWKEY#");
        }
        this.setDataIntegrityColumnNames(arrayList);
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return true;
    }

    public void closeModel() {
        super.closeModel();
        this._addRowScnColumn = false;
    }

    public String getOrderBy() {
        List<ResultSetGridColumn> list = this.getGridColumns();
        return X10ResultSetTableModel.getOrderBy(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findTotalRows(boolean bl) {
        String string = "0";
        StringBuilder stringBuilder = new StringBuilder("SELECT COUNT(1) FROM (\n");
        if (bl) {
            stringBuilder.append(this.getModifiedSql());
        } else {
            stringBuilder.append(this._rstmsql.getModifiedSql());
        }
        stringBuilder.append("\n) sub1");
        stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll("[sS][eE][lL][eE][cC][tT]", "SELECT /*+ TT_PartialResult(1) */"));
        theLogger.finest("Rewritten query for select:<" + stringBuilder.toString() + ">");
        if (Connections.getInstance().lock(this._connName, true)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((String)this._connName);
                string = this.getBindList() != null && this.getBindList().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindList()) : (this.getBindMap() != null && this.getBindMap().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindMap()) : dBUtil.executeReturnOneCol(stringBuilder.toString(), (Map)null));
            }
            catch (Exception exception) {
                theLogger.severe("Count rows failed" + exception.getLocalizedMessage());
            }
            finally {
                Connections.getInstance().unlock(this._connName);
            }
        }
        return Integer.parseInt(string);
    }

    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        ResultSetCondition resultSetCondition;
        if (this.allRowsFetched()) {
            return;
        }
        ArrayList<ResultSetGridCell> arrayList = null;
        Connections.getInstance().lock(this.getConnectionName());
        if (this.getModelList() == null) {
            this.setModelList(new ArrayList());
        }
        try {
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            if (this._rs == null) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage("Executing: " + this.getModifiedSql());
                }
                this._rs = this.openResultSet();
            }
            resultSetCondition = ResultSetCondition.NO_MORE_ROWS;
            arrayList = null;
            for (int i = 0; i < n; ++i) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (this.is_resultSetInvalidFlag()) {
                    break;
                }
                resultSetCondition = X10ResultSetTableModel.testAndAdvanceResultSet(this._rs);
                if (resultSetCondition == ResultSetCondition.NO_MORE_ROWS) {
                    this.setAllRowsFetched(true);
                    this.shouldCloseResultSet = true;
                    break;
                }
                if (resultSetCondition == ResultSetCondition.RESET) {
                    this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.4") + (Object)((Object)resultSetCondition), null);
                    this.set_resultSetInvalidFlag(true);
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    break;
                }
                if (this.isVerticalDisplay()) {
                    for (int j = 1; j <= this._rs.getMetaData().getColumnCount(); ++j) {
                        arrayList = new ArrayList<ResultSetGridCell>();
                        arrayList.add(new ResultSetGridCell((Object)this._rs.getMetaData().getColumnName(j), this.getConnectionName()));
                        this.cacheObjectInARow(arrayList, j, this._rs);
                        this.addRow(arrayList);
                    }
                    continue;
                }
                this.addRow(this.fetchRowFromResultSet());
                if (iRaptorTaskProgressUpdater == null) continue;
                iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), i));
            }
        }
        catch (SQLException sQLException) {
            this._rstmsql = new RSTMSql(this._sql);
            SQL_EXCEPTION_LISTENER.handleSQLError(this.getConnectionName(), sQLException);
            try {
                this.set_resultSetInvalidFlag(true);
                if (arrayList != null) {
                    arrayList.clear();
                }
                this.closeResultSet();
                this.fireStateChanged();
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
            }
            throw new ExecutionException(sQLException);
        }
        catch (DBException dBException) {
            throw new ExecutionException(dBException);
        }
        finally {
            Connections.getInstance().unlock(this.getConnectionName());
        }
        if (resultSetCondition == ResultSetCondition.RESET) {
            this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.5"), null);
            try {
                this.closeResultSet();
                this.fireStateChanged();
            }
            catch (SQLException sQLException) {
                theLogger.severe(sQLException.getMessage());
            }
        }
        if (this.allRowsFetched() && iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(RSTableMessages.getString((String)"ResultSetTableModel.6") + this.getLoadedRowCount());
        } else if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), this.getLoadedRowCount()));
        }
        if (iRaptorTaskProgressUpdater != null) {
            this._fetchTime += Float.parseFloat(iRaptorTaskProgressUpdater.getDescriptor().getElapsedTime() + "") / 1000.0f;
        }
    }

    protected void reopenResultSet() {
        try {
            this.getModelList().clear();
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.theChangeListener = new WeakReference<ChangeListener>(changeListener);
    }

    public void removeChangeListener() {
        this.theChangeListener = null;
    }

    private void fireStateChanged() {
        if (this.theChangeListener == null) {
            return;
        }
        ChangeListener changeListener = (ChangeListener)this.theChangeListener.get();
        if (changeListener == null) {
            return;
        }
        changeListener.stateChanged(new ResultSetInvalidEvent((Object)this));
        this.fireTableDataChanged();
    }

    public void refresh() throws ExecutionException {
        super.refresh();
        if (this.is_resultSetInvalidFlag()) {
            if (this._rs != null) {
                try {
                    this._rs.close();
                    this._rs = null;
                    this.getModelList().clear();
                }
                catch (SQLException sQLException) {
                    throw new ExecutionException(sQLException);
                }
            }
            this.set_resultSetInvalidFlag(false);
        }
    }

    protected void cacheObjectInARow(List<ResultSetGridCell> list, int n, ResultSet resultSet) throws SQLException {
        Object object;
        Object object2 = null;
        RowInfo rowInfo = this._columnMap.get(n);
        if (rowInfo == null) {
            object = resultSet.getMetaData();
            rowInfo = new RowInfo();
            rowInfo.type = object.getColumnType(n);
            rowInfo.typeName = object.getColumnTypeName(n);
            this._columnMap.put(n, rowInfo);
        }
        try {
            object2 = resultSet.getObject(n);
            if (theLogger.isLoggable(Level.FINEST)) {
                theLogger.log(Level.FINEST, n + ": sql type: " + rowInfo.type + " value: " + object2 + " name: " + resultSet.getMetaData().getColumnName(n) + ", type: " + rowInfo.typeName + " " + resultSet.getMetaData().getColumnClassName(n) + " " + rowInfo.type);
            }
            if (rowInfo.type == -3 || rowInfo.type == -2 || object2 instanceof byte[]) {
                list.add(new ResultSetGridCell((Object)new VarBinaryType((byte[])object2), this._connName));
            } else if (rowInfo.typeName.equals("DATE") || object2 instanceof Date) {
                if (object2 == null) {
                    list.add(new ResultSetGridCell(object2, this._connName));
                    return;
                }
                object = object2.toString();
                String[] stringArray = ((String)object).split("\\.");
                object = stringArray[0];
                if (stringArray.length == 1) {
                    list.add(new ResultSetGridCell(object, this._connName));
                } else if (this.isEraBC((Timestamp)object2)) {
                    object = "-" + (String)object;
                    list.add(new ResultSetGridCell(object, this._connName));
                } else {
                    list.add(new ResultSetGridCell(object, this._connName));
                }
            } else if (object2 instanceof Timestamp) {
                if (this.isEraBC((Timestamp)object2)) {
                    object = object2.toString();
                    object = "-" + (String)object;
                    list.add(new ResultSetGridCell(object, this._connName));
                } else {
                    list.add(new ResultSetGridCell(object2, this._connName));
                }
            } else if (rowInfo.type == 2004 || object2 instanceof Blob) {
                object = (Blob)object2;
                list.add(new ResultSetGridCell((Object)new BlobType((Blob)object), this._connName));
            } else if (rowInfo.type == 2005 || object2 instanceof Clob) {
                list.add(new ResultSetGridCell(object2, this._connName));
            } else {
                list.add(new ResultSetGridCell(object2, this._connName));
            }
        }
        catch (SQLException sQLException) {
            super.cacheObjectInARow(list, n, resultSet);
        }
    }

    private boolean isEraBC(Date date) {
        this._calendar.clear();
        this._calendar.setTimeInMillis(date.getTime());
        return this._calendar.get(0) == 0;
    }

    private boolean isEraBC(Timestamp timestamp) {
        this._calendar.clear();
        this._calendar.setTimeInMillis(timestamp.getTime());
        return this._calendar.get(0) == 0;
    }

    public boolean isColumnSortable(int n) {
        boolean bl = super.isColumnSortable(n);
        if (bl) {
            try {
                Connection connection = this.getConnection();
                String string = this.getConnectionName();
                if (connection == null || string == null) {
                    return false;
                }
                ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails((String)string, (Connection)connection);
                return connectionTypeDetails.isColumnTypeSortable(this.getColumnSqlType(n));
            }
            catch (DBException dBException) {
                return false;
            }
        }
        return false;
    }

    public List<ResultSetGridColumn> getGridColumns() {
        List list = super.getGridColumns();
        if (this.shouldCloseResultSet) {
            if (!X10ResultSetTableModel.hasLOBColumn(list)) {
                try {
                    this.closeResultSet();
                }
                catch (SQLException sQLException) {
                    theLogger.severe(sQLException.getMessage());
                }
            }
            this.shouldCloseResultSet = false;
        }
        return list;
    }

    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this._rs == null) {
            try {
                this._rs = this.openResultSet();
                return this._rs == null ? null : this._rs.getMetaData();
            }
            catch (DBException dBException) {
                theLogger.severe(dBException.getMessage());
                return null;
            }
        }
        return this._rs.getMetaData();
    }

    static /* synthetic */ String access$1500(X10ERSTM x10ERSTM) {
        return x10ERSTM._schemaName;
    }

    static /* synthetic */ String access$1600(X10ERSTM x10ERSTM) {
        return x10ERSTM._tablename;
    }

    static /* synthetic */ boolean access$1700(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowIdColumn;
    }

    static /* synthetic */ boolean access$1800(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowScnColumn;
    }

    static /* synthetic */ List access$1900(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ Connection access$2000(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ List access$2100(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ DBObject access$2200(X10ERSTM x10ERSTM) {
        return x10ERSTM._dbObject;
    }

    static /* synthetic */ List access$2300(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    static /* synthetic */ Connection access$2400(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ List access$2500(X10ERSTM x10ERSTM) {
        return x10ERSTM.DATA_INTEGRITY_COLS;
    }

    static /* synthetic */ void access$2600(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel, String string) {
        x10ERSTM.setRowId(raptorGridRowModel, string);
    }

    static /* synthetic */ Logger access$2700() {
        return theLogger;
    }

    static /* synthetic */ Connection access$2800(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ String access$2900(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel) {
        return x10ERSTM.getRowId(raptorGridRowModel);
    }

    static /* synthetic */ String access$3000(X10ERSTM x10ERSTM, RaptorGridRowModel raptorGridRowModel) {
        return x10ERSTM.getRowScn(raptorGridRowModel);
    }

    static /* synthetic */ boolean access$3100(X10ERSTM x10ERSTM) {
        return x10ERSTM._addRowScnColumn;
    }

    static /* synthetic */ List access$3200(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    static /* synthetic */ Connection access$3300(X10ERSTM x10ERSTM) throws DBException {
        return x10ERSTM.getConnection();
    }

    static /* synthetic */ List access$3400(X10ERSTM x10ERSTM) {
        return x10ERSTM._log;
    }

    public class X10DataTabGridUpdater
    implements IRaptorGridUpdater {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (raptorGridRowModel.isNew()) continue;
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                String string2 = X10ERSTM.this._schemaName + "." + X10ERSTM.this._tablename;
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                if (X10ERSTM.this.theGridConnectionFlag && X10ERSTM.this.theRowKeyFoundFlag) {
                    stringBuffer.append(string2 + " WHERE ROWKEY# = ?");
                    stringBuffer2.append(string2 + " WHERE ROWKEY# = " + X10ERSTM.this.quote(this.getRowKey(raptorGridRowModel)));
                } else if (X10ERSTM.this.theGridConnectionFlag && !X10ERSTM.this.theRowKeyFoundFlag) {
                    stringBuffer.append(string2 + " WHERE " + X10ERSTM.this.pkColName + " = ?");
                    stringBuffer2.append(string2 + " WHERE " + X10ERSTM.this.pkColName + " = " + X10ERSTM.this.quote(this.getPKValue(raptorGridRowModel)));
                } else {
                    stringBuffer.append(string2 + " WHERE ROWID = ?");
                    stringBuffer2.append(string2 + " WHERE ROWID = " + X10ERSTM.this.quote(X10ERSTM.this.getRowId(raptorGridRowModel)));
                }
                X10ERSTM.this._log.add(stringBuffer2.toString());
                PreparedStatement preparedStatement = null;
                try {
                    int n2;
                    preparedStatement = X10ERSTM.this.getConnection().prepareStatement(stringBuffer.toString());
                    if (X10ERSTM.this.theGridConnectionFlag && X10ERSTM.this.theRowKeyFoundFlag) {
                        preparedStatement.setString(1, this.getRowKey(raptorGridRowModel));
                    } else if (X10ERSTM.this.theGridConnectionFlag && !X10ERSTM.this.theRowKeyFoundFlag) {
                        preparedStatement.setString(1, this.getPKValue(raptorGridRowModel));
                    } else {
                        preparedStatement.setString(1, X10ERSTM.this.getRowId(raptorGridRowModel));
                    }
                    if ((n2 = preparedStatement.executeUpdate()) == 1 || n2 != 0) continue;
                    raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_DELETE_ERR") + System.getProperty("line.separator"));
                    ++n;
                }
                catch (SQLException sQLException) {
                    SQL_EXCEPTION_LISTENER.handleSQLError(X10ERSTM.this.getConnection(), sQLException);
                    String string3 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), stringBuffer.toString());
                    X10ERSTM.this._log.add(string3);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    raptorGridRowModel.setError(exception.getLocalizedMessage());
                    ++n;
                }
                finally {
                    try {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            return null;
        }

        /*
         * Exception decompiling
         */
        public int insertRows(String var1_1, List<RaptorGridRowModel> var2_2, IRaptorTaskProgressUpdater var3_3, List<String> var4_4) throws SQLException, DBException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            int n = 0;
            for (RaptorGridRowModel raptorGridRowModel : list) {
                Object object;
                int n2;
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                ArrayList<ResultSetGridCell> arrayList = new ArrayList<ResultSetGridCell>();
                String string2 = X10ERSTM.this._schemaName + "." + X10ERSTM.this._tablename;
                stringBuffer.append(string2 + " SET ");
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                boolean bl = true;
                String string3 = null;
                int n3 = X10ERSTM.this.getGridColumns().size();
                int n4 = -1;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = X10ERSTM.this.getColumnName(n2);
                    if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                    ResultSetGridCell resultSetGridCell = (ResultSetGridCell)raptorGridRowModel.getRow().get(n2);
                    object = resultSetGridCell.getCellData();
                    String string4 = resultSetGridCell.getDisplayValue(Integer.MAX_VALUE);
                    boolean bl2 = resultSetGridCell.isUpdated();
                    n4 = X10ERSTM.this.getColumnSqlType(n2);
                    if (object == null || object instanceof ExtendedType && n4 != -2 && n4 != -3 && n4 != 2004 || !bl2) continue;
                    arrayList.add(resultSetGridCell);
                    if (!bl) {
                        stringBuffer.append(", ");
                        stringBuffer2.append(", ");
                    } else {
                        bl = false;
                    }
                    string3 = DBUtil.getInstance((Connection)X10ERSTM.this.getConnection()).addDbQuotes(string3, false);
                    stringBuffer.append(string3 + " = ?");
                    if (n4 == 2004) {
                        stringBuffer2.append(string3 + " = " + X10ERSTM.this.quote("(BLOB)"));
                        continue;
                    }
                    if (n4 == -2) {
                        stringBuffer2.append(string3 + " = " + X10ERSTM.this.quote("(BINARY)"));
                        continue;
                    }
                    if (n4 == -3) {
                        stringBuffer2.append(string3 + " = " + X10ERSTM.this.quote("(VARBINARY)"));
                        continue;
                    }
                    stringBuffer2.append(string3 + " = " + X10ERSTM.this.quote(string4.length() == 0 ? null : string4));
                }
                if (X10ERSTM.this.theGridConnectionFlag && X10ERSTM.this.theRowKeyFoundFlag) {
                    stringBuffer.append(" WHERE ROWKEY# = ?");
                    stringBuffer2.append(" WHERE ROWKEY# = " + X10ERSTM.this.quote(this.getRowKey(raptorGridRowModel)));
                } else if (X10ERSTM.this.theGridConnectionFlag && !X10ERSTM.this.theRowKeyFoundFlag) {
                    stringBuffer.append(" WHERE " + X10ERSTM.this.pkColName + " = ?");
                    stringBuffer2.append(" WHERE " + X10ERSTM.this.pkColName + " = " + X10ERSTM.this.quote(this.getPKValue(raptorGridRowModel)));
                } else {
                    stringBuffer.append(" WHERE ROWID = ?");
                    stringBuffer2.append(" WHERE ROWID = " + X10ERSTM.this.quote(X10ERSTM.this.getRowId(raptorGridRowModel)));
                }
                X10ERSTM.this._log.add(stringBuffer2.toString());
                PreparedStatement preparedStatement = null;
                try {
                    int n5;
                    ResultSetGridCell resultSetGridCell2;
                    preparedStatement = X10ERSTM.this.getConnection().prepareStatement(stringBuffer.toString());
                    int n6 = 1;
                    for (ResultSetGridCell resultSetGridCell2 : arrayList) {
                        Object object2 = resultSetGridCell2.getCellData();
                        ResultSetGridColumn resultSetGridColumn = X10ERSTM.this.getGridColumnForCell((RaptorGridCell)resultSetGridCell2);
                        if (object2 == null || resultSetGridColumn == null) continue;
                        String string5 = "unknown";
                        string5 = resultSetGridColumn.getSqlTypeName();
                        int n7 = resultSetGridColumn.getSqlType();
                        try {
                            if (string5 == null) {
                                string5 = "unknown";
                            }
                        }
                        catch (Exception exception) {
                            string5 = "unknown";
                        }
                        if (string5.equals("DATE") || string5.equals("TIMESTAMP")) {
                            if (object2.toString().length() == 0) {
                                preparedStatement.setNull(n6, n7);
                            } else {
                                preparedStatement.setString(n6, object2.toString());
                            }
                        } else if (object2 != null && (string5.equals("BINARY_FLOAT") || string5.equals("NUMBER")) && object2.toString().toLowerCase().endsWith("f")) {
                            preparedStatement.setFloat(n6, Float.parseFloat(object2.toString()));
                        } else if (string5.equals("CLOB")) {
                            preparedStatement.setString(n6, object2.toString());
                        } else if (object2.toString().length() == 0) {
                            preparedStatement.setNull(n6, n7);
                        } else if (n7 == -2 || n7 == -3 || n7 == 2004) {
                            InputStream inputStream = ((ExtendedType)object2).getBinaryStream();
                            preparedStatement.setBinaryStream(n6, inputStream, inputStream.available());
                        } else {
                            preparedStatement.setString(n6, object2.toString());
                        }
                        ++n6;
                    }
                    if (X10ERSTM.this.theGridConnectionFlag && X10ERSTM.this.theRowKeyFoundFlag) {
                        preparedStatement.setString(n6, this.getRowKey(raptorGridRowModel));
                    } else if (X10ERSTM.this.theGridConnectionFlag && !X10ERSTM.this.theRowKeyFoundFlag) {
                        preparedStatement.setString(n6, this.getPKValue(raptorGridRowModel));
                    } else {
                        preparedStatement.setString(n6, X10ERSTM.this.getRowId(raptorGridRowModel));
                    }
                    ++n6;
                    if (arrayList.size() > 0) {
                        n5 = preparedStatement.executeUpdate();
                        if (n5 == 1) {
                            for (n2 = 0; n2 < n3; ++n2) {
                                string3 = X10ERSTM.this.getColumnName(n2);
                                if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                                object = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData();
                                n4 = X10ERSTM.this.getColumnSqlType(n2);
                                if (n4 == -2 || n4 == -3 || n4 == 2004 || object == null || !(object instanceof ExtendedType) || (resultSetGridCell2 = (ExtendedType)object).saveToDb(X10ERSTM.this.getConnection(), string2, X10ERSTM.this.getColumnName(n2), X10ERSTM.this.getRowId(raptorGridRowModel), X10ERSTM.this.getRowScn(raptorGridRowModel), X10ERSTM.this._addRowScnColumn, X10ERSTM.this._log)) continue;
                                ++n;
                            }
                            continue;
                        }
                        if (n5 != 0) continue;
                        raptorGridRowModel.setError(ConnectionArb.getString((String)"EDITRSM_UPDATE_ERR") + System.getProperty("line.separator"));
                        ++n;
                        continue;
                    }
                    n5 = 0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        string3 = X10ERSTM.this.getColumnName(n2);
                        if (X10ERSTM.this.DATA_INTEGRITY_COLS.contains(string3)) continue;
                        object = ((RaptorGridCell)raptorGridRowModel.getRow().get(n2)).getCellData();
                        n4 = X10ERSTM.this.getColumnSqlType(n2);
                        if (n4 == -2 || n4 == -3 || n4 == 2004 || object == null || !(object instanceof ExtendedType)) continue;
                        resultSetGridCell2 = (ExtendedType)object;
                        n5 = resultSetGridCell2.saveToDb(X10ERSTM.this.getConnection(), string2, X10ERSTM.this.getColumnName(n2), X10ERSTM.this.getRowId(raptorGridRowModel), X10ERSTM.this.getRowScn(raptorGridRowModel), X10ERSTM.this._addRowScnColumn, X10ERSTM.this._log) ? 1 : 0;
                    }
                    if (n5 != 0) continue;
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), X10ERSTM.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    raptorGridRowModel.setError(MessageFormat.format(ConnectionArb.getString((String)"EDITRSM_FORMAT_ERR"), X10ERSTM.this.getColumnName(n2 + 1)));
                    ++n;
                }
                catch (SQLException sQLException) {
                    SQL_EXCEPTION_LISTENER.handleSQLError(X10ERSTM.this.getConnection(), sQLException);
                    String string6 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), stringBuffer.toString());
                    X10ERSTM.this._log.add(string6);
                    raptorGridRowModel.setError(sQLException.getLocalizedMessage());
                    ++n;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                    ++n;
                }
                finally {
                    try {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return n;
        }

        protected String getRowKey(RaptorGridRowModel raptorGridRowModel) {
            return ((RaptorGridCell)raptorGridRowModel.getRow().get(1)).getDisplayValue(Integer.MAX_VALUE);
        }

        protected String getPKValue(RaptorGridRowModel raptorGridRowModel) {
            return ((RaptorGridCell)raptorGridRowModel.getRow().get(X10ERSTM.this.pkColLocation)).getDisplayValue(Integer.MAX_VALUE);
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    private class ResultSetInvalidEvent
    extends ChangeEvent {
        public ResultSetInvalidEvent(Object object) {
            super(object);
        }
    }

    public class RowInfo {
        public String typeName;
        public Integer type;
    }
}

