/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.PrepareResult;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.timesten.ResultSetCondition;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.timesten.extendedtype.VarBinaryType;
import oracle.dbtools.raptor.timesten.utils.SelectSimpleParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;

public class X10ResultSetTableModel
extends ResultSetTableModel {
    protected boolean _resultSetInvalidFlag;
    protected Calendar _calendar = Calendar.getInstance();
    private boolean shouldCloseResultSet;
    private static final TTSQLExceptionListener SQL_EXCEPTION_LISTENER = TTSQLExceptionListener.getTheInstance();
    private static final Logger LOGGER = Logger.getLogger(X10ResultSetTableModel.class.getName());

    public synchronized boolean is_resultSetInvalidFlag() {
        return this._resultSetInvalidFlag;
    }

    protected synchronized void set_resultSetInvalidFlag(boolean bl) {
        this._resultSetInvalidFlag = bl;
    }

    protected void init(String string, String string2, List list, Map map) {
        super.init(string, string2, list, map);
    }

    public String getModifiedSql() {
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this._rstmsql.getModifiedSql());
        String string = this.getOrderBy();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(string);
        }
        String string2 = SelectSimpleParser.appendToFirst(stringBuilder.toString(), "/*+ TT_PartialResult(1) */");
        LOGGER.finest("Modified sql: <" + string2 + ">");
        return X10ResultSetTableModel.sanitizeOracleSQL(string2.toString());
    }

    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        Connections connections = Connections.getInstance();
        DBUtil dBUtil = null;
        List list = this.getBindList();
        Map map = this.getBindMap();
        String string = this.getModifiedSql();
        boolean bl = false;
        try {
            assert (ModelUtil.hasLength((String)string));
            preparedStatement = null;
            connection = this.getConnection();
            dBUtil = DBUtil.getInstance((Connection)connection);
            if (this.getBindMap() != null) {
                PrepareResult prepareResult = dBUtil.prepareNonOracleSql(string, map);
                list = prepareResult.getBinds();
            } else if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            bl = connections.lock(connection);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            DBUtil.bind((PreparedStatement)preparedStatement, (List)list);
        }
        catch (SQLException sQLException) {
            SQL_EXCEPTION_LISTENER.handleSQLError(connection, sQLException);
            throw TTSQLExceptionScrubber.cloneScrubbedSQLException(sQLException, string);
        }
        catch (DBException dBException) {
            throw dBException;
        }
        finally {
            if (bl) {
                connections.unlock(connection);
            }
        }
        return preparedStatement;
    }

    private static String sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    public boolean isSortable() {
        return true;
    }

    public boolean isColumnSortable(int n) {
        boolean bl = super.isColumnSortable(n);
        if (bl) {
            try {
                Connection connection = this.getConnection();
                String string = this.getConnectionName();
                if (connection == null || string == null) {
                    return false;
                }
                ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails((String)string, (Connection)connection);
                return connectionTypeDetails.isColumnTypeSortable(this.getColumnSqlType(n));
            }
            catch (DBException dBException) {
                return false;
            }
        }
        return false;
    }

    public boolean supportsOrderingNulls() {
        return false;
    }

    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        ResultSetCondition resultSetCondition;
        if (this.allRowsFetched()) {
            return;
        }
        boolean bl = Connections.getInstance().lock(this.getConnectionName());
        if (this.getModelList() == null) {
            this.setModelList(new ArrayList());
        }
        try {
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            if (this._rs == null) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage("Executing: " + this.getModifiedSql());
                }
                this._rs = this.openResultSet();
            }
            resultSetCondition = ResultSetCondition.NO_MORE_ROWS;
            ArrayList<ResultSetGridCell> arrayList = null;
            for (int i = 0; i < n; ++i) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if ((resultSetCondition = X10ResultSetTableModel.testAndAdvanceResultSet(this._rs)) == ResultSetCondition.NO_MORE_ROWS) {
                    this.setAllRowsFetched(true);
                    this.shouldCloseResultSet = true;
                    break;
                }
                if (resultSetCondition == ResultSetCondition.RESET) {
                    this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.4") + (Object)((Object)resultSetCondition), null);
                    this.set_resultSetInvalidFlag(true);
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    this._rs.close();
                    this._rs = null;
                    break;
                }
                if (this.isVerticalDisplay()) {
                    for (int j = 1; j <= this._rs.getMetaData().getColumnCount(); ++j) {
                        arrayList = new ArrayList<ResultSetGridCell>();
                        arrayList.add(new ResultSetGridCell((Object)this._rs.getMetaData().getColumnName(j), this.getConnectionName()));
                        this.cacheObjectInARow(arrayList, j, this._rs);
                        this.addRow(arrayList);
                    }
                    continue;
                }
                this.addRow(this.fetchRowFromResultSet());
                if (iRaptorTaskProgressUpdater == null) continue;
                iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), i));
            }
        }
        catch (SQLException sQLException) {
            this._rstmsql = new RSTMSql(this._sql);
            SQL_EXCEPTION_LISTENER.handleSQLError(this.getConnectionName(), sQLException);
            try {
                this.closeResultSet();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new ExecutionException(sQLException);
        }
        catch (DBException dBException) {
            throw new ExecutionException(dBException);
        }
        finally {
            if (bl) {
                Connections.getInstance().unlock(this.getConnectionName());
            }
        }
        if (resultSetCondition == ResultSetCondition.RESET) {
            this.publishStatusMessage(RSTableMessages.getString((String)"ResultSetTableModel.5"), null);
            this.reopenResultSet();
        }
        if (this.allRowsFetched() && iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(RSTableMessages.getString((String)"ResultSetTableModel.6") + this.getLoadedRowCount());
        } else if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString((String)"ResultSetTableModel.10"), this.getLoadedRowCount()));
        }
        if (iRaptorTaskProgressUpdater != null) {
            this._fetchTime += Float.parseFloat(iRaptorTaskProgressUpdater.getDescriptor().getElapsedTime() + "") / 1000.0f;
        }
    }

    protected void reopenResultSet(boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    X10ResultSetTableModel.this.getModelList().clear();
                    X10ResultSetTableModel.this.refresh();
                    X10ResultSetTableModel.this.fireTableDataChanged();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        SwingUtils.invokeAfterRepaint((Runnable)runnable);
    }

    protected void reopenResultSet() {
        try {
            this.getModelList().clear();
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static ResultSetCondition testAndAdvanceResultSet(ResultSet resultSet) throws SQLException {
        try {
            if (resultSet.next()) {
                return ResultSetCondition.MORE_ROWS;
            }
            return ResultSetCondition.NO_MORE_ROWS;
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("S1010")) {
                return ResultSetCondition.RESET;
            }
            throw sQLException;
        }
    }

    public String getTableName() {
        return this._tablename;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public List<GridColumn> getSkipCols() {
        return Collections.emptyList();
    }

    public String getOrderBy() {
        List<ResultSetGridColumn> list = this.getGridColumns();
        return X10ResultSetTableModel.getOrderBy(list);
    }

    public static String getOrderBy(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
            for (Object object : list) {
                GridColumn gridColumn = (GridColumn)object;
                if (gridColumn.getSortParameter() == null) continue;
                arrayList.add(gridColumn);
            }
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                GridColumn gridColumn = (GridColumn)arrayList.get(i);
                GridColumnSortParameter.SortDir sortDir = gridColumn.getSortParameter().getSortDir();
                object = gridColumn.getSortParameter().getNullsOption();
                String string = gridColumn.getAlias();
                if (string == null) {
                    string = gridColumn.getOriginal();
                }
                int n = list.indexOf(gridColumn) + 1;
                if (object == GridColumnSortParameter.NullsOption.FIRST && sortDir == GridColumnSortParameter.SortDir.ASCENDING) {
                    stringBuilder.append("decode(" + string + ", null, 0, 1), " + n + " " + sortDir.toString());
                } else if (object == GridColumnSortParameter.NullsOption.LAST && sortDir == GridColumnSortParameter.SortDir.DESCENDING) {
                    stringBuilder.append("decode(" + string + ", null, 1, 0), " + n + " " + sortDir.toString());
                } else {
                    stringBuilder.append(list.indexOf(gridColumn) + 1 + " " + sortDir.toString());
                }
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString().length() != 0 ? stringBuilder.toString() : null;
    }

    protected void cacheObjectInARow(List<ResultSetGridCell> list, int n, ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        try {
            Object object = resultSet.getObject(n);
            if (n2 == -3 || n2 == -2 || object instanceof byte[]) {
                list.add(new ResultSetGridCell((Object)new VarBinaryType((byte[])object), this._connName));
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.cacheObjectInARow(list, n, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findTotalRows(boolean bl) {
        String string = "0";
        StringBuilder stringBuilder = new StringBuilder("SELECT COUNT(1) FROM (\n");
        if (bl) {
            stringBuilder.append(this.getModifiedSql());
        } else {
            stringBuilder.append(this._rstmsql.getModifiedSql());
        }
        stringBuilder.append("\n) sub1");
        if (this._sql != null && this._sql.startsWith("call")) {
            string = this.findTotalRowsinCallStatement(this._sql);
        } else {
            stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll("[sS][eE][lL][eE][cC][tT]", "SELECT /*+ TT_PartialResult(1) */"));
            LOGGER.finest("Rewritten query for select:<" + stringBuilder.toString() + ">");
            if (Connections.getInstance().lock(this._connName, true)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((String)this._connName);
                    string = this.getBindList() != null && this.getBindList().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindList()) : (this.getBindMap() != null && this.getBindMap().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindMap()) : dBUtil.executeReturnOneCol(stringBuilder.toString(), (Map)null));
                }
                finally {
                    Connections.getInstance().unlock(this._connName);
                }
            }
        }
        return Integer.parseInt(string);
    }

    private String findTotalRowsinCallStatement(String string) {
        Connection connection = null;
        int n = 0;
        try {
            connection = this.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.toString(n);
    }

    public List<ResultSetGridColumn> getGridColumns() {
        List list = super.getGridColumns();
        if (this.shouldCloseResultSet) {
            if (!X10ResultSetTableModel.hasLOBColumn(list)) {
                try {
                    this.closeResultSet();
                }
                catch (SQLException sQLException) {
                    LOGGER.severe(sQLException.getMessage());
                }
            }
            this.shouldCloseResultSet = false;
        }
        return list;
    }

    static boolean hasLOBColumn(List<ResultSetGridColumn> list) {
        if (list == null) {
            return false;
        }
        for (ResultSetGridColumn resultSetGridColumn : list) {
            if (resultSetGridColumn.getSqlType() != 2004 && resultSetGridColumn.getSqlType() != 2005 && resultSetGridColumn.getSqlType() != 2011) continue;
            return true;
        }
        return false;
    }

    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this._rs == null) {
            try {
                this._rs = this.openResultSet();
                return this._rs == null ? null : this._rs.getMetaData();
            }
            catch (DBException dBException) {
                LOGGER.severe(dBException.getMessage());
                return null;
            }
        }
        return this._rs.getMetaData();
    }
}

