/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class AddAgingTBPanel
extends DialogBase {
    private JComboBox gui_column;
    private JTextField gui_aging_state;
    private JFormattedTextField gui_lt;
    private JComboBox gui_lt_unit;
    private JFormattedTextField gui_cy;
    private JComboBox gui_cy_unit;

    @Override
    public boolean applicable(DBObject dBObject) {
        if (this._model != null) {
            if (this._model.get("TYPE") != null) {
                TTDialog.showError(MessageFormat.format(Messages.getString("AddAgingTBPanel.thisCommandOnlyAppliesTo"), this.THING));
                return false;
            }
            if (this._model.get("ALL TIMESTAMP COLS0") == null) {
                TTDialog.showError(MessageFormat.format(Messages.getString("AddAgingTBPanel.thisCommandReuqiresThatThe"), this.ROOT));
                return false;
            }
        }
        return true;
    }

    public AddAgingTBPanel(DBObject dBObject, String string) {
        super(dBObject, string, "AddAgingTBPanel", "aging");
    }

    public AddAgingTBPanel(DBObject dBObject, String string, String string2) {
        super(dBObject, string, "AddAgingTBPanel", string2);
    }

    @Override
    protected void initGUI() {
        Object object;
        String[] stringArray;
        this.setLayout(this.gridbag);
        if (!this._mode.equals("none")) {
            this.addOwnerAndName(this._dict);
        }
        this.gui_aging_state = new JTextField("ON");
        this._textValues.add(this.gui_aging_state);
        Container container = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("AgingInfo.on"), Messages.getString("AgingInfo.off")}, 0, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgingTBPanel.this.gui_aging_state.setText("on");
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddAgingTBPanel.this.gui_aging_state.setText("off");
            }
        }});
        String[] stringArray2 = new String[]{Messages.getString("AddAgingTBPanel.noTimestampColumnsFound")};
        if (this._model != null) {
            stringArray = new ArrayList();
            int n = 0;
            while ((object = (String)this._model.get("ALL TIMESTAMP COLS" + n)) != null) {
                stringArray.add(object);
                ++n;
            }
            stringArray2 = stringArray.toArray(new String[stringArray.size()]);
        }
        this.gui_column = TTDialog.createMenu(stringArray2);
        this._textValues.add(this.gui_column);
        Serializable serializable = new ArrayList<String>();
        if (CGCPanel.allowSecondsLevelTBAging(this._dbObject)) {
            serializable.add(Messages.getString("TimesTen.common.seconds"));
        }
        serializable.add(Messages.getString("TimesTen.common.minutes"));
        serializable.add(Messages.getString("TimesTen.common.hours"));
        serializable.add(Messages.getString("TimesTen.common.days"));
        stringArray = serializable.toArray(new String[serializable.size()]);
        serializable = new JPanel(new GridLayout(1, 2, 1, 0));
        object = null;
        if (this._model != null) {
            object = (String)this._model.get("LIFETIME");
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        this.gui_lt = new JFormattedTextField(new NumberFormatter(decimalFormat));
        if (object != null) {
            this.gui_lt.setValue(Integer.parseInt((String)object));
        }
        ((Container)serializable).add(this.gui_lt);
        this._textValues.add(this.gui_lt);
        object = Messages.getString("TimesTen.common.minutes");
        if (this._model != null) {
            object = (String)this._model.get("LIFETIME UNIT");
        }
        this.gui_lt_unit = TTDialog.createMenu(stringArray, (String)object);
        ((Container)serializable).add(this.gui_lt_unit);
        this._textValues.add(this.gui_lt_unit);
        object = new JPanel(new GridLayout(1, 2, 1, 0));
        decimalFormat = new DecimalFormat("#0");
        this.gui_cy = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this.gui_cy.setValue(5);
        ((Container)object).add(this.gui_cy);
        this._textValues.add(this.gui_cy);
        String string = Messages.getString("TimesTen.common.minutes");
        if (this._model != null) {
            string = (String)this._model.get("CYCLE UNIT");
        }
        this.gui_cy_unit = TTDialog.createMenu(stringArray, string);
        ((Container)object).add(this.gui_cy_unit);
        if (!this._mode.startsWith("none")) {
            this.addRow(Messages.getString("AgingInfo.timeBasedAging"), (Component)container);
        }
        this.addRow(Messages.getString("AgingInfo.column"), (Component)this.gui_column);
        this.addRow(Messages.getString("AgingInfo.lifeTime"), (Component)serializable);
        this.addRow(Messages.getString("AgingInfo.cycle"), (Component)object);
        if (this._mode.startsWith("none")) {
            this.addRow(container);
        }
        this.setSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    public void fixMenuAgingTB() {
        if (this._mode != "none") {
            return;
        }
        this.gui_column.removeAllItems();
        CGCPanel cGCPanel = CGCPanel.theDialog;
        Iterator iterator = cGCPanel.getTimestampCols();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            this.gui_column.addItem(string);
        }
    }

    @Override
    public String getSql() {
        boolean bl = this._mode == "none";
        String[] stringArray = new String[]{"seconds", "minutes", "hours", "days"};
        String string = this.gui_column.getSelectedItem().toString();
        String string2 = this.gui_lt.getText().trim();
        String string3 = "";
        int n = this.gui_lt_unit.getSelectedIndex();
        if (!CGCPanel.allowSecondsLevelTBAging(this._dbObject)) {
            ++n;
        }
        string3 = stringArray[n];
        String string4 = this.gui_cy.getText().trim();
        String string5 = "";
        int n2 = this.gui_cy_unit.getSelectedIndex();
        if (!CGCPanel.allowSecondsLevelTBAging(this._dbObject)) {
            ++n2;
        }
        string5 = stringArray[n2];
        String string6 = this.gui_aging_state.getText().trim();
        return String.format(bl ? "\n  AGING USE %s LIFETIME %s %s CYCLE %s %s %s" : "alter table " + this._rootTableFullname + "\n    add aging use %s lifetime %s %s\n    cycle %s %s\n    %s", string, string2, string3, string4, string5, string6);
    }

    @Override
    public boolean validateValues() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl2 = bl = this._mode == "none";
        if (this.gui_lt.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("AddAgingTBPanel.lifeTimeCannotBeBlankForTimebasedAging"));
        } else if (bl) {
            String string = this.gui_column.getSelectedItem().toString();
            CGCTableTreeNode cGCTableTreeNode = CGCPanel.theDialog.getRootTable();
            CGCColInfo cGCColInfo = cGCTableTreeNode.getCol(string);
            String string2 = "Time-based aging column " + string;
            if (string == null || cGCColInfo == null) {
                stringBuffer.append(string2 + " must be specified.");
            } else if (!cGCColInfo.getCached().booleanValue()) {
                stringBuffer.append(string2 + " must be selected for caching. \n\n(Check box for the column must indicate that the column is cached.)");
            } else if (cGCColInfo.getNullable().booleanValue()) {
                stringBuffer.append(string2 + " cannot be nullable. \n\n(Check box for the column must not indicate that the column allows null.)");
            }
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        if (this.gui_cy.getText().trim().length() == 0) {
            this.gui_cy.setText("5");
            this.gui_cy_unit.setSelectedIndex(0);
        }
        return true;
    }
}

