/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.table.RegexFormatter;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class AddPKPanel
extends DialogBase
implements FocusListener,
ActionListener {
    static int ROW = 0;
    static int PAGE = 1;
    static int RANGE_BUTTON = 0;
    static int HASH_BUTTON = 1;
    TTJPanel _yesPKPanel;
    Container _rangeHashGroup;
    JComboBox _pageRow;
    JFormattedTextField _name;
    JComboBox[] _pkMenus;
    int _nPKs;
    List<String> _nonNullCols;
    JFormattedTextField _n;
    JLabel _withNumberOf;
    Object _page;
    Object _row;
    JTextField _wakeup;
    int _lastN;
    boolean _isPage = false;
    String[] _PKInfo = null;
    static final String HASH = "0";
    static final String RANGE = "1";
    static final String INDEX = "2";

    public AddPKPanel(DBObject dBObject, String string) {
        super(dBObject, string, "AddPKPanel");
    }

    @Override
    public boolean applicable(DBObject dBObject) {
        boolean bl;
        this._PKInfo = SimpleQuery.getTTPKType(dBObject);
        this._nonNullCols = SimpleQuery.getNonNullCols(this._dbObject);
        boolean bl2 = bl = this._PKInfo != null && this._PKInfo[0] != null && this._PKInfo[1] != null;
        if (this._arg.equals("ChangePK") && !bl) {
            TTDialog.showError(Messages.getString("AddPKPanel.tableHasNoPK"));
            return false;
        }
        if (this._arg.equals("CreatePK") && bl) {
            TTDialog.showError(Messages.getString("AddPKPanel.tableHasPK"));
            return false;
        }
        if (this._arg.equals("CreatePK") && (this._nonNullCols == null || this._nonNullCols.size() <= 0)) {
            TTDialog.showError(Messages.getString("AddPKPanel.NoNonNullableColumns"));
            return false;
        }
        return true;
    }

    @Override
    protected void initGUI() {
        boolean bl;
        this.addOwnerAndName(this._dict);
        this._yesPKPanel = new TTJPanel();
        boolean bl2 = bl = this._PKInfo != null;
        if (this._arg.equals("CreatePK")) {
            bl = false;
        }
        int n = bl && this._PKInfo[0].equals(HASH) ? 1 : 0;
        int n2 = RANGE_BUTTON;
        if (n != 0) {
            n2 = HASH_BUTTON;
        }
        if (this._arg.equals("CreatePK")) {
            n2 = HASH_BUTTON;
        }
        this._rangeHashGroup = TTDialog.createRadioButtonGroup(new String[]{Messages.getString("CGCTableAttrPanel.useRange"), Messages.getString("CGCTableAttrPanel.useHash")}, n2, new ActionListener[]{new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPKPanel.this.isNowHashIdx(false);
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPKPanel.this.isNowHashIdx(true);
            }
        }}, false);
        JPanel jPanel = new JPanel();
        this._withNumberOf = new JLabel(Messages.getString("CGCTableAttrPanel.withNumberOf") + " ");
        this._pageRow = TTDialog.createMenu(new String[]{Messages.getString("CGCTableAttrPanel.row"), Messages.getString("CGCTableAttrPanel.pages")}, this);
        this._row = this._pageRow.getItemAt(ROW);
        this._page = this._pageRow.getItemAt(PAGE);
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        this._n = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._n.setFocusLostBehavior(1);
        this._n.addFocusListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this._withNumberOf);
        jPanel.add(this._pageRow);
        jPanel.add(new JLabel(" : "));
        jPanel.add(this._n);
        this._textValues.add(this._pageRow);
        this._textValues.add(this._n);
        this._wakeup = new JTextField("");
        this._textValues.add(this._wakeup);
        if (n != 0) {
            this._n.setValue(Integer.parseInt(this._PKInfo[1]));
            this._pageRow.setSelectedIndex(PAGE);
        }
        this._yesPKPanel.addRow(this._rangeHashGroup);
        this._yesPKPanel.addRow("", (Component)jPanel);
        this._yesPKPanel.setAlignmentX(0.0f);
        this.isNowHashIdx(n2 != RANGE_BUTTON);
        this.addRow(Messages.getString("CGCTableAttrPanel.keyIndexType"), this._yesPKPanel, true);
        if (this._arg.equals("CreatePK")) {
            this._name = new JFormattedTextField(new RegexFormatter("[a-zA-Z][_0-9a-zA-Z]{0,35}"));
            this._name.setColumns(20);
            this._textValues.add(this._name);
            this.addRow(Messages.getString("AddPKPanel.constraintName"), (Component)this._name);
            String[] stringArray = this._nonNullCols.toArray(new String[this._nonNullCols.size()]);
            n = stringArray.length;
            this._nPKs = 4;
            if (n < this._nPKs) {
                this._nPKs = n;
            }
            System.out.println("_nPKs is     " + this._nPKs);
            if (n >= 16) {
                this._nPKs = 16;
            }
            System.out.println("_nPKs is now " + this._nPKs);
            this._pkMenus = new JComboBox[this._nPKs];
            for (n2 = 0; n2 < this._nPKs; ++n2) {
                this._pkMenus[n2] = TTDialog.createMenu(stringArray, this);
                this._pkMenus[n2].insertItemAt("", 0);
                this._pkMenus[n2].setSelectedIndex(0);
                this.addRow(Messages.getString("BuiltInProcedure.Column") + " " + (n2 + 1), (Component)this._pkMenus[n2]);
            }
        }
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public boolean validateValues() {
        int n;
        String string;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._withNumberOf.isEnabled()) {
            string = (String)this._pageRow.getSelectedItem();
            if (this._n.getText().trim().length() == 0) {
                stringBuffer.append(String.format(Messages.getString("CGCTableAttrPanel.emptyPageRow"), string));
            } else {
                n = 0;
                try {
                    n = ((Number)this._n.getValue()).intValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n <= 0) {
                    stringBuffer.append(String.format(Messages.getString("CGCTableAttrPanel.wrongNumPageRow"), string));
                }
            }
        }
        if (this._arg.equals("CreatePK") && stringBuffer.length() == 0 && this._name.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("AddPKPanel.constraintNameEmptyError"));
        }
        if (this._arg.equals("CreatePK") && stringBuffer.length() == 0 && this._name.getText().trim().length() > 30) {
            stringBuffer.append(Messages.getString("AddPKPanel.constraintNameMoreThan30"));
        }
        if (this._arg.equals("CreatePK") && stringBuffer.length() == 0) {
            String string2;
            string = "";
            for (n = 0; n < this._nPKs && (string2 = this._pkMenus[n].getSelectedItem().toString()) != ""; ++n) {
                string = string + string2;
            }
            if (string.length() == 0) {
                stringBuffer.append(Messages.getString("AddPKPanel.noPKError"));
            }
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("alter table \"#OBJECT_OWNER#\".\"#OBJECT_NAME#\"\n");
        if (this._arg.equals("CreatePK")) {
            String string;
            stringBuffer.append("  add constraint " + this._name.getText() + "\n");
            stringBuffer.append("  primary key\n");
            stringBuffer.append("    (");
            String string2 = "";
            for (int i = 0; i < this._nPKs && (string = this._pkMenus[i].getSelectedItem().toString()) != ""; ++i) {
                stringBuffer.append(string2 + string);
                string2 = ",";
            }
            stringBuffer.append(")\n");
        }
        if (this._withNumberOf.isEnabled()) {
            stringBuffer.append("  use hash index pages = ");
            int n = 0;
            try {
                n = ((Number)this._n.getValue()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._pageRow.getSelectedIndex() == 0) {
                n = n / 256 + 1;
            }
            stringBuffer.append(n);
        } else if (this._arg.equals("ChangePK")) {
            stringBuffer.append("  use range index");
        }
        return stringBuffer.toString();
    }

    void isNowHashIdx(boolean bl) {
        this._withNumberOf.setEnabled(bl);
        this._pageRow.setEnabled(bl);
        this._n.setEnabled(bl);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        int n;
        Object object;
        if (focusEvent == null) {
            try {
                this._n.commitEdit();
                int n2 = ((Number)this._n.getValue()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (focusEvent.isTemporary()) {
            return;
        }
        try {
            object = this._n.getText();
            n = Integer.valueOf((String)object);
            if (n <= 0) {
                int n3 = this._lastN;
                this._n.setText(n3 > 0 ? n3 + "" : "");
                return;
            }
            this._n.commitEdit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = focusEvent.getSource();
        if (object == this._n) {
            try {
                this._lastN = n = ((Number)this._n.getValue()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._model == null) {
            return;
        }
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand().toLowerCase();
        if (string.startsWith("combobox")) {
            ItemSelectable itemSelectable = (ItemSelectable)actionEvent.getSource();
            Object[] objectArray = itemSelectable.getSelectedObjects();
            if (objectArray.length == 0) {
                return;
            }
            Object object2 = objectArray[0];
            if (object2 == this._page || object2 == this._row) {
                this._isPage = object2 == this._page;
            } else {
                JComboBox jComboBox = (JComboBox)object;
                String string2 = object2.toString();
                if (string2.length() > 0) {
                    // empty if block
                }
            }
        }
        this._wakeup.setText(this._wakeup.getText().length() == 0 ? RANGE : "");
    }
}

