/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.Common;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class StatusPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel _globalStatusPanel;
    private JPanel _errorLogPanel;
    private JButton _saveProfileButton;
    private JSplitPane _splitPane;
    private JTable _oStatusTable;
    private JTable _errorTable;
    private LoadTableRow load;
    private LoadTablesTable loadTable;
    private static final String[] OVERALL_STATUS = new String[]{Messages.getString("LoadTablesFromOracle.attributeHeader"), Messages.getString("LoadTablesFromOracle.valueHeader")};
    private static final String[] ACADIA_ATTRIBUTES = new String[]{Messages.getString("LoadTablesFromOracle.statusTable"), Messages.getString("LoadTablesFromOracle.globalStatus"), Messages.getString("LoadTablesFromOracle.totalLoadedRows"), Messages.getString("LoadTablesFromOracle.totalRowsWithErr"), Messages.getString("LoadTablesFromOracle.indexesCreated"), Messages.getString("LoadTablesFromOracle.started"), Messages.getString("LoadTablesFromOracle.ended"), Messages.getString("LoadTablesFromOracle.elapsed"), Messages.getString("LoadTablesFromOracle.RPS"), Messages.getString("LoadTablesFromOracle.oracleSCN")};
    private static final String[] ATTRIBUTES = new String[]{Messages.getString("LoadTablesFromOracle.statusTable"), Messages.getString("LoadTablesFromOracle.globalStatus"), Messages.getString("LoadTablesFromOracle.totalLoadedRows"), Messages.getString("LoadTablesFromOracle.indexesCreated")};

    public StatusPanel(LoadTableRow loadTableRow, LoadTablesTable loadTablesTable) {
        this.load = loadTableRow;
        this.loadTable = loadTablesTable;
        this.setLayout(new GridBagLayout());
        this._globalStatusPanel = new JPanel(new GridBagLayout());
        this._oStatusTable = new JTable(new OSTableModel());
        this._oStatusTable.setSelectionMode(0);
        this._oStatusTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = StatusPanel.this._oStatusTable.getSelectedRow();
                int n2 = StatusPanel.this._oStatusTable.getSelectedColumn();
                if (OSTRowIdx.isIndexesRow(n) && n2 == OSTColIdx.VALUE.getValue()) {
                    IndexPanel indexPanel = new IndexPanel(StatusPanel.this.load.getIndexMsgs());
                    JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)indexPanel, (String)Messages.getString("LoadTablesFromOracle.indexesCreated"), null);
                    jEWTDialog.setButtonMask(3);
                    jEWTDialog.runDialog();
                }
            }
        });
        TableColumnSizer.setColumnsWidthToFit(this._oStatusTable, true, true);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._oStatusTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this._globalStatusPanel.add((Component)new JScrollPane(this._oStatusTable, 20, 30), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        TableColumnModel tableColumnModel = this._oStatusTable.getColumnModel();
        tableColumnModel.getColumn(OSTColIdx.VALUE.getValue()).setCellRenderer(new IconTextCellRenderer());
        this._errorLogPanel = new JPanel(new GridBagLayout());
        this._errorLogPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.errorLog")));
        this._errorTable = new JTable(new ErrorTableModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = StatusPanel.this._errorTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        this._errorTable.setTableHeader(null);
        this._errorLogPanel.add((Component)new JScrollPane(this._errorTable, 20, 30), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(2, 2, 2, 2), 0, 0));
        this._splitPane = new JSplitPane(0, this._globalStatusPanel, this._errorLogPanel);
        this._splitPane.getRightComponent().setMinimumSize(new Dimension());
        this._splitPane.setDividerLocation(1.0);
        this._splitPane.setResizeWeight(1.0);
        this._splitPane.setOneTouchExpandable(true);
        this.add((Component)this._splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public JButton getCustomButton() {
        return this._saveProfileButton;
    }

    private void collapseErrorLog() {
        this._splitPane.setDividerLocation(1.0);
        this._splitPane.setResizeWeight(1.0);
    }

    private void expandErrorLog() {
        this._splitPane.setDividerLocation(0.65);
        this._splitPane.setResizeWeight(0.65);
    }

    public void changeLoadTableRow(LoadTableRow loadTableRow) {
        this.load = loadTableRow;
        LoadTableRow.LoadDataResult loadDataResult = loadTableRow.getLoadDataResult();
        if (loadDataResult != null) {
            if (loadDataResult.getErrors().size() == 0) {
                this.collapseErrorLog();
            } else {
                this.expandErrorLog();
            }
        }
        TableColumnSizer.setColumnsWidthToFit(this._errorTable, false, false);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.saveProfile();
    }

    public void saveProfile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Messages.getString("LoadTablesFromOracle.saveProfile"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JSON files (.json)", "json"));
        jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!string.endsWith(".json")) {
                string = string + ".json";
            }
            this.loadTable.saveJsonProfile(new File(string));
        }
    }

    private class IndexPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextPane _textPane;

        public IndexPanel(String string) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("LoadTablesFromOracle.indexLog")));
            this._textPane = new JTextPane();
            this._textPane.setPreferredSize(new Dimension(450, 200));
            this._textPane.setText(string);
            this._textPane.setEditable(false);
            this.add((Component)new JScrollPane(this._textPane, 20, 30), "Center");
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Image image = Common.iconToImage(Common.ERROR_ICON);
            Image image2 = image.getScaledInstance(12, 12, 4);
            ImageIcon imageIcon = new ImageIcon(image2);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setText(object.toString());
            jLabel.setToolTipText(object.toString());
            if (OSTRowIdx.isStatusRow(n) && StatusPanel.this.load.getStatus().getValue() == Common.LoadStatus.LOADED.getValue()) {
                jLabel.setIcon(Common.OK_ICON);
            } else if (OSTRowIdx.isStatusRow(n) && (StatusPanel.this.load.getStatus().getValue() == Common.LoadStatus.FATAL_ERROR.getValue() || StatusPanel.this.load.getStatus().getValue() == Common.LoadStatus.ERROR.getValue() || StatusPanel.this.load.getStatus().getValue() == Common.LoadStatus.LOADED_ERROR.getValue() || StatusPanel.this.load.getStatus().getValue() == Common.LoadStatus.SQL_EXCEPTION.getValue())) {
                jLabel.setIcon(imageIcon);
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }

    class OSTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        OSTableModel() {
        }

        @Override
        public int getRowCount() {
            return Common.isAcadia() != false ? ACADIA_ATTRIBUTES.length : ATTRIBUTES.length;
        }

        @Override
        public int getColumnCount() {
            return OVERALL_STATUS.length;
        }

        private long elapsedTimeSeconds(String string, String string2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss (z)");
            long l = 0L;
            try {
                Date date = simpleDateFormat.parse(string);
                Date date2 = simpleDateFormat.parse(string2);
                l = date2.getTime() - date.getTime();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            return l / 1000L;
        }

        private String localeString(String string) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss (z)");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, Locale.getDefault());
            dateFormat.setTimeZone(TimeZone.getDefault());
            Date date = null;
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                return "";
            }
            return dateFormat.format(date);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == OSTColIdx.ATTRIBUTE.getValue()) {
                return Common.isAcadia() != false ? ACADIA_ATTRIBUTES[n] : ATTRIBUTES[n];
            }
            if (n2 == OSTColIdx.VALUE.getValue()) {
                if (OSTRowIdx.isTableRow(n)) {
                    return StatusPanel.this.load.getTimesTenTable();
                }
                if (OSTRowIdx.isStatusRow(n)) {
                    return StatusPanel.this.load.getStatus() == Common.LoadStatus.SQL_EXCEPTION ? StatusPanel.this.load.getStatusText() : StatusPanel.this.load.getStatus().getStatusMessage(true);
                }
                if (OSTRowIdx.isTotalLoadedRow(n)) {
                    if (StatusPanel.this.load.getLoadDataResult() == null) {
                        if (StatusPanel.this.load.getStatus() == Common.LoadStatus.SQL_EXCEPTION && StatusPanel.this.load.alreadyExist()) {
                            return StatusPanel.this.load.getTimestenRowCount() - StatusPanel.this.load.getInitialTTRowCount();
                        }
                        return StatusPanel.this.load.getTimestenRowCount();
                    }
                    if (StatusPanel.this.load.getStatus() == Common.LoadStatus.SQL_EXCEPTION) {
                        if (StatusPanel.this.load.alreadyExist()) {
                            return StatusPanel.this.load.getTimestenRowCount() - StatusPanel.this.load.getInitialTTRowCount();
                        }
                        return StatusPanel.this.load.getTimestenRowCount();
                    }
                    return StatusPanel.this.load.getLoadDataResult().getRowsLoaded();
                }
                if (OSTRowIdx.isTotalErrorRow(n)) {
                    if (StatusPanel.this.load.getLoadDataResult() != null) {
                        return StatusPanel.this.load.getLoadDataResult().getRowsWithErrors();
                    }
                } else {
                    if (OSTRowIdx.isIndexesRow(n)) {
                        return "<html><a href=\"\">" + (StatusPanel.this.load.getIndexes() == null ? 0 : StatusPanel.this.load.getCreatedIndexesCount()) + "</a></html>";
                    }
                    if (OSTRowIdx.isStartedRow(n)) {
                        if (StatusPanel.this.load.getLoadDataResult() != null && StatusPanel.this.load.getLoadDataResult().getStarted() != null) {
                            return this.localeString(StatusPanel.this.load.getLoadDataResult().getStarted());
                        }
                    } else if (OSTRowIdx.isEndedRow(n)) {
                        if (StatusPanel.this.load.getLoadDataResult() != null && StatusPanel.this.load.getLoadDataResult().getEnded() != null) {
                            return this.localeString(StatusPanel.this.load.getLoadDataResult().getEnded());
                        }
                    } else if (OSTRowIdx.isOracleSCNRow(n)) {
                        if (StatusPanel.this.load.getLoadDataResult() != null && StatusPanel.this.load.getStatus() != Common.LoadStatus.SQL_EXCEPTION) {
                            return StatusPanel.this.load.getLoadDataResult().getOracleSCN();
                        }
                    } else if (OSTRowIdx.isElapsedRow(n)) {
                        if (StatusPanel.this.load.getLoadDataResult() != null && StatusPanel.this.load.getLoadDataResult().getStarted() != null && StatusPanel.this.load.getLoadDataResult().getEnded() != null) {
                            long l = this.elapsedTimeSeconds(StatusPanel.this.load.getLoadDataResult().getStarted(), StatusPanel.this.load.getLoadDataResult().getEnded());
                            return MessageFormat.format(Messages.getString("LoadTablesFromOracle.seconds"), l);
                        }
                    } else if (OSTRowIdx.isRPSRow(n) && StatusPanel.this.load.getLoadDataResult() != null && StatusPanel.this.load.getLoadDataResult().getStarted() != null && StatusPanel.this.load.getLoadDataResult().getEnded() != null) {
                        long l = this.elapsedTimeSeconds(StatusPanel.this.load.getLoadDataResult().getStarted(), StatusPanel.this.load.getLoadDataResult().getEnded());
                        long l2 = StatusPanel.this.load.getLoadDataResult().getRowsLoaded();
                        return l > 0L ? l2 / l : l2;
                    }
                }
                return Messages.getString("LoadTablesFromOracle.noDataFound");
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return OVERALL_STATUS[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    class ErrorTableModel
    extends AbstractTableModel {
        static final int INDEX_COL = 0;
        static final int MESSAGE_COL = 1;

        ErrorTableModel() {
        }

        @Override
        public int getRowCount() {
            LoadTableRow.LoadDataResult loadDataResult = StatusPanel.this.load.getLoadDataResult();
            return loadDataResult == null ? 0 : (loadDataResult.getErrors().size() > 0 ? loadDataResult.getErrors().size() : 0);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return n + 1;
                }
                case 1: {
                    LoadTableRow.LoadDataResult loadDataResult = StatusPanel.this.load.getLoadDataResult();
                    return loadDataResult == null ? "" : (loadDataResult.getErrors().size() > 0 ? loadDataResult.getErrors().get(n).getErrorMessage() : "");
                }
            }
            return null;
        }
    }

    private static enum OSTRowIdx {
        TABLE(0),
        STATUS(1),
        TOTAL_LROWS(2),
        TOTAL_EROWS(3),
        INDEXES(3),
        INDEXES_ACADIA(4),
        STARTED(5),
        ENDED(6),
        ELAPSED(7),
        RPS(8),
        ORACLE_SCN(9);

        private final int value;

        private OSTRowIdx(int n2) {
            this.value = n2;
        }

        int getValue() {
            return this.value;
        }

        static boolean isTableRow(int n) {
            return n == TABLE.getValue();
        }

        static boolean isStatusRow(int n) {
            return n == STATUS.getValue();
        }

        static boolean isTotalLoadedRow(int n) {
            return n == TOTAL_LROWS.getValue();
        }

        static boolean isTotalErrorRow(int n) {
            return Common.isAcadia().booleanValue() ? n == TOTAL_EROWS.getValue() : false;
        }

        static boolean isIndexesRow(int n) {
            return Common.isAcadia().booleanValue() ? n == INDEXES_ACADIA.getValue() : n == INDEXES.getValue();
        }

        static boolean isElapsedRow(int n) {
            return Common.isAcadia().booleanValue() ? n == ELAPSED.getValue() : false;
        }

        static boolean isStartedRow(int n) {
            return Common.isAcadia().booleanValue() ? n == STARTED.getValue() : false;
        }

        static boolean isEndedRow(int n) {
            return Common.isAcadia().booleanValue() ? n == ENDED.getValue() : false;
        }

        static boolean isRPSRow(int n) {
            return Common.isAcadia().booleanValue() ? n == RPS.getValue() : false;
        }

        static boolean isOracleSCNRow(int n) {
            return Common.isAcadia().booleanValue() ? n == ORACLE_SCN.getValue() : false;
        }
    }

    private static enum OSTColIdx {
        ATTRIBUTE(0),
        VALUE(1);

        private final int value;

        private OSTColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

