/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.awt.Component;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.timesten.utils.TTSchema;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class TTSchemaSQLTab
extends AsynchronousViewerEditor {
    private static Logger theLogger = Logger.getLogger(TTSchemaSQLTab.class.getPackage().getName());
    private JScrollPane _scrollPane;
    protected IdeAction _refreshAction;
    protected BasicEditorPane _code;
    protected DBObject _dbObject;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");

    protected JComponent createViewerUI() {
        this._code = EditorFactory.createIdeEditorPane();
        BasicDocument basicDocument = (BasicDocument)this._code.getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this._code.setEditable(false);
        this._code.setCaretPosition(0);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this._code.installPlugin((EditorPlugin)lineGutterPlugin);
        this._scrollPane = new JScrollPane((Component)this._code, 22, 32);
        this._scrollPane.setRowHeaderView((Component)lineGutterPlugin);
        this._refreshAction = IdeAction.findOrCreate((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString((String)"TimestenGrid.refresh"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                TTSchemaSQLTab.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        TTSchemaSQLTab.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)TTSchemaSQLTab.this.getFixedTopMargin()), Toolbar.class);
                toolbar.add((ToggleAction)TTSchemaSQLTab.this._refreshAction);
            }
        });
        return this._scrollPane;
    }

    public Object getPrintable() {
        return this._scrollPane;
    }

    protected void updateContent(boolean bl) {
        ViewerNode viewerNode;
        if (bl) {
            TTTableViewer.forceUpdateLastViewer();
        }
        if ((viewerNode = this.getViewerNode()) != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null) {
            final BasicEditorPane basicEditorPane = this._code;
            ResultCallBack resultCallBack = new ResultCallBack(){

                @Override
                public void setResult(String string) {
                    basicEditorPane.setEditable(true);
                    basicEditorPane.setText(string);
                    basicEditorPane.setEditable(false);
                }
            };
            String string = this.getSchema1(resultCallBack, this._dbObject);
        }
    }

    protected void cleanUp() {
        this._code = null;
        this._scrollPane = null;
        this._dbObject = null;
        this._refreshAction = null;
    }

    protected String getSchema1(ResultCallBack resultCallBack, DBObject dBObject) {
        return TTSchemaSQLTab.getSchema(resultCallBack, this._dbObject);
    }

    public static String getDSN(DBObject dBObject) {
        try {
            String string;
            String string2 = dBObject.getConnection().getMetaData().getURL().toString();
            String string3 = "";
            if (string2.toUpperCase().indexOf("TTC_SERVER_DSN") != -1) {
                string3 = string2.replaceAll("jdbc:timesten:direct:", "").replaceAll("jdbc:timesten:client:", "");
            } else {
                string = string2.toLowerCase();
                if (string.contains("jdbc:timesten:direct:") && !string.contains("dsn=")) {
                    String[] stringArray;
                    string = string.replace("jdbc:timesten:direct:", "");
                    for (String string4 : stringArray = string.split(";")) {
                        if (string4.contains("=")) continue;
                        string3 = string4;
                        break;
                    }
                } else {
                    string3 = string2.substring(string2.indexOf("DSN=") + 4).replaceAll(";.*$", "");
                }
            }
            string = Connections.getInstance().getConnectionInfo(dBObject.getConnectionName()).getProperty("user");
            if (string != null && !string.equals("")) {
                string3 = string3 + ";UID=" + string;
            }
            return string3;
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return "";
        }
    }

    public static String getSchema(ResultCallBack resultCallBack, DBObject dBObject) {
        try {
            String string;
            boolean bl;
            String string2 = dBObject.getConnection().getMetaData().getURL().toString();
            String string3 = TTSchemaSQLTab.getDSN(dBObject);
            TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
            String string4 = dBObject.getConnectionName();
            Connections connections = Connections.getInstance();
            Properties properties = connections.getConnectionInfo(string4);
            String string5 = properties.getProperty("password");
            if (string5 == null) {
                string5 = X10ConnectionProperties.getTheInstance().getProperty(Connections.getConnectionName((String)string4), "sys1");
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            boolean bl2 = true;
            boolean bl3 = bl = string2.indexOf(":client:") != -1;
            if (!bl && tTInstanceInformation.accessControlEnabled() && (string = properties.getProperty("user")) != null && TTSchemaSQLTab.getCurrentUserName().equals(string)) {
                string5 = null;
                bl2 = false;
            }
            return TTSchema.getDDL(resultCallBack, string3, dBObject.getSchemaName(), dBObject.getObjectName(), bl, bl2, string5);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return "";
        }
    }

    private static String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
            theLogger.info("Current user name" + string);
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot get login name", exception);
        }
        return string;
    }

    public static interface ResultCallBack {
        public void setResult(String var1);
    }
}

