/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.DataInstancesPanel;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGridOutputStream;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;

public class CreateGridTask
extends SwingWorker<Void, Void> {
    private CustomProgressMonitor _progressMonitor;
    private TraversableContext dataContext;
    private String installerParentDir;
    private TTGridOutputStream oStream;
    private boolean removeMemConfig;
    private boolean removeCGFile;
    private String memConfig;
    private String cgFileName;
    private static final String TT_INSTANCE_CREATE = "ttInstanceCreate";
    static Logger logger = Logger.getLogger(CreateGridTask.class.getName());

    public CreateGridTask(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        this.oStream = new TTGridOutputStream(this);
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.createGrid"), Messages.getString("TimesTenGrid.creatingTTGrid"), null);
        this._progressMonitor.setSwingWorker(this);
        this._progressMonitor.setCancellable(false);
        this.addPropertyChangeListener(this._progressMonitor);
    }

    /*
     * Loose catch block
     */
    @Override
    protected Void doInBackground() throws Exception {
        GridObject gridObject = null;
        try {
            this._progressMonitor.start();
            gridObject = this.createGrid();
            this.addGridNode(gridObject);
        }
        catch (GridCommandException gridCommandException) {
            this.firePropertyChange("error", null, gridCommandException.getMessage());
            logger.log(Level.SEVERE, gridCommandException.getMessage());
            this.cancel(true);
            this.oStream.close();
            if (gridObject != null && (this.removeMemConfig || this.removeCGFile)) {
                try {
                    GridCommand gridCommand = GridCommand.PERL_DELETE_FILES;
                    if (this.removeMemConfig && this.removeCGFile) {
                        gridCommand.prepareCommand(this.memConfig, this.cgFileName);
                    } else {
                        gridCommand.prepareCommand(this.removeMemConfig ? this.memConfig : this.cgFileName);
                    }
                    gridObject.getExecutor().executePerlScriptCommand(gridCommand, null);
                    logger.info("Temporary files used for grid creation were deleted");
                }
                catch (GridCommandException gridCommandException2) {
                    logger.warning(gridCommandException2.getMessage());
                }
            }
        }
        catch (IOException | Common.FromPerlException exception) {
            logger.log(Level.SEVERE, exception.getMessage());
            this.cancel(true);
            {
                catch (Throwable throwable) {
                    this.oStream.close();
                    if (gridObject != null && (this.removeMemConfig || this.removeCGFile)) {
                        try {
                            GridCommand gridCommand = GridCommand.PERL_DELETE_FILES;
                            if (this.removeMemConfig && this.removeCGFile) {
                                gridCommand.prepareCommand(this.memConfig, this.cgFileName);
                            } else {
                                gridCommand.prepareCommand(this.removeMemConfig ? this.memConfig : this.cgFileName);
                            }
                            gridObject.getExecutor().executePerlScriptCommand(gridCommand, null);
                            logger.info("Temporary files used for grid creation were deleted");
                        }
                        catch (GridCommandException gridCommandException2) {
                            logger.warning(gridCommandException2.getMessage());
                        }
                    }
                    throw throwable;
                }
            }
            this.oStream.close();
            if (gridObject != null && (this.removeMemConfig || this.removeCGFile)) {
                try {
                    GridCommand gridCommand = GridCommand.PERL_DELETE_FILES;
                    if (this.removeMemConfig && this.removeCGFile) {
                        gridCommand.prepareCommand(this.memConfig, this.cgFileName);
                    } else {
                        gridCommand.prepareCommand(this.removeMemConfig ? this.memConfig : this.cgFileName);
                    }
                    gridObject.getExecutor().executePerlScriptCommand(gridCommand, null);
                    logger.info("Temporary files used for grid creation were deleted");
                }
                catch (GridCommandException gridCommandException3) {
                    logger.warning(gridCommandException3.getMessage());
                }
            }
        }
        this.oStream.close();
        if (gridObject != null && (this.removeMemConfig || this.removeCGFile)) {
            try {
                GridCommand gridCommand = GridCommand.PERL_DELETE_FILES;
                if (this.removeMemConfig && this.removeCGFile) {
                    gridCommand.prepareCommand(this.memConfig, this.cgFileName);
                } else {
                    gridCommand.prepareCommand(this.removeMemConfig ? this.memConfig : this.cgFileName);
                }
                gridObject.getExecutor().executePerlScriptCommand(gridCommand, null);
                logger.info("Temporary files used for grid creation were deleted");
            }
            catch (GridCommandException gridCommandException) {
                logger.warning(gridCommandException.getMessage());
            }
        }
        return null;
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.unsuccessfulGridCreation"));
            this._progressMonitor.finish();
            this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.unsuccessfulGridCreation"));
        }
    }

    private GridObject createGrid() throws GridCommandException, Common.FromPerlException, IOException {
        Object object;
        GridCommand gridCommand;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = (String)this.dataContext.get("GRID_NAME");
        String string2 = (String)this.dataContext.get("MEM_SERVICE");
        this.memConfig = (String)this.dataContext.get("MEM_CONFIG");
        String string3 = (String)this.dataContext.get("NAME");
        String string4 = (String)this.dataContext.get("HOSTNAME");
        String string5 = (String)this.dataContext.get("INSTANCE_LOCATION");
        String string6 = (String)this.dataContext.get("INSTALLATION_LOCATION");
        String string7 = (String)this.dataContext.get("INSTANCE_ADMIN");
        char[] cArray = (char[])this.dataContext.get("PWD");
        String string8 = (String)this.dataContext.get("SSH_KEY_FILE");
        boolean bl = (Boolean)this.dataContext.get("SAVE_PWD");
        int n = (Integer)this.dataContext.get("DAEMON_PORT");
        int n2 = (Integer)this.dataContext.get("CS_PORT");
        int n3 = (Integer)this.dataContext.get("K_SAFETY");
        boolean bl2 = (Boolean)this.dataContext.get("LOCAL_PATH");
        String string9 = (String)this.dataContext.get("SW_LOCATION");
        List list = (List)this.dataContext.get("HOSTS");
        boolean bl3 = (Boolean)this.dataContext.get("IS_LOCAL_HOST");
        boolean bl4 = (Boolean)this.dataContext.get("APPLY");
        String string10 = (String)this.dataContext.get("INTADDRESS");
        String string11 = (String)this.dataContext.get("EXTADDRESS");
        int n4 = 1;
        if (this.dataContext.contains("DSG")) {
            n4 = (Integer)this.dataContext.get("DSG");
        }
        String string12 = null;
        if (this.dataContext.contains("TT_GROUP")) {
            string12 = (String)this.dataContext.get("TT_GROUP");
        }
        File file = null;
        boolean bl5 = false;
        String string13 = string9;
        boolean bl6 = string13.toLowerCase().endsWith(".zip");
        if (bl2) {
            file = new File(string9);
            bl5 = true;
        } else if (Common.validTTSWFile(string9)) {
            bl5 = true;
        }
        GridCommandExecutor gridCommandExecutor = GridCommandExecutor.getNewInstance(string11, string5, string7, cArray, string8);
        this._progressMonitor.setGridCommandExecutor(gridCommandExecutor);
        GridObject gridObject = new GridObject(string, gridCommandExecutor);
        gridObject.setSavePassword(bl);
        List list2 = (List)this.dataContext.get("DIRS_TO_CREATE");
        if (!list2.isEmpty()) {
            object6 = this.getDirsPerHost(list2);
            object5 = ((HashMap)object6).keySet().iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingDirs"), object4));
                object3 = new StringBuilder();
                for (Object object22 : (List)((HashMap)object6).get(object4)) {
                    ((StringBuilder)object3).append((String)object22);
                    ((StringBuilder)object3).append(" ");
                }
                gridCommand = GridCommand.CREATE_REMOTE_DIR_NO_GRID;
                gridCommand.prepareCommand(new String[]{object4, ((StringBuilder)object3).toString()});
                try {
                    gridCommandExecutor.executeSimpleCommand(gridCommand);
                }
                catch (GridCommandException gridCommandException) {
                    throw new GridCommandException("Error while creating " + object3, gridCommandException);
                }
            }
        }
        object6 = this.getFileSeparatorFromLocation(bl5 ? string6 : string9);
        if (bl5) {
            if (bl2 && !bl3) {
                this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.copyingTTGridSW"), string4));
                gridCommandExecutor.executeSCP(file, string6);
                string13 = file.getName();
                gridCommand = bl6 ? GridCommand.CDPARENTDIR_ZIP_SW : GridCommand.CDPARENTDIR_TAR_SW;
                gridCommand.prepareCommand(string6, string13);
            } else {
                gridCommand = bl6 ? GridCommand.PARENTDIR_ZIP_SW : GridCommand.PARENTDIR_TAR_SW;
                gridCommand.prepareCommand(string13);
            }
            this.installerParentDir = gridCommandExecutor.executeSimpleCommandGetOutput(gridCommand);
            if (bl6 && ((String[])(object5 = this.installerParentDir.split("\\s+"))).length > 0) {
                this.installerParentDir = object5[((String[])object5).length - 1];
            }
            if (this.installerParentDir.contains(TT_INSTANCE_CREATE)) {
                object5 = Pattern.compile("\\." + (String)object6 + "(.*?)" + (String)object6);
                object4 = ((Pattern)object5).matcher(this.installerParentDir);
                this.installerParentDir = ((Matcher)object4).find() ? ((Matcher)object4).group(1) : this.installerParentDir.substring(0, this.installerParentDir.indexOf((String)object6));
            } else {
                if (bl2 && !bl3) {
                    gridCommand = GridCommand.CDREMOVE_FILE;
                    gridCommand.prepareCommand(string6, string13);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.deletingTTGridSW"));
                    gridCommandExecutor.executeSimpleCommand(gridCommand);
                }
                this.installerParentDir = null;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.invalidInstallable"), string13));
            }
            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.uncompressingTTGridSW"));
            gridCommand = bl6 ? GridCommand.UNCOMPRESS_ZIP_SW : GridCommand.UNCOMPRESS_TAR_SW;
            gridCommand.prepareCommand(string6, string13);
            gridCommandExecutor.executeSimpleCommand(gridCommand);
        }
        gridCommand = GridCommand.PERL_GET_SYSTEM_INFO_NG;
        gridCommand.prepareCommand(string6 + (String)object6 + (this.installerParentDir != null ? this.installerParentDir + (String)object6 : "") + "PERL" + (String)object6 + "bin" + (String)object6);
        gridCommandExecutor.executeSimpleCommand(gridCommand);
        object5 = gridCommandExecutor.getSSHChannel().getLastCommandOutput().split(";");
        object4 = object5[0];
        object3 = object5[1];
        String string14 = (String)object5[2] + (String)object5[3];
        object22 = object5[3];
        if (string12 != null) {
            this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.changingGroupTTInstall"), string12));
            gridCommand = GridCommand.CHANGE_DIR_GROUP;
            gridCommand.prepareCommand(string12, string6 + (this.installerParentDir != null ? (String)object22 + this.installerParentDir : ""));
            gridCommandExecutor.executeSimpleCommand(gridCommand);
        }
        String string15 = (String)object22 + "bin" + (String)object22;
        if (this.installerParentDir != null) {
            string15 = (String)object22 + this.installerParentDir + string15;
        }
        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.addingMgmtInstance"), string3, string4));
        gridCommand = GridCommand.TT_INSTANCE_CREATE;
        gridCommand.prepareCommand(string6 + string15, (String)this.dataContext.get("INSTANCE_LOCATION"), string3, String.valueOf(n), String.valueOf(n2));
        gridCommandExecutor.executeSimpleCommand(gridCommand);
        gridCommandExecutor.getSSHChannel().setInstanceHome(string5 + (String)object22 + string3);
        gridCommandExecutor.getWorkingHost().setInstanceHome(string5 + (String)object22 + string3);
        gridCommandExecutor.getWorkingHost().updateSystemInfo((String)object4, (String)object3, string14, (String)object22);
        gridObject.setName(string);
        if (Common.isAFile(this.memConfig) && !bl3) {
            this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.copyingMemConfig"), string4));
            object = new File(this.memConfig);
            gridCommandExecutor.executeSCP((File)object, string14);
            this.memConfig = (String)string14 + ((File)object).getName();
            this.removeMemConfig = true;
        }
        object = this.getCreateGridStr(string, n3, string10, string11, string4, n4, string6, string3, string2, this.memConfig, list);
        this.cgFileName = this.getCreateGridFileName();
        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.copyingCGFile"), string4));
        gridCommandExecutor.executeSCP((String)object, string14, this.cgFileName);
        this.cgFileName = (String)string14 + this.cgFileName;
        this.removeCGFile = true;
        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingGrid"), string));
        gridCommand = GridCommand.PERL_CREATE_GRID;
        gridCommand.prepareCommand(this.cgFileName);
        try {
            gridCommandExecutor.executePerlScriptCommand(gridCommand, this.oStream);
        }
        catch (GridCommandException gridCommandException) {
            if (gridCommandException.getCause() == null) {
                throw new Common.FromPerlException(gridCommandException.getMessage());
            }
            throw gridCommandException;
        }
        if (list.size() > 0) {
            if (list.size() > 1) {
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.addingHosts"));
            }
            gridCommand = GridCommand.PERL_ADD_HOSTS;
            gridCommand.prepareCommand(this.cgFileName);
            try {
                gridCommandExecutor.executePerlScriptCommand(gridCommand, this.oStream);
            }
            catch (GridCommandException gridCommandException) {
                try {
                    this.populateGrid(gridObject);
                    this.addGridNode(gridObject);
                }
                catch (GridCommandException gridCommandException2) {
                    logger.log(Level.SEVERE, "While populating grid when trying to add hosts: " + gridCommandException2.getMessage());
                }
                if (gridCommandException.getCause() == null) {
                    throw new Common.FromPerlException(gridCommandException.getMessage());
                }
                throw gridCommandException;
            }
        }
        if (bl4) {
            gridCommand = GridCommand.PERL_APPLY_MODEL;
            gridCommand.prepareCommand("");
            try {
                gridCommandExecutor.executePerlScriptCommand(gridCommand, this.oStream);
            }
            catch (GridCommandException gridCommandException) {
                try {
                    this.populateGrid(gridObject);
                    this.addGridNode(gridObject);
                }
                catch (GridCommandException gridCommandException3) {
                    logger.log(Level.SEVERE, "While populating grid when trying to apply model: " + gridCommandException3.getMessage());
                }
                if (gridCommandException.getCause() == null) {
                    throw new Common.FromPerlException(gridCommandException.getMessage());
                }
                throw gridCommandException;
            }
        }
        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.retrievingGridModel"));
        this.populateGrid(gridObject);
        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.gridCreated"));
        this.firePropertyChange("progress", null, 100);
        return gridObject;
    }

    private HashMap<String, List<String>> getDirsPerHost(List<String> list) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string : list) {
            List<Object> list2;
            String[] stringArray = string.split(":");
            if (hashMap.containsKey(stringArray[0])) {
                list2 = hashMap.get(stringArray[0]);
                if (list2.contains(stringArray[1])) continue;
                list2.add(stringArray[1]);
                continue;
            }
            list2 = new ArrayList<String>();
            list2.add(stringArray[1]);
            hashMap.put(stringArray[0], list2);
        }
        return hashMap;
    }

    private void populateGrid(GridObject gridObject) throws GridCommandException {
        try {
            GridCommand gridCommand = GridCommand.EXPORT_MODEL;
            JsonObject jsonObject = gridObject.getExecutor().executeCommandGetJson(gridCommand, true);
            gridObject.setGridComponents(jsonObject, true);
            gridObject.setCurrentModel(jsonObject);
            gridObject.getGridCurrentModel().diff(gridObject);
        }
        catch (JsonException jsonException) {
            throw new GridCommandException(Messages.getString("TimesTenGrid.readModelError") + " " + jsonException.getMessage());
        }
    }

    private void addGridNode(GridObject gridObject) {
        if (gridObject != null && TTGridRootNode.getInstance().getGrid(gridObject.getName()) == null) {
            TTGridRootNode.getInstance().addGrid(gridObject);
        }
    }

    private String getCreateGridFileName() {
        return "createTTGrid_" + System.currentTimeMillis();
    }

    private String getCreateGridStr(String string, int n, String string2, String string3, String string4, int n2, String string5, String string6, String string7, String string8, List<DataInstancesPanel.Host> list) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("gridName", string);
        jsonObjectBuilder.add("k", n);
        jsonObjectBuilder.add("hostName", string4);
        jsonObjectBuilder.add("dataSpaceGroup", n2);
        jsonObjectBuilder.add("installationLocation", string5);
        jsonObjectBuilder.add("instanceName", string6);
        jsonObjectBuilder.add("membershipService", string7);
        jsonObjectBuilder.add("membershipConfig", string8);
        jsonObjectBuilder.add("internalAddress", string2);
        jsonObjectBuilder.add("externalAddress", string3);
        jsonObjectBuilder.add("mgmtPort", ((Integer)this.dataContext.get("MANAGEMENT_PORT")).intValue());
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (DataInstancesPanel.Host host : list) {
            boolean bl = false;
            if (host.getName().equals(string4)) {
                bl = true;
            }
            JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
            jsonObjectBuilder2.add("type", "host");
            jsonObjectBuilder2.add("name", host.getName());
            jsonObjectBuilder2.add("internalAddress", host.getInternalAddress());
            jsonObjectBuilder2.add("externalAddress", host.getExternalAddress());
            jsonObjectBuilder2.add("dataSpaceGroup", host.getDSG());
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
            int n3 = 1;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl) {
                n3 = 2;
                hashMap.put(string5, "installation1");
            }
            for (DataInstancesPanel.Instance instance : host.getInstances()) {
                JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder();
                jsonObjectBuilder3.add("type", "instance");
                jsonObjectBuilder3.add("name", instance.getName());
                jsonObjectBuilder3.add("location", instance.getLocation());
                jsonObjectBuilder3.add("daemonPort", instance.getDaemonPort());
                jsonObjectBuilder3.add("csPort", instance.getCSPort());
                if (!hashMap.containsKey(instance.getInstallLocation())) {
                    String string9 = "installation" + n3++;
                    JsonObjectBuilder jsonObjectBuilder4 = Json.createObjectBuilder();
                    jsonObjectBuilder4.add("type", "installation");
                    jsonObjectBuilder4.add("name", string9);
                    String string10 = instance.getInstallLocation();
                    if (this.installerParentDir != null && (host.getName().equals(string4) || host.getInternalAddress().equals(string2) && host.getExternalAddress().equals(string3))) {
                        string10 = string10 + "/" + this.installerParentDir;
                    }
                    jsonObjectBuilder4.add("location", string10);
                    jsonArrayBuilder3.add(jsonObjectBuilder4);
                    hashMap.put(instance.getInstallLocation(), string9);
                    jsonObjectBuilder3.add("installation", string9);
                } else {
                    jsonObjectBuilder3.add("installation", (String)hashMap.get(instance.getInstallLocation()));
                }
                jsonArrayBuilder2.add(jsonObjectBuilder3);
            }
            jsonObjectBuilder2.add("installations", jsonArrayBuilder3);
            jsonObjectBuilder2.add("instances", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("hosts", jsonArrayBuilder);
        jsonWriter.writeObject(jsonObjectBuilder.build());
        jsonWriter.close();
        return stringWriter.getBuffer().toString();
    }

    private String getFileSeparatorFromLocation(String string) {
        String string2 = "/";
        File file = new File(string);
        String string3 = file.getName();
        String string4 = file.getParentFile().getName();
        if (string4 != null) {
            try {
                string2 = string.substring(string.lastIndexOf(string4) + string4.length(), string.lastIndexOf(string3));
            }
            catch (Exception exception) {
                logger.warning("Can't determine file separator from install location: " + exception.getMessage());
            }
        }
        return string2;
    }
}

