/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGridTextPane;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;

public class CustomProgressMonitor
extends IndeterminateProgressMonitor
implements ChangeListener,
PropertyChangeListener {
    private SwingWorker worker;
    private boolean success;
    private GridCommandExecutor gridCmdExec;
    private TTGridTextPane _textPane;
    private JScrollPane _scrollPane;
    private ProgressPanel _progressPanel;
    private static final int HEIGHT = 300;
    private static final int WIDTH = 500;

    public CustomProgressMonitor(Component component, String string, String string2, String string3) {
        super(component, string, (Object)string2, string3);
        this.init();
    }

    private void init() {
        this._progressPanel = this.getPanel();
        this.setCancellable(true);
        this.setMillisToPopup(0);
        this.setCloseOnFinish(false);
        this.setModal(true);
        this.setBarVisible(true);
        this.setDetailsTextAreaActivated(true);
        this.addCancellationListener(this);
        this.setEditableTextArea(false);
        this.setTextAreaPreferredSize(500, 300);
        this.success = false;
    }

    public void setEditableTextArea(boolean bl) {
        this._textPane.setEditable(bl);
    }

    protected void setTextAreaPreferredSize(int n, int n2) {
        this._scrollPane.setPreferredSize(new Dimension(n, n2));
    }

    public void updateMessage(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._progressPanel.setMessage(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomProgressMonitor.this._progressPanel.setMessage(string);
                }
            });
        }
    }

    public void setDetailsTextAreaActivated(boolean bl) {
        if (bl) {
            if (this.getDetailContent() == null) {
                this._textPane = new TTGridTextPane();
                this._scrollPane = new JScrollPane(this._textPane);
                this._scrollPane.setPreferredSize(new Dimension(300, 100));
                if (SwingUtilities.isEventDispatchThread()) {
                    this.setDetailContent(this._scrollPane);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustomProgressMonitor.this.setDetailContent(CustomProgressMonitor.this._scrollPane);
                        }
                    });
                }
            }
        } else {
            this.setDetailContent(null);
            this._textPane = null;
            this._scrollPane = null;
        }
    }

    public void setGridCommandExecutor(GridCommandExecutor gridCommandExecutor) {
        this.gridCmdExec = gridCommandExecutor;
        this._textPane.setGridCommandExecutor(this.gridCmdExec);
    }

    public void setSwingWorker(SwingWorker swingWorker) {
        this.worker = swingWorker;
    }

    public boolean successfulExecution() {
        return this.success;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.worker.cancel(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "progress") {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 100) {
                this.success = true;
                this.updateMessage(Messages.getString("IndexAdvisor.completed"));
                this.finish();
                return;
            }
            if (this.isCanceled() || this.worker.isDone()) {
                Toolkit.getDefaultToolkit().beep();
                if (this.isCanceled()) {
                    this.worker.cancel(true);
                } else {
                    this.finish();
                }
            }
        } else if (propertyChangeEvent.getPropertyName() == "message" || propertyChangeEvent.getPropertyName() == "error") {
            String string = propertyChangeEvent.getPropertyName() == "error" ? "Error: " + (String)propertyChangeEvent.getNewValue() : (String)propertyChangeEvent.getNewValue();
            this._textPane.updateText(string);
        }
    }

    public void finish() {
        super.finish();
        if (this.getComponent() != null) {
            ((DetailDialog)this.getComponent()).setDefaultCloseOperation(2);
        }
    }
}

