/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.json.Json;
import javax.json.JsonObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CredentialsPanel;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;

public class ManageExistingGridPanel
extends JPanel
implements ActionListener {
    private JLabel _addressLabel;
    private JLabel _locationLabel;
    private AutoCompleteComponent _addressTxtField;
    private AutoCompleteComponent _locationTxtField;
    private JButton _testButton;
    private JButton _okButton;
    private JPanel _mgmtInstPanel;
    private CredentialsPanel _credPanel;
    private JEWTDialog _dialog;
    private CustomProgressMonitor _progressMonitor;
    private GridObject grid;
    private GridObject existingGrid;

    public ManageExistingGridPanel(GridObject gridObject) {
        this.existingGrid = gridObject;
        this.setLayout(new GridBagLayout());
        this._addressTxtField = new AutoCompleteComponent(15, HostObject.getHostExternalAddressSuggestions());
        this._locationTxtField = new AutoCompleteComponent(30, InstanceObject.getInstanceHomeSuggestions());
        this._addressLabel = new JLabel(Messages.getString("TimesTenGrid.addressLabel"));
        this._addressLabel.setLabelFor(this._addressTxtField);
        this._locationLabel = new JLabel(Messages.getString("TimesTenGrid.instHomeLabel"));
        this._locationLabel.setLabelFor(this._locationTxtField);
        this._testButton = new JButton(Messages.getString("TimesTenGrid.test"));
        this._testButton.addActionListener(this);
        this._okButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
        this._okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
        this._okButton.addActionListener(this);
        this._mgmtInstPanel = new JPanel(new GridBagLayout());
        this._mgmtInstPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.mgmtInstInformation")));
        this._credPanel = new CredentialsPanel();
        this._credPanel.initialize();
        this._mgmtInstPanel.add((Component)this._addressLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._addressTxtField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._locationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 5, 10, 10), 0, 0));
        this._mgmtInstPanel.add((Component)this._locationTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._mgmtInstPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._credPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (gridObject != null) {
            this.populateFields();
        }
        this.setNames();
    }

    private void populateFields() {
        GridCommandExecutor.WorkingHost workingHost = this.existingGrid.getExecutor().getWorkingHost();
        this._addressTxtField.setText(workingHost.getIPaddress());
        this._locationTxtField.setText(workingHost.getInstanceHome());
        this._credPanel.setInstanceAdmin(workingHost.getInstanceAdmin(), true);
        if (workingHost.getPwd() != null) {
            if (this.existingGrid.getSavePassword()) {
                this._credPanel.setPassword(new String(workingHost.getPwd()));
            }
            this._credPanel.setSavePassword(this.existingGrid.getSavePassword());
        }
        if (workingHost.getKeyFile() != null) {
            this._credPanel.setKeyFile(workingHost.getKeyFile());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            return;
        }
        this.connect(actionEvent.getSource() == this._testButton);
    }

    private boolean validInput() {
        String string = this._addressTxtField.getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noAddressError"));
            return false;
        }
        if (!Common.validAddress(string)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.addressFormatError"));
            return false;
        }
        String string2 = this._locationTxtField.getText().trim();
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInstHomeError"));
            return false;
        }
        String string3 = this._credPanel.getInstanceAdmin();
        if (string3 == null) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noInstanceAdminError"));
            return false;
        }
        if (this._credPanel.isUsingPassword()) {
            char[] cArray = this._credPanel.getPassword();
            if (cArray == null) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noPwdError"));
                return false;
            }
        } else {
            String string4 = this._credPanel.getKeyFile();
            if (string4 == null) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.noKeyFileError"));
                return false;
            }
            File file = new File(string4);
            if (!file.exists()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.keyFileDoesntExistError"));
                return false;
            }
            if (!file.isFile()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.keyNotNormalFileError"));
                return false;
            }
        }
        return true;
    }

    public JButton getTestButton() {
        return this._testButton;
    }

    public JButton getOKButton() {
        return this._okButton;
    }

    private void connect(final boolean bl) {
        final String string = this._addressTxtField.getText().trim();
        final String string2 = this._locationTxtField.getText().trim();
        final String string3 = this._credPanel.getInstanceAdmin();
        final char[] cArray = this._credPanel.isUsingPassword() ? this._credPanel.getPassword() : null;
        final String string4 = this._credPanel.isUsingPassword() ? null : this._credPanel.getKeyFile();
        this._progressMonitor = new CustomProgressMonitor(this, MessageFormat.format(Messages.getString("TimesTenGrid.connectingToHost"), string), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            StringBuilder errorMessage = new StringBuilder();

            @Override
            protected Void doInBackground() throws Exception {
                Object object;
                GridCommandExecutor gridCommandExecutor = GridCommandExecutor.getNewInstance(string, string2, string3, cArray, string4);
                ManageExistingGridPanel.this._progressMonitor.start();
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.verifyingInstance"));
                try {
                    object = GridCommand.PERL_CHECK_ACTIVE_MGMT_INST;
                    ((GridCommand)((Object)object)).prepareCommand(string, string2);
                    gridCommandExecutor.executePerlScriptCommand((GridCommand)((Object)object), null);
                }
                catch (GridCommandException gridCommandException) {
                    if (gridCommandException.getMessage().indexOf(123) >= 0) {
                        String string5 = gridCommandException.getMessage().substring(gridCommandException.getMessage().indexOf(123), gridCommandException.getMessage().length());
                        JsonObject jsonObject = Json.createReader((Reader)new StringReader(string5)).readObject();
                        if (jsonObject.getInt("status") == 73) {
                            this.errorMessage.append(Messages.getString("TimesTenGrid.invalidManagementInstanceHome"));
                        } else {
                            this.errorMessage.append(gridCommandException.getMessage());
                        }
                    } else {
                        this.errorMessage.append(gridCommandException.getMessage());
                    }
                    return null;
                }
                if (!bl) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.retrievingGridModel"));
                    try {
                        if (ManageExistingGridPanel.this.existingGrid != null) {
                            object = ManageExistingGridPanel.this.existingGrid;
                            ((GridObject)object).setExecutor(gridCommandExecutor);
                        } else {
                            object = ManageExistingGridPanel.this.grid = new GridObject("", gridCommandExecutor);
                        }
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.gettingSystemInfo"));
                        GridCommand gridCommand = GridCommand.PERL_GET_SYSTEM_INFO;
                        gridCommand.prepareCommand("");
                        gridCommandExecutor.executePerlScriptCommand(gridCommand, null);
                        String[] stringArray = gridCommandExecutor.getSSHChannel().getLastCommandOutput().split(";");
                        String string6 = stringArray[0];
                        String string22 = stringArray[1];
                        String string32 = stringArray[2] + stringArray[3];
                        String string42 = stringArray[3];
                        gridCommandExecutor.getWorkingHost().updateSystemInfo(string6, string22, string32, string42);
                        ((GridObject)object).setSavePassword(ManageExistingGridPanel.this._credPanel.getSavePassword());
                        JsonObject jsonObject = gridCommandExecutor.executeCommandGetJson(GridCommand.EXPORT_MODEL, true);
                        ((GridObject)object).setGridComponents(jsonObject, true);
                        ((GridObject)object).setCurrentModel(((GridObject)object).getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true));
                        ((GridObject)object).getGridCurrentModel().diff((GridObject)object);
                    }
                    catch (Exception exception) {
                        this.errorMessage.append(exception.getMessage());
                        return null;
                    }
                }
                this.firePropertyChange("progress", null, 100);
                return null;
            }

            @Override
            protected void done() {
                ManageExistingGridPanel.this._progressMonitor.close();
                if (this.isCancelled()) {
                    return;
                }
                if (ManageExistingGridPanel.this._progressMonitor.successfulExecution()) {
                    TTGridRootNode.getStorage().saveSuggestion("adminUID", string3);
                    if (string4 != null) {
                        TTGridRootNode.getStorage().saveSuggestion("keyFile", string4);
                    }
                    String string5 = Messages.getString("TimesTenGrid.successfulTest");
                    String string22 = Messages.getString("TimesTenGrid.testGrid");
                    if (!bl) {
                        ManageExistingGridPanel.this.getDialog().dispose();
                        if (ManageExistingGridPanel.this.existingGrid != null) {
                            return;
                        }
                        if (TTGridRootNode.getInstance().getGrid(ManageExistingGridPanel.this.grid.getName()) == null) {
                            TTGridRootNode.getInstance().addGrid(ManageExistingGridPanel.this.grid);
                        }
                        string5 = MessageFormat.format(Messages.getString("TimesTenGrid.successfullyManage"), ManageExistingGridPanel.this.grid.getShortName());
                        string22 = Messages.getString("TimesTenGrid.manageExistingGrid");
                    }
                    Common.displayInfoMsg((Component)Ide.getMainWindow(), string5, string22);
                } else {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    private void setNames() {
        this._addressLabel.setName(Messages.getString("TimesTenGrid.addressLabel"));
        this._locationLabel.setName(Messages.getString("TimesTenGrid.instHomeLabel"));
        this._addressTxtField.setName("_addressTxtField", "_addressCmbBox");
        this._locationTxtField.setName("_locationTxtField", "_locationCmbBox");
        this._testButton.setName(Messages.getString("TimesTenGrid.test"));
        this._okButton.setName(Messages.getString("TimesTen.common.OKButton"));
    }
}

