/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;

public class SSHChannel {
    private String instanceAdmin;
    private String instanceHome;
    private String ipAddress;
    private char[] pwd;
    private String keyFile;
    private static final String COMMAND = "#LOCATION#/bin/ttenv #COMMAND#";
    private static final String FILE_EXISTS = "test -f #FILE#";
    private static final String DIRECTORY_EXISTS = "test -d #DIRECTORY#";
    private static final String DIRECTORY_EXISTS_WPERM = "test -w #DIRECTORY#";
    private static final String SAME_DIRECTORIES = "test #PATH1# -ef #PATH2#";
    private static final String USER_IN_GROUP = "id -nG #USER# | grep -qw #GROUP#";
    private static final String TTGRIDADMIN_HELP = "#LOCATION#/PERL/bin/perl #LOCATION#/bin/ttGridAdmin.pl -h";
    private StringBuilder commandOutput;
    private String commandErrorOutput;
    private Session session;
    private Session SCPSession;
    private Channel channel;
    private static final Logger logger = Logger.getLogger(SSHChannel.class.getName());
    public static final int SUCCESS = 0;
    private int commandExitStatus;
    private boolean cancelCommand;
    private static final int SSH_PORT = 22;
    private static final File PERL_SCRIPT = Common.streamToFile(GridCommandExecutor.class.getResourceAsStream("gridCompositeCommands.pl"));

    SSHChannel(String string, String string2, String string3, char[] cArray) {
        this.init(string, string2, string3);
        this.pwd = cArray;
    }

    SSHChannel(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3);
        this.keyFile = string4;
    }

    private void init(String string, String string2, String string3) {
        this.ipAddress = string;
        this.instanceHome = string2;
        this.instanceAdmin = string3;
    }

    public void setInstanceHome(String string) {
        this.instanceHome = string;
    }

    public void setPwd(char[] cArray) {
        this.pwd = cArray;
    }

    public void setKeyFile(String string) {
        this.keyFile = string;
    }

    private static Session getSessionHelper(String string, String string2, char[] cArray, String string3) throws JSchException {
        JSch jSch = new JSch();
        if (string3 != null) {
            if (!Common.validFilePermission(string3)) {
                throw new JSchException(Messages.getString("TimesTenGrid.keyFileInvalidPermission"));
            }
            jSch.addIdentity(string3);
        }
        Session session = jSch.getSession(string, string2, 22);
        session.setConfig("StrictHostKeyChecking", "no");
        if (cArray != null) {
            session.setPassword(new String(cArray));
        }
        return session;
    }

    private void prepareChannel() throws MySSHException {
        try {
            this.closeChannel();
            if (this.session == null) {
                this.session = SSHChannel.getSessionHelper(this.instanceAdmin, this.ipAddress, this.pwd, this.keyFile);
            }
            if (!this.session.isConnected()) {
                this.session.connect();
                ShutdownHook shutdownHook = new ShutdownHook(){

                    public boolean canShutdown() {
                        return true;
                    }

                    public void shutdown() {
                        SSHChannel.this.forceClose();
                    }
                };
                ExitCommand.removeShutdownHook((ShutdownHook)shutdownHook);
                ExitCommand.addShutdownHook((ShutdownHook)shutdownHook);
            }
            this.channel = this.session.openChannel("exec");
            this.setCancelCommand(false);
        }
        catch (JSchException jSchException) {
            this.session = null;
            this.channel = null;
            throw new MySSHException("Failed while opening ssh session or channel:" + jSchException.getMessage(), jSchException.getCause());
        }
    }

    public synchronized boolean getCancelCommand() {
        return this.cancelCommand;
    }

    public synchronized void setCancelCommand(boolean bl) {
        this.cancelCommand = bl;
    }

    public static String tryConnect(String string, String string2, char[] cArray, String string3) throws MySSHException {
        return SSHChannel.tryConnect(string, string2, cArray, string3, null, null);
    }

    public void checkSameDirectories(String string, List<String> list) throws MySSHException {
        Session session = null;
        try {
            session = SSHChannel.getSessionHelper(this.instanceAdmin, this.ipAddress, this.pwd, this.keyFile);
        }
        catch (JSchException jSchException) {
            throw new MySSHException(jSchException.getMessage(), jSchException.getCause());
        }
        try {
            session.connect();
            for (String string2 : list) {
                if (!SSHChannel.sameDirectories(session, string, string2)) continue;
                throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.alreadyUsedInstDirHost"), this.ipAddress));
            }
        }
        catch (JSchException jSchException) {
            throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHostExp"), this.ipAddress, jSchException.getMessage()));
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static String tryConnect(String string, String string2, char[] cArray, String string3, boolean[] blArray, String[] stringArray) throws MySSHException {
        Session session = null;
        String string4 = null;
        try {
            session = SSHChannel.getSessionHelper(string2, string, cArray, string3);
        }
        catch (JSchException jSchException) {
            throw new MySSHException(jSchException.getMessage(), jSchException.getCause());
        }
        try {
            session.connect();
            string4 = SSHChannel.getHostName(session);
            if (blArray == null) {
                String string5 = string4;
                return string5;
            }
            if (blArray[Common.CheckIndex.MEMCONFIG_IDX.ordinal()] && !SSHChannel.existRemoteFile(session, stringArray[Common.CheckIndex.MEMCONFIG_IDX.ordinal()])) {
                throw new MySSHException(Messages.getString("TimesTenGrid.membershipConfFileNE"));
            }
            if (blArray[Common.CheckIndex.INSTDIR_IDX.ordinal()]) {
                if (!SSHChannel.existRemotePathWritePerm(session, stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()])) {
                    int n = Common.CheckIndex.INSTDIR_IDX.ordinal();
                    stringArray[n] = stringArray[n] + "$$CREATE_DIR$$";
                }
                if (SSHChannel.existRemotePath(session, stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] + "/" + stringArray[Common.CheckIndex.INSTNAME_IDX.ordinal()])) {
                    throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.instHomeAlreadyExists"), stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] + "/" + stringArray[Common.CheckIndex.INSTNAME_IDX.ordinal()], string));
                }
            }
            if (blArray[Common.CheckIndex.TTINSTALL_IDX.ordinal()] && !SSHChannel.validTTInstallation(session, stringArray[Common.CheckIndex.TTINSTALL_IDX.ordinal()])) {
                throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.wrongSWLocation"), stringArray[Common.CheckIndex.TTINSTALL_IDX.ordinal()]));
            }
            if (blArray[Common.CheckIndex.TTSW_IDX.ordinal()] && !SSHChannel.existRemoteFile(session, stringArray[Common.CheckIndex.TTSW_IDX.ordinal()])) {
                throw new MySSHException(Messages.getString("TimesTenGrid.swLocationNE"));
            }
            if (blArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()]) {
                boolean bl = false;
                if (blArray[Common.CheckIndex.FIRSTINST_IDX.ordinal()]) {
                    if (!SSHChannel.existRemotePathWritePerm(session, stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()])) {
                        int n = Common.CheckIndex.INSTALLLOC_IDX.ordinal();
                        stringArray[n] = stringArray[n] + "$$CREATE_DIR$$";
                    } else {
                        bl = true;
                    }
                } else {
                    bl = SSHChannel.existRemotePathWritePerm(session, stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()]);
                }
                if (bl && blArray[Common.CheckIndex.INSTDIR_IDX.ordinal()] && SSHChannel.sameDirectories(session, stringArray[Common.CheckIndex.INSTDIR_IDX.ordinal()], stringArray[Common.CheckIndex.INSTALLLOC_IDX.ordinal()])) {
                    throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.sameInstDirInstallLocHost"), string));
                }
            }
            if (blArray[Common.CheckIndex.TTGROUP_IDX.ordinal()] && !stringArray[Common.CheckIndex.TTGROUP_IDX.ordinal()].isEmpty() && !SSHChannel.isUserInGroup(session, string2, stringArray[Common.CheckIndex.TTGROUP_IDX.ordinal()])) {
                throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.noUserInGroupError"), string2, stringArray[Common.CheckIndex.TTGROUP_IDX.ordinal()]));
            }
        }
        catch (JSchException jSchException) {
            throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHostExp"), string, jSchException.getMessage()));
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return string4;
    }

    private static boolean existRemoteFile(Session session, String string) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, FILE_EXISTS.replace("#FILE#", string));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying remote file existence " + string + ": " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    public static boolean existRemoteFile(String string, String string2, char[] cArray, String string3, String string4, boolean bl) throws MySSHException {
        Session session = null;
        try {
            session = SSHChannel.getSessionHelper(string2, string, cArray, string3);
        }
        catch (JSchException jSchException) {
            throw new MySSHException(jSchException.getMessage(), jSchException.getCause());
        }
        try {
            session.connect();
            boolean bl2 = bl ? SSHChannel.existRemotePathWritePerm(session, string4) : SSHChannel.existRemoteFile(session, string4);
            return bl2;
        }
        catch (JSchException jSchException) {
            throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHostExp"), string, jSchException.getMessage()));
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private static boolean isUserInGroup(Session session, String string, String string2) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, USER_IN_GROUP.replace("#USER#", string).replace("#GROUP#", string2));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying user " + string + " membership in group " + string2 + ": " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    private static boolean existRemotePath(Session session, String string) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, DIRECTORY_EXISTS.replace("#DIRECTORY#", string));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying remote path existence " + string + ": " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    private static boolean existRemotePathWritePerm(Session session, String string) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, DIRECTORY_EXISTS_WPERM.replace("#DIRECTORY#", string));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying remote path existence and write permission" + string + ": " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    private static boolean sameDirectories(Session session, String string, String string2) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, SAME_DIRECTORIES.replace("#PATH1#", string).replace("#PATH2#", string2));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying if two paths refer to same directory" + string + " " + string2 + " : " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    private static boolean validTTInstallation(Session session, String string) throws MySSHException {
        try {
            return SSHChannel.succesfulCommand(session, TTGRIDADMIN_HELP.replace("#LOCATION#", string));
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while verifying timesten installation " + string + ": " + jSchException.getMessage(), jSchException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean succesfulCommand(Session session, String string) throws JSchException {
        Channel channel = null;
        InputStream inputStream = null;
        try {
            boolean bl;
            channel = session.openChannel("exec");
            inputStream = channel.getInputStream();
            ((ChannelExec)channel).setCommand(string);
            StringBuilder stringBuilder = new StringBuilder();
            channel.connect();
            byte[] byArray = new byte[1024];
            while (true) {
                if (inputStream.available() > 0 && (bl = inputStream.read(byArray, 0, 1024)) >= false) {
                    stringBuilder.append(new String(byArray, 0, bl ? 1 : 0));
                    continue;
                }
                if (channel.isClosed() && inputStream.available() <= 0) break;
            }
            bl = channel.getExitStatus() == 0;
            return bl;
        }
        catch (IOException iOException) {
            logger.severe("Exception executing " + string + ", message is:" + iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    private static String getHostName(Session session) throws MySSHException {
        Channel channel = null;
        InputStream inputStream = null;
        try {
            channel = session.openChannel("exec");
            inputStream = channel.getInputStream();
            ((ChannelExec)channel).setCommand("hostname -s");
            StringBuilder stringBuilder = new StringBuilder();
            channel.connect();
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                    stringBuilder.append(new String(byArray, 0, n));
                    continue;
                }
                if (channel.isClosed() && inputStream.available() <= 0) break;
            }
            String string = stringBuilder.toString().trim();
            return string;
        }
        catch (JSchException | IOException throwable) {
            logger.severe("Exception executing hostname, message is:" + throwable.getMessage());
            throw new MySSHException(throwable.getMessage());
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public static String getHostName(String string, String string2, char[] cArray, String string3) throws MySSHException {
        Session session = null;
        String string4 = null;
        try {
            session = SSHChannel.getSessionHelper(string2, string, cArray, string3);
        }
        catch (JSchException jSchException) {
            throw new MySSHException(jSchException.getMessage(), jSchException.getCause());
        }
        try {
            session.connect();
            string4 = SSHChannel.getHostName(session);
        }
        catch (JSchException jSchException) {
            throw new MySSHException(MessageFormat.format(Messages.getString("TimesTenGrid.cantConnectToHostExp"), string, jSchException.getMessage()));
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return string4;
    }

    public void forceStop() {
        this.setCancelCommand(true);
    }

    public void forceClose() {
        this.forceStop();
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            this.session.setPassword(new String());
            this.session = null;
        }
    }

    private void prepareSCP(String string) throws MySSHException {
        try {
            this.closeChannel();
            this.SCPSession = SSHChannel.getSessionHelper(this.instanceAdmin, string, this.pwd, this.keyFile);
            this.SCPSession.connect();
            this.channel = this.SCPSession.openChannel("exec");
        }
        catch (JSchException jSchException) {
            throw new MySSHException("Failed while opening ssh session and channel:" + jSchException.getMessage(), jSchException.getCause());
        }
    }

    private void closeChannel() {
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
    }

    private void execute(String string, OutputStream outputStream, boolean bl) throws MySSHException {
        InputStream inputStream = null;
        try {
            this.commandOutput = new StringBuilder();
            ((ChannelExec)this.channel).setPty(true);
            ((ChannelExec)this.channel).setCommand(string);
            this.channel.setInputStream(null);
            OutputStream outputStream2 = new OutputStream(){
                private StringBuilder string = new StringBuilder();

                @Override
                public void write(int n) throws IOException {
                    this.string.append((char)n);
                }

                public String toString() {
                    return this.string.toString();
                }
            };
            ((ChannelExec)this.channel).setErrStream(outputStream2);
            inputStream = this.channel.getInputStream();
            this.channel.connect();
            byte[] byArray = new byte[1024];
            int n = 0;
            int n2 = Common.CMD_TIMEOUT * 1000;
            while (!this.getCancelCommand()) {
                int n3;
                while (inputStream.available() > 0 && (n3 = inputStream.read(byArray, 0, 1024)) >= 0) {
                    this.commandOutput.append(new String(byArray, 0, n3));
                    if (outputStream == null) continue;
                    outputStream.write(byArray, 0, n3);
                }
                if (this.channel.isClosed()) {
                    if (inputStream.available() <= 0) break;
                    continue;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(500L);
                    if ((n += 500) < n2 || inputStream.available() > 0) continue;
                    String string2 = Messages.getString("TimesTenGrid.stopCMDTimeout");
                    logger.severe(string2);
                    this.commandOutput.append("\n" + string2);
                    if (outputStream == null) break;
                    outputStream.write(string2.getBytes(), 0, string2.getBytes().length);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.getCancelCommand()) {
                logger.info("Command execution cancelled by user");
                this.channel.setInputStream(null);
                this.channel.getOutputStream().write(3);
                this.channel.getOutputStream().flush();
                this.commandExitStatus = 1;
                return;
            }
            this.commandExitStatus = this.channel.getExitStatus();
            if (this.channel.getExitStatus() != 0) {
                this.commandErrorOutput = "";
                if (!outputStream2.toString().isEmpty()) {
                    this.commandErrorOutput = outputStream2.toString() + "\n";
                }
                if (!this.getLastCommandOutput().isEmpty()) {
                    this.commandErrorOutput = this.commandErrorOutput + this.getLastCommandOutput();
                }
            }
            if (!(outputStream2.toString().isEmpty() || outputStream2.toString().contains("FIPS integrity verification test failed") || outputStream2.toString().contains("NOTE: unknown or unsupported java version, setting values for JDK"))) {
                throw new MySSHException(outputStream2.toString());
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException("Failed while executing " + string + ":" + throwable.getMessage(), throwable.getCause());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePerlCmd(String string, OutputStream outputStream, boolean bl) throws MySSHException {
        InputStream inputStream = null;
        OutputStream outputStream2 = null;
        FileInputStream fileInputStream = null;
        try {
            int n;
            this.commandOutput = new StringBuilder();
            ((ChannelExec)this.channel).setCommand(string);
            this.channel.setInputStream(null);
            OutputStream outputStream3 = new OutputStream(){
                private StringBuilder string = new StringBuilder();

                @Override
                public void write(int n) throws IOException {
                    this.string.append((char)n);
                }

                public String toString() {
                    return this.string.toString();
                }
            };
            ((ChannelExec)this.channel).setErrStream(outputStream3);
            inputStream = this.channel.getInputStream();
            this.channel.connect();
            outputStream2 = this.channel.getOutputStream();
            fileInputStream = new FileInputStream(PERL_SCRIPT);
            byte[] byArray = new byte[1024];
            while (!this.getCancelCommand() && (n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                outputStream2.write(byArray, 0, n);
            }
            if (this.getCancelCommand()) {
                logger.info("Command execution cancelled by user");
                this.commandExitStatus = 1;
                return;
            }
            byArray[0] = 0;
            outputStream2.write(byArray, 0, 1);
            outputStream2.flush();
            outputStream2.close();
            byte[] byArray2 = new byte[1024];
            int n2 = 0;
            int n3 = Common.CMD_TIMEOUT * 1000;
            while (!this.getCancelCommand()) {
                int n4;
                while (inputStream.available() > 0 && (n4 = inputStream.read(byArray2, 0, 1024)) >= 0) {
                    this.commandOutput.append(new String(byArray2, 0, n4));
                    if (outputStream == null) continue;
                    outputStream.write(byArray2, 0, n4);
                }
                if (this.channel.isClosed()) {
                    if (inputStream.available() <= 0) break;
                    continue;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(500L);
                    if ((n2 += 500) < n3 || inputStream.available() > 0) continue;
                    String string2 = Messages.getString("TimesTenGrid.stopCMDTimeout");
                    logger.severe(string2);
                    this.commandOutput.append("\n" + string2);
                    if (outputStream == null) break;
                    outputStream.write(string2.getBytes(), 0, string2.getBytes().length);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.getCancelCommand()) {
                logger.info("Command execution cancelled by user");
                this.commandExitStatus = 1;
                return;
            }
            this.commandExitStatus = this.channel.getExitStatus();
            if (this.channel.getExitStatus() != 0) {
                this.commandErrorOutput = "";
                if (!outputStream3.toString().isEmpty()) {
                    this.commandErrorOutput = outputStream3.toString() + "\n";
                }
                if (!this.getLastCommandOutput().isEmpty()) {
                    this.commandErrorOutput = this.commandErrorOutput + this.getLastCommandOutput();
                }
            }
            if (outputStream3.toString().isEmpty()) return;
            if (outputStream3.toString().contains("FIPS integrity verification test failed")) return;
            if (outputStream3.toString().contains("NOTE: unknown or unsupported java version, setting values for JDK")) return;
            throw new MySSHException(outputStream3.toString());
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException("Failed while executing " + string + ":" + throwable.getMessage(), throwable.getCause());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream2 != null) {
                    outputStream2.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String executeCommand(GridCommand gridCommand, OutputStream outputStream) throws MySSHException {
        return this.executeCommand(gridCommand, outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommand(GridCommand gridCommand, OutputStream outputStream, boolean bl) throws MySSHException {
        try {
            this.prepareChannel();
            if (bl) {
                this.executePerlCmd(COMMAND.replace("#LOCATION#", this.instanceHome).replace("#COMMAND#", gridCommand.getCommand()), outputStream, gridCommand.enableTimeout());
            } else {
                this.execute(COMMAND.replace("#LOCATION#", this.instanceHome).replace("#COMMAND#", gridCommand.getCommand()), outputStream, gridCommand.enableTimeout());
            }
            String string = this.getLastCommandOutput();
            return string;
        }
        finally {
            this.closeChannel();
        }
    }

    public String executeCommand(GridCommand gridCommand) throws MySSHException {
        try {
            this.prepareChannel();
            logger.info("Executing in management instance:" + gridCommand.getCommand());
            this.execute(COMMAND.replace("#LOCATION#", this.instanceHome).replace("#COMMAND#", gridCommand.getCommand()).replace("#PERL_LOCATION#", Common.getWorkingInstanceObject() != null ? Common.getWorkingInstanceObject().getInstallation().getLocation() + "/PERL/bin/perl" : ""), null, gridCommand.enableTimeout());
            String string = this.getLastCommandOutput();
            return string;
        }
        finally {
            this.closeChannel();
        }
    }

    public String executeSimpleCommand(GridCommand gridCommand) throws MySSHException {
        try {
            this.prepareChannel();
            this.execute(gridCommand.getCommand(), null, gridCommand.enableTimeout());
            String string = this.commandOutput.toString();
            return string;
        }
        finally {
            this.closeChannel();
        }
    }

    public void executeSCPCommand(File file, String string, String string2) throws MySSHException {
        this.prepareSCP(string2);
        try {
            String string3 = "scp  -p -t " + string;
            ((ChannelExec)this.channel).setCommand(string3);
            try (OutputStream outputStream = this.channel.getOutputStream();
                 InputStream inputStream = this.channel.getInputStream();){
                byte[] byArray;
                this.channel.connect();
                this.checkAck(inputStream);
                long l = file.length();
                string3 = "C0644 " + l + " " + file.getName();
                string3 = string3 + "\n";
                outputStream.write(string3.getBytes());
                outputStream.flush();
                this.checkAck(inputStream);
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    int n;
                    byArray = new byte[1024];
                    while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                this.checkAck(inputStream);
                this.commandExitStatus = this.channel.getExitStatus();
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException("Failed while executing SCP:" + throwable.getMessage(), throwable.getCause());
        }
        finally {
            this.closeChannel();
            if (this.SCPSession != null && this.SCPSession.isConnected()) {
                this.SCPSession.disconnect();
            }
        }
    }

    public void executeSCPCommand(File file, String string, String string2, String string3) throws MySSHException {
        this.prepareSCP(string3);
        try {
            String string4 = "scp  -p -t " + string2 + "/" + string;
            ((ChannelExec)this.channel).setCommand(string4);
            try (OutputStream outputStream = this.channel.getOutputStream();
                 InputStream inputStream = this.channel.getInputStream();){
                byte[] byArray;
                this.channel.connect();
                this.checkAck(inputStream);
                long l = file.length();
                string4 = "C0644 " + l + " " + string;
                string4 = string4 + "\n";
                outputStream.write(string4.getBytes());
                outputStream.flush();
                this.checkAck(inputStream);
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    int n;
                    byArray = new byte[1024];
                    while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                this.checkAck(inputStream);
                this.commandExitStatus = this.channel.getExitStatus();
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException("Failed while executing SCP:" + throwable.getMessage(), throwable.getCause());
        }
        finally {
            this.closeChannel();
            if (this.SCPSession != null && this.SCPSession.isConnected()) {
                this.SCPSession.disconnect();
            }
        }
    }

    public void executeSCPFromRemote2LocalCommand(String string, String string2) throws MySSHException {
        this.prepareSCP(this.ipAddress);
        try {
            int n;
            String string3 = "scp -f " + string;
            ((ChannelExec)this.channel).setCommand(string3);
            OutputStream outputStream = this.channel.getOutputStream();
            InputStream inputStream = this.channel.getInputStream();
            FileOutputStream fileOutputStream = null;
            this.channel.connect();
            byte[] byArray = new byte[1024];
            String string4 = null;
            if (new File(string2).isDirectory()) {
                string4 = string2 + File.separator;
            }
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            while ((n = this.checkAck(inputStream)) == 67) {
                inputStream.read(byArray, 0, 5);
                long l = 0L;
                while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                    l = l * 10L + (long)(byArray[0] - 48);
                }
                String string5 = null;
                int n2 = 0;
                while (true) {
                    inputStream.read(byArray, n2, 1);
                    if (byArray[n2] == 10) break;
                    ++n2;
                }
                string5 = new String(byArray, 0, n2);
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                fileOutputStream = new FileOutputStream(string4 == null ? string2 : string4 + string5);
                do {
                    n2 = (long)byArray.length < l ? byArray.length : (int)l;
                    if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                    fileOutputStream.write(byArray, 0, n2);
                } while ((l -= (long)n2) != 0L);
                fileOutputStream.close();
                fileOutputStream = null;
                if (this.checkAck(inputStream) != 0) {
                    System.exit(0);
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException(throwable);
        }
    }

    public void executeSCPFromRemote2LocalCommand(String string, String string2, String string3) throws MySSHException {
        this.prepareSCP(string);
        try {
            int n;
            String string4 = "scp -f " + string2;
            ((ChannelExec)this.channel).setCommand(string4);
            OutputStream outputStream = this.channel.getOutputStream();
            InputStream inputStream = this.channel.getInputStream();
            FileOutputStream fileOutputStream = null;
            this.channel.connect();
            byte[] byArray = new byte[1024];
            String string5 = null;
            if (new File(string3).isDirectory()) {
                string5 = string3 + File.separator;
            }
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            while ((n = this.checkAck(inputStream)) == 67) {
                inputStream.read(byArray, 0, 5);
                long l = 0L;
                while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                    l = l * 10L + (long)(byArray[0] - 48);
                }
                String string6 = null;
                int n2 = 0;
                while (true) {
                    inputStream.read(byArray, n2, 1);
                    if (byArray[n2] == 10) break;
                    ++n2;
                }
                string6 = new String(byArray, 0, n2);
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                fileOutputStream = new FileOutputStream(string5 == null ? string3 : string5 + string6);
                do {
                    n2 = (long)byArray.length < l ? byArray.length : (int)l;
                    if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                    fileOutputStream.write(byArray, 0, n2);
                } while ((l -= (long)n2) != 0L);
                fileOutputStream.close();
                fileOutputStream = null;
                if (this.checkAck(inputStream) != 0) {
                    System.exit(0);
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException(throwable);
        }
    }

    public void executeSCPCommand(String string, String string2, String string3, String string4) throws MySSHException {
        this.prepareSCP(string4);
        try {
            String string5 = "scp  -p -t " + string2 + string3;
            ((ChannelExec)this.channel).setCommand(string5);
            try (OutputStream outputStream = this.channel.getOutputStream();
                 InputStream inputStream = this.channel.getInputStream();){
                this.channel.connect();
                this.checkAck(inputStream);
                long l = string.length();
                string5 = "C0644 " + l + " " + string3;
                string5 = string5 + "\n";
                outputStream.write(string5.getBytes());
                outputStream.flush();
                this.checkAck(inputStream);
                try (Object object = new ByteArrayInputStream(string.getBytes());){
                    int n;
                    byte[] byArray = new byte[1024];
                    while ((n = ((ByteArrayInputStream)object).read(byArray, 0, byArray.length)) > 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                object = new byte[]{0};
                outputStream.write((byte[])object, 0, 1);
                outputStream.flush();
                this.checkAck(inputStream);
                this.commandExitStatus = this.channel.getExitStatus();
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException("Failed while executing SCP: " + throwable.getMessage(), throwable.getCause());
        }
        finally {
            this.closeChannel();
            if (this.SCPSession != null && this.SCPSession.isConnected()) {
                this.SCPSession.disconnect();
            }
        }
    }

    private int checkAck(InputStream inputStream) throws IOException, MySSHException {
        int n = inputStream.read();
        if (n == 0 || n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            logger.log(Level.SEVERE, "Failed while reading ack in scp:" + stringBuffer.toString());
            throw new MySSHException(stringBuffer.toString());
        }
        return n;
    }

    public String getLastCommandOutput() {
        if (this.commandOutput != null) {
            return this.commandOutput.toString();
        }
        return null;
    }

    public int getLastCommandExitStatus() {
        return this.commandExitStatus;
    }

    public String getLastErrorMessage() {
        return this.commandErrorOutput;
    }

    public static void testPasswordless(String string, String string2, char[] cArray, String string3, String string4) throws MySSHException {
        String string5 = "ssh -o StrictHostKeyChecking=yes -o PasswordAuthentication=no " + string4 + " echo 0";
        SSHChannel.testPasswordlessSSHConn(string, string2, cArray, string3, string5);
    }

    public static void testPasswordless(String string, String string2, char[] cArray, String string3, String string4, String string5) throws MySSHException {
        String string6 = "ssh " + string4 + " ssh -o StrictHostKeyChecking=yes -o PasswordAuthentication=no " + string5 + " echo 0";
        SSHChannel.testPasswordlessSSHConn(string, string2, cArray, string3, string6);
    }

    private static void testPasswordlessSSHConn(String string, String string2, char[] cArray, String string3, String string4) throws MySSHException {
        Session session = null;
        Channel channel = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            session = SSHChannel.getSessionHelper(string2, string, cArray, string3);
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(string4);
            channel.setInputStream(null);
            OutputStream outputStream = new OutputStream(){
                private StringBuilder string = new StringBuilder();

                @Override
                public void write(int n) throws IOException {
                    this.string.append((char)n);
                }

                public String toString() {
                    return this.string.toString();
                }
            };
            ((ChannelExec)channel).setErrStream(outputStream);
            InputStream inputStream = channel.getInputStream();
            channel.connect();
            byte[] byArray = new byte[1024];
            while (true) {
                int n;
                if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                    stringBuilder.append(new String(byArray, 0, n));
                    continue;
                }
                if (channel.isClosed() && inputStream.available() <= 0) break;
            }
            if (channel.getExitStatus() != 0) {
                throw new MySSHException(outputStream.toString());
            }
            if (!outputStream.toString().isEmpty() && !outputStream.toString().contains("NOTE: unknown or unsupported java version, setting values for JDK")) {
                throw new MySSHException(outputStream.toString() + stringBuilder.toString());
            }
        }
        catch (JSchException | IOException throwable) {
            throw new MySSHException(throwable);
        }
        finally {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
            channel = null;
            session = null;
        }
    }
}

