/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TTGUIBasePanel
extends JPanel
implements ActionListener {
    protected static final long serialVersionUID = 1L;
    protected JEWTDialog _dialog;
    protected JButton _okButton;
    protected GridObject grid;
    protected TTGridRootNode root;
    protected CustomProgressMonitor _progressMonitor;
    protected boolean oked;
    protected boolean disposeDialog;

    public TTGUIBasePanel() {
        this(true);
    }

    public TTGUIBasePanel(boolean bl) {
        this.setLayout(new GridBagLayout());
        if (bl) {
            this.oked = false;
            this.disposeDialog = true;
            this._okButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
            this._okButton.setName(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
            this._okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
            this._okButton.addActionListener(this);
        }
        this.root = TTGridRootNode.getInstance();
        this.grid = this.root.getGrid(this.root.getCurrentGrid());
    }

    public JButton getOkButton() {
        return this._okButton;
    }

    public boolean isOkd() {
        return this.oked;
    }

    public void setDisposeDialog(boolean bl) {
        this.disposeDialog = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.disposeDialog) {
            this._dialog.dispose();
        }
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    public static boolean showLocationMissingWarning(String string, String string2) {
        if (MessageDialog.getPersistence().getConfirmed("CreatePathID") == null) {
            return MessageDialog.optionalConfirm((String)"CreatePathID", (Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("TimesTenGrid.pathDoesNotExist"), string, string2), (String)Messages.getString("TimesTenGrid.pathDoesNotExistTitle"), null);
        }
        return MessageDialog.getPersistence().getConfirmed("CreatePathID");
    }

    protected void showModelNeedsApplyWarning() {
        DifferenceObject differenceObject = this.grid.getGridCurrentModel().diff(this.grid);
        if (differenceObject.areDifferences()) {
            this.grid.getGridNode().updateIcon(false);
            if (MessageDialog.getPersistence().getConfirmed("ModelChangesID") == null) {
                MessageDialog.optionalInformation((String)"ModelChangesID", (Component)this, (Object)Messages.getString("TimesTenGrid.applyChangesWarn"), (String)Messages.getString("TimesTenGrid.applyChanges"), null);
            }
        }
    }
}

