/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DirectoryAttribute;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.ide.Ide;
import oracle.ide.nulls.NullPrintStream;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class NewDBDefinitionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DBDefObject newDBDef;
    private ArrayList<AttributesDefinitionPanel> typePanels;
    private JButton _importButton;
    private JLabel _dbNameLabel;
    private JLabel _dbDefLabel;
    private JTextField _dbNameTxtField;
    private AttributesDefinitionPanel _attrPanel;
    private static final String TTCSERVERSTR = "ttc_server";
    private static final List<String> EXCLUDED_GENERAL_CONNECTION_ATTRIBUTE = Arrays.asList("UID");
    private JTabbedPane tabs;
    private static Logger logger = Logger.getLogger(NewDBDefinitionPanel.class.getName());
    private GridObject currentGrid;
    private static final String TT_HOME = "!!TIMESTEN_HOME!!";
    private static final String INST_NAME = "!!INSTANCE_NAME!!";
    private static final String HOST_NAME = "!!HOST_NAME!!";
    private JEWTDialog dialog;
    private JButton okButton;
    private boolean isEditMode;
    private boolean dbExists;

    public NewDBDefinitionPanel(GridObject gridObject) {
        this(gridObject, null);
    }

    public NewDBDefinitionPanel(GridObject gridObject, DBDefObject dBDefObject) {
        this.currentGrid = gridObject;
        this.dbExists = false;
        this.newDBDef = dBDefObject != null ? dBDefObject : new DBDefObject(this.currentGrid, null);
        this.isEditMode = dBDefObject != null;
        this.initGUI();
        if (this.isEditMode) {
            this.populateTabsWithDBDef(dBDefObject);
            this.checkDBExists(dBDefObject.getName());
        }
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.okButton = new JButton(Messages.getString("TimesTenGrid.okButtonWizard"));
        this.okButton.addActionListener(actionEvent -> this.createDBDef());
        this._importButton = new JButton(Messages.getString("TimesTenGrid.importDbdef"));
        this._importButton.addActionListener(this);
        this._dbNameTxtField = new JTextField(15);
        this._dbNameTxtField.setText(this.getNextDBName());
        this._dbNameTxtField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ((AttributesDefinitionPanel)NewDBDefinitionPanel.this.typePanels.get(0)).setDBNameAsSuffix(NewDBDefinitionPanel.this._dbNameTxtField.getText());
                super.keyTyped(keyEvent);
            }
        });
        this._dbNameLabel = new JLabel(Messages.getString("TimesTenGrid.dbNameLabel"));
        this._dbDefLabel = new JLabel(Messages.getString("TimesTenGrid.dbDef"));
        this._dbDefLabel.setForeground(new Color(0, 0, 185));
        this.tabs = new JTabbedPane();
        this.typePanels = new ArrayList();
        for (DBDefAttribute.DBDefAttributeType dBDefAttributeType : DBDefAttribute.DBDefAttributeType.values()) {
            if (dBDefAttributeType == DBDefAttribute.DBDefAttributeType.CUSTOM || this.isEditMode && dBDefAttributeType == DBDefAttribute.DBDefAttributeType.GENERAL_CONNECTION) continue;
            this._attrPanel = new AttributesDefinitionPanel(false, true, dBDefAttributeType, this.currentGrid, dBDefAttributeType == DBDefAttribute.DBDefAttributeType.GENERAL_CONNECTION ? EXCLUDED_GENERAL_CONNECTION_ATTRIBUTE : Collections.emptyList());
            this.typePanels.add(this._attrPanel);
            this.tabs.addTab(dBDefAttributeType.getShowName(), this._attrPanel);
            this._attrPanel = null;
        }
        this.typePanels.get(0).setDBNameAsSuffix(this._dbNameTxtField.getText());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._dbDefLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 1, new Insets(10, 10, 10, 0), 0, 0));
        jPanel.add((Component)new JSeparator(0), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 10, 0), 0, 0));
        jPanel.add((Component)this._dbNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 10, 10), 0, 0));
        jPanel.add((Component)this._dbNameTxtField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 30, 10, 10), 0, 0));
        jPanel.add((Component)this._importButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.tabs, "Center");
        this.add((Component)jPanel, "First");
        this.setNames();
    }

    private void populateTabsWithDBDef(DBDefObject dBDefObject) {
        if (dBDefObject == null) {
            return;
        }
        this._dbNameTxtField.setText(dBDefObject.getName());
        this._dbNameTxtField.setEnabled(false);
        for (DBDefAttribute dBDefAttribute : dBDefObject.getAttributes()) {
            boolean bl = false;
            for (AttributesDefinitionPanel attributesDefinitionPanel : this.typePanels) {
                if (!attributesDefinitionPanel.setAttributeValue(dBDefAttribute.getAttribute(), dBDefAttribute.getValueAsString())) continue;
                if (dBDefAttribute.getAttribute().equalsIgnoreCase("DataStore")) {
                    this.typePanels.get(0).setDBNameAsSuffix(dBDefAttribute.getValueAsString());
                }
                if (dBDefAttribute.getAttribute().equalsIgnoreCase("LogDir")) {
                    this.typePanels.get(0).setLogDir(dBDefAttribute.getValueAsString());
                }
                bl = true;
                break;
            }
            if (bl) continue;
            this.typePanels.get(0).addCustomAttribute(dBDefAttribute.getAttribute(), dBDefAttribute.getValueAsString());
        }
    }

    private void checkDBExists(final String string) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor(this, Messages.getString("TimesTenGrid.checkingDBExists"), Messages.getString("TimesTen.common.pleaseWait"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws GridCommandException {
                customProgressMonitor.start();
                GridCommand gridCommand = GridCommand.DB_STATUS;
                gridCommand.prepareCommand(string);
                NewDBDefinitionPanel.this.dbExists = true;
                try {
                    JsonObject jsonObject = NewDBDefinitionPanel.this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, false);
                    NewDBDefinitionPanel.this.currentGrid.getDatabase(string).updateDBStatus(jsonObject);
                }
                catch (Exception exception) {
                    NewDBDefinitionPanel.this.dbExists = false;
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                customProgressMonitor.close();
                if (NewDBDefinitionPanel.this.dbExists) {
                    for (AttributesDefinitionPanel attributesDefinitionPanel : NewDBDefinitionPanel.this.typePanels) {
                        if (attributesDefinitionPanel.getType() != DBDefAttribute.DBDefAttributeType.DATASTORE) continue;
                        attributesDefinitionPanel.enableAllComponents(false);
                    }
                    NewDBDefinitionPanel.this.tabs.setSelectedIndex(1);
                    if ((NewDBDefinitionPanel.this.currentGrid.getDatabase(string).getDBStatus().isOpen() || NewDBDefinitionPanel.this.currentGrid.getDatabase(string).getDBStatus().isPartiallyOpen()) && MessageDialog.getPersistence().getConfirmed("FirstConnectID") == null) {
                        MessageDialog.optionalInformation((String)"FirstConnectID", (Component)Ide.getMainWindow(), (Object)Messages.getString("TimesTenGrid.firstConnAttrEdited"), (String)Messages.getString("TimesTenGrid.editingOpenDB"), null);
                    }
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public void areValuesValid(Runnable runnable) throws TraversalException {
        for (AttributesDefinitionPanel attributesDefinitionPanel : this.typePanels) {
            if (attributesDefinitionPanel.areAttributesValid()) continue;
            this.tabs.setSelectedComponent(attributesDefinitionPanel);
            throw new TraversalException(Messages.getString("TimesTenGrid.invalidAttributes"));
        }
        if (!this.isEditMode && this.currentGrid.getDatabase(this._dbNameTxtField.getText()) != null) {
            throw new TraversalException(Messages.getString("TimesTenGrid.DBNameTaken"));
        }
        if (this._dbNameTxtField.getText().isEmpty()) {
            throw new TraversalException(Messages.getString("TimesTenGrid.nameEmpty"));
        }
        if (this.isEditMode) {
            runnable.run();
        } else {
            this.checkDataStoreLocation(runnable);
        }
    }

    private void checkDataStoreLocation(final Runnable runnable) {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), "Checking Directory Attributes", Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            boolean checkOk;

            @Override
            protected Void doInBackground() throws GridCommandException {
                customProgressMonitor.start();
                this.checkOk = false;
                this.checkOk = this.DirsExistsInHosts();
                this.firePropertyChange("progress", null, 100);
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    return;
                }
                if (this.checkOk) {
                    customProgressMonitor.close();
                    NewDBDefinitionPanel.this.newDBDef.setName(NewDBDefinitionPanel.this._dbNameTxtField.getText());
                    NewDBDefinitionPanel.this.newDBDef.getAttributes().clear();
                    for (int i = 0; i < NewDBDefinitionPanel.this.typePanels.size(); ++i) {
                        NewDBDefinitionPanel.this.newDBDef.getAttributes().addAll(((AttributesDefinitionPanel)NewDBDefinitionPanel.this.typePanels.get(i)).getSelectedAttributes());
                    }
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private boolean DirsExistsInHosts() throws GridCommandException {
                boolean bl = true;
                ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
                for (HostObject object : NewDBDefinitionPanel.this.currentGrid.getHosts()) {
                    for (InstanceObject instanceObject : object.getInstances()) {
                        arrayList.add(instanceObject);
                    }
                }
                for (AttributesDefinitionPanel attributesDefinitionPanel : NewDBDefinitionPanel.this.typePanels) {
                    for (DBDefAttribute dBDefAttribute : attributesDefinitionPanel.getSelectedAttributes()) {
                        void var4_9;
                        if (!(dBDefAttribute instanceof DirectoryAttribute)) continue;
                        if (dBDefAttribute.getAttribute().equalsIgnoreCase("datastore")) {
                            String string = dBDefAttribute.getValueAsString().substring(0, dBDefAttribute.getValueAsString().lastIndexOf("/"));
                        } else {
                            String string = dBDefAttribute.getValueAsString();
                        }
                        String string = MessageFormat.format(Messages.getString("TimesTenGrid.verifyPath"), var4_9);
                        this.firePropertyChange("message", null, string);
                        logger.log(Level.INFO, string);
                        for (InstanceObject instanceObject : arrayList) {
                            if (instanceObject.isMgmtInstance()) continue;
                            if (!instanceObject.isAppliedToCurrent() && var4_9.contains(NewDBDefinitionPanel.TT_HOME)) {
                                logger.log(Level.INFO, "Cannot verify !!TIMESTEN_HOME!! in " + instanceObject.getFullName() + ". This instance is not applied.");
                                continue;
                            }
                            String string2 = var4_9.replaceAll(NewDBDefinitionPanel.TT_HOME, instanceObject.getHome()).replaceAll(NewDBDefinitionPanel.INST_NAME, instanceObject.getName()).replaceAll(NewDBDefinitionPanel.HOST_NAME, instanceObject.getHost().getName());
                            logger.log(Level.INFO, "The actual path we will check is:" + string2);
                            GridCommand gridCommand = GridCommand.CHECK_REMOTE_DIR_IS_W;
                            gridCommand.prepareCommand(instanceObject.getHost().getInternalAddress(), string2);
                            try {
                                NewDBDefinitionPanel.this.currentGrid.getExecutor().executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                            }
                            catch (GridCommandException gridCommandException) {
                                logger.warning(gridCommandException.getMessage());
                                this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.dirNotOkInHost"), string2, instanceObject.getFullName()));
                                boolean bl2 = TTGUIBasePanel.showLocationMissingWarning(string2, instanceObject.getFullName());
                                if (!bl2) {
                                    bl = false;
                                    continue;
                                }
                                this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.creatingPath"), string2, instanceObject.getHost().getInternalAddress()));
                                gridCommand = GridCommand.CREATE_REMOTE_DIR;
                                gridCommand.prepareCommand(instanceObject.getHost().getInternalAddress(), string2);
                                NewDBDefinitionPanel.this.currentGrid.getExecutor().executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                            }
                        }
                    }
                }
                return bl;
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._importButton) {
            this.importButtonActionPerformed();
        }
    }

    private void importButtonActionPerformed() {
        JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
        jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.importDbdef"));
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("DBDef File (.dbdef)", "dbdef"));
        jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
        int n = 0;
        n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
        String[] stringArray = new String[2];
        if (n == 0) {
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            try {
                String string;
                if (!file.getAbsolutePath().toLowerCase().endsWith(".dbdef")) {
                    file = new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
                }
                String string2 = file.getName().substring(0, file.getName().indexOf(46));
                if (!this.isEditMode) {
                    this._dbNameTxtField.setText(string2);
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = "(\\w+)=(.*)";
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.trim().matches(string3)) continue;
                    Object object = string.trim().split("=");
                    if (((String[])object).length == 1) {
                        stringArray[0] = object[0];
                        stringArray[1] = "";
                        object = stringArray;
                    }
                    boolean bl = true;
                    for (AttributesDefinitionPanel attributesDefinitionPanel : this.typePanels) {
                        if (this.dbExists && this.isEditMode && attributesDefinitionPanel.getType() != DBDefAttribute.DBDefAttributeType.FIRST_CONNECTION || !attributesDefinitionPanel.setAttributeValue((String)object[0], (String)object[1])) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || this.dbExists || this.isEditMode) continue;
                    if (((String)object[0]).toLowerCase().contains(TTCSERVERSTR)) {
                        this.typePanels.get(2).addCustomAttribute((String)object[0], (String)object[1]);
                        continue;
                    }
                    this.typePanels.get(0).addCustomAttribute((String)object[0], (String)object[1]);
                }
                bufferedReader.close();
                for (DBDefAttribute dBDefAttribute : this.typePanels.get(0).getSelectedAttributes()) {
                    if (!dBDefAttribute.getAttribute().equalsIgnoreCase("datastore")) continue;
                    this.typePanels.get(0).setDBNameAsSuffix(this._dbNameTxtField.getText().trim(), true);
                    break;
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage());
            }
        }
    }

    public void createDBDef() {
        for (AttributesDefinitionPanel attributesDefinitionPanel : this.typePanels) {
            if (attributesDefinitionPanel.areAttributesValid()) continue;
            this.tabs.setSelectedComponent(attributesDefinitionPanel);
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.invalidAttributes"));
            return;
        }
        if (!this.isEditMode && this.currentGrid.getDatabase(this._dbNameTxtField.getText()) != null) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.DBNameTaken"));
            return;
        }
        if (this._dbNameTxtField.getText().isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.nameEmpty"));
            return;
        }
        this.checkDataStoreLocation(new Runnable(){

            @Override
            public void run() {
                final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.creatingDbDef"), Messages.getString("TimesTen.common.pleaseWait"), null);
                SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
                    String dbName;
                    GridCommandExecutor gridCmdExec;

                    @Override
                    protected Void doInBackground() throws Exception {
                        SwingUtilities.invokeLater(() -> NewDBDefinitionPanel.this.dialog.dispose());
                        customProgressMonitor.start();
                        this.gridCmdExec = NewDBDefinitionPanel.this.currentGrid.getExecutor();
                        this.dbName = NewDBDefinitionPanel.this.newDBDef.getName();
                        try {
                            File file = this.appendAttributesTempFile();
                            this.createDatabase(file, this.dbName);
                            this.firePropertyChange("progress", null, 100);
                        }
                        catch (IOException | GridCommandException exception) {
                            logger.log(Level.SEVERE, exception.getMessage());
                            this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.invalidAttribute"), exception.getMessage()));
                            this.cancel(true);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        customProgressMonitor.finish();
                        if (this.isCancelled()) {
                            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                            customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskCancelled"));
                        } else {
                            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                            customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                        }
                    }

                    private File appendAttributesTempFile() throws FileNotFoundException, GridCommandException {
                        File file = TimesTenUtil.getTemporaryFile(this.dbName, "dbdef");
                        try (PrintWriter printWriter = new PrintWriter(file);){
                            printWriter.println(NewDBDefinitionPanel.this.getDBDefinition());
                        }
                        catch (IOException iOException) {
                            logger.log(Level.SEVERE, "While writing in the temporary file:" + iOException.getMessage());
                            throw new GridCommandException("While writing in the temporary file:" + iOException.getMessage());
                        }
                        return file;
                    }

                    public void createDatabase(File file, String string) throws GridCommandException, IOException {
                        String string2 = MessageFormat.format(Messages.getString("TimesTenGrid.copyDBDef"), this.gridCmdExec.getHostIP());
                        this.firePropertyChange("message", null, string2);
                        logger.log(Level.INFO, string2);
                        String string3 = this.gridCmdExec.getWorkingHost().getInstanceHome() + "/" + string + ".dbdef";
                        this.gridCmdExec.executeSCP(file, string + ".dbdef", NewDBDefinitionPanel.this.currentGrid.getExecutor().getWorkingHost().getInstanceHome());
                        GridCommand gridCommand = NewDBDefinitionPanel.this.isEditMode ? GridCommand.MODIFY_DBDEF : GridCommand.CREATE_DBDEF;
                        gridCommand.prepareCommand(string3);
                        try {
                            if (NewDBDefinitionPanel.this.isEditMode) {
                                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updatingDbDef"));
                            } else {
                                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.creatingDbDef"));
                            }
                            this.gridCmdExec.executeCommandGetString(gridCommand, true);
                            gridCommand = GridCommand.REMOVE_FILE;
                            gridCommand.prepareCommand(string3);
                            this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.deletingTmpFiles"));
                            this.gridCmdExec.executeCommandGetString(gridCommand, false);
                        }
                        catch (GridCommandException gridCommandException) {
                            throw gridCommandException;
                        }
                        finally {
                            try {
                                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                                NewDBDefinitionPanel.this.currentGrid.refreshGridModels();
                                NewDBDefinitionPanel.this.currentGrid.getGridCurrentModel().diff(NewDBDefinitionPanel.this.currentGrid);
                            }
                            catch (GridCommandException gridCommandException) {
                                logger.log(Level.SEVERE, gridCommandException.getMessage());
                            }
                        }
                    }
                };
                swingWorker.addPropertyChangeListener(customProgressMonitor);
                customProgressMonitor.setSwingWorker(swingWorker);
                swingWorker.execute();
            }
        });
    }

    private String getNextDBName() {
        String string;
        int n = 1;
        boolean bl = true;
        do {
            string = "database" + String.valueOf(n);
            for (DatabaseObject databaseObject : this.currentGrid.getDatabases()) {
                if (databaseObject.getName().equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                bl = false;
            }
            ++n;
        } while (bl && this.currentGrid.getDatabases().size() > 0);
        return string;
    }

    public DBDefObject getNewDBDef() {
        return this.newDBDef;
    }

    private String getDBDefinition() {
        ConnectableObject connectableObject;
        if (this.newDBDef.getAttributes().isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendAttributes(stringBuilder, this.newDBDef.getAttributes());
        if (this.isEditMode && (connectableObject = this.newDBDef.getConnectable(this.newDBDef.getName())) != null) {
            this.appendAttributes(stringBuilder, connectableObject.getAttributes());
        }
        return stringBuilder.toString();
    }

    private void appendAttributes(StringBuilder stringBuilder, List<DBDefAttribute> list) {
        for (DBDefAttribute dBDefAttribute : list) {
            stringBuilder.append(dBDefAttribute.getAttribute().toLowerCase());
            stringBuilder.append("=");
            if (!dBDefAttribute.getAttribute().toLowerCase().equalsIgnoreCase("PWDCrypt")) {
                stringBuilder.append(dBDefAttribute.getDBDefValue());
            }
            stringBuilder.append("\n");
        }
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this.dialog = jEWTDialog;
    }

    private void setNames() {
        this._importButton.setName(Messages.getString("TimesTenGrid.importDbdef"));
        this._dbNameLabel.setName(Messages.getString("TimesTenGrid.dbNameLabel"));
        this._dbDefLabel.setName(Messages.getString("TimesTenGrid.dbDef"));
        this._dbNameTxtField.setName("_dbNameTxtField");
        this.okButton.setName(Messages.getString("TimesTenGrid.okButtonWizard"));
    }
}

