/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.CustomAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class WizardSummary
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel _dbSummaryLabel;
    private ArrayList<DBDefAttribute> selectedAttributes = new ArrayList();
    private CustomProgressMonitor _progressMonitor;
    private JButton _exportButton;
    private AttributesDefinitionPanel allAttributesSummary;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private GridObject thisGrid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
    private DatabaseObject db;
    private boolean skipDist;

    public WizardSummary() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this._dbSummaryLabel = new JLabel(Messages.getString("TimesTenGrid.summary"));
        this._dbSummaryLabel.setForeground(new Color(0, 0, 185));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._exportButton = new JButton(Messages.getString("TimesTenGrid.exportDbdef"));
        this._exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = WizardSummary.this.db.getDBDef().getName();
                JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
                jFileChooser.setSelectedFile(new File(string));
                jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.exportDbdef"));
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("DBDef File (.dbdef)", "dbdef"));
                jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
                int n = 0;
                n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                    File file = jFileChooser.getSelectedFile();
                    try {
                        if (!file.getAbsolutePath().toLowerCase().endsWith(".dbdef")) {
                            file = new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
                        }
                        PrintWriter printWriter = new PrintWriter(file);
                        printWriter.println(WizardSummary.this.getDBDefinition());
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        WizardSummary.this.logger.log(Level.SEVERE, exception.getMessage());
                    }
                }
            }
        });
        this.allAttributesSummary = new AttributesDefinitionPanel(true, false, null, this.thisGrid);
        jPanel.add((Component)this._exportButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(10, 10, 10, 10), 0, 0));
        jPanel.add((Component)this.allAttributesSummary, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        jTabbedPane.addTab(Messages.getString("TimesTenGrid.attributes"), jPanel);
        this.add(this._dbSummaryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add(new JSeparator(0), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add(jTabbedPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    private String getDBDefinition() {
        if (this.selectedAttributes.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.skipDist) {
            stringBuilder.append("#!!!!!SQLDeveloper:DBDistribution!!!!!\n");
            stringBuilder.append("#");
            for (TopologyElement topologyElement : this.db.getDistributionMap().getToAdd()) {
                stringBuilder.append(((Element)topologyElement).toString() + " ");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("\n");
        }
        for (int i = 2; i < this.selectedAttributes.size(); ++i) {
            DBDefAttribute dBDefAttribute = this.selectedAttributes.get(i);
            stringBuilder.append(dBDefAttribute.getAttribute().toLowerCase());
            stringBuilder.append("=");
            if (!dBDefAttribute.getAttribute().toLowerCase().equalsIgnoreCase("PWDCrypt")) {
                stringBuilder.append(dBDefAttribute.getDBDefValue());
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        this.db = (DatabaseObject)traversableContext.get("DF_DEF_ATTRIBUTES");
        this.skipDist = (Boolean)traversableContext.get("addInNextDistMap");
        this.selectedAttributes.clear();
        CustomAttribute customAttribute = new CustomAttribute(Messages.getString("TimesTenGrid.dbNameLabel"), null);
        customAttribute.setValue(this.db.getDBDef().getName());
        CustomAttribute customAttribute2 = new CustomAttribute(Messages.getString("TimesTenGrid.instToIncInDistMap"), null);
        customAttribute2.setValue("" + (this.skipDist ? 0 : this.db.getDistributionMap().getToAdd().size()));
        this.selectedAttributes.add(customAttribute);
        this.selectedAttributes.add(customAttribute2);
        this.selectedAttributes.addAll(this.db.getDBDef().getAttributes());
        this.allAttributesSummary.update(this.selectedAttributes);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() != 2) {
            this.executeAddDB();
        }
    }

    private void executeAddDB() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TimesTenGrid.creatingDB"), this.db.getDBDef().getName()), Messages.getString("TimesTen.common.pleaseWait"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private GridCommandExecutor gridCmdExec;

            @Override
            protected Void doInBackground() throws Exception {
                WizardSummary.this._progressMonitor.start();
                this.gridCmdExec = WizardSummary.this.thisGrid.getExecutor();
                try {
                    File file = this.appendAttributesTempFile();
                    this.createDatabase(file);
                }
                catch (IOException | GridCommandException exception) {
                    this.firePropertyChange("message", null, exception.getMessage());
                    WizardSummary.this.logger.log(Level.SEVERE, exception.getMessage());
                    this.cancel(true);
                    throw exception;
                }
                this.firePropertyChange("progress", null, 100);
                return null;
            }

            private File appendAttributesTempFile() throws FileNotFoundException, GridCommandException {
                File file = TimesTenUtil.getTemporaryFile(WizardSummary.this.db.getDBDef().getName(), "dbdef");
                file.deleteOnExit();
                try (PrintWriter printWriter = new PrintWriter(file);){
                    printWriter.println(WizardSummary.this.getDBDefinition());
                }
                catch (IOException iOException) {
                    WizardSummary.this.logger.log(Level.SEVERE, "While writing in the temporary file:" + iOException.getMessage());
                    throw new GridCommandException("While writing in the temporary file:" + iOException.getMessage());
                }
                return file;
            }

            public void createDatabase(File file) throws GridCommandException, IOException {
                String string = MessageFormat.format(Messages.getString("TimesTenGrid.copyDBDef"), this.gridCmdExec.getHostIP());
                this.firePropertyChange("message", null, string);
                WizardSummary.this.logger.log(Level.INFO, string);
                String string2 = WizardSummary.this.thisGrid.getExecutor().getWorkingHost().getInstanceHome() + "/" + WizardSummary.this.db.getDBDef().getName() + ".dbdef";
                this.gridCmdExec.executeSCP(file, WizardSummary.this.db.getDBDef().getName() + ".dbdef", WizardSummary.this.thisGrid.getExecutor().getWorkingHost().getInstanceHome());
                GridCommand gridCommand = GridCommand.PERL_CREATE_DATABASE;
                gridCommand.prepareCommand(string2);
                try {
                    this.gridCmdExec.executePerlScriptCommand(gridCommand, new OutputStream(){
                        private StringBuffer string = new StringBuffer();

                        @Override
                        public void write(int n) throws IOException {
                            try {
                                SwingUtilities.invokeAndWait(() -> {
                                    if ((char)n == '\n') {
                                        this.firePropertyChange("message", null, this.string.substring(0, this.string.length()));
                                        this.string.setLength(0);
                                    } else {
                                        this.string.append(Character.toString((char)n));
                                    }
                                });
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                WizardSummary.this.logger.log(Level.SEVERE, exception.getMessage());
                            }
                        }
                    });
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    WizardSummary.this.thisGrid.refreshGridModels();
                    WizardSummary.this.thisGrid.getGridCurrentModel().setGridComponents(this.gridCmdExec.executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true), false);
                    WizardSummary.this.thisGrid.getGridCurrentModel().diff(WizardSummary.this.thisGrid);
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    WizardSummary.this.logger.log(Level.SEVERE, gridCommandException.getMessage());
                    int n = this.gridCmdExec.getSSHChannel().getLastCommandExitStatus();
                    if (n == 3) {
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.createDbTimedOut"));
                    }
                    this.cancel(true);
                }
            }

            @Override
            protected void done() {
                WizardSummary.this._progressMonitor.finish();
                if (WizardSummary.this._progressMonitor.isCancelled() || !WizardSummary.this._progressMonitor.successfulExecution()) {
                    this.gridCmdExec.stopCurrentExecution();
                    this.refreshGridInfo(WizardSummary.this.thisGrid);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.dbcreationCancelled"));
                    WizardSummary.this.logger.log(Level.INFO, Messages.getString("TimesTenGrid.dbcreationCancelled"));
                    WizardSummary.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.dbcreationCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    WizardSummary.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.taskComplete"));
                }
            }

            private void refreshGridInfo(final GridObject gridObject) {
                RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                    protected Void doWork() throws TaskException {
                        try {
                            gridObject.refreshGridModels();
                            gridObject.getGridCurrentModel().diff(gridObject);
                        }
                        catch (GridCommandException gridCommandException) {
                            WizardSummary.this.logger.log(Level.SEVERE, gridCommandException.getMessage());
                        }
                        return null;
                    }
                };
                raptorTask.setCancellable(false);
                raptorTask.setMessage(Messages.getString("TimesTenGrid.fetchingGrindInfo"));
                RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public Object getExitTransition() {
        return null;
    }
}

