/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class GridStatusPanel
extends JPanel {
    static final Logger logger = Logger.getLogger(GridStatusPanel.class.getName());
    static final String[] HEADER = new String[]{Messages.getString("IndexAdvisor.database"), Messages.getString("TimesTen.common.status"), Messages.getString("TimesTenGrid.connections")};
    static final int DATABASE_COLUMN_INDEX = 0;
    static final int STATUS_COLUMN_INDEX = 1;
    static final int CONNECTIONS_COLUMN_INDEX = 2;
    private JTable _statusTable;
    private JScrollPane _scrollPane;
    private StatusTableModel _model;
    private List<DatabaseObject> databases;

    public GridStatusPanel() {
        this.setLayout(new GridBagLayout());
        this._model = new StatusTableModel();
        this._statusTable = new JTable(this._model){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                return super.getCellRenderer(n, n2);
            }
        };
        this._statusTable.setAutoResizeMode(0);
        this._statusTable.setRowSelectionAllowed(false);
        this._statusTable.setColumnSelectionAllowed(false);
        this._scrollPane = new JScrollPane(this._statusTable);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void loadContent(List<DatabaseObject> list) {
        this.databases = list;
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._statusTable, true, true);
            this.showData();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(GridStatusPanel.this._statusTable, true, true);
                        GridStatusPanel.this.showData();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private void showData() {
        this._model.fireTableRowsUpdated(0, this._model.getRowCount() - 1);
    }

    class StatusTableModel
    extends AbstractTableModel {
        StatusTableModel() {
        }

        @Override
        public int getRowCount() {
            if (GridStatusPanel.this.databases != null) {
                return GridStatusPanel.this.databases.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (GridStatusPanel.this.databases != null && GridStatusPanel.this.databases.size() > 0) {
                switch (n2) {
                    case 0: {
                        return ((DatabaseObject)GridStatusPanel.this.databases.get(n)).getName();
                    }
                    case 1: {
                        return ((DatabaseObject)GridStatusPanel.this.databases.get(n)).getDBStatus().getSummary();
                    }
                    case 2: {
                        return ((DatabaseObject)GridStatusPanel.this.databases.get(n)).getConnections();
                    }
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }
}

