/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class HostInstancesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ArrayList<InstanceEntry> tableData;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.instanceName"), Messages.getString("TimesTenGrid.installation"), Messages.getString("TimesTenGrid.daemonPortColumn"), Messages.getString("TimesTenGrid.csPortColumn")};
    static final int INSTANCE_COLUMN = 0;
    static final int INSTALLATION_COLUMN = 1;
    static final int DAEMONP_COLUMN = 2;
    static final int SERVERP_COLUMN = 3;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private MyTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;

    public HostInstancesPanel() {
        this.tableData = new ArrayList();
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new MyTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = HostInstancesPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    HostInstancesPanel.this.logger.log(Level.SEVERE, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateHostInfo(HostObject hostObject) {
        InstanceEntry instanceEntry = null;
        this.tableData.clear();
        for (InstanceObject instanceObject : hostObject.getInstances()) {
            instanceEntry = new InstanceEntry();
            instanceEntry.setDaemonPort(String.valueOf(instanceObject.getDaemonPort()));
            instanceEntry.setServerPort(String.valueOf(instanceObject.getCSPort()));
            instanceEntry.setInstanceName(instanceObject.getName());
            instanceEntry.setInstallation(hostObject.getInstallations().get(0).getName());
            this.tableData.add(instanceEntry);
            instanceEntry = null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
            this._model.fireTableDataChanged();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(HostInstancesPanel.this._table, true, true);
                        HostInstancesPanel.this._model.fireTableDataChanged();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private static class InstanceEntry {
        private String instanceName;
        private String installation;
        private String daemonPort;
        private String serverPort;

        private InstanceEntry() {
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String string) {
            this.instanceName = string;
        }

        public String getInstallation() {
            return this.installation;
        }

        public void setInstallation(String string) {
            this.installation = string;
        }

        public String getDaemonPort() {
            return this.daemonPort;
        }

        public void setDaemonPort(String string) {
            this.daemonPort = string;
        }

        public String getServerPort() {
            return this.serverPort;
        }

        public void setServerPort(String string) {
            this.serverPort = string;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return HostInstancesPanel.this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return HostInstancesPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((InstanceEntry)HostInstancesPanel.this.tableData.get(n)).getInstanceName();
                }
                case 1: {
                    return ((InstanceEntry)HostInstancesPanel.this.tableData.get(n)).getInstallation();
                }
                case 2: {
                    return ((InstanceEntry)HostInstancesPanel.this.tableData.get(n)).getDaemonPort();
                }
                case 3: {
                    return ((InstanceEntry)HostInstancesPanel.this.tableData.get(n)).getServerPort();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HostInstancesPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

