/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.ClosableEscMenuItem;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.database.DatabaseEditor;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class InstStatusEditor
extends TTBaseEditor
implements ActionListener {
    private JPanel _panel;
    private ISStatusModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;
    private JPopupMenu _popupMenu;
    private JMenuItem _start;
    private JMenuItem _stop;
    private ToggleToolButton _startToggle;
    private ToggleToolButton _stopToggle;
    protected IdeAction _startAction;
    protected IdeAction _stopAction;
    protected static final int START_ID = Ide.findOrCreateCmdID((String)"Grid_Editor.Start");
    protected static final int STOP_ID = Ide.findOrCreateCmdID((String)"Grid_Editor.Stop");
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.hostColumn"), Messages.getString("TimesTenGrid.instanceColumn"), Messages.getString("TimesTen.common.type"), Messages.getString("TimesTenGrid.daemonPortColumn"), Messages.getString("TimesTenGrid.csPortColumn"), Messages.getString("TimesTenGrid.mgmtPortColumn"), Messages.getString("TimesTenGrid.daemonstatus"), Messages.getString("TimesTenGrid.serverstatus"), Messages.getString("TimesTenGrid.role"), Messages.getString("TimesTenGrid.repAgentStatus")};
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private List<InstanceObject> instances;

    public InstStatusEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._panel = new JPanel(new GridBagLayout());
            this._model = new ISStatusModel();
            this._popupMenu = new JPopupMenu();
            this._start = new ClosableEscMenuItem(Messages.getString("IndexAdvisor.start"), this._popupMenu);
            this._stop = new ClosableEscMenuItem(Messages.getString("IndexAdvisor.stop"), this._popupMenu);
            this._start.addActionListener(this);
            this._stop.addActionListener(this);
            this._popupMenu.add(this._start);
            this._popupMenu.add(this._stop);
            this._startAction = IdeAction.get((int)START_ID);
            this._startAction.addController((Controller)this);
            this._stopAction = IdeAction.get((int)STOP_ID);
            this._stopAction.addController((Controller)this);
            this._table = new JTable(this._model);
            this._table.setSelectionModel(new CustomSelectionModel());
            this._table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        InstStatusEditor.this.doRightClick(mouseEvent);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.isPopupTrigger()) {
                        InstStatusEditor.this.doRightClick(mouseEvent);
                    }
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(121, 1, true);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(525, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InstStatusEditor.this.displayPopup();
                }
            };
            this._table.registerKeyboardAction(actionListener, keyStroke, 0);
            this._table.registerKeyboardAction(actionListener, keyStroke2, 0);
            this._popupMenu.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InstStatusEditor.this._popupMenu.setVisible(false);
                }
            }, keyStroke3, 0);
            this._table.setAutoResizeMode(0);
            TableColumnModel tableColumnModel = this._table.getColumnModel();
            tableColumnModel.getColumn(ColIdx.SERVER_STATUS.ordinal()).setCellRenderer(new IconTextCellRenderer());
            tableColumnModel.getColumn(ColIdx.DAEMON_STATUS.ordinal()).setCellRenderer(new IconTextCellRenderer());
            tableColumnModel.getColumn(ColIdx.REP_AGENT_STATUS.ordinal()).setCellRenderer(new IconTextCellRenderer());
            this._scrollPane = new JScrollPane(this._table);
            this._panel.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._panel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.INST_STATUS_EDITOR.toString());
            this._startToggle = this._toolbar.addToggleButton((ToggleAction)this._startAction);
            this._startToggle.setToolTipText(Messages.getString("TimesTenGrid.startInstances"));
            this._startToggle.setIcon(OracleIcons.getIcon((String)"startserver.png"));
            this._stopToggle = this._toolbar.addToggleButton((ToggleAction)this._stopAction);
            this._stopToggle.setToolTipText(Messages.getString("TimesTenGrid.stopInstances"));
            this._stopToggle.setIcon(OracleIcons.getIcon((String)"stopserver.png"));
            this.initialized = true;
        }
    }

    private void doRightClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this._table.rowAtPoint(point);
        if (!this.isMgmtInstIndex(n)) {
            ((CustomSelectionModel)this._table.getSelectionModel()).setSelecInt(n, n);
            this._popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void displayPopup() {
        Rectangle rectangle = this._table.getCellRect(this._table.getSelectedRow(), this._table.getSelectedColumn(), false);
        if (this._table.getSelectedRow() != -1) {
            this._popupMenu.show(this._table, rectangle.x, rectangle.y);
        }
    }

    @Override
    public void updateContent() {
        if (this.instances == null) {
            this.refreshInstStatus(this::loadContent);
        } else {
            this.loadContent();
        }
    }

    private void loadContent() {
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
            this.showData();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(InstStatusEditor.this._table, true, true);
                        InstStatusEditor.this.showData();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private void showData() {
        this._model.fireTableRowsUpdated(0, this._model.getRowCount() - 1);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_ID) {
            this.refreshInstStatus(this::loadContent);
            return true;
        }
        if (n == START_ID || n == STOP_ID) {
            if (this._table.getSelectedRowCount() > 0) {
                this.tryExecuteCommand(n == START_ID);
            } else {
                MessageDialog.error((Component)this._table, (Object)Messages.getString("TimesTenGrid.noSelectedInstances"), (String)Messages.getString("TimesTen.common.error"), null);
            }
            return true;
        }
        return false;
    }

    private void refreshInstStatus(final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.errorMessage = new StringBuilder("");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                GridCommandExecutor gridCommandExecutor = InstStatusEditor.this.currentGrid.getExecutor();
                try {
                    GridMouseListener.expander.setTree(InstStatusEditor.this.currentGrid.getGridNode().getCustomTree());
                    GridMouseListener.expander.saveExpansionState();
                    GridCommand gridCommand = GridCommand.EXPORT_MODEL;
                    jsonObject = gridCommandExecutor.executeCommandGetJson(gridCommand, true);
                    InstStatusEditor.this.currentGrid.setGridComponents(jsonObject, false);
                    InstStatusEditor.this.currentGrid.getGridCurrentModel().setGridComponents(gridCommandExecutor.executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true), false);
                    InstStatusEditor.this.currentGrid.getGridCurrentModel().diff(InstStatusEditor.this.currentGrid);
                    GridMouseListener.expander.restoreExpansionState();
                    InstStatusEditor.this.instances = new ArrayList<InstanceObject>(InstStatusEditor.this.currentGrid.getAllMgmtInstances());
                    InstStatusEditor.this.instances.addAll(InstStatusEditor.this.currentGrid.getAllDataInstances());
                    InstStatusEditor.this.asyncUpdate();
                    gridCommand = GridCommand.TT_STATUS_ALL;
                    ArrayList<GridCommandExecutor.ExecOutput> arrayList = InstStatusEditor.this.currentGrid.getExecutor().execCommand(InstStatusEditor.this.currentGrid.getAllMgmtInstances(), gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.MGMT.getExecMode(), 600);
                    for (GridCommandExecutor.ExecOutput execOutput : arrayList) {
                        execOutput.setInstanceStatus();
                    }
                    InstStatusEditor.this.asyncUpdate();
                    InstStatusEditor.this.currentGrid.updateMgmInstancesModel(InstStatusEditor.this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.MGMT_EXAMINE, true));
                    InstStatusEditor.this.asyncUpdate();
                    if (InstStatusEditor.this.currentGrid.getAllDataInstances().size() > 0) {
                        InstStatusEditor.this.asyncUpdate();
                        arrayList = InstStatusEditor.this.currentGrid.getExecutor().execCommand(InstStatusEditor.this.currentGrid.getAllDataInstances(), gridCommand, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode(), 600);
                        for (GridCommandExecutor.ExecOutput execOutput : arrayList) {
                            execOutput.setInstanceStatus();
                        }
                    }
                    Collections.sort(InstStatusEditor.this.instances, new Comparator<InstanceObject>(){

                        @Override
                        public int compare(InstanceObject instanceObject, InstanceObject instanceObject2) {
                            if (instanceObject.isMgmtInstance() && instanceObject2.isMgmtInstance()) {
                                if (instanceObject.getType() == InstanceObject.ManagementInstanceRole.STANDBY) {
                                    return 1;
                                }
                                if (instanceObject2.getType() == InstanceObject.ManagementInstanceRole.STANDBY) {
                                    return -1;
                                }
                                return 0;
                            }
                            if (!instanceObject.isMgmtInstance() && !instanceObject2.isMgmtInstance()) {
                                return 0;
                            }
                            if (instanceObject.isMgmtInstance()) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                }
                catch (JsonException | GridCommandException throwable) {
                    InstStatusEditor.this.logger.severe(throwable.getMessage());
                    this.errorMessage.append(throwable.getMessage());
                    for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor instanceof DatabaseEditor)) continue;
                        final List<Editor> list = Arrays.asList(editor);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    EditorManager.getEditorManager().closeEditors(list);
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {}
                        break;
                    }
                }
                if (!this.errorMessage.toString().isEmpty()) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    return null;
                }
                runnable.run();
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.updateInstancesInfoTask"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void asyncUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.loadContent();
        } else {
            SwingUtilities.invokeLater(() -> this.loadContent());
        }
    }

    private boolean isMgmtInstIndex(int n) {
        return this.instances != null ? this.instances.get(n).isMgmtInstance() : true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._start == actionEvent.getSource() || this._stop == actionEvent.getSource()) {
            this.tryExecuteCommand(this._start == actionEvent.getSource());
        }
    }

    private void tryExecuteCommand(boolean bl) {
        String string = Messages.getString("TimesTenGrid.startInstances");
        String string2 = Messages.getString("TimesTenGrid.startDataInsts");
        if (!bl) {
            string = Messages.getString("TimesTenGrid.stopInstances");
            string2 = Messages.getString("TimesTenGrid.stopDataInsts");
        }
        if (MessageDialog.confirm((Component)this._table, (Object)string2, (String)string, null)) {
            this.executeCommand(bl);
        }
    }

    private void executeCommand(final boolean bl) {
        int[] nArray = this._table.getSelectedRows();
        final ArrayList<InstanceObject> arrayList = new ArrayList<InstanceObject>();
        for (int n : nArray) {
            arrayList.add(this.instances.get(n));
        }
        if (!arrayList.isEmpty()) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
                StringBuilder errorMessage;
                {
                    super(string, bl3, iRaptorTaskRunMode);
                    this.errorMessage = new StringBuilder("");
                }

                protected Void doWork() throws TaskException {
                    try {
                        ArrayList<GridCommandExecutor.ExecOutput> arrayList3 = InstStatusEditor.this.currentGrid.getExecutor().execCommand(arrayList, bl ? GridCommand.START_WORKING_INSTANCE : GridCommand.STOP_WORKING_INSTANCE, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode());
                        arrayList.clear();
                        for (GridCommandExecutor.ExecOutput object : arrayList3) {
                            if (Common.forceStart(object.getOutput()) || Common.forceStop(object.getOutput())) {
                                arrayList.add((InstanceObject)object.getObject());
                                continue;
                            }
                            InstStatusEditor.this.checkInstExecOutput(object, this.errorMessage);
                        }
                        if (!arrayList.isEmpty()) {
                            ArrayList<GridCommandExecutor.ExecOutput> arrayList2 = InstStatusEditor.this.currentGrid.getExecutor().execCommand(arrayList, bl ? GridCommand.START_WORKING_INSTANCE_FORCE : GridCommand.STOP_WORKING_INSTANCE_FORCE, false, BaseTraversablePanel.InstanceActionPanelInstanceType.DATA.getExecMode());
                            Iterator iterator = arrayList2.iterator();
                            while (iterator.hasNext()) {
                                GridCommandExecutor.ExecOutput execOutput = (GridCommandExecutor.ExecOutput)iterator.next();
                                InstStatusEditor.this.checkInstExecOutput(execOutput, this.errorMessage);
                            }
                        }
                    }
                    catch (JsonException | GridCommandException throwable) {
                        InstStatusEditor.this.logger.severe(throwable.getMessage());
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), throwable.getMessage());
                        return null;
                    }
                    InstStatusEditor.this.refreshInstStatus(() -> InstStatusEditor.this.loadContent());
                    if (!this.errorMessage.toString().isEmpty()) {
                        Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    }
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            raptorTask.setMessage(bl ? Messages.getString("TimesTenGrid.startInstancesMessage") : Messages.getString("TimesTenGrid.stopInstancesMessage"));
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    private void checkInstExecOutput(GridCommandExecutor.ExecOutput execOutput, StringBuilder stringBuilder) {
        if (execOutput.hasError() && execOutput.getExitCode() != 0) {
            String string = MessageFormat.format(Messages.getString("TimesTenGrid.outputFromInstance"), ((InstanceObject)execOutput.getObject()).getFullName(), execOutput.getError());
            this.logger.severe(string);
            stringBuilder.append(string);
        } else {
            this.logger.info(execOutput.getOutput());
        }
    }

    private class CustomSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1L;

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (!super.isSelectionEmpty()) {
                super.clearSelection();
            }
            this.addSelectionInterval(n, n2);
        }

        private void setSelecInt(int n, int n2) {
            this.addSelectionInterval(n, n2);
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            if (InstStatusEditor.this.isMgmtInstIndex(n)) {
                return;
            }
            if (InstStatusEditor.this.isMgmtInstIndex(n2)) {
                return;
            }
            super.addSelectionInterval(n, n2);
        }
    }

    private class IconTextCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private IconTextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!((InstanceObject)InstStatusEditor.this.instances.get(n)).isStatusAvailable() && n2 != ColIdx.REP_AGENT_STATUS.ordinal()) {
                jLabel.setText(Messages.getString("TimesTen.common.unknown"));
                jLabel.setIcon(null);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
            boolean bl3 = false;
            if (n2 == ColIdx.SERVER_STATUS.ordinal()) {
                bl3 = ((InstanceObject)InstStatusEditor.this.instances.get(n)).getCSState();
            } else if (n2 == ColIdx.DAEMON_STATUS.ordinal()) {
                bl3 = ((InstanceObject)InstStatusEditor.this.instances.get(n)).getDaemonStatus();
            } else if (n2 == ColIdx.REP_AGENT_STATUS.ordinal()) {
                if (((InstanceObject)InstStatusEditor.this.instances.get(n)).isMgmtInstance()) {
                    Common.RepAgentStatus repAgentStatus = ((InstanceObject)InstStatusEditor.this.instances.get(n)).getRepAgentStatus();
                    switch (repAgentStatus) {
                        case UP: {
                            bl3 = true;
                            break;
                        }
                        case DOWN: {
                            break;
                        }
                        case NOT_APPLICABLE: {
                            jLabel.setText(repAgentStatus.toString());
                            jLabel.setIcon(null);
                            jLabel.setHorizontalAlignment(0);
                            return jLabel;
                        }
                    }
                } else {
                    jLabel.setText(object.toString());
                    jLabel.setIcon(null);
                    jLabel.setHorizontalAlignment(0);
                    return jLabel;
                }
            }
            jLabel.setText(bl3 ? Messages.getString("TimesTenGrid.up") : Messages.getString("TimesTenGrid.down"));
            jLabel.setIcon(bl3 ? Common.UP_ICON : Common.DOWN_ICON);
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    private class ISStatusModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ISStatusModel() {
        }

        @Override
        public int getRowCount() {
            return InstStatusEditor.this.instances != null ? InstStatusEditor.this.instances.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return InstStatusEditor.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (InstStatusEditor.this.instances != null) {
                if (n2 == ColIdx.HOST.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getHost().getName();
                }
                if (n2 == ColIdx.INSTANCE.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getName();
                }
                if (n2 == ColIdx.TYPE.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).isMgmtInstance() ? Messages.getString("TimesTenGrid.management") : Messages.getString("TimesTenGrid.data");
                }
                if (n2 == ColIdx.DAEMON_PORT.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getDaemonPort();
                }
                if (n2 == ColIdx.SERVER_PORT.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getCSPort();
                }
                if (n2 == ColIdx.MGMT_PORT.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).isMgmtInstance() ? Integer.valueOf(((InstanceObject)InstStatusEditor.this.instances.get(n)).getMgmtPort()) : "";
                }
                if (n2 == ColIdx.DAEMON_STATUS.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getDaemonStatus() ? Common.UP_ICON : Common.DOWN_ICON;
                }
                if (n2 == ColIdx.SERVER_STATUS.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getCSState() ? Common.UP_ICON : Common.DOWN_ICON;
                }
                if (n2 == ColIdx.REP_ROLE.ordinal()) {
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).isMgmtInstance() ? ((InstanceObject)InstStatusEditor.this.instances.get(n)).getType() : "";
                }
                if (n2 == ColIdx.REP_AGENT_STATUS.ordinal()) {
                    if (((InstanceObject)InstStatusEditor.this.instances.get(n)).isMgmtInstance() && InstStatusEditor.this.currentGrid.getAllMgmtInstances().size() > 1) {
                        return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getRepAgentStatus() == Common.RepAgentStatus.UP ? Common.UP_ICON : Common.DOWN_ICON;
                    }
                    return ((InstanceObject)InstStatusEditor.this.instances.get(n)).getRepAgentStatus().toString();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return InstStatusEditor.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    static enum ColIdx {
        HOST,
        INSTANCE,
        TYPE,
        DAEMON_PORT,
        SERVER_PORT,
        MGMT_PORT,
        DAEMON_STATUS,
        SERVER_STATUS,
        REP_ROLE,
        REP_AGENT_STATUS;

    }
}

