/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.installations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.nulls.NullPrintStream;

public class InstallationCreatePanel
extends TTGUIBasePanel {
    private final InstallationCreatePanel thisPanel;
    private InstallationInfoPanel _installInfoPanel;
    private JLabel _sourceHostLbl;
    private JComboBox<HostObject> _sourceHostCmb;
    private JLabel _sourceInstallLbl;
    private JLabel _sourceLocationLbl;
    private JTextField _sourceLocationTxtFld;
    private JRadioButton _existentSourceRdo;
    private JRadioButton _newSourceRdo;
    private ButtonGroup _btnGrp;
    private List<HostObject> sourceHosts;
    private JComboBox<InstallationObject> _sourceInstallationCmb;
    private HostObject installationHost;
    private HostObject sourceHost;
    private Runnable onFinishCall;
    private boolean standAlone;
    private boolean isWizard = false;
    private Runnable updateSourceComboBox;
    private InstallationObject dummy;
    private InstallationObject newInstall;
    private static final Logger _logger = Logger.getLogger(InstallationCreatePanel.class.getName());

    public InstallationCreatePanel(HostObject hostObject) {
        this.installationHost = hostObject;
        this.thisPanel = this;
        this.standAlone = true;
        this.dummy = new InstallationObject(null, " ");
        this.newInstall = new InstallationObject(null, null);
        this.dummy.setLocation("");
        this.initGUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.NEW_INSTALLATION.toString());
    }

    public void setOnFinishCall(Runnable runnable) {
        this.onFinishCall = runnable;
        this.standAlone = false;
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.sourceHosts = new ArrayList<HostObject>();
        this.sourceHosts.addAll(this.grid.getHosts());
        this._sourceHostLbl = new JLabel(Messages.getString("TimesTenGrid.hostColon"));
        this._sourceHostCmb = new JComboBox();
        this._sourceLocationLbl = new JLabel(Messages.getString("TimesTenGrid.locationColon"));
        this._sourceLocationTxtFld = new JTextField(25);
        this._existentSourceRdo = new JRadioButton(Messages.getString("TimesTenGrid.useExSrc"));
        this._newSourceRdo = new JRadioButton(Messages.getString("TimesTenGrid.newSrc"));
        this._btnGrp = new ButtonGroup();
        this._sourceInstallLbl = new JLabel(Messages.getString("TimesTenGrid.InstallationObjectName"));
        this._sourceInstallationCmb = new JComboBox();
        this._sourceInstallationCmb.setMinimumSize(this._sourceInstallationCmb.getPreferredSize());
        this.updateSourceComboBox = () -> {
            this._sourceInstallationCmb.removeAllItems();
            if (!this.sourceHost.hasInstallationsAvailable()) {
                this._sourceInstallationCmb.addItem(this.dummy);
            } else {
                for (InstallationObject installationObject : this.sourceHost.getInstallations()) {
                    if (!installationObject.isAppliedToCurrent()) continue;
                    this._sourceInstallationCmb.addItem(installationObject);
                }
            }
        };
        this._sourceHostCmb.setModel((ComboBoxModel<HostObject>)new MutableComboBoxModel<HostObject>(){

            @Override
            public int getSize() {
                return InstallationCreatePanel.this.sourceHosts.size();
            }

            @Override
            public HostObject getElementAt(int n) {
                return (HostObject)InstallationCreatePanel.this.sourceHosts.get(n);
            }

            @Override
            public void addListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public void removeListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public void addElement(HostObject hostObject) {
                InstallationCreatePanel.this.sourceHosts.add(hostObject);
            }

            @Override
            public void insertElementAt(HostObject hostObject, int n) {
                InstallationCreatePanel.this.sourceHosts.add(n, hostObject);
            }

            @Override
            public void removeElement(Object object) {
                InstallationCreatePanel.this.sourceHosts.remove(object);
            }

            @Override
            public void removeElementAt(int n) {
                InstallationCreatePanel.this.sourceHosts.remove(n);
            }

            @Override
            public void setSelectedItem(Object object) {
                InstallationCreatePanel.this.sourceHost = (HostObject)object;
            }

            @Override
            public Object getSelectedItem() {
                return InstallationCreatePanel.this.sourceHost;
            }
        });
        this._sourceHostCmb.addActionListener(actionEvent -> {
            this.updateSourceComboBox.run();
            this._sourceInstallationCmb.setSelectedIndex(0);
            if (this.sourceHost.hasInstallationsAvailable()) {
                if (this._existentSourceRdo.isSelected()) {
                    this._existentSourceRdo.setEnabled(true);
                    this._sourceLocationTxtFld.setEnabled(false);
                    this._sourceInstallationCmb.setEnabled(true);
                } else {
                    this._existentSourceRdo.setEnabled(true);
                    this._sourceLocationTxtFld.setEnabled(true);
                    this._sourceInstallationCmb.setEnabled(false);
                }
            } else {
                this._existentSourceRdo.setEnabled(false);
                this._newSourceRdo.setSelected(true);
                this._sourceInstallationCmb.setEnabled(false);
                this._sourceLocationTxtFld.setEnabled(true);
            }
        });
        this._existentSourceRdo.setSelected(true);
        this._existentSourceRdo.addActionListener(actionEvent -> {
            this._sourceLocationTxtFld.setEnabled(false);
            this._sourceInstallationCmb.setEnabled(true);
        });
        this._newSourceRdo.addActionListener(actionEvent -> {
            this._sourceLocationTxtFld.setEnabled(true);
            this._sourceInstallationCmb.setEnabled(false);
        });
        this._btnGrp.add(this._existentSourceRdo);
        this._btnGrp.add(this._newSourceRdo);
        this._sourceHostCmb.setSelectedIndex(0);
        this._sourceLocationTxtFld.setMinimumSize(this._sourceLocationTxtFld.getPreferredSize());
        this._installInfoPanel = new InstallationInfoPanel(this.installationHost.getName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._existentSourceRdo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this._newSourceRdo, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.selectSrc")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._sourceHostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add(this._sourceHostCmb, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this._sourceInstallLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add(this._sourceInstallationCmb, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this._sourceLocationLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this._sourceLocationTxtFld, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.installSrc")));
        this.add((Component)this._installInfoPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 23, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._installInfoPanel.getNameTxtField().setText(this.getNextInstallationName());
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = this._installInfoPanel.getNameTxtField().getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.nameEmpty"));
            return;
        }
        String string2 = Common.validateName(string, Messages.getString("TimesTenGrid.installation"));
        if (string2 != null) {
            Common.displayErrorMsg(this, string2);
            return;
        }
        if (this.grid.getHost(this.installationHost.getName()) != null && this.grid.getHost(this.installationHost.getName()).getInstallation(string) != null) {
            Common.displayErrorMsg(this, MessageFormat.format(Messages.getString("TimesTenGrid.installExists"), string));
            return;
        }
        String string3 = this._installInfoPanel.getLocationTxtField().getText().trim();
        if (string3.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.installLocEmpty"));
            return;
        }
        String string4 = this._sourceLocationTxtFld.getText().trim();
        if (this._newSourceRdo.isSelected() && string4.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.srcInstallLocEmpty"));
            return;
        }
        for (InstallationObject object2 : this.installationHost.getInstallations()) {
            if (!object2.getLocation().equalsIgnoreCase(string3)) continue;
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.installLocUsedInstall"));
            return;
        }
        for (InstanceObject instanceObject : this.installationHost.getInstances()) {
            if (!instanceObject.getHome().equalsIgnoreCase(string3)) continue;
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.installLocUsedInstance"));
            return;
        }
        if (this._newSourceRdo.isSelected()) {
            object = string4;
        } else {
            String string5 = this.grid.getExecutor().getWorkingHost().getSystemInfo().getFileSeparator();
            String string6 = ((InstallationObject)this._sourceInstallationCmb.getSelectedItem()).getLocation();
            String string7 = ((InstallationObject)this._sourceInstallationCmb.getSelectedItem()).getSourceRelease();
            String string8 = "tt" + string7;
            string6 = Common.removeTrailingFileSeparator(string6, string5);
            object = string6 + string5 + string8;
        }
        this.newInstall.setName(string);
        this.newInstall.setSourceAddress(this.sourceHost.getInternalAddress());
        this.newInstall.setSourcePath((String)object);
        this.newInstall.setLocation(string3);
        if (!this.isWizard) {
            this.createInstallationWorker();
        } else {
            if (this._existentSourceRdo.isSelected()) {
                this.newInstall.setSourceRelease(((InstallationObject)this._sourceInstallationCmb.getSelectedItem()).getSourceRelease());
            }
            this.oked = true;
            this.dispose();
        }
    }

    public void setInstallation(InstallationObject installationObject) {
        this._installInfoPanel.getNameTxtField().setText(this.getNextInstallationName());
        this._installInfoPanel.getLocationTxtField().setText(installationObject.getLocation() != null ? installationObject.getLocation() : "");
        this._installInfoPanel.getHostLbl().setText(installationObject.getHost().getName());
        this.installationHost = installationObject.getHost();
        if (!this.grid.getHosts().contains(this.installationHost)) {
            this._sourceHostCmb.addItem(this.installationHost);
            this._sourceHostCmb.updateUI();
            this._sourceHostCmb.repaint();
        }
        this.newInstall = installationObject;
        this.isWizard = true;
        if (installationObject.getSourceAddress() != null && installationObject.getSourcePath() != null) {
            HostObject tTGridObject = null;
            for (HostObject tTGridObject2 : this.grid.getHosts()) {
                if (!tTGridObject2.getInternalAddress().equalsIgnoreCase(installationObject.getSourceAddress())) continue;
                this._sourceHostCmb.setSelectedItem(tTGridObject2);
                tTGridObject = tTGridObject2;
                break;
            }
            if (tTGridObject == null) {
                return;
            }
            for (InstallationObject installationObject2 : tTGridObject.getInstallations()) {
                if (!installationObject2.getLocation().equalsIgnoreCase(installationObject.getSourcePath())) continue;
                this.updateSourceComboBox.run();
                this._existentSourceRdo.setSelected(true);
                this._sourceInstallationCmb.setSelectedItem(installationObject2);
                this._sourceLocationTxtFld.setEnabled(false);
                return;
            }
            this._newSourceRdo.setSelected(true);
            this._sourceLocationTxtFld.setText(installationObject.getSourcePath());
            this._sourceLocationTxtFld.setEnabled(true);
            this._sourceInstallationCmb.setEnabled(false);
        }
    }

    public void dispose() {
        this._dialog.dispose();
    }

    private void createInstallationWorker() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.creatinginstallation"), Messages.getString("TimesTenGrid.creatinginstallation"), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                GridCommand gridCommand;
                customProgressMonitor.start();
                GridMouseListener.expander.saveExpansionState();
                if (InstallationCreatePanel.this._newSourceRdo.isSelected()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.checkingSrcInstallLoc"));
                    gridCommand = Common.validTTSWFile(InstallationCreatePanel.this._sourceLocationTxtFld.getText().trim()) ? GridCommand.CHECK_REMOTE_DIR_FILE_IS_READ : GridCommand.CHECK_REMOTE_DIR_IS_READ;
                    gridCommand.prepareCommand(InstallationCreatePanel.this.sourceHost.getInternalAddress(), InstallationCreatePanel.this._sourceLocationTxtFld.getText());
                    try {
                        InstallationCreatePanel.this.grid.getExecutor().executePerlScriptCommand(gridCommand, (OutputStream)new NullPrintStream());
                    }
                    catch (GridCommandException gridCommandException) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.installSrcLocError"));
                        _logger.log(Level.SEVERE, Messages.getString("TimesTenGrid.installSrcLocError") + gridCommandException.getMessage());
                        this.cancel(true);
                        throw new Exception();
                    }
                }
                this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.createinstallationcommand"));
                InstallationCreatePanel.this.thisPanel.dispose();
                gridCommand = GridCommand.INSTALLATION_CREATE_FULL;
                gridCommand.prepareCommand(InstallationCreatePanel.this.installationHost.getName(), InstallationCreatePanel.this.newInstall.getLocation(), InstallationCreatePanel.this.newInstall.getName(), InstallationCreatePanel.this.newInstall.getSource());
                try {
                    InstallationCreatePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    InstallationCreatePanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    this.firePropertyChange("message", null, gridCommandException.getMessage());
                    _logger.log(Level.SEVERE, gridCommandException.getMessage());
                    this.cancel(true);
                    throw new Exception(gridCommandException);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.installationCreationCancelled"));
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.installationCreationCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    if (InstallationCreatePanel.this.standAlone) {
                        InstallationCreatePanel.this.showModelNeedsApplyWarning();
                    } else {
                        DifferenceObject differenceObject = InstallationCreatePanel.this.grid.getGridCurrentModel().diff(InstallationCreatePanel.this.grid);
                        if (differenceObject.areDifferences()) {
                            InstallationCreatePanel.this.grid.getGridNode().updateIcon(false);
                        }
                        InstallationCreatePanel.this.onFinishCall.run();
                    }
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private String getNextInstallationName() {
        String string;
        int n = 1;
        boolean bl = true;
        do {
            string = "installation" + String.valueOf(n);
            for (InstallationObject installationObject : this.installationHost.getInstallations()) {
                if (installationObject.getName().equalsIgnoreCase(string)) {
                    bl = true;
                    break;
                }
                bl = false;
            }
            ++n;
        } while (bl && this.installationHost.getInstallations().size() > 0);
        return string;
    }

    public static class InstallationInfoPanel
    extends JPanel {
        private JLabel _nameLbl;
        private AutoCompleteComponent _nameTxtFld;
        private JLabel _hostLbl;
        private JLabel _hostNameLbl;
        private JLabel _locationLbl;
        private AutoCompleteComponent _locationTxtFld;

        public InstallationInfoPanel(String string) {
            this.setLayout(new GridBagLayout());
            this._nameLbl = new JLabel(Messages.getString("TimesTenGrid.installationName"));
            this._nameTxtFld = new AutoCompleteComponent(15, InstallationObject.getInstallationNameSuggestions());
            this._hostLbl = new JLabel(Messages.getString("TimesTenGrid.hostColon"));
            this._hostNameLbl = new JLabel(string);
            this._nameTxtFld.setMinimumSize(this._nameTxtFld.getPreferredSize());
            this._locationLbl = new JLabel(Messages.getString("TimesTenGrid.locationColon"));
            this._locationTxtFld = new AutoCompleteComponent(25, InstallationObject.getInstallationLocationSuggestions());
            this._locationTxtFld.setMinimumSize(this._locationTxtFld.getPreferredSize());
            this.add((Component)this._hostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._hostNameLbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._nameLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._nameTxtFld, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._locationLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._locationTxtFld, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.installationProp")));
            this.setNames(string);
        }

        public void setInstallInfoBorder() {
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.installInfo")));
        }

        public AutoCompleteComponent getNameTxtField() {
            return this._nameTxtFld;
        }

        public AutoCompleteComponent getLocationTxtField() {
            return this._locationTxtFld;
        }

        public JLabel getHostLbl() {
            return this._hostNameLbl;
        }

        private void setNames(String string) {
            this._nameLbl.setName(Messages.getString("TimesTenGrid.installationName"));
            this._hostLbl.setName(Messages.getString("TimesTenGrid.hostColon"));
            this._hostNameLbl.setName(string);
            this._locationLbl.setName(Messages.getString("TimesTenGrid.locationColon"));
            this._nameTxtFld.setName("_nameTxtField", "_nameCmbBox");
            this._locationTxtFld.setName("_locationTxtField", "_locationCmbBox");
        }
    }
}

