/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.start;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BaseTraversablePanel;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DatabaseTraversablePanel
extends BaseTraversablePanel {
    private static final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.databaseColumn"), Messages.getString("TimesTenGrid.dbLoadReadiness"), Messages.getString("TimesTenGrid.dbLoadStatus")};
    private boolean allLoaded;
    private boolean dbUnloaded;
    private List<DatabaseObject> databases = new ArrayList<DatabaseObject>();
    private static final long serialVersionUID = 1L;

    public DatabaseTraversablePanel() {
        super(true);
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.model = new DatabasesModel();
        this._objTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                string = DatabaseTraversablePanel.this._objTable.getValueAt(n, n2).toString();
                return string;
            }
        };
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._objTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this._objTable.getColumnModel();
        tableColumnModel.getColumn(DBColIdx.DATABASE.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DBColIdx.READINESS.getValue()).setCellRenderer(this.centerRenderer);
        tableColumnModel.getColumn(DBColIdx.STATUS.getValue()).setCellRenderer(this.centerRenderer);
        this._objTable.setRowHeight(30);
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
        this.add(new JScrollPane(this._objTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.actionBtn.setText(Messages.getString("TimesTenGrid.databasesLoad"));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.dataContext = traversableContext;
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        this.databases = this.currentGrid.getDatabases();
        this.launchUpdater();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() != 2) {
            boolean bl;
            boolean bl2 = bl = Common.loadedDBsCount(this.databases, false) < this.databases.size();
            if (bl && !Common.displayConfirm((Component)((Object)this), Messages.getString("TimesTenGrid.dbsNotLoaded"), Messages.getString("TimesTenGrid.dbsNotLoadedTitle"), null)) {
                throw new TraversalException(null);
            }
        }
        this.shutdownAutoRefresh();
    }

    @Override
    protected void executeCommand() {
        try {
            for (DatabaseObject databaseObject : this.databases) {
                if (!databaseObject.getDBStatus().isLoaded() && databaseObject.getLoadReadiness() == DatabaseObject.LoadReadiness.YES) {
                    GridCommand gridCommand = GridCommand.LOAD_DATABASE;
                    gridCommand.prepareCommand(databaseObject.getName());
                    String string = MessageFormat.format(Messages.getString("TimesTenGrid.loadDBStarted"), databaseObject.getName());
                    this.worker.firePropertyChange("message", null, string);
                    this.printMessageInPanel(string);
                    this.currentGrid.getExecutor().executeCommandGetString(gridCommand, true);
                    continue;
                }
                this.printMessageInPanel(MessageFormat.format(Messages.getString("TimesTenGrid.skipLoadDB"), databaseObject.getName()));
            }
        }
        catch (GridCommandException gridCommandException) {
            logger.severe(gridCommandException.getMessage());
            this.printMessageInPanel(gridCommandException.getMessage());
        }
    }

    @Override
    protected void updateStatus(boolean bl) throws GridCommandException, JsonException {
        this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateDBsStatus"));
        this.currentGrid.updateDatabasesStatus();
        this.updateLastRefresh();
        for (int i = 0; this.worker.commandExecuted() && i < 60; ++i) {
            int n = Common.loadedDBsCount(this.databases, false);
            this.worker.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.DBsLoadedCount"), n, this.databases.size()));
            if (n == this.databases.size()) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                logger.warning("Interrupted while waiting to get databases status (grid->start): " + interruptedException.getMessage());
            }
            this.worker.firePropertyChange("message", null, Messages.getString("TimesTenGrid.updateDBsStatus"));
            this.currentGrid.updateDatabasesStatus();
            this.updateLastRefresh();
        }
        this.allLoaded = true;
        this.dbUnloaded = false;
        Iterator<DatabaseObject> iterator = this.databases.iterator();
        while (iterator.hasNext()) {
            DatabaseObject databaseObject = iterator.next();
            try {
                databaseObject.updateLoadReadiness();
            }
            catch (GridCommandException gridCommandException) {
                if (gridCommandException.getMessage().indexOf(123) >= 0) {
                    String string = gridCommandException.getMessage().substring(gridCommandException.getMessage().indexOf(123), gridCommandException.getMessage().length());
                    JsonObject jsonObject = Json.createReader((Reader)new StringReader(string)).readObject();
                    if (jsonObject.getInt("status") == 2) {
                        iterator.remove();
                        continue;
                    }
                    throw gridCommandException;
                }
                throw gridCommandException;
            }
            if (databaseObject.getDBStatus().isLoaded()) continue;
            this.allLoaded = false;
            if (databaseObject.getLoadReadiness() != DatabaseObject.LoadReadiness.YES) continue;
            this.dbUnloaded = true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateGUIComponents();
        } else {
            SwingUtilities.invokeLater(() -> this.updateGUIComponents());
        }
        if (this.allLoaded && !this.databases.isEmpty() && bl) {
            this.printMessageInPanel(Messages.getString("TimesTenGrid.dbLoaded"));
        }
    }

    private void updateGUIComponents() {
        this.enableWizardButtons();
        this.actionBtn.setEnabled(this.dbUnloaded);
        this.model.fireTableDataChanged();
        TableColumnSizer.setColumnsWidthToFit(this._objTable, true, true);
    }

    @Override
    protected void enableWizardButtons() {
        this.dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(this.allLoaded || this.actionBtnClicked));
    }

    private class DatabasesModel
    extends AbstractTableModel {
        private DatabasesModel() {
        }

        @Override
        public int getRowCount() {
            return DatabaseTraversablePanel.this.databases.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == DBColIdx.DATABASE.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getName();
            }
            if (n2 == DBColIdx.READINESS.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getLoadReadiness();
            }
            if (n2 == DBColIdx.STATUS.getValue()) {
                return ((DatabaseObject)DatabaseTraversablePanel.this.databases.get(n)).getDBStatus().getSummary();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    private static enum DBColIdx {
        DATABASE(0),
        READINESS(1),
        STATUS(2);

        private final int value;

        private DBColIdx(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

