/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.feedback.FeedbackManager;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResult;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResultType;
import oracle.jdevimpl.debugger.breakpoint.ConditionEvaluationResultsByThread;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.plugin.evaluator.ExpressionEvaluationException;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugJDIBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint,
ConditionEvaluationResultsByThread {
    protected DebugJDI dj;
    private List<EventRequest> requests;
    private List<DebugJDILocation> locations;
    private String name;
    private boolean enabled;
    private Set<ObjectReference> instanceFilters;
    private String threadname;
    private String threadnameNot;
    private DebugBreakpointCondition condition;
    private int passCount;
    private boolean stop;
    private boolean log;
    private String enableOtherBPs;
    private String disableOtherBPs;
    private int tempDisabled;
    private Map<Long, ConditionEvaluationResultType> evaluationResults = new HashMap<Long, ConditionEvaluationResultType>();
    private Map<Long, String> evaluationMessages = new HashMap<Long, String>();
    private Map<Long, Throwable> evaluationExceptions = new HashMap<Long, Throwable>();
    private List<DebugJDIBreakpoint> parents;
    private DebugJDIBreakpoint child;

    DebugJDIBreakpoint(DebugJDI dj) {
        this.dj = dj;
        this.requests = new ArrayList<EventRequest>();
        this.locations = new ArrayList<DebugJDILocation>();
        this.stop = true;
        this.enabled = true;
        this.instanceFilters = new LinkedHashSet<ObjectReference>();
        this.passCount = 1;
    }

    public void remove() {
        this.prepareForChange();
        if (this.dj != null) {
            this.dj.removeBreakpoint(this);
        }
        if (this.child != null) {
            this.child.removeParent(this);
            if (!this.child.hasAtLeastOneParent() && this.dj != null) {
                this.dj.removeBreakpoint(this.child);
            }
            this.setChild(null);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String threadname) {
        if (threadname != null && threadname.length() == 0) {
            threadname = null;
        }
        this.threadname = threadname;
        if (threadname != null && this.threadnameNot != null) {
            this.threadnameNot = null;
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String threadnameNot) {
        if (threadnameNot != null && threadnameNot.length() == 0) {
            threadnameNot = null;
        }
        this.threadnameNot = threadnameNot;
        if (threadnameNot != null && this.threadname != null) {
            this.threadname = null;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.prepareForChange();
            this.enabled = enabled;
            for (EventRequest request : this.requests) {
                request.setEnabled(enabled);
            }
            this.afterChange();
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String enableOtherBPs) {
        this.enableOtherBPs = enableOtherBPs;
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String disableOtherBPs) {
        this.disableOtherBPs = disableOtherBPs;
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition condition) {
        this.condition = condition;
    }

    public int getPassCount() {
        return this.passCount;
    }

    public void setPassCount(int passCount) {
        this.passCount = passCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceFilter(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            Set<ObjectReference> set = this.instanceFilters;
            synchronized (set) {
                this.instanceFilters.add(or);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            Set<ObjectReference> set = this.instanceFilters;
            synchronized (set) {
                this.instanceFilters.remove(or);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(long uniqueID) {
        Set<ObjectReference> set = this.instanceFilters;
        synchronized (set) {
            for (ObjectReference or : this.instanceFilters) {
                if (or.uniqueID() != uniqueID) continue;
                this.instanceFilters.remove(or);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceFilterSet(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            Set<ObjectReference> set = this.instanceFilters;
            synchronized (set) {
                if (this.instanceFilters.contains(or)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceFilters() {
        Set<ObjectReference> set = this.instanceFilters;
        synchronized (set) {
            long[] array = new long[this.instanceFilters.size()];
            int i = 0;
            Iterator<ObjectReference> it = this.instanceFilters.iterator();
            while (it.hasNext()) {
                array[i++] = it.next().uniqueID();
            }
            return array;
        }
    }

    public DebugLocation[] getLocations() {
        DebugJDILocation[] array = new DebugJDILocation[this.locations.size()];
        return this.locations.toArray(array);
    }

    protected void setOptions(EventRequest er) {
        try {
            er.setSuspendPolicy(2);
            if (this.tempDisabled == 0) {
                er.setEnabled(this.enabled);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    private boolean threadMatches(ThreadReference tr) {
        if (this.threadname != null) {
            return this.threadname.equals(tr.name());
        }
        if (this.threadnameNot != null) {
            return !this.threadnameNot.equals(tr.name());
        }
        return true;
    }

    private boolean conditionSatisfied(Event e, ThreadReference tr) {
        boolean result = true;
        int MAX_RETRIES = 3;
        int retryCount = 0;
        boolean retriable = false;
        do {
            if (this.condition == null) continue;
            this.dj.incrementStoppedCount(false);
            DebugJDIThreadInfo thread = DebugJDIThreadInfo.makeThreadInfo(this.dj, tr);
            DebugStackFrameInfo[] stack = thread.listStack();
            result = this.condition.checkBreakpointCondition((DebugBreakpoint)this, (DebugVirtualMachine)this.dj, (DebugThreadInfo)thread, stack);
            retriable = false;
            ConditionEvaluationResultType resultType = this.evaluationResults.remove(thread.getThreadId());
            if (resultType == ConditionEvaluationResultType.RETRIABLE_EXCEPTION) {
                Throwable t = this.evaluationExceptions.get(thread.getThreadId());
                if (t instanceof ExpressionEvaluationException) {
                    t = t.getCause();
                }
                if (!this.isRetriable(t)) {
                    FeedbackManager.reportException((String)"Exception marked retriable but we don't know how to retry this", (Throwable)t);
                    return false;
                }
                if (retryCount++ < MAX_RETRIES) {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    ++retryCount;
                    retriable = true;
                }
            }
            this.dj.incrementStoppedCount(false);
        } while (retriable);
        return result;
    }

    private boolean isRetriable(Throwable t) {
        return t instanceof InvalidStackFrameException || t instanceof NumberFormatException;
    }

    private boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
            if (this.dj.debugListener != null) {
                this.dj.debugListener.breakpointChanged((DebugBreakpoint)this);
            }
        }
        return this.passCount == 0;
    }

    protected ObjectReference getInstanceForEvent(Event e, ThreadReference tr) {
        if (e instanceof BreakpointEvent) {
            try {
                return tr.frame(0).thisObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean checkConditions(Event e, ThreadReference tr) {
        ObjectReference or;
        if (!this.instanceFilters.isEmpty() && (or = this.getInstanceForEvent(e, tr)) != null && !this.instanceFilters.contains(or)) {
            return false;
        }
        if (!this.threadMatches(tr)) {
            return false;
        }
        if (!this.conditionSatisfied(e, tr)) {
            return false;
        }
        return this.checkPassCount();
    }

    boolean isThisYourEvent(Event e, ThreadReference tr) {
        if (this.enabled) {
            EventRequest er = e.request();
            for (EventRequest request : this.requests) {
                if (!request.equals(er)) continue;
                return this.checkConditions(e, tr);
            }
        }
        return false;
    }

    void prepareForChange() {
        this.dj.breakpointBeforeChange(this);
        for (EventRequest request : this.requests) {
            try {
                request.disable();
                this.dj.erm.deleteEventRequest(request);
            }
            catch (InternalException internalException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
        this.clearRequests();
        this.locations.clear();
    }

    void afterChange() {
        this.dj.breakpointAfterChange(this);
    }

    String getClassPrepareFilter() {
        return null;
    }

    void redefiningClass(ReferenceType rt) {
        int i;
        for (i = this.locations.size() - 1; i >= 0; --i) {
            DebugJDILocation loc = this.locations.get(i);
            DebugJDIClassInfo clazz = (DebugJDIClassInfo)loc.getClassInfo();
            if (clazz.getReferenceType() != rt) continue;
            this.locations.remove(i);
        }
        for (i = this.requests.size() - 1; i >= 0; --i) {
            BreakpointRequest br;
            Location location;
            EventRequest er = this.requests.get(i);
            if (!(er instanceof BreakpointRequest) || (location = (br = (BreakpointRequest)er).location()).declaringType() != rt) continue;
            br.disable();
            this.dj.erm.deleteEventRequest(br);
            this.removeRequest(er);
        }
    }

    boolean verify(ReferenceType rt, String rtName) {
        return false;
    }

    protected void locationIdentified(Location location) {
        DebugJDILocation loc = this.dj.makeLocation(location);
        if (loc != null) {
            this.locations.add(loc);
            BreakpointRequest er = this.dj.erm.createBreakpointRequest(location);
            this.setOptions(er);
            this.addRequest(er);
        }
    }

    protected final void addRequest(EventRequest er) {
        this.dj.addBPRequest(er);
        this.requests.add(er);
    }

    protected final void removeRequest(EventRequest er) {
        this.dj.removeBPRequest(er);
        this.requests.remove(er);
    }

    protected final void clearRequests() {
        for (int i = this.requests.size() - 1; i >= 0; --i) {
            this.dj.removeBPRequest(this.requests.get(i));
        }
        this.requests.clear();
    }

    void tempDisableRequests() {
        if (this.tempDisabled == 0) {
            for (EventRequest request : this.requests) {
                request.disable();
            }
        }
        ++this.tempDisabled;
    }

    void tempReenableRequests() {
        --this.tempDisabled;
        if (this.tempDisabled == 0) {
            for (int i = this.requests.size() - 1; i >= 0; --i) {
                ReferenceType rt;
                EventRequest er = this.requests.get(i);
                boolean collected = false;
                if (er instanceof BreakpointRequest) {
                    BreakpointRequest br = (BreakpointRequest)er;
                    rt = br.location().declaringType();
                    collected = this.dj.isClassCollected(rt);
                } else if (er instanceof ExceptionRequest) {
                    ExceptionRequest xr = (ExceptionRequest)er;
                    rt = xr.exception();
                    collected = this.dj.isClassCollected(rt);
                }
                if (collected) {
                    this.removeRequest(er);
                    continue;
                }
                er.setEnabled(this.enabled);
            }
        }
    }

    public void setBreakpoint() {
    }

    public void changeBreakpoint() {
    }

    public String getLogMessage(DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return null;
    }

    boolean needsVerification() {
        return true;
    }

    void disconnect() {
        this.requests.clear();
        this.locations.clear();
    }

    public ConditionEvaluationResultType getResultType(long threadID) {
        ConditionEvaluationResultType rt = this.evaluationResults.get(threadID);
        return rt == null ? ConditionEvaluationResultType.UNAVAILABLE : rt;
    }

    public String getMessage(long threadID) {
        return this.evaluationMessages.get(threadID);
    }

    public void setResultType(long threadID, ConditionEvaluationResultType resultType) {
        this.evaluationResults.put(threadID, resultType);
    }

    public void setMessage(long threadID, String message) {
        this.evaluationMessages.put(threadID, message);
    }

    public Throwable getException(long threadID) {
        return this.evaluationExceptions.get(threadID);
    }

    public void setException(long threadID, Throwable cause) {
        this.evaluationExceptions.put(threadID, cause);
    }

    public void clearResults(long threadID) {
        this.evaluationResults.remove(threadID);
        this.evaluationMessages.remove(threadID);
        this.evaluationExceptions.remove(threadID);
    }

    public void clearAllResults() {
        this.evaluationResults.clear();
        this.evaluationMessages.clear();
        this.evaluationExceptions.clear();
    }

    public void addResult(long threadID, ConditionEvaluationResult result) {
        this.setResultType(threadID, result.getResultType());
        this.setMessage(threadID, result.getMessage());
        this.setException(threadID, result.getException());
    }

    public void addParent(DebugJDIBreakpoint parent) {
        if (this.parents == null) {
            this.parents = new ArrayList<DebugJDIBreakpoint>();
        }
        this.parents.add(parent);
    }

    public void removeParent(DebugJDIBreakpoint parent) {
        assert (this.parents != null);
        this.parents.remove((Object)parent);
    }

    public boolean hasAtLeastOneParent() {
        return this.parents != null && this.parents.size() > 0;
    }

    public List<DebugJDIBreakpoint> getParents() {
        return this.parents;
    }

    public void setChild(DebugJDIBreakpoint child) {
        this.child = child;
    }

    public DebugJDIBreakpoint getChild() {
        return this.child;
    }
}

