/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.db2;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.db2.DB2BasicPanel;
import oracle.dbtools.thirdparty.db2.DB2BrowserAddin;
import oracle.ide.util.ResourceUtils;

public class DB2ConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = -9116356172775367840L;
    private DB2BasicPanel m_basicPanel;
    private JPanel m_panel;
    private CardLayout m_layout;
    public static final String HOST = "localhost";
    public static final String PORT = "50000";

    public DB2ConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this.m_basicPanel = new DB2BasicPanel(this);
        this.m_layout = new CardLayout(0, 0);
        this.m_panel = new JPanel(this.m_layout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this.m_panel.add((Component)this.m_basicPanel, "Basic");
        this.add(this.m_panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.m_layout.show(this.m_panel, "Basic");
    }

    private CDComponentView getPanel() {
        return this.m_basicPanel;
    }

    public void clear() {
        this.m_basicPanel.clear();
    }

    public String getConnectionType() {
        return "DB2";
    }

    public String getDriver() {
        return this.m_basicPanel.getDriver();
    }

    public String[] getSupportedDrivers() {
        return new String[]{"com.ibm.db2.jcc.DB2Driver", "com.ibm.as400.access.AS400JDBCDriver"};
    }

    public void setDefaultPrompts() {
        this.m_basicPanel.setDefaultPrompts();
    }

    public void updatePrompts(Properties properties) {
        this.m_basicPanel.updatePrompts(properties);
        properties.setProperty("ConnName", this.getConnectionName());
        properties.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
    }

    protected Properties getInput(Properties properties) {
        properties.setProperty("subtype", DB2BrowserAddin.SUBTYPE_DB2);
        properties.setProperty("RaptorConnectionType", DB2BrowserAddin.SUBTYPE_DB2);
        properties.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.generateProperties(properties);
        return properties;
    }
}

