/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sybase;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.connections.AuthenticationPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sybase.BasicPanel;
import oracle.dbtools.thirdparty.sybase.SybaseAuthenticationPanel;
import oracle.dbtools.thirdparty.sybase.SybaseBrowserAddin;
import oracle.ide.util.ResourceUtils;

public class SybaseConnectionPanel
extends IConnectionPanel {
    static final boolean OS_WINDOWS = PlatformUtils.isWindows();
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private BasicPanel _basicPanel;
    private CardLayout _layout;
    public static final String DRIVER_CLASSNAME = "net.sourceforge.jtds.jdbc.Driver";
    public static final String HOST = "localhost";
    public static final String PORT = "5000";
    public static String SYBASE_WINDOWS_AUTHENTICATION = "sybase_windows_authentication";
    public static String SYBASE_DEFAULT_PASSWORD = "sybase_default_password";
    public static String SYBASE_DOMAIN = "sybase_domain";

    public SybaseConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._basicPanel = this.createBasicPanel();
        this._basicPanel.init(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this._panel.add((Component)this._basicPanel, "Basic");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._layout.show(this._panel, "Basic");
    }

    protected BasicPanel createBasicPanel() {
        return new BasicPanel();
    }

    protected Properties getInput(Properties properties) {
        properties.putAll((Map<?, ?>)this.getAuthenticationPanel().getConnectionDetails());
        properties.setProperty("subtype", this.getConnectionSubtype());
        properties.setProperty("driver", this.getDriver());
        properties.setProperty("RaptorConnectionType", this.getConnectionType());
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.generateProperties(properties);
        return properties;
    }

    protected String getConnectionSubtype() {
        return SybaseBrowserAddin.SUBTYPE_SYBASE;
    }

    private CDComponentView getPanel() {
        return this._basicPanel;
    }

    public void clear() {
        this.getAuthenticationPanel().clear();
        this._basicPanel.clear();
    }

    public void updatePrompts(Properties properties) {
        this.getAuthenticationPanel().setConnectionDetails(properties);
        this._basicPanel.updatePrompts(properties);
        properties.setProperty("ConnName", this.getConnectionName());
        this._basicPanel.retrieveDatabase(properties);
    }

    public String getDriver() {
        return DRIVER_CLASSNAME;
    }

    public void setDefaultPrompts() {
        this.getAuthenticationPanel().initializeToDefaults();
        this._basicPanel.setDefaultPrompts();
    }

    public String getConnectionType() {
        return "Sybase";
    }

    protected AuthenticationPanel createAuthenticationPanel() {
        return new SybaseAuthenticationPanel();
    }

    Properties getAuthenticationProperties() {
        return this.getAuthenticationPanel().getConnectionDetails();
    }
}

