/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.util.XMLDOMParser;

public class BuiltinStyles {
    public static String highlightColorStyleName = "HILIGHT_COLOR";
    public static Style highlightColorStyle = new StyleColor(new Color(255, 255, 0, 138), Color.gray);
    public static String invisibleColorStyleName = "NULL_STYLE";
    public static Style invisibleColorStyle = new StyleColor(new Color(255, 255, 255, 0));
    public static String blackLineStyleName = "BLACK_LINE";
    public static Style blackLineStyle = null;
    public static String pointClusterStyleName = "DEFAULT_POINT_CLUSTER_STYLE";
    public static Style circleMarkerStyle = BuiltinStyles.createCircleMarkerStyle();
    public static String circleMarkerStyleName = "PINK_CIRCLE_MARKER";

    private static Style createCircleMarkerStyle() {
        String markerStyleXML = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n    <desc/>\n    <g class=\"marker\" style=\"stroke:#3333FF;fill:#FF6666;width:15;height:15;font-family:Dialog;font-size:12;font-fill:#FF0000\">\n        <circle cx=\"0\" cy=\"0\" r=\"0\"/>\n  </g>\n</svg>\n";
        return StyleFactory.createStyleFromXML(markerStyleXML);
    }

    public static VariableMarkerStyle getPointClusterStyle() throws DataException {
        String xml = "<?xml version=\"1.0\" ?>\n<AdvancedStyle>\n  <VariableMarkerStyle basemarker=\"" + circleMarkerStyleName + "\" startsize=\"18\" increment=\"4\">\n" + "    <Buckets>\n" + "       <RangedBucket seq=\"0\" label=\"0 - 10\" low=\"0\" high=\"10\"/>\n" + "       <RangedBucket seq=\"1\" label=\"10-50\" low=\"10\" high=\"50\"/>\n" + "       <RangedBucket seq=\"2\" label=\"50-100\" low=\"50\" high=\"100\"/>\n" + "       <RangedBucket seq=\"3\" label=\"100-500\" low=\"100\" high=\"500\"/>\n" + "       <RangedBucket seq=\"4\" label=\"500-1000\" low=\"500\" high=\"1000\"/>\n" + "       <RangedBucket seq=\"5\" label=\"1000-\" low=\"1000\" high=\"Infinity\"/>\n" + "    </Buckets>\n" + "   </VariableMarkerStyle>\n" + "</AdvancedStyle>\n";
        return (VariableMarkerStyle)StyleFactory.createAdvancedStyle(XMLDOMParser.parseToDoc(xml));
    }

    static {
        LineStyleModel m = new LineStyleModel();
        m.setName("BLACK_LINE");
        m.setCenterLineWidth(1.0f);
        m.setCenterLineColor(Color.black);
        blackLineStyle = new StyleLine(m);
    }
}

