/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.impl;

import java.util.Iterator;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StackTraceIterator
implements Iterator<StackTraceElement> {
    private static final boolean JLA_AVAILABLE = StackTraceIterator.initJLACheck();
    private final Throwable t = new Throwable();
    private final int elemLen;
    private final Object jla;
    private final StackTraceElement[] elems;
    private int curr = 0;

    private static boolean initJLACheck() {
        boolean jla = false;
        try {
            JavaLangAccess j = SharedSecrets.getJavaLangAccess();
            int len = j.getStackTraceDepth(new Throwable());
            jla = len > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jla;
    }

    public StackTraceIterator() {
        StackTraceElement[] el = null;
        int elLen = -1;
        JavaLangAccess jl = null;
        if (JLA_AVAILABLE) {
            try {
                JavaLangAccess j = SharedSecrets.getJavaLangAccess();
                elLen = j.getStackTraceDepth(this.t);
                jl = j;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (elLen == -1 || jl == null) {
            el = this.t.getStackTrace();
            elLen = el.length;
        }
        this.elemLen = elLen;
        this.elems = el;
        this.jla = jl;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.elemLen;
    }

    @Override
    public StackTraceElement next() {
        if (this.jla != null) {
            return ((JavaLangAccess)this.jla).getStackTraceElement(this.t, this.curr++);
        }
        return this.elems[this.curr++];
    }
}

