/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.common.impl.StackTraceAnalyzer;
import oracle.adf.share.logging.ADFLogger;

public abstract class ADFLoggerExtension {
    protected static final String[] BEGIN_KEYS = new String[]{"Component", "ADF_MESSAGE_CONTEXT_DATA", "ADF_MESSAGE_ACTION_NAME", "ADF_MESSAGE_ACTION_DESC", "ADF_MESSAGE_STATUS", "ADF_MESSAGE_DEFAULT_CONTEXT_DATA"};
    protected static final String[] END_KEYS = new String[]{"ADF_MESSAGE_STATUS", "ADF_MESSAGE_ACTION_NAME"};
    protected static final String[] RELATIVE_KEYS = new String[]{"ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID"};
    protected static final String[] ADD_MESSAGE_KEYS = new String[]{"Component", "ADF_MESSAGE_CONTEXT_DATA", "ADF_MESSAGE_ACTION_NAME", "ADF_MESSAGE_STATUS"};

    public abstract Logger getLogger(String var1, String var2);

    protected LogRecord createLogRecord(Level level, String msg, String loggerClassName) {
        LogRecord rec = new LogRecord(level, msg);
        this.setSourceNames(rec, loggerClassName);
        return rec;
    }

    protected void setSupplAttributes(LogRecord rec, Map<String, String> cntx) {
    }

    protected void unsetSupplAttributes(LogRecord rec, Map<String, String> cntx, String[] keys) {
    }

    protected void encodeContextData(Map<String, String> cntx, Map<String, String> contextData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(ADFLogger inst, Level level, String actionName, Map<String, String> contextData) {
        if (actionName == null) {
            return;
        }
        Logger logger = inst.getLogger();
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        Map<String, String> cntx = this.prepareBeginContext(logger, actionName, contextData, rec);
        try {
            this.setSupplAttributes(rec, cntx);
            logger.log(rec);
        }
        finally {
            this.unsetSupplAttributes(rec, cntx, BEGIN_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ADFLogger inst, Level level, String actionName) {
        Logger logger = inst.getLogger();
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        HashMap<String, String> cntx = new HashMap<String, String>();
        cntx.put("ADF_MESSAGE_STATUS", "end");
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        try {
            this.setSupplAttributes(rec, cntx);
            logger.log(rec);
        }
        finally {
            this.unsetSupplAttributes(rec, cntx, END_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRelativeADFRequest(ADFLogger inst, String parentEcid) {
        Logger logger = inst.getLogger();
        if (!logger.isLoggable(Level.CONFIG)) {
            return;
        }
        LogRecord rec = this.createLogRecord(Level.CONFIG, "Secondary ADF Request", inst.getClass().getName());
        HashMap<String, String> cntx = new HashMap<String, String>();
        cntx.put("ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID");
        cntx.put("PARENT_REQUEST_ECID", parentEcid);
        try {
            this.setSupplAttributes(rec, cntx);
            logger.log(rec);
        }
        finally {
            this.unsetSupplAttributes(rec, cntx, RELATIVE_KEYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageToRequest(ADFLogger inst, Level level, String actionName, Map<String, String> contextData, String messageTag, Throwable thrown) {
        Logger logger = inst.getLogger();
        if (!logger.isLoggable(level)) {
            return;
        }
        LogRecord rec = this.createLogRecord(level, actionName, inst.getClass().getName());
        Map<String, String> cntx = this.prepareMessageContext(contextData, actionName, messageTag, rec);
        rec.setThrown(thrown);
        try {
            this.setSupplAttributes(rec, cntx);
            logger.log(rec);
        }
        finally {
            this.unsetSupplAttributes(rec, cntx, ADD_MESSAGE_KEYS);
        }
    }

    protected Map<String, String> prepareBeginContext(Logger logger, String actionName, Map<String, String> contextData, LogRecord rec) {
        ResourceBundle rb = logger.getResourceBundle();
        String actionDesc = "";
        String disCol = "";
        String disColValue = "";
        if (rb != null) {
            String actionNamePrefix = actionName.trim().replace(' ', '_');
            try {
                actionDesc = rb.getString(actionNamePrefix + "_DESC");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                String val;
                disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                String string = val = contextData != null ? contextData.get(disCol) : null;
                if (val != null) {
                    disColValue = val;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !contextData.containsKey("Component")) {
            cntx.put("Component", rec.getSourceClassName());
        }
        this.encodeContextData(cntx, contextData);
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_ACTION_DESC", actionDesc);
        cntx.put("ADF_MESSAGE_STATUS", "begin");
        if (disCol != null && disCol.trim().length() > 0) {
            cntx.put("ADF_MESSAGE_DEFAULT_CONTEXT_DATA", disCol + "=" + disColValue);
        }
        return cntx;
    }

    protected Map<String, String> prepareMessageContext(Map<String, String> contextData, String actionName, String messageTag, LogRecord rec) {
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !contextData.containsKey("Component")) {
            cntx.put("Component", rec.getSourceClassName());
        }
        this.encodeContextData(cntx, contextData);
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_STATUS", messageTag);
        return cntx;
    }

    protected void setSourceNames(LogRecord rec, String loggerClassName) {
        String finalLoggerClassName;
        StackTraceElement el;
        if (loggerClassName == null) {
            loggerClassName = "oracle.adf.share.logging.ADFLogger";
        }
        if ((el = new StackTraceAnalyzer().getCallerFrame(new StackTraceAnalyzer.StackTraceElementChecker(finalLoggerClassName = loggerClassName){
            final /* synthetic */ String val$finalLoggerClassName;
            {
                this.val$finalLoggerClassName = string;
            }

            @Override
            public boolean isRelevantFrame(StackTraceElement se) {
                return se.getClassName().equals(this.val$finalLoggerClassName);
            }
        }, new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement se) {
                String cnam = se.getClassName();
                return cnam.equals(finalLoggerClassName) || cnam.contains(".reflect.");
            }
        })) != null) {
            rec.setSourceClassName(el.getClassName());
            rec.setSourceMethodName(el.getMethodName());
        }
    }
}

