/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.ADFLoggerExtension;
import oracle.adf.share.logging.ADFLoggerUtil;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

class ADFLoggerExtensionODL
extends ADFLoggerExtension {
    private static final String MY_CLASS = "oracle.adf.share.logging.ADFLoggerExtensionODL";

    ADFLoggerExtensionODL() {
    }

    @Override
    public Logger getLogger(String name, String bundleName) {
        if (bundleName != null) {
            return ODLLogger.getLogger((String)name, (String)bundleName);
        }
        return ODLLogger.getLogger((String)name);
    }

    @Override
    protected LogRecord createLogRecord(Level level, String msg, String loggerClassName) {
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        this.setSourceNames((LogRecord)rec, loggerClassName);
        return rec;
    }

    @Override
    protected void encodeContextData(Map<String, String> cntx, Map<String, String> contextData) {
        String ctxData = ADFLoggerUtil.convertContextDataMap(contextData);
        if (ctxData.length() > 0) {
            cntx.put("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
    }

    @Override
    protected void setSupplAttributes(LogRecord rec, Map<String, String> cntx) {
        if (rec != null) {
            ((ODLLogRecord)rec).setSupplAttributes(cntx);
        }
        if (SingletonRegistration.initialized) {
            ExecutionContext ec = ExecutionContext.get();
            for (Map.Entry<String, String> ent : cntx.entrySet()) {
                ec.setValue(ent.getKey(), ent.getValue());
            }
        }
    }

    @Override
    protected void unsetSupplAttributes(LogRecord rec, Map<String, String> cntx, String[] keys) {
        if (rec != null) {
            ((ODLLogRecord)rec).setSupplAttributes(null);
        }
        if (SingletonRegistration.initialized) {
            ExecutionContext ec = ExecutionContext.get();
            for (String ent : cntx.keySet()) {
                ec.setValue(ent, null);
            }
        }
    }

    private static boolean initSupplementalAttributes() {
        try {
            DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_CONTEXT_DATA", (int)1);
            DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_ACTION_NAME", (int)1);
            DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_ACTION_DESC", (int)1);
            DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_STATUS", (int)1);
            DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_DEFAULT_CONTEXT_DATA", (int)1);
            DMSContextManager.setKeyAttribute((String)"PARENT_REQUEST_ECID", (int)1);
            DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_NAME", (int)1);
            DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_MODE", (int)1);
            DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_USER_ID", (int)1);
            DMSContextManager.setKeyAttribute((String)"Component", (int)1);
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(MY_CLASS).log(Level.WARNING, "SupplementalAttribute registration failed", e);
            return false;
        }
    }

    static /* synthetic */ boolean access$000() {
        return ADFLoggerExtensionODL.initSupplementalAttributes();
    }

    private static class SingletonRegistration {
        static final boolean initialized = ADFLoggerExtensionODL.access$000();

        private SingletonRegistration() {
        }
    }
}

