/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.metrics;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.internal.perf.BridgedMetricFactory;
import oracle.adf.share.metrics.Counter;
import oracle.adf.share.metrics.Metric;
import oracle.adf.share.metrics.StateTracker;
import oracle.adf.share.metrics.Timer;
import oracle.adf.share.platform.AdfServerPlatformUtil;

public class MetricFactory {
    protected MetricFactory() {
    }

    protected boolean isActive(Level level) {
        return Metric.LevelHolder.INST.isLoggable(level);
    }

    public Counter createCounter(Level level, String groupName, String name, String type, String desc) {
        return Counter.DUMMY_COUNTER;
    }

    public Timer createTimer(Level level, String groupName, String name, String type, String desc) {
        return Timer.DUMMY_TIMER;
    }

    public StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc) {
        return StateTracker.DUMMY_STATE_TRACKER;
    }

    public void removeApplicationMetrics(String ... removeStrs) {
    }

    private static MetricFactory initMetricFactory() {
        MetricFactory mf;
        block5: {
            block4: {
                mf = null;
                try {
                    String cn = MetricFactory.getSecuredProperty("oracle.adf.metrics.factoryclass");
                    if (cn == null || cn.trim().length() <= 0 || (mf = MetricFactory.loadFactoryClass(cn)) == null) break block4;
                    MetricFactory metricFactory = mf;
                    System.out.println("Initialized " + mf);
                    return metricFactory;
                }
                catch (Throwable throwable) {
                    System.out.println("Initialized " + mf);
                    throw throwable;
                }
            }
            if (!AdfServerPlatformUtil.isMicroServicePlatform() || (mf = MetricFactory.loadFactoryClass("oracle.ramp.helidon.metrics.HelidonMetricFactory")) == null) break block5;
            MetricFactory metricFactory = mf;
            System.out.println("Initialized " + mf);
            return metricFactory;
        }
        mf = new BridgedMetricFactory();
        System.out.println("Initialized " + mf);
        return mf;
    }

    private static String getSecuredProperty(final String propName) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(propName);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propName);
                }
            });
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static MetricFactory loadFactoryClass(String cn) {
        try {
            ClassLoader cl = ClassUtils.getClassLoader(Metric.class);
            if (cl.getResource(cn.replace('.', '/') + ".class") != null) {
                return (MetricFactory)ClassUtils.forName(cn, Metric.class).newInstance();
            }
        }
        catch (Throwable t) {
            Metric.LevelHolder.INST.log(Level.FINE, cn, t);
        }
        return null;
    }

    static /* synthetic */ MetricFactory access$000() {
        return MetricFactory.initMetricFactory();
    }

    protected static class FactoryHolder {
        public static final MetricFactory INST = MetricFactory.access$000();

        protected FactoryHolder() {
        }
    }
}

