/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.metrics;

import java.util.logging.Level;
import oracle.adf.share.metrics.Metric;
import oracle.adf.share.metrics.MetricFactory;

public abstract class StateTracker
extends Metric {
    public static final byte DOUBLE = 1;
    public static final byte INTEGER = 3;
    public static final byte LONG = 2;
    public static final byte OBJECT = 5;
    public static final StateTracker DUMMY_STATE_TRACKER = new DummyStateTracker();

    protected StateTracker(Level level, String fullName) {
        super(level, fullName);
    }

    public void increment(long increasedAmount) {
    }

    public void increment(int increasedAmount) {
    }

    public void increment(double increasedAmount) {
    }

    public void update(long newValue) {
    }

    public void update(int newValue) {
    }

    public void update(double newValue) {
    }

    public void update(Object newValue) {
    }

    protected abstract Object getClonedValue();

    public static StateTracker createStateTracker(Level level, String groupName, String name, byte valueType, String unit, String desc) {
        return MetricFactory.FactoryHolder.INST.createStateTracker(level, groupName, name, null, valueType, unit, desc);
    }

    public static StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc) {
        return MetricFactory.FactoryHolder.INST.createStateTracker(level, groupName, name, type, valueType, unit, desc);
    }

    private static class DummyStateTracker
    extends StateTracker {
        private static final String sName = "Dummy State Tracker";

        public DummyStateTracker() {
            super(Level.ALL, sName);
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public String toString() {
            return sName;
        }

        @Override
        public Object getClonedValue() {
            return null;
        }
    }
}

