/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.mt.util;

import java.beans.Beans;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.mt.util.CloudHelperJRF;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adfinternal.share.release.ReleaseAdapter;

class CloudHelper {
    private static final Logger logger = Logger.getLogger(CloudHelper.class.getName());

    private CloudHelper() {
    }

    public static boolean isMultitenancySupportable() {
        return SingletonHolder.mtSupportable;
    }

    public static Object getTenantKeyOrThrow() {
        Object uuid = SingletonHolder.jrfHelper.getServiceUUID();
        if (uuid == null) {
            throw new NullPointerException("ServiceUUID");
        }
        return uuid;
    }

    public static Object getPartitionKeyOrThrow() {
        String pn = SingletonHolder.jrfHelper.getPartitionName();
        if (pn == null || pn.isEmpty()) {
            if (SingletonHolder.isWebLogic) {
                throw new NullPointerException("PartitionName");
            }
            return "DOMAIN";
        }
        return pn;
    }

    static boolean isWebLogic() {
        return SingletonHolder.isWebLogic;
    }

    private static class SingletonHolder {
        static final boolean isWebLogic;
        private static final CloudHelperJRF jrfHelper;
        private static final boolean mtSupportable;

        private SingletonHolder() {
        }

        static {
            CloudHelperJRF ret;
            block9: {
                isWebLogic = AdfServerPlatformUtil.isWebLogicJRF();
                ret = null;
                try {
                    if (ReleaseAdapter.getInstance().supportsMT() && !Beans.isDesignTime() && !AdfServerPlatformUtil.isWebLogicCore()) {
                        if (ClassUtils.getClassLoader(CloudHelper.class).getResource("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class") == null) {
                            throw new ClassNotFoundException("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class");
                        }
                        ret = new CloudHelperJRF();
                        if (ret.getServiceUUID() == null) {
                            throw new IllegalStateException("ServiceUUID");
                        }
                        String partName = ret.getPartitionName();
                        if ((partName == null || partName.isEmpty()) && isWebLogic) {
                            throw new IllegalStateException("PartitionName");
                        }
                    }
                }
                catch (Throwable t) {
                    ret = null;
                    String plat = AdfServerPlatformUtil.getInternalPlatformName();
                    if (isWebLogic) {
                        if (logger.isLoggable(AdfServerPlatformUtil.INCIDENT_ERROR)) {
                            logger.log(AdfServerPlatformUtil.INCIDENT_ERROR, "Multi-Tenancy support failed on " + plat, t);
                        }
                    }
                    if (!logger.isLoggable(Level.CONFIG)) break block9;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Multi-Tenancy support not loaded on " + plat + "\nFINEST level, DIAGNOSTIC AID, NOT AN ERROR", t);
                    }
                    logger.config("Multi-Tenancy support not loaded on " + plat);
                }
            }
            jrfHelper = ret;
            mtSupportable = ret != null;
        }
    }
}

