/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;
import oracle.javatools.annotations.Concealed;

public class AdfServerPlatformUtil {
    private static final String CLASS_NAME = "oracle.adf.share.platform.AdfServerPlatformUtil";
    private static final Logger logger = Logger.getLogger("oracle.adf.share.platform.AdfServerPlatformUtil");
    private static final String CONFIG_HELPER_CLASS = "oracle.adfinternal.share.platform.app.PlatformConfigHelper";
    private static final String CONFIG_HELPER_RESOURCE = "oracle.adfinternal.share.platform.app.PlatformConfigHelper".replace('.', '/') + ".class";
    private static final String VBCS_NO_MDS_MARKER = "META-INF/oracle.adfinternal.share.appspecific.nomds.properties";
    public static final Level INCIDENT_ERROR = SingletonHolder.access$1100();

    public static boolean isWebLogic() {
        return SingletonHolder.isWebLogic;
    }

    public static boolean isWebLogicJRF() {
        return SingletonHolder.isWebLogic;
    }

    public static boolean isWebLogicCore() {
        return SingletonHolder.isWebLogicCore;
    }

    @Deprecated
    public static boolean isWebSphere() {
        return SingletonHolder.isWebSphere;
    }

    @Deprecated
    public static boolean isWebSphereND() {
        return SingletonHolder.isWebSphereND;
    }

    @Deprecated
    public static boolean isWebSphereAS() {
        return SingletonHolder.isWebSphereAS;
    }

    @Deprecated
    public static boolean isJBoss() {
        return SingletonHolder.isJBoss;
    }

    public static boolean isJEE() {
        return SingletonHolder.isJEE;
    }

    public static boolean isGlassFish() {
        return SingletonHolder.isGlassfish;
    }

    public static boolean isTomcat() {
        return SingletonHolder.isTomcat;
    }

    public static boolean isMicroServicePlatform() {
        return SingletonHolder.isMicroServicePlatform;
    }

    @Concealed
    public static String getInternalPlatformName() {
        return SingletonHolder.platName;
    }

    private static Class loadOracleChecksum(ClassLoader cl) throws Exception {
        Class<?> clazz = null;
        try {
            if (cl != null) {
                clazz = Class.forName("oracle.security.misc.Checksum", true, cl);
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            clazz = AdfServerPlatformUtil.loadOracleChecksum(cl.getParent());
        }
        return clazz;
    }

    public static byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        Class clazz;
        if (data == null) {
            return new byte[0];
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((clazz = AdfServerPlatformUtil.loadOracleChecksum(AdfServerPlatformUtil.getThreadContextClassLoader())) == null) {
            return new byte[0];
        }
        Method checkSumMethod = null;
        if (algorithm.toUpperCase().equals("MD5")) {
            checkSumMethod = clazz.getMethod("MD5", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("SHA")) {
            checkSumMethod = clazz.getMethod("SHA", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("MD2")) {
            checkSumMethod = clazz.getMethod("MD2", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else if (algorithm.toUpperCase().equals("MD4")) {
            checkSumMethod = clazz.getMethod("MD4", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else {
            ResourceBundle platformRes = ResourceBundle.getBundle(ADFPlatformMessageBundle.class.getName());
            throw new NoSuchAlgorithmException(algorithm + " " + platformRes.getString("CHECKSUM_ALGORITHM_NOT_SUPPORTED"));
        }
        return new byte[0];
    }

    public static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    public static String setSystemProperty(final String name, final String value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static String clearSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.clearProperty(name);
            }
        });
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static boolean isODLAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "odl");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform odl=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isODLAvailable;
    }

    public static boolean isDMS4LoggingAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "dms4log");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform dms4log=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isDMS4LoggingAvailable;
    }

    public static boolean isDMSAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "dms");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform dms=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isDMSAvailable;
    }

    public static boolean isMDSAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "mds");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform mds=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isMDSAvailable;
    }

    public static boolean isJRFAvailable() {
        return SingletonHolder.isJRFAvailable;
    }

    public static boolean isDFWAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "dfw");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform dfw=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isDFWAvailable;
    }

    private static Map<String, String> getPlatformConfigMap() {
        return null;
    }

    private static boolean isClassAvailable(String cn) {
        String RES_NAME = cn.endsWith(".class") ? cn : cn.replace('.', '/') + ".class";
        return ClassUtils.getClassLoader(AdfServerPlatformUtil.class).getResource(RES_NAME) != null;
    }

    private static Boolean isPlatformFeatureEnabled(Map<String, String> m, String feat) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        String en = m.get(feat + "_enabled");
        if (en != null) {
            return Boolean.parseBoolean(en);
        }
        en = m.get("default_enabled");
        if (en != null) {
            return Boolean.parseBoolean(en);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final Level INCIDENT_ERROR;
        private static final boolean isODLAvailable;
        private static final boolean isDMSAvailable;
        private static final boolean isDMS4LoggingAvailable;
        private static final boolean isJRFAvailable;
        private static final boolean isMDSAvailable;
        private static final boolean isDFWAvailable;
        private static final boolean isWebLogic;
        private static final boolean isWebLogicCore;
        private static final boolean isWebSphere;
        private static final boolean isWebSphereND;
        private static final boolean isWebSphereAS;
        private static final boolean isJBoss;
        private static final boolean isGlassfish;
        private static final boolean isTomcat;
        private static final boolean isGrizzly;
        private static final boolean isMicroServicePlatform;
        private static final boolean isJEE;
        private static final String platName;

        private SingletonHolder() {
        }

        private static boolean isNDClassCheck() {
            String cn = "oracle.jrf.was.WasServerPlatformSupport";
            try {
                Class c = ClassUtils.forName("oracle.jrf.was.WasServerPlatformSupport", AdfServerPlatformUtil.class);
                Method method = c.getMethod("isND", new Class[0]);
                Boolean ret = (Boolean)method.invoke(null, new Object[0]);
                return ret;
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.CONFIG)) {
                    boolean FINE = logger.isLoggable(Level.FINE);
                    logger.log(Level.CONFIG, FINE ? "oracle.jrf.was.WasServerPlatformSupport" : "" + t, FINE ? t : null);
                }
                return false;
            }
        }

        private static boolean initMDSAvailable(Map<String, Object> props) {
            String adfmMds = (String)props.get("oracle.adfm.usemds");
            String jboMds = (String)props.get("oracle.jbo.usemds");
            if ("false".equalsIgnoreCase(adfmMds) || "false".equalsIgnoreCase(jboMds)) {
                return false;
            }
            if ("true".equalsIgnoreCase(adfmMds) || "true".equalsIgnoreCase(jboMds)) {
                return true;
            }
            if (isWebLogicCore) {
                return false;
            }
            if (!AdfServerPlatformUtil.isClassAvailable("oracle/mds/core/MDSInstance.class")) {
                return false;
            }
            return ClassUtils.getClassLoader(AdfServerPlatformUtil.class).getResource(AdfServerPlatformUtil.VBCS_NO_MDS_MARKER) == null;
        }

        private static void logSystemProperties() {
            if (System.getSecurityManager() == null) {
                SingletonHolder.internalLogSystemProperties();
            } else {
                AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        SingletonHolder.internalLogSystemProperties();
                        return null;
                    }
                });
            }
        }

        private static void internalLogSystemProperties() {
            Set<Map.Entry<Object, Object>> ents = System.getProperties().entrySet();
            Map.Entry[] entArr = ents.toArray(new Map.Entry[0]);
            Arrays.sort(entArr, new Comparator<Map.Entry>(){

                @Override
                public int compare(Map.Entry o1, Map.Entry o2) {
                    return String.valueOf(o1.getKey()).compareToIgnoreCase(String.valueOf(o2.getKey()));
                }
            });
            StringBuilder buf = new StringBuilder(entArr.length * 100);
            for (Map.Entry ent : entArr) {
                buf.append(ent.getKey() + "=" + ent.getValue() + "\n");
            }
            new Throwable("STARTUP - DIAGNOSTIC STACK").printStackTrace();
            System.out.println("STARTUP - SYSTEM PROPERTIES");
            System.out.println(buf.toString());
        }

        private static void dumpInitedState() {
            StringBuilder buf = new StringBuilder();
            buf.append("STARTUP - INITED STATE\n");
            buf.append("isODLAvailable=" + isODLAvailable);
            buf.append(", isDMSAvailable=" + isDMSAvailable);
            buf.append(", isDMS4LoggingAvailable=" + isDMS4LoggingAvailable);
            buf.append(", isJRFAvailable=" + isJRFAvailable);
            buf.append(", isMDSAvailable=" + isMDSAvailable);
            buf.append(", isDFWAvailable=" + isDFWAvailable);
            buf.append(", isJEE=" + isJEE);
            buf.append(", platName=" + platName);
            buf.append(", isWebLogic=" + isWebLogic);
            buf.append(", isWebLogicCore=" + isWebLogicCore);
            buf.append(", isWebSphere=" + isWebSphere);
            buf.append(", isWebSphereND=" + isWebSphereND);
            buf.append(", isWebSphereAS=" + isWebSphereAS);
            buf.append(", isJBoss=" + isJBoss);
            buf.append(", isGlassfish=" + isGlassfish);
            buf.append(", isTomcat=" + isTomcat);
            buf.append(", isGrizzly=" + isGrizzly);
            buf.append(", isMicroServicePlatform=" + isMicroServicePlatform);
            System.out.println(buf.toString());
        }

        static /* synthetic */ Level access$1100() {
            return INCIDENT_ERROR;
        }

        static {
            boolean localIsJee;
            boolean gfVersion;
            Level level;
            boolean STARTUP_LOGGABLE;
            block9: {
                STARTUP_LOGGABLE = Logger.getLogger("oracle.adf.share.platform.AdfServerPlatformUtil.startup").isLoggable(Level.FINE);
                if (STARTUP_LOGGABLE) {
                    SingletonHolder.logSystemProperties();
                }
                level = null;
                if (AdfServerPlatformUtil.isClassAvailable("oracle/core/ojdl/logging/ODLLevel.class")) {
                    String cn = "oracle.core.ojdl.logging.ODLLevel";
                    try {
                        Class c = ClassUtils.forName("oracle.core.ojdl.logging.ODLLevel", AdfServerPlatformUtil.class);
                        Field f = c.getDeclaredField("INCIDENT_ERROR");
                        level = (Level)f.get(null);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.CONFIG)) break block9;
                        boolean FINE = logger.isLoggable(Level.FINE);
                        logger.log(Level.CONFIG, FINE ? "oracle.core.ojdl.logging.ODLLevel" : "" + t, FINE ? t : null);
                    }
                }
            }
            isODLAvailable = level != null;
            INCIDENT_ERROR = level != null ? level : Level.parse(String.valueOf(Level.SEVERE.intValue() + 100));
            isDFWAvailable = AdfServerPlatformUtil.isClassAvailable("oracle/dfw/dump/ComponentDiagnosticDump.class");
            Map<String, Object> props = System.getSecurityManager() == null ? new InitAction().run() : AccessController.doPrivileged(new InitAction());
            boolean isWebLogicName = props.get("weblogic.Name") != null;
            isJRFAvailable = props.get("common.components.home") != null;
            isWebLogic = isWebLogicName && isJRFAvailable;
            isWebLogicCore = isWebLogicName && !isJRFAvailable;
            isDMSAvailable = AdfServerPlatformUtil.isClassAvailable("oracle/dms/instrument/EventIntf.class") && AdfServerPlatformUtil.isClassAvailable("oracle/dms/instrument/SegregationType.class");
            isDMS4LoggingAvailable = AdfServerPlatformUtil.isClassAvailable("oracle/dms/context/ExecutionContext.class");
            isMDSAvailable = SingletonHolder.initMDSAvailable(props);
            boolean bl = isWebSphere = props.get("was.install.root") != null || props.get("server.root") != null;
            if (isWebSphere) {
                boolean nd;
                isWebSphereND = nd = SingletonHolder.isNDClassCheck();
                isWebSphereAS = !nd;
            } else {
                isWebSphereND = false;
                isWebSphereAS = false;
            }
            boolean bl2 = isJBoss = props.get("jboss.home.dir") != null;
            isTomcat = props.get("catalina.home") != null ? AdfServerPlatformUtil.isClassAvailable("org/apache/tomcat/dbcp/dbcp2/DelegatingConnection.class") || AdfServerPlatformUtil.isClassAvailable("org/apache/tomcat/dbcp/dbcp/DelegatingConnection.class") : false;
            boolean bl3 = gfVersion = props.get("glassfish.version") != null;
            isGlassfish = gfVersion ? !isTomcat : false;
            String msName = (String)props.get("oracle.microservice.platform");
            isMicroServicePlatform = msName != null;
            boolean bl4 = localIsJee = isWebLogic || isWebLogicCore || isTomcat || isGlassfish || isWebSphere || isJBoss;
            isGrizzly = !localIsJee ? (localIsJee = props.get("surefire.test.class.path") != null) : false;
            String altJeeName = "unrecognized-jee";
            if (!localIsJee) {
                boolean bl5 = localIsJee = props.get("__oracle.jbo.kava.simulate_jee") != null;
                if (localIsJee) {
                    altJeeName = "kava-simulated-jee";
                }
            }
            String pn = !(isJEE = localIsJee) ? (isMicroServicePlatform ? msName : "jse") : (isWebLogic ? "weblogic" : (isWebLogicCore ? "weblogic-core" : (isGlassfish ? "glassfish" : (isWebSphere ? "websphere" : (isTomcat ? "tomcat" : (isJBoss ? "jboss" : (isGrizzly ? "grizzly" : altJeeName)))))));
            platName = pn;
            if (STARTUP_LOGGABLE) {
                SingletonHolder.dumpInitedState();
            }
        }
    }

    private static class InitAction
    implements PrivilegedAction<Map<String, Object>> {
        static final String[] serverIdNames = new String[]{"weblogic.Name", "common.components.home", "was.install.root", "server.root", "jboss.home.dir", "glassfish.version", "catalina.home", "catalina.base", "oracle.adfm.usemds", "oracle.jbo.usemds", "surefire.test.class.path", "__oracle.jbo.kava.simulate_jee", "oracle.microservice.platform"};

        private InitAction() {
        }

        @Override
        public Map<String, Object> run() {
            HashMap<String, Object> map = new HashMap<String, Object>(serverIdNames.length);
            for (int i = 0; i < serverIdNames.length; ++i) {
                String k = serverIdNames[i];
                map.put(k, System.getProperty(k));
            }
            return map;
        }
    }
}

