/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.core.ojdl.logging.JpsUserContextImpl;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.logging.context.LoggingContextProvider;
import oracle.core.ojdl.logging.context.UserContext;

public class UserLevelLoggingContextProvider
implements LoggingContextProvider {
    private static Map<String, Level> m_userLevels = new ConcurrentHashMap<String, Level>();
    private UserContext m_userCtx = this.getUserContext();
    private static boolean m_userLevelEnabled = true;
    private LoggingContextProvider m_targetProvider;

    public static void associateWithLogger(String loggerName) {
        LoggingContextProvider p = LoggingContextManager.getEffectiveLoggingContextProvider(loggerName);
        LoggingContextManager.setLoggingContextProvider(loggerName, new UserLevelLoggingContextProvider(p));
    }

    public UserLevelLoggingContextProvider(LoggingContextProvider targetProvider) {
        this.m_targetProvider = targetProvider;
    }

    @Override
    public LoggingContext getLoggingContext() {
        return new UserLevelLoggingContext(this);
    }

    @Override
    public boolean isContextLevelEnabled() {
        return m_userLevelEnabled || this.m_targetProvider.isContextLevelEnabled();
    }

    public static synchronized void setUserLevel(String userName, Level level) {
        if (level == null) {
            m_userLevels.remove(userName);
        } else {
            m_userLevels.put(userName, level);
        }
        m_userLevelEnabled = m_userLevels.size() > 0;
    }

    public static Level getUserLevel(String userName) {
        return m_userLevels.get(userName);
    }

    public Level getUserLevel() {
        String userName;
        if (this.m_userCtx != null && (userName = this.m_userCtx.getUserName()) != null) {
            return UserLevelLoggingContextProvider.getUserLevel(userName);
        }
        return null;
    }

    private UserContext getUserContext() {
        String userCtxProvider = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("oracle.core.ojdl.logging.usercontextprovider", JpsUserContextImpl.class.getName());
            }
        });
        if (userCtxProvider != null && userCtxProvider.length() > 0 && !"disabled".equalsIgnoreCase(userCtxProvider)) {
            try {
                return (UserContext)Class.forName(userCtxProvider).newInstance();
            }
            catch (Throwable t) {
                System.out.println("UserLevelLoggingContextProvider: unable to create instance of UserContext class " + userCtxProvider + ": " + t);
            }
        }
        return null;
    }

    private static class UserLevelLoggingContext
    implements LoggingContext {
        private final UserLevelLoggingContextProvider m_parent;
        private final LoggingContext m_targetCtx;

        UserLevelLoggingContext(UserLevelLoggingContextProvider parent) {
            this.m_parent = parent;
            this.m_targetCtx = parent.m_targetProvider.getLoggingContext();
        }

        @Override
        public String getECID() {
            return this.m_targetCtx.getECID();
        }

        @Override
        public String getRID() {
            return this.m_targetCtx.getRID();
        }

        @Override
        public Set<String> getLoggableAttributes() {
            return this.m_targetCtx.getLoggableAttributes();
        }

        @Override
        public String getAttributeValue(String attrName) {
            return this.m_targetCtx.getAttributeValue(attrName);
        }

        @Override
        public Level getLevel() {
            UserLevelLoggingContext userLevelLoggingContext = this;
            Level userLevel = m_userLevelEnabled ? this.m_parent.getUserLevel() : null;
            Level ctxLevel = this.m_targetCtx.getLevel();
            if (userLevel == null) {
                return ctxLevel;
            }
            if (ctxLevel == null) {
                return userLevel;
            }
            if (userLevel.intValue() < ctxLevel.intValue()) {
                return userLevel;
            }
            return ctxLevel;
        }
    }
}

