/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.oci;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.oci.OCIRESTClient;

public class OCIProfiles {
    private ArrayList<String> _sections = new ArrayList();
    private Properties profiles = null;

    public ArrayList<String> getProfiles() throws IOException {
        this._sections.clear();
        this.load();
        return this._sections;
    }

    public OCIRESTClient getOciClient(String section) throws IOException {
        this.getProfiles();
        OCIRESTClient client = new OCIRESTClient.Builder().authUserId(this.profiles.getProperty(section + "/user")).keyFingerprint(this.profiles.getProperty(section + "/fingerprint")).tenancyId(this.profiles.getProperty(section + "/tenancy")).privateKeyPath(this.profiles.getProperty(section + "/key_file")).build();
        return client;
    }

    public void load() throws IOException {
        Path path = FileSystems.getDefault().getPath(System.getProperty("user.home"), ".oci", "config");
        FileReader reader = new FileReader(path.toFile());
        this.profiles = new Properties(){
            private String section = "ROOT";

            @Override
            public Object put(Object key, Object value) {
                String header = ((String)key + " " + value).trim();
                if (header.startsWith("[") && header.endsWith("]")) {
                    OCIProfiles.this._sections.add(header.substring(1, header.length() - 1));
                    this.section = header.substring(1, header.length() - 1);
                    return this.section;
                }
                return super.put(this.section + "/" + key, value);
            }
        };
        this.profiles.load(reader);
    }
}

