/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.oci;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.oci.OCISignature;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class OCIRESTClient {
    private String _authUserId;
    private String _tenancyId;
    private String _keyFingerprint;
    private String _privateKeyString;
    private File _privateKeyFile;

    public OCIRESTClient(String tenancyId, String authUserId, String keyFingerprint, String privateKeyPath, String privateKeyString) {
        this._tenancyId = tenancyId;
        this._authUserId = authUserId;
        this._keyFingerprint = keyFingerprint;
        this._privateKeyString = privateKeyString;
        this._privateKeyFile = privateKeyPath != null ? new File(privateKeyPath) : null;
    }

    public String getAuthUserId() {
        return this._authUserId;
    }

    public String getTenancyId() {
        return this._tenancyId;
    }

    public CloseableHttpResponse getResponse(OCIRequest ociRequest) throws InvalidKeyException, SignatureException, UnsupportedEncodingException, GeneralSecurityException, IOException {
        return this.go(ociRequest);
    }

    public InputStream getStream(OCIRequest ociRequest) throws InvalidKeyException, SignatureException, UnsupportedEncodingException, GeneralSecurityException, IOException {
        CloseableHttpResponse response = this.go(ociRequest);
        return response.getEntity().getContent();
    }

    public String getString(OCIRequest ociRequest) throws InvalidKeyException, SignatureException, UnsupportedEncodingException, GeneralSecurityException, IOException {
        CloseableHttpResponse response = this.go(ociRequest);
        String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
        return ret;
    }

    public CloseableHttpResponse go(OCIRequest ociRequest) throws InvalidKeyException, SignatureException, UnsupportedEncodingException, GeneralSecurityException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String now = sdf.format(new Date());
        String escaped_target = ociRequest.getTarget();
        String request_target = "(request-target): " + ociRequest.getMethod() + " " + escaped_target;
        String date_header = "date: " + now;
        String host_header = "host: " + ociRequest.getHost();
        String singingString = request_target + "\n" + date_header + "\n" + host_header;
        String signingHeaders = "date host";
        String authHeader = null;
        RequestBuilder request = null;
        switch (ociRequest.getMethod()) {
            case "delete": {
                request = RequestBuilder.delete((String)("https://" + ociRequest.getHost() + ociRequest.getTarget()));
                break;
            }
            case "put": {
                request = RequestBuilder.put((String)("https://" + ociRequest.getHost() + ociRequest.getTarget()));
                break;
            }
            case "post": {
                request = RequestBuilder.post((String)("https://" + ociRequest.getHost() + ociRequest.getTarget()));
                break;
            }
            default: {
                request = RequestBuilder.get((String)("https://" + ociRequest.getHost() + ociRequest.getTarget()));
            }
        }
        if (ociRequest.hasBody() && (ociRequest.getMethod().equals("put") || ociRequest.getMethod().equals("post"))) {
            String content_type = ociRequest.getContentType();
            String content_length = null;
            String content_sha256 = null;
            if (ociRequest.getBody() != null) {
                content_sha256 = OCISignature.sha256Digest(ociRequest.getBody());
                content_length = ociRequest.getBody().length() + "";
                request.setEntity((HttpEntity)new StringEntity(ociRequest.getBody(), ContentType.create((String)content_type)));
            } else if (ociRequest.getBodyFile() != null) {
                content_sha256 = OCISignature.sha256Digest(ociRequest.getBodyFile());
                content_length = ociRequest.getBodyFile().length() + "";
                request.setEntity((HttpEntity)new FileEntity(ociRequest.getBodyFile()));
            }
            content_length = request.getEntity().getContentLength() + "";
            request.addHeader("x-content-sha256", content_sha256);
            request.addHeader("content-type", content_type);
            singingString = singingString + "\nx-content-sha256: " + content_sha256 + "\ncontent-type: " + content_type + "\ncontent-length: " + content_length;
            signingHeaders = signingHeaders + " x-content-sha256 content-type content-length";
        }
        authHeader = new OCISignature.Builder().authUserId(this._authUserId).tenancyId(this._tenancyId).keyFingerprint(this._keyFingerprint).keyString(this._privateKeyString).keyFile(this._privateKeyFile).build().ociAuthHeader(singingString, signingHeaders);
        request.addHeader("Authorization", authHeader);
        request.addHeader("date", now);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = httpClient.execute(request.build());
        return response;
    }

    public static class Builder {
        private String _tenancyId;
        private String _authUserId;
        private String _keyFingerprint;
        private String _privateKeyPath;
        private String _privateKeyString;

        public Builder tenancyId(String tenancyId) {
            this._tenancyId = tenancyId;
            return this;
        }

        public Builder authUserId(String authUserId) {
            this._authUserId = authUserId;
            return this;
        }

        public Builder keyFingerprint(String keyFingerprint) {
            this._keyFingerprint = keyFingerprint;
            return this;
        }

        public Builder privateKeyPath(String privateKeyPath) {
            this._privateKeyPath = privateKeyPath;
            return this;
        }

        public Builder privateKeyString(String privateKeyString) {
            this._privateKeyString = privateKeyString;
            return this;
        }

        public OCIRESTClient build() {
            if (this._tenancyId == null || this._authUserId == null || this._keyFingerprint == null && (this._privateKeyPath != null || this._privateKeyString != null)) {
                throw new RuntimeException("OCI Information missing. Must have tenancyid , authuserid, fingerprint and private key in string or filename!");
            }
            return new OCIRESTClient(this._tenancyId, this._authUserId, this._keyFingerprint, this._privateKeyPath, this._privateKeyString);
        }
    }
}

