/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.ext;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlChange;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlStatement;
import liquibase.ext.ora.createoraclesxml.CreateOracleSxmlChange;
import liquibase.ext.ora.createoracletrigger.CreateTriggerChange;
import liquibase.ext.ora.generator.Generator;
import liquibase.ext.ora.oraclestatement.AbstractOracleStatement;
import liquibase.ext.ora.rollback.RollbackOraclePlSqlChange;
import liquibase.ext.ora.rollback.RollbackOraclePlSqlStatement;
import liquibase.ext.ora.rollback.RollbackOracleSxmlChange;
import liquibase.ext.ora.rollback.RollbackOracleSxmlStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptChange;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.ext.ora.utils.StringUtils;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ProcessFailedException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.liquibaseCommand;
import oracle.dbtools.util.Service;

public class OracleDatabaseV2
extends OracleDatabase {
    private boolean includeSchema = true;
    private Boolean processLogTable = true;
    private final String LogTableSource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n   </RELATIONAL_TABLE>\r\n</TABLE>";
    private final String LogTriggerSource = "--create log table trigger\nCREATE OR REPLACE TRIGGER databasechangelog_actions_trg BEFORE\r\n    INSERT ON databasechangelog_actions\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        databasechangelog_actions\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n";
    private final String LoigViewsource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n   <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_DETAILS</NAME>\r\n   <COL_LIST>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DEPLOYMENT_ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>AUTHOR</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>FILENAME</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SQL</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SXML</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DATEEXECUTED</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>EXECTYPE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>MD5SUM</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DESCRIPTION</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>COMMENTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LIQUIBASE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>CONTEXTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LABELS</NAME>\r\n      </COL_LIST_ITEM>\r\n   </COL_LIST>\r\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \r\nFROM databasechangelog d  LEFT JOIN databasechangelog_actions da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\r\n</VIEW>";
    private final String MergeSql = "MERGE INTO databasechangelog_actions tt\r\nUSING databasechangelog st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,\r\n    tt.filename = st.filename;";
    private final String PkSql = "ALTER TABLE databasechangelog_actions ADD PRIMARY KEY (id,author,filename,sequence);";
    final CreateOracleSxmlChange CreateorUpdateLogTableChange = new CreateOracleSxmlChange();
    final CreateTriggerChange CreateorUpdateLogTableTriggerChange = new CreateTriggerChange();
    final RunOracleScriptChange UpdateLogDataChange = new RunOracleScriptChange();
    final RunOracleScriptChange CreatePkChange = new RunOracleScriptChange();
    final CreateOracleSxmlChange CreateorUpdateLogViewChange = new CreateOracleSxmlChange();
    private BufferedOutputStream m_out = null;
    static QueryXMLSupport s_xml = null;

    public BufferedOutputStream getOutWriter() {
        return this.m_out;
    }

    public void setOutWriter(BufferedOutputStream m_out) {
        this.m_out = m_out;
    }

    public OracleDatabaseV2() {
        this.CreateorUpdateLogTableChange.setSource("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n   </RELATIONAL_TABLE>\r\n</TABLE>");
        this.CreateorUpdateLogTableChange.setObjectName("DATABASECHANGELOG_ACTIONS");
        this.CreateorUpdateLogTableChange.setObjectType("TABLE");
        this.CreateorUpdateLogTableTriggerChange.setSource("--create log table trigger\nCREATE OR REPLACE TRIGGER databasechangelog_actions_trg BEFORE\r\n    INSERT ON databasechangelog_actions\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        databasechangelog_actions\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n");
        this.CreateorUpdateLogTableTriggerChange.setObjectType("TRIGGER");
        this.CreateorUpdateLogTableTriggerChange.setObjectName("DATABASECHANGELOG_ACTIONS_TRG");
        this.CreateorUpdateLogViewChange.setSource("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n   <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>DATABASECHANGELOG_DETAILS</NAME>\r\n   <COL_LIST>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DEPLOYMENT_ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>AUTHOR</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>FILENAME</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SQL</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SXML</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DATEEXECUTED</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>EXECTYPE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>MD5SUM</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DESCRIPTION</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>COMMENTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LIQUIBASE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>CONTEXTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LABELS</NAME>\r\n      </COL_LIST_ITEM>\r\n   </COL_LIST>\r\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \r\nFROM databasechangelog d  LEFT JOIN databasechangelog_actions da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\r\n</VIEW>");
        this.CreateorUpdateLogViewChange.setObjectName("DATABASECHANGELOG_DETAILS");
        this.CreateorUpdateLogViewChange.setObjectType("VIEW");
        this.UpdateLogDataChange.setSource("MERGE INTO databasechangelog_actions tt\r\nUSING databasechangelog st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,\r\n    tt.filename = st.filename;");
        this.UpdateLogDataChange.setSourceType("STRING");
        this.CreatePkChange.setSource("ALTER TABLE databasechangelog_actions ADD PRIMARY KEY (id,author,filename,sequence);");
        this.CreatePkChange.setSourceType("STRING");
    }

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(liquibaseCommand.class.getClassLoader(), "oracle/dbtools/raptor/scriptrunner/commands/liquibase/cmQueries.xml"));
        }
        return s_xml;
    }

    private String getSchedulerObjectType(String name, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_NAME", name);
        String type = dbUtil.executeReturnOneCol("select object_type from all_objects where object_name = :OBJECT_NAME and rownum = 1", binds);
        return type;
    }

    public Sql[] getCreateSqlSxml(AbstractOracleStatement stmt) {
        try {
            String sql = null;
            String oName = stmt.getObjectName();
            String oType = stmt.getObjectType();
            String sxml = stmt.getSource();
            String schema = stmt.getOwnerName();
            boolean includeSchema = this.includeSchema();
            if (stmt.getFile() == null) {
                stmt.setObjectOwner(this.getDefaultSchemaName());
                stmt.setSource(stmt.getSource().replaceAll("%USER_NAME%", this.getDefaultSchemaName()));
                sxml = sxml.replaceAll("%USER_NAME%", this.getDefaultSchemaName());
            }
            if (!oType.equalsIgnoreCase("VIEW") && this.doesObjectExist(oName, oType)) {
                String dbTableSxml = this.getXMLFromDb(stmt);
                sql = this.getAlterDdlDFromSXML(dbTableSxml, sxml, stmt);
            } else {
                sql = this.getDdlFromSXML(sxml, stmt);
            }
            if (sql == null) {
                sql = "";
            }
            if (!includeSchema) {
                sql = sql.replaceAll("\"" + schema + "\".", "");
                sql = sql.replaceAll("\"" + this.getDefaultCatalogName() + "\".", "");
            }
            if (sql.trim().equalsIgnoreCase("")) {
                sql = "-- object is the same nothing to do";
            }
            if (sql.endsWith(";;")) {
                sql = sql.replace(";;", ";");
            }
            return new Sql[]{new UnparsedSql(sql.trim(), new DatabaseObject[0])};
        }
        catch (Exception e) {
            return null;
        }
    }

    private int nthOccurrence(String str, char c, int n) {
        if (n <= 0) {
            return -1;
        }
        int pos = str.indexOf(c, 0);
        while (n-- > 1 && pos != -1) {
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }

    public Sql[] getDropSqlSxml(AbstractOracleStatement statement) throws ProcessFailedException {
        String oldSxml = null;
        String outSql = null;
        StringBuilder sql = new StringBuilder();
        try {
            String oType = statement.getObjectType();
            String sxml = statement.getSource();
            oldSxml = this.getXmlFromActionsLog(statement);
            if (oldSxml != null) {
                sql.append(this.getAlterDdlDFromSXML(sxml, oldSxml, statement));
            } else if (oType.equals("MATERIALIZED_VIEW_LOG")) {
                String create = null;
                create = this.getDdlFromSXML(sxml, statement);
                String drop = create.replace("CREATE", "DROP");
                int loc = this.nthOccurrence(drop, '\"', 4);
                drop = drop.substring(0, loc + 1);
                sql.append(drop);
            } else {
                sql.append("DROP ");
                if (Generator.typeChanges.containsKey(statement.getObjectType())) {
                    sql.append(Generator.typeChanges.get(statement.getObjectType()) + " ");
                } else {
                    sql.append(statement.getObjectType() + " ");
                }
                sql.append("\"" + statement.getObjectName() + "\"");
                if (statement.getObjectType().equals("TABLE")) {
                    sql.append(" CASCADE CONSTRAINTS");
                }
            }
            outSql = !this.includeSchema() ? sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "") : sql.toString();
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            return null;
        }
    }

    public Sql[] getCreateSqlPlSql(AbstractOracleStatement statement) {
        String outSql = null;
        StringBuilder sql = new StringBuilder();
        if (!(statement.getObjectType().equals("GRANT") || statement.getObjectType().equals("JOB") || statement.getSource().toUpperCase().substring(0, 15).contains("CREATE") || statement.getSource().toUpperCase().substring(0, 15).contains("ALTER"))) {
            sql.append("CREATE ");
            if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
                sql.append("OR REPLACE ");
            }
        }
        sql.append(statement.getSource());
        sql.toString().replace("%USER_NAME%", this.getDefaultSchemaName());
        if (!this.includeSchema()) {
            outSql = sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "");
            outSql = outSql.replaceAll("\"" + this.getDefaultCatalogName() + "\".", "");
        } else {
            outSql = sql.toString();
        }
        if (outSql != null && !outSql.trim().equals("")) {
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
    }

    public Sql[] getDropSqlPlSql(AbstractOracleStatement statement) throws ProcessFailedException {
        String outSql = null;
        String oName = null;
        StringBuilder sql = new StringBuilder();
        String action = null;
        if (statement instanceof RunOracleScriptStatement) {
            return null;
        }
        try {
            if (statement.getObjectName() != null && !statement.getObjectName().equals("%OBJECT_NAME%")) {
                oName = Service.handleMixedCase((String)statement.getObjectName());
            }
            try {
                action = this.getXmlFromActionsLog(statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (action == null || action.equalsIgnoreCase("")) {
                if (statement.getObjectType() != null && statement.getObjectType().contentEquals("JOB")) {
                    String subType = this.getSchedulerObjectType(oName, (Database)this);
                    if (subType != null) {
                        return new Sql[]{new UnparsedSql("BEGIN DBMS_SCHEDULER.drop_" + subType.toLowerCase() + " (" + subType.toLowerCase() + "_name => '" + oName + "' ,FORCE=>TRUE); end;", new DatabaseObject[0])};
                    }
                    return null;
                }
                if (oName != null && !oName.equals("%OBJECT_NAME%")) {
                    sql.append("DROP ");
                    if (Generator.typeChanges.containsKey(statement.getObjectType())) {
                        sql.append(Generator.typeChanges.get(statement.getObjectType()) + " ");
                    } else {
                        sql.append(statement.getObjectType() + " ");
                    }
                    sql.append("\"" + oName + "\"");
                } else if (statement.getObjectType().equalsIgnoreCase("GRANT")) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("GRANT", "REVOKE");
                    dropsql = dropsql.replaceAll("TO", "FROM");
                    sql.append(dropsql);
                } else if (statement.getObjectType().equalsIgnoreCase("MATERIALIZED_VIEW_LOG")) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("CREATE", "DROP");
                }
                if (statement.getObjectType() != null && statement.getObjectType().equalsIgnoreCase("JOB")) {
                    return null;
                }
            } else {
                sql.append(this.getDdlFromXML(action, statement));
            }
            if (statement.getObjectType().equalsIgnoreCase("TABLE")) {
                sql.append(" CASCADE CONSTRAINTS");
            }
            if (!this.includeSchema()) {
                outSql = sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "");
                outSql = outSql.replaceAll("\"" + this.getDefaultCatalogName() + "\".", "");
            } else {
                outSql = sql.toString();
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public SqlStatement getRollbackAction(String id, String author, String filename) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete from DATABASECHANGELOG_actions where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "' and sequence = (select Max(sequence) from DATABASECHANGELOG_actions where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "')");
        RunOracleScriptStatement stmt = new RunOracleScriptStatement();
        stmt.setObjectName("rollbackAction");
        stmt.setContinueOnError(true);
        stmt.setObjectOwner(author);
        stmt.setUseScriptRunner(true);
        stmt.setSource(sb.toString());
        stmt.setSourceType("STRING");
        return stmt;
    }

    private List<String> splitString(String stringtoSplit, int length) {
        ArrayList<String> returnStringList = new ArrayList<String>((stringtoSplit.length() + length - 1) / length);
        for (int start = 0; start < stringtoSplit.length(); start += length) {
            returnStringList.add(stringtoSplit.substring(start, Math.min(stringtoSplit.length(), start + length)));
        }
        return returnStringList;
    }

    private SqlStatement logAction(String id, String author, String filename, String actions, String sxml) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        String rawAction = "";
        String rawSxml = "";
        if (actions != null) {
            rawAction = new String(Base64.getEncoder().encode(actions.getBytes()));
        }
        if (sxml != null) {
            rawSxml = new String(Base64.getEncoder().encode(sxml.getBytes()));
        }
        sb.append("-- Logging Oracle Extension actions to the Database. ");
        sb.append("\n DECLARE ");
        sb.append("\n id varchar2(200) := '" + id + "';");
        sb.append("\n rawAction clob;");
        sb.append("\n rawSxml clob;");
        sb.append("\n myrow varchar2(2000);");
        sb.append("\n action clob := '';");
        sb.append("\n sxml clob := '';");
        sb.append("\n dep varchar2(200) := '" + ChangeLogHistoryServiceFactory.getInstance().getChangeLogService((Database)this).getDeploymentId() + "';");
        sb.append("\n author varchar2(200) := '" + author + "';");
        sb.append("\n filename varchar2(200) := '" + filename + "';");
        sb.append("\n insertlog varchar2(200) := 'insert into DATABASECHANGELOG_ACTIONS (id,author,filename,sql,sxml,deployment_id) values (:id,:author,:filename,:action,:sxml,:dep) returning rowid into :out';");
        sb.append("\n updateaction varchar2(200) := 'update DATABASECHANGELOG_ACTIONS set sql = sql ||:action where rowid = :myrow ';");
        sb.append("\n updatesxml varchar2(200) := 'update DATABASECHANGELOG_ACTIONS set sxml = sxml ||:sxml where rowid = :myrow ';");
        sb.append("\n begin ");
        if (actions == null) {
            sb.append("\n action := '';");
        } else if (rawAction.length() < 32000 && rawSxml.length() < 32000) {
            if (rawAction.length() > 0) {
                sb.append("\naction := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawAction + "}')));");
            }
            if (rawSxml.length() > 0) {
                sb.append("\nsxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawSxml + "}')));");
            }
            sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
        } else {
            List<String> actionchunks = this.splitString(rawAction, 32000);
            List<String> sxmlchunks = this.splitString(rawSxml, 32000);
            boolean first = true;
            for (String piece : actionchunks) {
                sb.append("\n rawAction := '" + piece + "';");
                sb.append("\n action := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawAction)));");
                if (first) {
                    sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
                    first = false;
                    continue;
                }
                sb.append("\n execute immediate updateaction using action,myrow;");
            }
            for (String piece : sxmlchunks) {
                sb.append("\n rawSxml := '" + piece + "';");
                sb.append("\n sxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawSxml)));");
                sb.append("\n execute immediate updatesxml using sxml,myrow;");
            }
        }
        sb.append("\nend;");
        sb.append("\n/");
        sb.append("\n-- ");
        RunOracleScriptStatement stmt = new RunOracleScriptStatement();
        stmt.setObjectName("logAction");
        stmt.setObjectOwner(author);
        stmt.setUseScriptRunner(true);
        stmt.setSource(sb.toString());
        stmt.setSourceType("STRING");
        stmt.setContinueOnError(true);
        return stmt;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "oracle".equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public int getPriority() {
        return 99;
    }

    public void executeRollbackStatements(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        this.executeWithActionLogging(statements, sqlVisitors, null);
    }

    public void executeRollbackStatements(Change change, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        try {
            String action = null;
            boolean skipped = false;
            String id = null;
            String author = null;
            String file = null;
            boolean drop = false;
            SqlStatement[] statements = null;
            if (change instanceof AbstractCommonSxmlChange) {
                id = ((AbstractCommonSxmlChange)change).getId();
                action = this.getXmlFromActionsLog(id, author = ((AbstractCommonSxmlChange)change).getAuthor(), file = ((AbstractCommonSxmlChange)change).getFile());
                if (action != null && action.equalsIgnoreCase("--skipped")) {
                    skipped = true;
                } else if (action != null && !action.equalsIgnoreCase("")) {
                    ((AbstractCommonSxmlChange)change).setSource(action);
                } else {
                    drop = true;
                }
            } else if (change instanceof AbstractCommonPlSqlChange) {
                id = ((AbstractCommonPlSqlChange)change).getId();
                action = this.getXmlFromActionsLog(id, author = ((AbstractCommonPlSqlChange)change).getAuthor(), file = ((AbstractCommonPlSqlChange)change).getFile());
                if (action != null && action.equalsIgnoreCase("--skipped")) {
                    skipped = true;
                } else if (action != null && !action.equalsIgnoreCase("")) {
                    ((AbstractCommonPlSqlChange)change).setSource(action);
                } else {
                    drop = true;
                }
            } else {
                super.executeRollbackStatements(change, sqlVisitors);
            }
            if (skipped) {
                Executor currentExecutor = ExecutorService.getInstance().getExecutor((Database)this);
                SqlStatement logstmt = this.getRollbackAction(id, author, file);
                if (currentExecutor instanceof LoggingExecutor) {
                    currentExecutor.execute(logstmt, sqlVisitors);
                } else {
                    Sql[] sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                    this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                }
            } else {
                if (change instanceof AbstractCommonSxmlChange) {
                    RollbackOracleSxmlChange rb = new RollbackOracleSxmlChange((AbstractCommonSxmlChange)change);
                    if (drop) {
                        rb.setSource(null);
                    }
                    statements = rb.generateStatements((Database)this);
                } else if (change instanceof AbstractCommonPlSqlChange) {
                    RollbackOraclePlSqlChange rb = new RollbackOraclePlSqlChange((AbstractCommonPlSqlChange)change);
                    if (drop) {
                        rb.setSource(null);
                    }
                    statements = rb.generateStatements((Database)this);
                }
                this.executeRollbackStatements(statements, sqlVisitors);
            }
        }
        catch (Exception e) {
            if (e instanceof LiquibaseException) {
                throw (LiquibaseException)e;
            }
            throw new LiquibaseException(e.getStackTrace()[0].getMethodName(), (Throwable)e);
        }
    }

    public void execute(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        this.executeWithActionLogging(statements, sqlVisitors, null);
    }

    public void executeStatements(Change change, DatabaseChangeLog changeLog, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        try {
            if (change instanceof AbstractCommonSxmlChange || change instanceof AbstractCommonPlSqlChange) {
                SqlStatement[] statements;
                for (SqlStatement stmt : statements = change.generateStatements((Database)this)) {
                    if (!(stmt instanceof AbstractSqlStatement)) continue;
                    AbstractSqlStatement a = (AbstractSqlStatement)stmt;
                    a.setContinueOnError(change.getChangeSet().getFailOnError() == false);
                }
                if (change instanceof AbstractCommonSxmlChange) {
                    this.executeWithActionLogging(statements, sqlVisitors, this.getXMLFromDb((AbstractCommonSxmlStatement)statements[0]));
                } else if (change instanceof AbstractCommonPlSqlChange) {
                    AbstractCommonPlSqlChange xmlChange = (AbstractCommonPlSqlChange)change;
                    if (this.doesObjectExist(xmlChange.getObjectName(), xmlChange.getObjectType())) {
                        this.executeWithActionLogging(statements, sqlVisitors, this.getXMLFromDb((AbstractCommonPlSqlStatement)statements[0]));
                    } else {
                        this.executeWithActionLogging(statements, sqlVisitors, null);
                    }
                }
            } else {
                super.executeStatements(change, changeLog, sqlVisitors);
            }
        }
        catch (Exception e) {
            if (e instanceof LiquibaseException) {
                throw (LiquibaseException)e;
            }
            throw new LiquibaseException(e.getStackTrace()[0].getMethodName(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLFromDb(AbstractOracleStatement stmt) throws ProcessFailedException {
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        Generator gen = new Generator(conn, null);
        try {
            String string = gen.getObjectFromDb(stmt.getObjectType(), stmt.getObjectName());
            return string;
        }
        finally {
            gen.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDdlFromSXML(String sourceSxml, AbstractOracleStatement stmt) throws ProcessFailedException {
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        Generator gen = new Generator(conn, null);
        try {
            String string = gen.getDdlFromSXML(sourceSxml, stmt.getObjectType());
            return string;
        }
        finally {
            gen.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDdlFromXML(String sourceSxml, AbstractOracleStatement stmt) throws ProcessFailedException {
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        Generator gen = new Generator(conn, null);
        try {
            String string = gen.getDdlFromXML(sourceSxml, stmt.getObjectType());
            return string;
        }
        finally {
            gen.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlterDdlDFromSXML(String sourceSxml, String destSxml, AbstractOracleStatement stmt) throws ProcessFailedException {
        String sql = null;
        if (destSxml == null) {
            if (stmt instanceof AbstractOracleStatement) {
                Sql[] sql2 = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)stmt, (Database)this);
                sql = sql2[0].toSql();
            }
            return sql;
        }
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        Generator gen = new Generator(conn, null);
        try {
            String string = gen.getAlterDdlDFromSXML(sourceSxml, destSxml, stmt.getObjectType());
            return string;
        }
        finally {
            gen.Destroy();
        }
    }

    public boolean includeSchema() {
        return this.includeSchema;
    }

    public void includeSchema(boolean incSchema) {
        this.includeSchema = incSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesObjectExist(String oName, String oType) {
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        String objectExistsQuery = OracleDatabaseV2.getXMLQueries().getQuery("objectExistsQuery", conn).getSql();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int count = 0;
            stmt = conn.prepareStatement(objectExistsQuery);
            stmt.setString(1, oName);
            if (Generator.typeChanges.containsKey(oType)) {
                stmt.setString(2, Generator.typeChanges.get(oType));
            } else {
                stmt.setString(2, oType);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getXmlFromActionsLog(String changeId, String author, String filename) throws ProcessFailedException {
        String string;
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = OracleDatabaseV2.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(actionLogSxmlQuery);
            stmt.setString(1, changeId);
            stmt.setString(2, author);
            stmt.setString(3, filename);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Clob sxml = rs.getClob(1);
                if (sxml == null) {
                    String string2 = null;
                    return string2;
                }
                sb.append(StringUtils.clobToString(sxml));
            }
            string = sb.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String getXmlFromActionsLog(AbstractOracleStatement statement) throws ProcessFailedException {
        String string;
        Connection conn = ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = OracleDatabaseV2.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(actionLogSxmlQuery);
            stmt.setString(1, statement.getId());
            stmt.setString(2, statement.getAuthor());
            stmt.setString(3, statement.getFile());
            rs = stmt.executeQuery();
            while (rs.next()) {
                Clob sxml = rs.getClob(1);
                if (sxml == null) {
                    String string2 = null;
                    return string2;
                }
                sb.append(StringUtils.clobToString(sxml));
            }
            string = sb.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public String runRollbackSql(String sql, Connection conn) throws ProcessFailedException {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(sql);
            ScriptExecutor runner = new ScriptExecutor((Reader)rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            ctx.setSubstitutionOn(false);
            ctx.setScanOn(false);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            conn.commit();
            return BaS.toString(encoding);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
    }

    public String runSqlReturnResult(String sql, Connection conn) throws ProcessFailedException {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(sql);
            ScriptExecutor runner = new ScriptExecutor((Reader)rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            ctx.setSubstitutionOn(false);
            ctx.setScanOn(false);
            ctx.setSqlError(4);
            ctx.putProperty("script.runner.exit_int_whenever", (Object)2);
            ctx.putProperty("script.runner.exit_int_whenever.wassqlcode", (Object)true);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            if (((Boolean)runner.getScriptRunnerContext().getProperty("sqldev.error")).booleanValue()) {
                throw new DatabaseException(BaS.toString(encoding));
            }
            return BaS.toString(encoding);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
    }

    private void createUpdateLogTable() throws LiquibaseException {
        Sql[] sql = null;
        boolean create = false;
        String sqlToRun = null;
        try {
            if (this.processLogTable.booleanValue()) {
                DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                String cols = dbUtil.executeReturnOneCol("select count(*) from user_tab_columns where table_name='DATABASECHANGELOG_ACTIONS' ");
                if (cols != null && Integer.parseInt(cols) == 7) {
                    this.processLogTable = false;
                    return;
                }
                create = Integer.parseInt(cols) == 0;
                if (ExecutorService.getInstance().getExecutor((Database)this) instanceof LoggingExecutor) {
                    ExecutorService.getInstance().getExecutor((Database)this).execute((Change)this.CreateorUpdateLogTableChange);
                    if (!create) {
                        ExecutorService.getInstance().getExecutor((Database)this).execute((Change)this.UpdateLogDataChange);
                    }
                    ExecutorService.getInstance().getExecutor((Database)this).execute((Change)this.CreatePkChange);
                    ExecutorService.getInstance().getExecutor((Database)this).execute((Change)this.CreateorUpdateLogTableTriggerChange);
                    ExecutorService.getInstance().getExecutor((Database)this).execute((Change)this.CreateorUpdateLogViewChange);
                } else {
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogTableChange, (Database)this);
                    sqlToRun = sql[0].toSql();
                    this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    if (!create) {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.UpdateLogDataChange, (Database)this);
                        sqlToRun = sql[0].toSql();
                        this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    }
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreatePkChange, (Database)this);
                    sqlToRun = sql[0].toSql();
                    this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogTableTriggerChange, (Database)this);
                    sqlToRun = sql[0].toSql();
                    this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogViewChange, (Database)this);
                    sqlToRun = sql[0].toSql();
                    this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                }
                this.processLogTable = false;
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw new LiquibaseException((Throwable)((ProcessFailedException)e).getOriginalException());
            }
            throw new LiquibaseException((Throwable)e);
        }
    }

    public void executeWithActionLogging(SqlStatement[] statements, List<SqlVisitor> sqlVisitors, String sxml) throws LiquibaseException {
        Sql[] sql = null;
        String sqlToRun = null;
        this.createUpdateLogTable();
        for (SqlStatement statement : statements) {
            SqlStatement logstmt;
            if (statement.skipOnUnsupported() && !SqlGeneratorFactory.getInstance().supports(statement, (Database)this)) continue;
            LogService.getLog(((Object)((Object)this)).getClass()).debug(LogType.LOG, "Executing Statement: " + statement);
            Executor currentExecutor = ExecutorService.getInstance().getExecutor((Database)this);
            if (statement instanceof AbstractOracleStatement && ((AbstractOracleStatement)statement).useScriptRunner() && currentExecutor instanceof JdbcExecutor) {
                sql = SqlGeneratorFactory.getInstance().generateSql(statement, (Database)this);
                if (sql == null) {
                    throw new LiquibaseException("Unable to Generate Sql");
                }
                sqlToRun = sql[0].toSql();
                try {
                    String result = null;
                    result = statement instanceof RollbackOracleSxmlStatement || statement instanceof RollbackOraclePlSqlStatement ? this.runRollbackSql(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection()) : this.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    if (statement instanceof AbstractOracleStatement) {
                        AbstractOracleStatement stmt = (AbstractOracleStatement)statement;
                        System.out.println("ScriptRunner Executed:" + stmt.getFile() + "::" + stmt.getId() + "::" + stmt.getAuthor());
                    } else {
                        System.out.println("ScriptRunner Executed:" + statement.toString());
                    }
                    if (this.m_out != null) {
                        this.m_out.write(sqlToRun.getBytes());
                        this.m_out.write(result.getBytes());
                        this.m_out.flush();
                    }
                    try {
                        Sql[] sql2;
                        AbstractOracleStatement rb;
                        logstmt = null;
                        if (statement instanceof RollbackOracleSxmlStatement) {
                            rb = (RollbackOracleSxmlStatement)statement;
                            logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                            sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                            result = this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                        } else if (statement instanceof RollbackOraclePlSqlStatement) {
                            rb = (RollbackOraclePlSqlStatement)statement;
                            logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                            sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                            result = this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                        } else {
                            AbstractOracleStatement st = (AbstractOracleStatement)statement;
                            logstmt = this.logAction(st.getId(), st.getAuthor(), st.getFile(), sqlToRun, sxml);
                            sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                            result = this.runSqlReturnResult(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof ProcessFailedException) {
                            Exception e1 = ((ProcessFailedException)e).getOriginalException();
                            throw new DatabaseException((Throwable)e1);
                        }
                        throw new DatabaseException((Throwable)e);
                    }
                }
                catch (Exception e) {
                    if (statement.continueOnError()) {
                        if (e instanceof ProcessFailedException) {
                            System.out.println("Error executing statement '" + statement.toString() + "', but continuing\n" + ((ProcessFailedException)e).getOriginalException().getMessage());
                        } else {
                            System.out.println("Error executing statement '" + statement.toString() + "', but continuing\n" + e.getMessage());
                        }
                    }
                    if (e instanceof ProcessFailedException) {
                        throw new DatabaseException((Throwable)((ProcessFailedException)e).getOriginalException());
                    }
                    if (e instanceof DatabaseException) {
                        throw (DatabaseException)((Object)e);
                    }
                    throw new DatabaseException((Throwable)e);
                }
                LogService.getLog(((Object)((Object)this)).getClass()).debug(LogType.LOG, "Executed using Oracle script runner - " + sqlToRun);
                continue;
            }
            if (statement instanceof AbstractOracleStatement && currentExecutor instanceof LoggingExecutor) {
                try {
                    SqlStatement logstmt2;
                    AbstractOracleStatement rb;
                    AbstractOracleStatement stmt = (AbstractOracleStatement)statement;
                    currentExecutor.execute(statement, sqlVisitors);
                    if (statement instanceof RollbackOracleSxmlStatement) {
                        rb = (RollbackOracleSxmlStatement)statement;
                        logstmt2 = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                        currentExecutor.execute(logstmt2, sqlVisitors);
                    } else if (statement instanceof RollbackOraclePlSqlStatement) {
                        rb = (RollbackOraclePlSqlStatement)statement;
                        logstmt2 = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                        currentExecutor.execute(logstmt2, sqlVisitors);
                    } else {
                        sql = SqlGeneratorFactory.getInstance().generateSql(statement, (Database)this);
                        if (sql == null) {
                            throw new LiquibaseException("Unable to Generate Sql");
                        }
                        sqlToRun = sql[0].toSql();
                        logstmt = this.logAction(stmt.getId(), stmt.getAuthor(), stmt.getFile(), sqlToRun, sxml);
                        currentExecutor.execute(logstmt, sqlVisitors);
                    }
                    System.out.println("LoggingExecutor logged:" + stmt.getFile() + "::" + stmt.getId() + "::" + stmt.getAuthor());
                    continue;
                }
                catch (DatabaseException e) {
                    if (statement.continueOnError()) {
                        System.out.println("Error executing statement '" + statement.toString() + "', but continuing\n" + e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
            try {
                currentExecutor.execute(statement, sqlVisitors);
                if (currentExecutor instanceof LoggingExecutor) continue;
                System.out.println("Liquibase Executed:" + statement.toString());
            }
            catch (DatabaseException e) {
                if (statement.continueOnError()) {
                    System.out.println(MessageFormat.format(Messages.getString("LB_DB_ERROR"), e.getMessage()));
                    LogService.getLog(((Object)((Object)this)).getClass()).severe(LogType.LOG, "Error executing statement '" + statement.toString() + "', but continuing", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }
}

