/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.abstractplsqlobject;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ProcessFailedException;

public abstract class AbstractCommonPlSqlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonPlSqlStatement> {
    public abstract boolean supports(AbstractCommonPlSqlStatement var1, Database var2);

    public abstract ACTIONS createOrDrop();

    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        if (statement instanceof AbstractCommonPlSqlStatement && ((Object)((Object)statement)).getClass().getSimpleName().startsWith("Create")) {
            validationErrors.checkRequiredField("source", (Object)statement.getSource());
        }
        if (statement instanceof RunOracleScriptStatement) {
            if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("STRING")) {
                validationErrors.checkRequiredField("source", (Object)statement.getSource());
            } else if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("FILE")) {
                if (!Files.isRegularFile(Paths.get(statement.getSource(), new String[0]), new LinkOption[0])) {
                    validationErrors.addError("Source (File) is not valid");
                }
            } else if (statement.getSourceType() != null && statement.getSourceType().toUpperCase().equals("URL")) {
                try {
                    URL url = new URL(statement.getSource());
                    url.toURI();
                }
                catch (Exception e) {
                    validationErrors.addError("Source (URL) is not valid");
                }
            } else {
                validationErrors.addError("Invalid source type :" + statement.getSourceType());
            }
        }
        return validationErrors;
    }

    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        if (statement.getObjectType() != null && (statement.getObjectType().equalsIgnoreCase("COMMENT") || statement.getObjectType().equalsIgnoreCase("REF_CONSTRAINT"))) {
            return new Sql[]{new UnparsedSql("REM no rollback on this object currently available --", new DatabaseObject[0])};
        }
        if (this.createOrDrop().equals((Object)ACTIONS.CREATE)) {
            return this.createSql(statement, database);
        }
        try {
            return this.dropSql(statement, database);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Sql[] dropSql(AbstractCommonPlSqlStatement statement, Database database) throws ProcessFailedException {
        if (database instanceof OracleDatabaseV2) {
            return ((OracleDatabaseV2)database).getDropSqlPlSql(statement);
        }
        return null;
    }

    private Sql[] createSql(AbstractCommonPlSqlStatement statement, Database database) {
        if (database instanceof OracleDatabaseV2) {
            return ((OracleDatabaseV2)database).getCreateSqlPlSql(statement);
        }
        return null;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

