/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.abstractsxmlobject;

import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlStatement;
import liquibase.ext.ora.oraclestatement.AbstractOracleStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ProcessFailedException;

public abstract class AbstractCommonSxmlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonSxmlStatement> {
    protected static final HashMap<String, String> typeChanges = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("PACKAGE SPEC", "PACKAGE");
            this.put("TYPE_SPEC", "TYPE");
            this.put("TYPE_BODY", "TYPE BODY");
            this.put("MATERIALIZED_VIEW_LOG", "MATERIALIZED VIEW LOG");
            this.put("MATERIALIZED_VIEW", "MATERIALIZED VIEW");
            this.put("DB_LINK", "DATABASE LINK");
        }
    };

    public abstract ACTIONS createOrDrop();

    public abstract boolean supports(AbstractCommonSxmlStatement var1, Database var2);

    public ValidationErrors validate(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        validationErrors.checkRequiredField("source", (Object)statement.getSource());
        return validationErrors;
    }

    public Sql[] generateSql(AbstractCommonSxmlStatement statement, Database database, SqlGeneratorChain chain) {
        if (this.createOrDrop().equals((Object)ACTIONS.CREATE)) {
            return this.createSql(statement, database);
        }
        try {
            return this.dropSql(statement, database);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Sql[] dropSql(AbstractOracleStatement statement, Database database) throws ProcessFailedException {
        if (database instanceof OracleDatabaseV2) {
            return ((OracleDatabaseV2)database).getDropSqlSxml(statement);
        }
        return null;
    }

    private Sql[] createSql(AbstractOracleStatement statement, Database database) {
        if (database instanceof OracleDatabaseV2) {
            return ((OracleDatabaseV2)database).getCreateSqlSxml(statement);
        }
        return null;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

