/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracledblink;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracledblink.CreateDbLinkStatement;
import liquibase.ext.ora.droporacledblink.DropDbLinkChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleDbLink", description="Create oracle database link", priority=1)
public class CreateDbLinkChange
extends AbstractCommonPlSqlChange {
    public CreateDbLinkChange() {
        this.setObjectType("DB_LINK");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Database Link {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateDbLinkStatement stmt = new CreateDbLinkStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropDbLinkChange inverse = new DropDbLinkChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

