/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclegrant;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclegrant.CreateGrantStatement;
import liquibase.ext.ora.droporaclegrant.DropGrantChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleGrant", description="Create oracle grant", priority=1)
public class CreateGrantChange
extends AbstractCommonPlSqlChange {
    public CreateGrantChange() {
        this.setObjectType("GRANT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Grant {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateGrantStatement stmt = new CreateGrantStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropGrantChange inverse = new DropGrantChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

