/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclesxml;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlChange;
import liquibase.ext.ora.createoraclesxml.CreateOracleSxmlStatement;
import liquibase.ext.ora.droporaclesxml.DropOracleSxmlChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createSxmlObject", description="Create Oracle Sxml Object", priority=1)
public class CreateOracleSxmlChange
extends AbstractCommonSxmlChange {
    public String getConfirmationMessage() {
        return MessageFormat.format("{0} {1} created successfully", this.getObjectType(), this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateOracleSxmlStatement stmt = new CreateOracleSxmlStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropOracleSxmlChange stmt = new DropOracleSxmlChange();
        stmt.setObjectName(this.getObjectName());
        stmt.setOwnerName(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{stmt};
    }
}

