/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclepackagebody;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclepackagebody.DropPackageBodyStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOraclePackageBody", description="Drop oracle package body", priority=1)
public class DropPackageBodyChange
extends AbstractCommonPlSqlChange {
    public DropPackageBodyChange() {
        this.setObjectType("PACKAGE_BODY");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Package body {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropPackageBodyStatement stmt = new DropPackageBodyStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

