/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import liquibase.ext.ora.generator.CustomSqlException;
import liquibase.ext.ora.utils.NullOutputStream;
import liquibase.ext.ora.utils.StopWatch;
import liquibase.ext.ora.utils.StringUtils;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ProcessFailedException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.liquibaseCommand;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Generator {
    public static final HashMap<String, String> typeChanges = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("PACKAGE_SPEC", "PACKAGE");
            this.put("PACKAGE_BODY", "PACKAGE BODY");
            this.put("TYPE_SPEC", "TYPE");
            this.put("TYPE_BODY", "TYPE BODY");
            this.put("MATERIALIZED_VIEW_LOG", "MATERIALIZED VIEW LOG");
            this.put("MATERIALIZED_VIEW", "MATERIALIZED VIEW");
            this.put("DB_LINK", "DATABASE LINK");
            this.put("PUBLIC_SYNONYM", "PUBLIC SYNONYM");
        }
    };
    private Connection conn = null;
    private ScriptRunnerContext ctx = null;
    private final LinkedHashMap<String, Boolean> file_names = new LinkedHashMap();
    private String[] _apexArgs = null;
    private ScriptExecutor m_executor = null;
    private final String RawChangeLogString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" failOnError=\"%FAILONERROR%\" %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
    private final String masterXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.1.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n";
    public static LinkedHashMap<String, Integer> ordered_types = new LinkedHashMap<String, Integer>(){
        {
            this.put("TYPE_SPEC", 1);
            this.put("TYPE_BODY", 2);
            this.put("SEQUENCE", 3);
            this.put("DIRECTORY", 4);
            this.put("CLUSTER", 5);
            this.put("TABLE", 6);
            this.put("MATERIALIZED_VIEW_LOG", 7);
            this.put("MATERIALIZED_VIEW", 8);
            this.put("VIEW", 9);
            this.put("REF_CONSTRAINT", 10);
            this.put("DIMENSION", 11);
            this.put("FUNCTION", 12);
            this.put("PROCEDURE", 13);
            this.put("PACKAGE_SPEC", 14);
            this.put("DB_LINK", 15);
            this.put("SYNONYM", 16);
            this.put("INDEX", 17);
            this.put("TRIGGER", 18);
            this.put("PACKAGE_BODY", 19);
            this.put("JOB", 20);
            this.put("PUBLIC_SYNONYM", 21);
            this.put("OBJECT_GRANT", 22);
        }
    };
    private static final HashMap<String, String> ddlChangeTypes = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("CONSTRAINT", "createOracleConstraint");
            this.put("REF_CONSTRAINT", "createOracleRefConstraint");
            this.put("DIMENSION", "createOracleDimension");
            this.put("FUNCTION", "createOracleFunction");
            this.put("PROCEDURE", "createOracleProcedure");
            this.put("PACKAGE_SPEC", "createOraclePackageSpec");
            this.put("PACKAGE_BODY", "createOraclePackageBody");
            this.put("TYPE_SPEC", "createOracleTypeSpec");
            this.put("TYPE_BODY", "createOracleTypeBody");
            this.put("PUBLIC_SYNONYM", "createOraclePublicSynonym");
            this.put("SYNONYM", "createOracleSynonym");
            this.put("OBJECT_GRANT", "createOracleGrant");
            this.put("DB_LINK", "createOracleDbLink");
            this.put("TRIGGER", "createOracleTrigger");
            this.put("JOB", "createOracleJob");
            this.put("DIRECTORY", "createOracleDirectory");
        }
    };
    static QueryXMLSupport _queries = null;
    static DBUtil dbUtil;

    protected static synchronized QueryXMLSupport getXMLQueries() {
        if (_queries == null) {
            _queries = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(liquibaseCommand.class.getClassLoader(), "oracle/dbtools/raptor/scriptrunner/commands/liquibase/cmQueries.xml"));
        }
        return _queries;
    }

    public Generator(Connection _conn, ScriptRunnerContext _ctx) throws ProcessFailedException {
        dbUtil = DBUtil.getInstance((Connection)_conn);
        try {
            this.conn = _conn;
            this.ctx = _ctx;
            this.m_executor = new ScriptExecutor(this.conn);
            if (!this.doesExportTableExist()) {
                this.createCaptureTable();
            } else {
                this.dropCaptureTable();
                this.createCaptureTable();
            }
            if (!this.doesExportPackageExist()) {
                this.createCapturePackage();
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void Destroy() {
        try {
            this.dropCapturePackage();
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
        try {
            this.dropCaptureTable();
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
    }

    private boolean isSxmlType(String name) {
        try {
            SXML_OBJECT_TYPES.valueOf(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getStringFromDocument(Document doc) throws ProcessFailedException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private boolean doesExportPackageExist() {
        String count = dbUtil.executeReturnOneCol(Generator.getXMLQueries().getQuery("checkLbPackage", this.conn).getSql());
        return Integer.valueOf(count) != 0;
    }

    private boolean doesExportTableExist() {
        String count = dbUtil.executeReturnOneCol(Generator.getXMLQueries().getQuery("checkLbtable", this.conn).getSql());
        return Integer.valueOf(count) != 0;
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(Generator.getXMLQueries().getQuery("checkApexVersion", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException("APEX is not installed in DB or this connecion has no access.");
        }
        Version source = new Version(version);
        return source.compareTo(new Version("19.2")) > 0;
    }

    public static boolean isOrdsInstalled(Connection conn) throws AppNotInstalledException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(Generator.getXMLQueries().getQuery("checkOrdsInstalled", conn).getSql());
        return count != null && !count.isEmpty() && count.equals("2");
    }

    public String getAlterDdlDFromSXML(String sourceSxml, String destSxml, String oType) throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        Statement stmt = null;
        try {
            String sxmltoDdlQuery = "{? = call SQLCL_LB_CAPTURE.getAlterDDL(?, ?, ?)}";
            Clob sourceClob = this.conn.createClob();
            sourceClob.setString(1L, sourceSxml);
            Clob destClob = this.conn.createClob();
            destClob.setString(1L, destSxml);
            stmt = this.conn.prepareCall("{? = call SQLCL_LB_CAPTURE.getAlterDDL(?, ?, ?)}");
            stmt.registerOutParameter(1, 2005);
            stmt.setClob(2, sourceClob);
            stmt.setClob(3, destClob);
            stmt.setString(4, oType);
            stmt.execute();
            Clob clob = stmt.getClob(1);
            if (clob != null) {
                sb.append(StringUtils.clobToString(clob));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String getDdlFromXML(String sourceSxml, String oType) throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        Statement stmt = null;
        try {
            String sxmltoDdlQuery = "{? = call SQLCL_LB_CAPTURE.xmlToDDL(?, ?)}";
            Clob myClob = this.conn.createClob();
            myClob.setString(1L, sourceSxml);
            stmt = this.conn.prepareCall("{? = call SQLCL_LB_CAPTURE.xmlToDDL(?, ?)}");
            stmt.registerOutParameter(1, 2005);
            stmt.setClob(2, myClob);
            stmt.setString(3, oType);
            stmt.execute();
            Clob clob = stmt.getClob(1);
            if (clob != null) {
                sb.append(StringUtils.clobToString(clob));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String getDdlFromSXML(String sourceSxml, String oType) throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        Statement stmt = null;
        try {
            String sxmltoDdlQuery = "{? = call SQLCL_LB_CAPTURE.sxmlToDDL(?, ?)}";
            Clob myClob = this.conn.createClob();
            myClob.setString(1L, sourceSxml);
            stmt = this.conn.prepareCall("{? = call SQLCL_LB_CAPTURE.sxmlToDDL(?, ?)}");
            stmt.registerOutParameter(1, 2005);
            stmt.setClob(2, myClob);
            stmt.setString(3, oType);
            stmt.execute();
            Clob clob = stmt.getClob(1);
            if (clob != null) {
                sb.append(StringUtils.clobToString(clob));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void writeChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        String cwd = FileUtils.getCWD((ScriptRunnerContext)this.ctx);
        Path path = Paths.get(cwd + "/" + params.get("filename"), new String[0]);
        File file = path.toFile();
        File dir = path.getParent().toFile();
        BufferedWriter writer = null;
        String ddl = params.get("ddl");
        String type = params.get("type");
        String oName = params.get("name");
        String dropProgram = "declare \n  programs number;\nbegin\nselect count(1) into programs from USER_SCHEDULER_PROGRAMS where program_name = '" + oName + "';\nif programs > 0 then\n    dbms_scheduler.drop_program('" + oName + "',true);\nend if;\n";
        String dropJob = "declare \n  jobs number;\nbegin\nselect count(1) into jobs from USER_SCHEDULER_JOBS where job_name = '" + oName + "';\nif jobs > 0 then\n    dbms_scheduler.drop_job(job_name => '" + oName + "');\nend if;\n";
        try {
            if (ddl == null || ddl.isEmpty()) {
                ddl = this.getObjectFromDb(params.get("type"), params.get("name"));
                if (ddl == null || ddl.length() == 0) {
                    throw new ProcessFailedException(new Exception("Unable to retrieve object metadata"), Thread.currentThread().getStackTrace()[1].getMethodName());
                }
            } else if (type.equalsIgnoreCase("JOB")) {
                if (ddl.contains("create_job")) {
                    ddl = StringUtils.replaceVal("BEGIN", dropJob, ddl);
                } else if (ddl.contains("create_program")) {
                    ddl = StringUtils.replaceVal("BEGIN", dropProgram, ddl);
                }
            }
            params.put("ddl", ddl);
            if (dir != null) {
                dir.mkdirs();
            }
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(this.getChangeLog(params));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void createCapturePackage() throws CustomSqlException {
        String createOrderRowProc = Generator.getXMLQueries().getQuery("createCapturePackage", this.conn).getSql();
        this.m_executor.setStmt(createOrderRowProc);
        this.m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        this.m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = this.m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    private void dropCapturePackage() throws CustomSqlException {
        String dropCapturePackage = Generator.getXMLQueries().getQuery("dropCapturePackage", this.conn).getSql();
        this.m_executor.setStmt(dropCapturePackage);
        this.m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        this.m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = this.m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    private void dropCaptureTable() throws CustomSqlException {
        String dropCaptureTable = Generator.getXMLQueries().getQuery("dropCaptureTable", this.conn).getSql();
        this.m_executor.setStmt(dropCaptureTable);
        this.m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        this.m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = this.m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    private void createCaptureTable() throws CustomSqlException {
        String createCaptureTable = Generator.getXMLQueries().getQuery("createCaptureTable", this.conn).getSql();
        this.m_executor.setStmt(createCaptureTable);
        this.m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        this.m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = this.m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    private void loadCaptureTable(HashMap<String, String> params) throws ProcessFailedException {
        boolean report = Boolean.parseBoolean(params.get("report"));
        boolean pubSyns = Boolean.parseBoolean(params.get("synonyms"));
        boolean grants = Boolean.parseBoolean(params.get("grants"));
        StopWatch stopWatch = new StopWatch();
        String callLoadCapture = Generator.getXMLQueries().getQuery("callLoadCapture", this.conn).getSql();
        CallableStatement statement = null;
        String key = "";
        try {
            statement = this.conn.prepareCall(callLoadCapture);
            for (Map.Entry<String, Integer> entry : ordered_types.entrySet()) {
                key = entry.getKey();
                if (key.equals("PUBLIC_SYNONYM") && !pubSyns || (key.equals("OBJECT_GRANT") || key.equals("SYSTEM_GRANT") || key.equals("ROLE_GRANT")) && !grants) continue;
                Integer rank = entry.getValue();
                statement.setString("otype", key);
                statement.setInt("rank", (int)rank);
                if (this.ctx.getDDLOptions() != null && !((String)this.ctx.getDDLOptions().get("DEFAULT")).equals("ON")) {
                    statement.setString("storage", (String)this.ctx.getDDLOptions().get("STORAGE"));
                    statement.setString("inherit", (String)this.ctx.getDDLOptions().get("INHERIT"));
                    statement.setString("sqlterminator", (String)this.ctx.getDDLOptions().get("SQLTERMINATOR"));
                    statement.setString("oid", (String)this.ctx.getDDLOptions().get("OID"));
                    statement.setString("specification", (String)this.ctx.getDDLOptions().get("SPECIFICATION"));
                    statement.setString("tablespace", (String)this.ctx.getDDLOptions().get("TABLESPACE"));
                    statement.setString("size_byte_keyword", (String)this.ctx.getDDLOptions().get("SIZE_BYTE_KEYWORD"));
                    statement.setString("pretty", (String)this.ctx.getDDLOptions().get("PRETTY"));
                    statement.setString("ref_constraints", (String)this.ctx.getDDLOptions().get("REF_CONSTRAINTS"));
                    statement.setString("force", (String)this.ctx.getDDLOptions().get("FORCE"));
                    statement.setString("partitioning", (String)this.ctx.getDDLOptions().get("PARTITIONING"));
                    statement.setString("constraints", (String)this.ctx.getDDLOptions().get("CONSTRAINTS"));
                    statement.setString("inserts", (String)this.ctx.getDDLOptions().get("INSERT"));
                    statement.setString("body", (String)this.ctx.getDDLOptions().get("BODY"));
                    statement.setString("constraints_as_alter", (String)this.ctx.getDDLOptions().get("CONSTRAINTS_AS_ALTER"));
                    statement.setString("segment_attributes", (String)this.ctx.getDDLOptions().get("SEGMENT_ATTRIBUTES"));
                }
                statement.execute();
                if (!report) continue;
                stopWatch.split("Type - " + key);
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, "type -" + key + " failed\n" + Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (report) {
                stopWatch.end("Method loadCaptureTable");
            }
        }
    }

    private void updateCaptureTable(String name, String depList, int depCount, String fileName, int seq, String type) throws ProcessFailedException {
        String updateCaptureTable = Generator.getXMLQueries().getQuery("updateCaptureTable", this.conn).getSql();
        PreparedStatement update = null;
        try {
            update = this.conn.prepareStatement(updateCaptureTable);
            update.setString(1, name);
            update.setString(2, depList);
            update.setInt(3, depCount);
            update.setString(4, fileName);
            update.setInt(5, seq);
            update.setString(6, type);
            update.executeUpdate();
            this.conn.commit();
        }
        catch (Exception e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (update != null) {
                try {
                    update.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void sortCaptureTable(boolean report) throws ProcessFailedException {
        StopWatch stopWatch = new StopWatch();
        String query = Generator.getXMLQueries().getQuery("callSortCapture", this.conn).getSql();
        CallableStatement statement = null;
        try {
            statement = this.conn.prepareCall(query);
            statement.execute();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (report) {
            stopWatch.end("Method sortCaptureTable");
        }
    }

    private void processCaptureTable(HashMap<String, String> params) throws ProcessFailedException {
        boolean report = Boolean.parseBoolean(params.get("report"));
        StopWatch stopWatch = new StopWatch();
        String queryCaptureTable = Generator.getXMLQueries().getQuery("queryCaptureTable", this.conn).getSql();
        PreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = this.conn.prepareStatement(queryCaptureTable);
            rs = pstatement.executeQuery();
            int counter = 0;
            int badFile = 0;
            while (rs.next()) {
                List names = null;
                List deps = null;
                String sql = null;
                String name = null;
                String depList = null;
                String fileName = null;
                String type = rs.getString(1);
                Clob meta = rs.getClob(2);
                int seq = rs.getInt(3);
                String clobData = StringUtils.trim(StringUtils.clobToString(meta));
                sql = ddlChangeTypes.containsKey(type) ? clobData.replace("REFERENCING FOR EACH ROW", "") : this.getDdlFromSXML(clobData, type);
                SqlRecognizer recognizer = null;
                recognizer = new SqlRecognizer(sql);
                names = recognizer.getObjectNames();
                deps = recognizer.getReferencedTypes();
                if (names != null && names.size() > 0) {
                    name = ((String)names.get(0)).replaceAll("\"", "");
                }
                if (deps != null && deps.size() > 0) {
                    depList = String.join((CharSequence)",", deps);
                    depList = depList.replaceAll("\"", "").toUpperCase();
                }
                if (name != null) {
                    fileName = (name + "_" + type + ".xml").toLowerCase();
                    int count = 1;
                    while (this.file_names.containsKey(fileName)) {
                        fileName = (name + "_" + type + count++ + ".xml").toLowerCase();
                    }
                    this.file_names.put(fileName, true);
                } else if (name == null && (type.equals("REF_CONSTRAINT") || type.equals("ROLE_GRANT") || type.equals("OBJECT_GRANT") || type.equals("SYSTEM_GRANT") || type.equals("MATERIALIZED_VIEW_LOG"))) {
                    fileName = (type + counter++ + ".xml").toLowerCase();
                    this.file_names.put(fileName, true);
                } else {
                    fileName = (type + "_BAD_" + badFile++ + ".xml").toLowerCase();
                    this.file_names.put(fileName, false);
                }
                params.replace("name", name);
                params.replace("filename", fileName);
                params.replace("ddl", clobData);
                params.replace("type", type);
                try {
                    this.writeChangeLog(params);
                }
                catch (Exception e) {
                    if (e instanceof ProcessFailedException) {
                        throw (ProcessFailedException)e;
                    }
                    throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
                }
                if (name != null && (type.equalsIgnoreCase("TABLE") || type.equalsIgnoreCase("VIEW"))) {
                    try {
                        String comments = this.getComments(name);
                        fileName = (name + "_comments.xml").toLowerCase();
                        params.replace("name", name);
                        params.replace("filename", fileName);
                        params.replace("ddl", comments);
                        params.replace("type", "COMMENT");
                        this.writeChangeLog(params);
                        this.file_names.put(fileName, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.updateCaptureTable(name, depList, deps.size(), fileName, seq, type);
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (report) {
            stopWatch.end("Method parseCaptureTableRecords");
        }
    }

    private String getComments(String oName) throws ProcessFailedException {
        String querycomments = Generator.getXMLQueries().getQuery("querycomments", this.conn).getSql();
        String ddlSetup = Generator.getXMLQueries().getQuery("ddlSetup", this.conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Object clob;
            stmt = this.conn.prepareStatement(ddlSetup);
            stmt.executeQuery();
            stmt.close();
            stmt = this.conn.prepareStatement(querycomments);
            stmt.setString(1, oName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                clob = rs.getClob(1);
                sb.append(StringUtils.clobToString((Clob)clob));
            }
            clob = sb.toString();
            return clob;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String getControllerHeader() {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.1.xsd\">\n";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.1.xsd\">\n";
    }

    private String getControllerFooter() {
        String end = "</databaseChangeLog> \n";
        return "</databaseChangeLog> \n";
    }

    private String getControllerInclude(String fileName) {
        String include = "  <include file=\"%FILE%\"/> \n";
        include = StringUtils.replaceVal("%FILE%", fileName, include);
        return include;
    }

    private void writeControllerFile(LinkedList<String> files) throws ProcessFailedException {
        try {
            String fileName = "controller.xml".toLowerCase();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ctx.prependCD(fileName.toLowerCase())));
            writer.write(this.getControllerHeader());
            for (String file : files) {
                writer.write(this.getControllerInclude(file));
            }
            writer.write(this.getControllerFooter());
            writer.close();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void doSchemaExport(HashMap<String, String> params) throws ProcessFailedException {
        boolean report = Boolean.parseBoolean(params.get("report"));
        boolean pubSyns = Boolean.parseBoolean(params.get("synonyms"));
        boolean grants = Boolean.parseBoolean(params.get("grants"));
        try {
            if (report) {
                this.ctx.write("\n" + Messages.getString("LB_FLAGS") + "\n");
                this.ctx.write(Messages.getString("LB_GRANTS") + "\t\t" + grants + "\n");
                this.ctx.write(Messages.getString("LB_SYNS") + "\t\t" + pubSyns + "\n");
            }
            this.loadCaptureTable(params);
            this.processCaptureTable(params);
            this.sortCaptureTable(report);
            StopWatch stopWatch = new StopWatch();
            if (this.file_names.containsValue(false)) {
                this.ctx.write("\n" + Messages.getString("LB_NO_PARSE") + "\n");
                for (Map.Entry<String, Boolean> entry : this.file_names.entrySet()) {
                    String key = entry.getKey();
                    Boolean state = entry.getValue();
                    if (state.booleanValue()) continue;
                    this.ctx.write(key + "\n");
                }
            }
            LinkedList<String> includes = new LinkedList<String>();
            for (Map.Entry<String, Boolean> entry : this.file_names.entrySet()) {
                String key = entry.getKey();
                Boolean state = entry.getValue();
                if (!state.booleanValue()) continue;
                includes.add(key);
            }
            this.writeControllerFile(includes);
            if (report) {
                stopWatch.end("Method createExportChangeLogs");
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            try {
                this.dropCapturePackage();
            }
            catch (CustomSqlException customSqlException) {}
            try {
                this.dropCaptureTable();
            }
            catch (CustomSqlException customSqlException) {}
        }
    }

    public String getObjectFromDb(String oType, String oName) throws ProcessFailedException {
        Object dbf;
        String objectType = oType.toUpperCase();
        String objectName = oName;
        Statement pstatement = null;
        ResultSet rs = null;
        String result = null;
        String dropJob = null;
        try {
            String queryddl;
            if (this.isSxmlType(objectType.toUpperCase())) {
                String querysxml = Generator.getXMLQueries().getQuery("querysxml", this.conn).getSql();
                pstatement = this.conn.prepareStatement(querysxml);
            } else if (objectType.equals("PUBLIC_SYNONYM")) {
                queryddl = Generator.getXMLQueries().getQuery("queryddlPublic", this.conn).getSql();
                pstatement = this.conn.prepareStatement(queryddl);
                objectType = "SYNONYM";
                pstatement.setString(3, "PUBLIC");
            } else if (objectType.equals("JOB")) {
                queryddl = Generator.getXMLQueries().getQuery("queryddlJob", this.conn).getSql();
                pstatement = this.conn.prepareStatement(queryddl);
                objectType = "PROCOBJ";
                dropJob = "declare \n  jobs number;\nbegin\nselect count(1) into jobs from all_scheduler_jobs where owner = user and job_name = '" + oName + "';\nif jobs > 0 then\n    dbms_scheduler.drop_job(job_name => '" + oName + "');\nend if;\n";
            } else if (objectType.equals("PUBLIC_DB_LINK")) {
                queryddl = Generator.getXMLQueries().getQuery("queryddlPublic", this.conn).getSql();
                pstatement = this.conn.prepareStatement(queryddl);
                objectType = "DB_LINK";
                pstatement.setString(3, "PUBLIC");
            } else {
                queryddl = Generator.getXMLQueries().getQuery("queryddl", this.conn).getSql();
                pstatement = this.conn.prepareStatement(queryddl);
            }
            pstatement.setString(1, objectType);
            pstatement.setString(2, objectName);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                String string = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (pstatement != null) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (rs != null && rs.next()) {
                result = rs.getString(1);
            }
            if (this.isSxmlType(oType.toUpperCase())) {
                dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = ((DocumentBuilderFactory)dbf).newDocumentBuilder();
                InputSource is = new InputSource();
                is.setCharacterStream(new StringReader(result));
                Document doc = db.parse(is);
                String string = this.getStringFromDocument(doc);
                return string;
            }
            result = StringUtils.replaceVal("CREATE OR REPLACE ", "", result);
            if (oType.equalsIgnoreCase("JOB")) {
                result = StringUtils.replaceVal("BEGIN", dropJob, result);
            }
            dbf = StringUtils.ltrim(result);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return dbf;
    }

    public void writeMasterLog(String name) throws ProcessFailedException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.ctx.prependCD(name.toLowerCase())));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.1.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n");
            writer.close();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void writeOrdsChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        String module = params.get("name");
        boolean enable = Boolean.getBoolean(params.get("enable"));
        boolean privs = Boolean.getBoolean(params.get("privs"));
        Statement stmt = null;
        Clob script = null;
        try {
            if (params.get("name") != null && !params.get("name").isEmpty()) {
                String ordsQuery = "begin ? := ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setString(2, module);
                stmt.setInt(3, enable ? 0 : 1);
                stmt.setInt(4, privs ? 0 : 1);
            } else {
                String ordsQuery = "begin ? := ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setInt(2, enable ? 0 : 1);
                stmt.setInt(3, privs ? 0 : 1);
            }
            stmt.execute();
            script = stmt.getClob(1);
            params.replace("name", "SCRIPT");
            params.replace("type", "ordsRestExport");
            params.replace("ddl", StringUtils.clobToString(script));
            this.writeChangeLog(params);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void writeApexChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        LinkedList<String> names = new LinkedList<String>();
        Object genApex = null;
        try {
            genApex = Generator.newApexVersion(this.conn) ? new APEXExport(true) : new APEXExportV1(true);
        }
        catch (AppNotInstalledException e) {
            throw new ProcessFailedException((Exception)((Object)e), Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        genApex.setConnection(this.conn);
        genApex.setOutStream((OutputStream)this.ctx.getOutputStream());
        genApex.setCWD(FileUtils.getCWD((ScriptRunnerContext)this.ctx));
        try {
            genApex.processArgs(this._apexArgs);
            genApex.doCapture();
            LinkedHashMap data = genApex.getClobData();
            for (Map.Entry item : data.entrySet()) {
                String fileName = (String)item.getKey();
                fileName = fileName.replace(".sql", ".xml");
                names.add(fileName);
                Clob script = (Clob)item.getValue();
                params.put("name", "SCRIPT");
                params.put("type", "apexObject");
                params.put("ddl", StringUtils.clobToString(script));
                params.put("filename", fileName);
                this.writeChangeLog(params);
            }
            if (data.size() > 1) {
                this.writeControllerFile(names);
                this.ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), "controller.xml".toLowerCase()));
            } else if (data.size() == 1) {
                String filename = (String)data.keySet().toArray()[0];
                this.ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), filename.replace(".sql", ".xml")));
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private final String getSha1fromString(String data) throws ProcessFailedException {
        try {
            String sha1 = null;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(data.getBytes("utf8"));
            sha1 = String.format("%040x", new BigInteger(1, digest.digest()));
            return sha1;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private String getChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        String oType = params.get("type");
        String oName = params.get("name");
        String ddlXml = params.get("ddl");
        String fail = params.get("fail");
        String context = params.get("context");
        String label = params.get("label");
        boolean replace = Boolean.parseBoolean(params.get("replace"));
        boolean runonchange = Boolean.parseBoolean(params.get("runonchange"));
        boolean runalways = Boolean.parseBoolean(params.get("runalways"));
        String schema = "";
        String change = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" failOnError=\"%FAILONERROR%\" %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
        try {
            schema = this.conn.getSchema();
            change = StringUtils.replaceVal("%ID%", this.getSha1fromString(ddlXml), change);
            change = StringUtils.replaceVal("%AUTHOR%", "Generated", change);
            if (oName != null) {
                change = StringUtils.replaceVal("%OBJECT_NAME%", oName.replaceAll("\"", ""), change);
            }
            if (oType != null) {
                change = StringUtils.replaceVal("%OBJECT_TYPE%", oType, change);
            }
            if (schema != null) {
                change = StringUtils.replaceVal("%OWNER_NAME%", schema, change);
            }
            change = StringUtils.replaceVal("%SOURCE%", ddlXml, change);
            if (this.isSxmlType(oType.toUpperCase())) {
                change = StringUtils.replaceVal("%CHANGE_TYPE%", "createSxmlObject", change);
            } else if (oType.equalsIgnoreCase("COMMENT")) {
                change = StringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", change);
                change = StringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
            } else if (oType.equalsIgnoreCase("SCRIPT")) {
                change = StringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", change);
                change = StringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
            } else {
                change = StringUtils.replaceVal("%CHANGE_TYPE%", ddlChangeTypes.get(oType.toUpperCase()), change);
            }
            change = StringUtils.replaceVal("%SOURCE_TYPE%", "", change);
            if (oType.equals("TRIGGER")) {
                change = change.replaceAll("\\nALTER TRIGGER", "/\nALTER TRIGGER");
            }
            change = StringUtils.replaceVal("%FAILONERROR%", fail, change);
            change = replace ? StringUtils.replaceVal("%REPLACEXISTS%", "replaceifexists=\"true\"", change) : StringUtils.replaceVal("%REPLACEXISTS%", null, change);
            change = context != null && !context.isEmpty() ? StringUtils.replaceVal("%CONTEXTS%", "context=\"" + context + "\"", change) : StringUtils.replaceVal("%CONTEXTS%", null, change);
            change = label != null && !label.isEmpty() ? StringUtils.replaceVal("%LABELS%", "label=\"" + label + "\"", change) : StringUtils.replaceVal("%LABELS%", null, change);
            String runOptions = "";
            if (runonchange) {
                runOptions = "runOnChange=\"true\" ";
            }
            if (runalways) {
                runOptions = runOptions + "runAlways=\"true\"";
            }
            change = runOptions != null && !runOptions.isEmpty() ? StringUtils.replaceVal("%RUNOPTIONS%", runOptions, change) : StringUtils.replaceVal("%RUNOPTIONS%", null, change);
            return change;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void setApexArgs(ArrayList<String> apexArgs) {
        this._apexArgs = apexArgs.toArray(new String[0]);
    }

    static enum SXML_OBJECT_TYPES {
        AQ_QUEUE,
        AQ_QUEUE_TABLE,
        AQ_TRANSFORM,
        ASSOCIATION,
        AUDIT,
        AUDIT_OBJ,
        CLUSTER,
        CONTEXT,
        DEFAULT_ROLE,
        FGA_POLICY,
        INDEX,
        LIBRARY,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PROFILE,
        PROXY,
        REFRESH_GROUP,
        RESOURCE_COST,
        RLS_CONTEXT,
        RLS_GROUP,
        RLS_POLICY,
        RMGR_CONSUMER_GROUP,
        RMGR_INTITIAL_CONSUMER_GROUP,
        RMGR_PLAN,
        RMGR_PLAN_DIRECTIVE,
        ROLE,
        ROLLBACK_SEGMENT,
        SEQUENCE,
        TABLE,
        TABLESPACE,
        TRUSTED_DB_LINK,
        TYPE,
        USER,
        VIEW,
        XMLSCHEMA,
        XS_USER,
        XS_ROLE,
        XS_ROLESET,
        XS_ROLE_GRANT,
        XS_SECURITY_CLASS,
        XS_DATA_SECURITY,
        XS_ACL,
        XS_ACL_PARAM,
        XS_NAMESPACE;

    }
}

