/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.rollback;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.rollback.RollbackOraclePlSqlStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="rollbackOraclePlSqlChange", description="Rollback PlSql Object", priority=1)
public class RollbackOraclePlSqlChange
extends AbstractCommonPlSqlChange {
    public RollbackOraclePlSqlChange() {
    }

    public RollbackOraclePlSqlChange(AbstractCommonPlSqlChange change) {
        this.setChangeSet(change.getChangeSet());
        this.setObjectName(change.getObjectName());
        this.setObjectType(change.getObjectType());
        this.setOwnerName(change.getOwnerName());
        this.setSource(change.getSource());
        if (this.getChangeSet() != null) {
            this.setId(this.getChangeSet().getId());
            this.setFile(this.getChangeSet().getFilePath());
            this.setAuthor(this.getChangeSet().getAuthor());
        }
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Rollback completed successfully for {0} {1}", this.getSourceType(), this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        RollbackOraclePlSqlStatement stmt = new RollbackOraclePlSqlStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

