/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.runoraclescript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlGenerator;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.structure.DatabaseObject;

public class RunOracleScriptGenerator
extends AbstractCommonPlSqlGenerator<AbstractCommonPlSqlStatement> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        OracleDatabaseV2 db = null;
        if (database instanceof OracleDatabaseV2) {
            db = (OracleDatabaseV2)database;
        }
        StringBuilder sql = new StringBuilder();
        if (statement.getSourceType().toUpperCase().equals("STRING")) {
            sql.append(statement.getSource());
        } else if (statement.getSourceType().toUpperCase().equals("FILE")) {
            String content = "";
            try {
                content = new String(Files.readAllBytes(Paths.get(statement.getSource(), new String[0])));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sql.append(content);
        } else if (statement.getSourceType().toUpperCase().equals("URL")) {
            try {
                String inputLine;
                BufferedReader in = null;
                URL url = new URL(statement.getSource());
                URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                URL fileURL = uri.toURL();
                in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    sql.append(inputLine);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String outSql = null;
        outSql = db != null && !db.includeSchema() ? sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "") : sql.toString();
        return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
    }

    @Override
    public boolean supports(AbstractCommonPlSqlStatement statement, Database database) {
        return database instanceof OracleDatabase && statement instanceof RunOracleScriptStatement;
    }

    @Override
    public AbstractCommonPlSqlGenerator.ACTIONS createOrDrop() {
        return null;
    }
}

