/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import liquibase.ext.ora.generator.Generator;
import org.w3c.dom.Document;

public class StringUtils {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public static String base64Decode(String encodedStr) {
        return new String(Base64.getDecoder().decode(encodedStr), Charset.forName("UTF-8"));
    }

    public static String exceptionToString(Throwable aThrowable) {
        StringBuilder result = new StringBuilder("ERROR: ");
        result.append(aThrowable.toString());
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE);
        return result.toString();
    }

    public static String exceptionToString2(Exception e) {
        return Arrays.toString(e.getStackTrace());
    }

    public static String base64Encode(String decodedStr) {
        byte[] decodedByteArr = decodedStr.getBytes(Charset.forName("UTF-8"));
        return Base64.getEncoder().encodeToString(decodedByteArr);
    }

    public static String getDocumentAsString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String clobToString(Clob data) throws SQLException, IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        Reader reader = data.getCharacterStream();
        BufferedReader br = new BufferedReader(reader);
        while (-1 != (b = br.read())) {
            sb.append((char)b);
        }
        br.close();
        return sb.toString();
    }

    public static InputStream getXSLTFromJar(String objectType) {
        InputStream input = Generator.class.getClassLoader().getResourceAsStream(objectType.toLowerCase() + ".xslt");
        if (input == null) {
            return null;
        }
        return input;
    }

    public static String ltrim(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    public static String rtrim(String s) {
        return RTRIM.matcher(s).replaceAll("");
    }

    public static String trim(String s) {
        return StringUtils.rtrim(StringUtils.ltrim(s));
    }

    public static String replaceVal(String parm, String value, String doc) {
        if (value == null) {
            value = "";
        }
        String workString = doc;
        workString = workString.replace(parm, value);
        return workString;
    }
}

